/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The returned result of the corresponding request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDistributionsResponse extends CloudFrontResponse implements
        ToCopyableBuilder<ListDistributionsResponse.Builder, ListDistributionsResponse> {
    private static final SdkField<DistributionList> DISTRIBUTION_LIST_FIELD = SdkField
            .<DistributionList> builder(MarshallingType.SDK_POJO)
            .memberName("DistributionList")
            .getter(getter(ListDistributionsResponse::distributionList))
            .setter(setter(Builder::distributionList))
            .constructor(DistributionList::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DistributionList")
                    .unmarshallLocationName("DistributionList").build(), PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISTRIBUTION_LIST_FIELD));

    private final DistributionList distributionList;

    private ListDistributionsResponse(BuilderImpl builder) {
        super(builder);
        this.distributionList = builder.distributionList;
    }

    /**
     * <p>
     * The <code>DistributionList</code> type.
     * </p>
     * 
     * @return The <code>DistributionList</code> type.
     */
    public final DistributionList distributionList() {
        return distributionList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(distributionList());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDistributionsResponse)) {
            return false;
        }
        ListDistributionsResponse other = (ListDistributionsResponse) obj;
        return Objects.equals(distributionList(), other.distributionList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListDistributionsResponse").add("DistributionList", distributionList()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DistributionList":
            return Optional.ofNullable(clazz.cast(distributionList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDistributionsResponse, T> g) {
        return obj -> g.apply((ListDistributionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFrontResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListDistributionsResponse> {
        /**
         * <p>
         * The <code>DistributionList</code> type.
         * </p>
         * 
         * @param distributionList
         *        The <code>DistributionList</code> type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder distributionList(DistributionList distributionList);

        /**
         * <p>
         * The <code>DistributionList</code> type.
         * </p>
         * This is a convenience method that creates an instance of the {@link DistributionList.Builder} avoiding the
         * need to create one manually via {@link DistributionList#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DistributionList.Builder#build()} is called immediately and its
         * result is passed to {@link #distributionList(DistributionList)}.
         * 
         * @param distributionList
         *        a consumer that will call methods on {@link DistributionList.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #distributionList(DistributionList)
         */
        default Builder distributionList(Consumer<DistributionList.Builder> distributionList) {
            return distributionList(DistributionList.builder().applyMutation(distributionList).build());
        }
    }

    static final class BuilderImpl extends CloudFrontResponse.BuilderImpl implements Builder {
        private DistributionList distributionList;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDistributionsResponse model) {
            super(model);
            distributionList(model.distributionList);
        }

        public final DistributionList.Builder getDistributionList() {
            return distributionList != null ? distributionList.toBuilder() : null;
        }

        public final void setDistributionList(DistributionList.BuilderImpl distributionList) {
            this.distributionList = distributionList != null ? distributionList.build() : null;
        }

        @Override
        public final Builder distributionList(DistributionList distributionList) {
            this.distributionList = distributionList;
            return this;
        }

        @Override
        public ListDistributionsResponse build() {
            return new ListDistributionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
