/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.xml.AwsXmlProtocolFactory;
import software.amazon.awssdk.protocols.xml.XmlOperationMetadata;
import software.amazon.awssdk.services.cloudfront.CloudFrontClient;
import software.amazon.awssdk.services.cloudfront.CloudFrontUtilities;
import software.amazon.awssdk.services.cloudfront.model.AccessDeniedException;
import software.amazon.awssdk.services.cloudfront.model.AssociateAliasRequest;
import software.amazon.awssdk.services.cloudfront.model.AssociateAliasResponse;
import software.amazon.awssdk.services.cloudfront.model.BatchTooLargeException;
import software.amazon.awssdk.services.cloudfront.model.CachePolicyAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.CachePolicyInUseException;
import software.amazon.awssdk.services.cloudfront.model.CannotChangeImmutablePublicKeyFieldsException;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontException;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontOriginAccessIdentityAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontOriginAccessIdentityInUseException;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontRequest;
import software.amazon.awssdk.services.cloudfront.model.CnameAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.ContinuousDeploymentPolicyAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.ContinuousDeploymentPolicyInUseException;
import software.amazon.awssdk.services.cloudfront.model.CopyDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.CopyDistributionResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateCachePolicyRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateCachePolicyResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateCloudFrontOriginAccessIdentityRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateCloudFrontOriginAccessIdentityResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateContinuousDeploymentPolicyRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateContinuousDeploymentPolicyResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateDistributionResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateDistributionWithTagsRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateDistributionWithTagsResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateFieldLevelEncryptionConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateFieldLevelEncryptionConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateFieldLevelEncryptionProfileRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateFieldLevelEncryptionProfileResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateFunctionRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateFunctionResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateInvalidationRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateInvalidationResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateKeyGroupRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateKeyGroupResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateMonitoringSubscriptionRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateMonitoringSubscriptionResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateOriginAccessControlRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateOriginAccessControlResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateOriginRequestPolicyRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateOriginRequestPolicyResponse;
import software.amazon.awssdk.services.cloudfront.model.CreatePublicKeyRequest;
import software.amazon.awssdk.services.cloudfront.model.CreatePublicKeyResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateRealtimeLogConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateRealtimeLogConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateResponseHeadersPolicyRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateResponseHeadersPolicyResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateStreamingDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateStreamingDistributionResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateStreamingDistributionWithTagsRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateStreamingDistributionWithTagsResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteCachePolicyRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteCachePolicyResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteCloudFrontOriginAccessIdentityRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteCloudFrontOriginAccessIdentityResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteContinuousDeploymentPolicyRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteContinuousDeploymentPolicyResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteDistributionResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteFieldLevelEncryptionConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteFieldLevelEncryptionConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteFieldLevelEncryptionProfileRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteFieldLevelEncryptionProfileResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteFunctionRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteFunctionResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteKeyGroupRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteKeyGroupResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteMonitoringSubscriptionRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteMonitoringSubscriptionResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteOriginAccessControlRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteOriginAccessControlResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteOriginRequestPolicyRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteOriginRequestPolicyResponse;
import software.amazon.awssdk.services.cloudfront.model.DeletePublicKeyRequest;
import software.amazon.awssdk.services.cloudfront.model.DeletePublicKeyResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteRealtimeLogConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteRealtimeLogConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteResponseHeadersPolicyRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteResponseHeadersPolicyResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteStreamingDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteStreamingDistributionResponse;
import software.amazon.awssdk.services.cloudfront.model.DescribeFunctionRequest;
import software.amazon.awssdk.services.cloudfront.model.DescribeFunctionResponse;
import software.amazon.awssdk.services.cloudfront.model.DistributionAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.DistributionNotDisabledException;
import software.amazon.awssdk.services.cloudfront.model.FieldLevelEncryptionConfigAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.FieldLevelEncryptionConfigInUseException;
import software.amazon.awssdk.services.cloudfront.model.FieldLevelEncryptionProfileAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.FieldLevelEncryptionProfileInUseException;
import software.amazon.awssdk.services.cloudfront.model.FieldLevelEncryptionProfileSizeExceededException;
import software.amazon.awssdk.services.cloudfront.model.FunctionAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.FunctionInUseException;
import software.amazon.awssdk.services.cloudfront.model.FunctionSizeLimitExceededException;
import software.amazon.awssdk.services.cloudfront.model.GetCachePolicyConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetCachePolicyConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetCachePolicyRequest;
import software.amazon.awssdk.services.cloudfront.model.GetCachePolicyResponse;
import software.amazon.awssdk.services.cloudfront.model.GetCloudFrontOriginAccessIdentityConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetCloudFrontOriginAccessIdentityConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetCloudFrontOriginAccessIdentityRequest;
import software.amazon.awssdk.services.cloudfront.model.GetCloudFrontOriginAccessIdentityResponse;
import software.amazon.awssdk.services.cloudfront.model.GetContinuousDeploymentPolicyConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetContinuousDeploymentPolicyConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetContinuousDeploymentPolicyRequest;
import software.amazon.awssdk.services.cloudfront.model.GetContinuousDeploymentPolicyResponse;
import software.amazon.awssdk.services.cloudfront.model.GetDistributionConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetDistributionConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.GetDistributionResponse;
import software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionProfileConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionProfileConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionProfileRequest;
import software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionProfileResponse;
import software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionRequest;
import software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionResponse;
import software.amazon.awssdk.services.cloudfront.model.GetFunctionRequest;
import software.amazon.awssdk.services.cloudfront.model.GetFunctionResponse;
import software.amazon.awssdk.services.cloudfront.model.GetInvalidationRequest;
import software.amazon.awssdk.services.cloudfront.model.GetInvalidationResponse;
import software.amazon.awssdk.services.cloudfront.model.GetKeyGroupConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetKeyGroupConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetKeyGroupRequest;
import software.amazon.awssdk.services.cloudfront.model.GetKeyGroupResponse;
import software.amazon.awssdk.services.cloudfront.model.GetMonitoringSubscriptionRequest;
import software.amazon.awssdk.services.cloudfront.model.GetMonitoringSubscriptionResponse;
import software.amazon.awssdk.services.cloudfront.model.GetOriginAccessControlConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetOriginAccessControlConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetOriginAccessControlRequest;
import software.amazon.awssdk.services.cloudfront.model.GetOriginAccessControlResponse;
import software.amazon.awssdk.services.cloudfront.model.GetOriginRequestPolicyConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetOriginRequestPolicyConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetOriginRequestPolicyRequest;
import software.amazon.awssdk.services.cloudfront.model.GetOriginRequestPolicyResponse;
import software.amazon.awssdk.services.cloudfront.model.GetPublicKeyConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetPublicKeyConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetPublicKeyRequest;
import software.amazon.awssdk.services.cloudfront.model.GetPublicKeyResponse;
import software.amazon.awssdk.services.cloudfront.model.GetRealtimeLogConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetRealtimeLogConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetResponseHeadersPolicyConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetResponseHeadersPolicyConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetResponseHeadersPolicyRequest;
import software.amazon.awssdk.services.cloudfront.model.GetResponseHeadersPolicyResponse;
import software.amazon.awssdk.services.cloudfront.model.GetStreamingDistributionConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetStreamingDistributionConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetStreamingDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.GetStreamingDistributionResponse;
import software.amazon.awssdk.services.cloudfront.model.IllegalDeleteException;
import software.amazon.awssdk.services.cloudfront.model.IllegalFieldLevelEncryptionConfigAssociationWithCacheBehaviorException;
import software.amazon.awssdk.services.cloudfront.model.IllegalOriginAccessConfigurationException;
import software.amazon.awssdk.services.cloudfront.model.IllegalUpdateException;
import software.amazon.awssdk.services.cloudfront.model.InconsistentQuantitiesException;
import software.amazon.awssdk.services.cloudfront.model.InvalidArgumentException;
import software.amazon.awssdk.services.cloudfront.model.InvalidDefaultRootObjectException;
import software.amazon.awssdk.services.cloudfront.model.InvalidDomainNameForOriginAccessControlException;
import software.amazon.awssdk.services.cloudfront.model.InvalidErrorCodeException;
import software.amazon.awssdk.services.cloudfront.model.InvalidForwardCookiesException;
import software.amazon.awssdk.services.cloudfront.model.InvalidFunctionAssociationException;
import software.amazon.awssdk.services.cloudfront.model.InvalidGeoRestrictionParameterException;
import software.amazon.awssdk.services.cloudfront.model.InvalidHeadersForS3OriginException;
import software.amazon.awssdk.services.cloudfront.model.InvalidIfMatchVersionException;
import software.amazon.awssdk.services.cloudfront.model.InvalidLambdaFunctionAssociationException;
import software.amazon.awssdk.services.cloudfront.model.InvalidLocationCodeException;
import software.amazon.awssdk.services.cloudfront.model.InvalidMinimumProtocolVersionException;
import software.amazon.awssdk.services.cloudfront.model.InvalidOriginAccessControlException;
import software.amazon.awssdk.services.cloudfront.model.InvalidOriginAccessIdentityException;
import software.amazon.awssdk.services.cloudfront.model.InvalidOriginException;
import software.amazon.awssdk.services.cloudfront.model.InvalidOriginKeepaliveTimeoutException;
import software.amazon.awssdk.services.cloudfront.model.InvalidOriginReadTimeoutException;
import software.amazon.awssdk.services.cloudfront.model.InvalidProtocolSettingsException;
import software.amazon.awssdk.services.cloudfront.model.InvalidQueryStringParametersException;
import software.amazon.awssdk.services.cloudfront.model.InvalidRelativePathException;
import software.amazon.awssdk.services.cloudfront.model.InvalidRequiredProtocolException;
import software.amazon.awssdk.services.cloudfront.model.InvalidResponseCodeException;
import software.amazon.awssdk.services.cloudfront.model.InvalidTaggingException;
import software.amazon.awssdk.services.cloudfront.model.InvalidTtlOrderException;
import software.amazon.awssdk.services.cloudfront.model.InvalidViewerCertificateException;
import software.amazon.awssdk.services.cloudfront.model.InvalidWebAclIdException;
import software.amazon.awssdk.services.cloudfront.model.KeyGroupAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.ListCachePoliciesRequest;
import software.amazon.awssdk.services.cloudfront.model.ListCachePoliciesResponse;
import software.amazon.awssdk.services.cloudfront.model.ListCloudFrontOriginAccessIdentitiesRequest;
import software.amazon.awssdk.services.cloudfront.model.ListCloudFrontOriginAccessIdentitiesResponse;
import software.amazon.awssdk.services.cloudfront.model.ListConflictingAliasesRequest;
import software.amazon.awssdk.services.cloudfront.model.ListConflictingAliasesResponse;
import software.amazon.awssdk.services.cloudfront.model.ListContinuousDeploymentPoliciesRequest;
import software.amazon.awssdk.services.cloudfront.model.ListContinuousDeploymentPoliciesResponse;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsByCachePolicyIdRequest;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsByCachePolicyIdResponse;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsByKeyGroupRequest;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsByKeyGroupResponse;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsByOriginRequestPolicyIdRequest;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsByOriginRequestPolicyIdResponse;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsByRealtimeLogConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsByRealtimeLogConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsByResponseHeadersPolicyIdRequest;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsByResponseHeadersPolicyIdResponse;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsByWebAclIdRequest;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsByWebAclIdResponse;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsRequest;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsResponse;
import software.amazon.awssdk.services.cloudfront.model.ListFieldLevelEncryptionConfigsRequest;
import software.amazon.awssdk.services.cloudfront.model.ListFieldLevelEncryptionConfigsResponse;
import software.amazon.awssdk.services.cloudfront.model.ListFieldLevelEncryptionProfilesRequest;
import software.amazon.awssdk.services.cloudfront.model.ListFieldLevelEncryptionProfilesResponse;
import software.amazon.awssdk.services.cloudfront.model.ListFunctionsRequest;
import software.amazon.awssdk.services.cloudfront.model.ListFunctionsResponse;
import software.amazon.awssdk.services.cloudfront.model.ListInvalidationsRequest;
import software.amazon.awssdk.services.cloudfront.model.ListInvalidationsResponse;
import software.amazon.awssdk.services.cloudfront.model.ListKeyGroupsRequest;
import software.amazon.awssdk.services.cloudfront.model.ListKeyGroupsResponse;
import software.amazon.awssdk.services.cloudfront.model.ListOriginAccessControlsRequest;
import software.amazon.awssdk.services.cloudfront.model.ListOriginAccessControlsResponse;
import software.amazon.awssdk.services.cloudfront.model.ListOriginRequestPoliciesRequest;
import software.amazon.awssdk.services.cloudfront.model.ListOriginRequestPoliciesResponse;
import software.amazon.awssdk.services.cloudfront.model.ListPublicKeysRequest;
import software.amazon.awssdk.services.cloudfront.model.ListPublicKeysResponse;
import software.amazon.awssdk.services.cloudfront.model.ListRealtimeLogConfigsRequest;
import software.amazon.awssdk.services.cloudfront.model.ListRealtimeLogConfigsResponse;
import software.amazon.awssdk.services.cloudfront.model.ListResponseHeadersPoliciesRequest;
import software.amazon.awssdk.services.cloudfront.model.ListResponseHeadersPoliciesResponse;
import software.amazon.awssdk.services.cloudfront.model.ListStreamingDistributionsRequest;
import software.amazon.awssdk.services.cloudfront.model.ListStreamingDistributionsResponse;
import software.amazon.awssdk.services.cloudfront.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.cloudfront.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.cloudfront.model.MissingBodyException;
import software.amazon.awssdk.services.cloudfront.model.MonitoringSubscriptionAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchCachePolicyException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchCloudFrontOriginAccessIdentityException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchContinuousDeploymentPolicyException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchDistributionException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchFieldLevelEncryptionConfigException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchFieldLevelEncryptionProfileException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchFunctionExistsException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchInvalidationException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchMonitoringSubscriptionException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchOriginAccessControlException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchOriginException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchOriginRequestPolicyException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchPublicKeyException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchRealtimeLogConfigException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchResourceException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchResponseHeadersPolicyException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchStreamingDistributionException;
import software.amazon.awssdk.services.cloudfront.model.OriginAccessControlAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.OriginAccessControlInUseException;
import software.amazon.awssdk.services.cloudfront.model.OriginRequestPolicyAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.OriginRequestPolicyInUseException;
import software.amazon.awssdk.services.cloudfront.model.PreconditionFailedException;
import software.amazon.awssdk.services.cloudfront.model.PublicKeyAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.PublicKeyInUseException;
import software.amazon.awssdk.services.cloudfront.model.PublishFunctionRequest;
import software.amazon.awssdk.services.cloudfront.model.PublishFunctionResponse;
import software.amazon.awssdk.services.cloudfront.model.QueryArgProfileEmptyException;
import software.amazon.awssdk.services.cloudfront.model.RealtimeLogConfigAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.RealtimeLogConfigInUseException;
import software.amazon.awssdk.services.cloudfront.model.RealtimeLogConfigOwnerMismatchException;
import software.amazon.awssdk.services.cloudfront.model.ResourceInUseException;
import software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicyAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicyInUseException;
import software.amazon.awssdk.services.cloudfront.model.StagingDistributionInUseException;
import software.amazon.awssdk.services.cloudfront.model.StreamingDistributionAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.StreamingDistributionNotDisabledException;
import software.amazon.awssdk.services.cloudfront.model.TagResourceRequest;
import software.amazon.awssdk.services.cloudfront.model.TagResourceResponse;
import software.amazon.awssdk.services.cloudfront.model.TestFunctionFailedException;
import software.amazon.awssdk.services.cloudfront.model.TestFunctionRequest;
import software.amazon.awssdk.services.cloudfront.model.TestFunctionResponse;
import software.amazon.awssdk.services.cloudfront.model.TooLongCspInResponseHeadersPolicyException;
import software.amazon.awssdk.services.cloudfront.model.TooManyCacheBehaviorsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyCachePoliciesException;
import software.amazon.awssdk.services.cloudfront.model.TooManyCertificatesException;
import software.amazon.awssdk.services.cloudfront.model.TooManyCloudFrontOriginAccessIdentitiesException;
import software.amazon.awssdk.services.cloudfront.model.TooManyContinuousDeploymentPoliciesException;
import software.amazon.awssdk.services.cloudfront.model.TooManyCookieNamesInWhiteListException;
import software.amazon.awssdk.services.cloudfront.model.TooManyCookiesInCachePolicyException;
import software.amazon.awssdk.services.cloudfront.model.TooManyCookiesInOriginRequestPolicyException;
import software.amazon.awssdk.services.cloudfront.model.TooManyCustomHeadersInResponseHeadersPolicyException;
import software.amazon.awssdk.services.cloudfront.model.TooManyDistributionCnamEsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyDistributionsAssociatedToCachePolicyException;
import software.amazon.awssdk.services.cloudfront.model.TooManyDistributionsAssociatedToFieldLevelEncryptionConfigException;
import software.amazon.awssdk.services.cloudfront.model.TooManyDistributionsAssociatedToKeyGroupException;
import software.amazon.awssdk.services.cloudfront.model.TooManyDistributionsAssociatedToOriginAccessControlException;
import software.amazon.awssdk.services.cloudfront.model.TooManyDistributionsAssociatedToOriginRequestPolicyException;
import software.amazon.awssdk.services.cloudfront.model.TooManyDistributionsAssociatedToResponseHeadersPolicyException;
import software.amazon.awssdk.services.cloudfront.model.TooManyDistributionsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyDistributionsWithFunctionAssociationsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyDistributionsWithLambdaAssociationsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyDistributionsWithSingleFunctionArnException;
import software.amazon.awssdk.services.cloudfront.model.TooManyFieldLevelEncryptionConfigsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyFieldLevelEncryptionContentTypeProfilesException;
import software.amazon.awssdk.services.cloudfront.model.TooManyFieldLevelEncryptionEncryptionEntitiesException;
import software.amazon.awssdk.services.cloudfront.model.TooManyFieldLevelEncryptionFieldPatternsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyFieldLevelEncryptionProfilesException;
import software.amazon.awssdk.services.cloudfront.model.TooManyFieldLevelEncryptionQueryArgProfilesException;
import software.amazon.awssdk.services.cloudfront.model.TooManyFunctionAssociationsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyFunctionsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyHeadersInCachePolicyException;
import software.amazon.awssdk.services.cloudfront.model.TooManyHeadersInForwardedValuesException;
import software.amazon.awssdk.services.cloudfront.model.TooManyHeadersInOriginRequestPolicyException;
import software.amazon.awssdk.services.cloudfront.model.TooManyInvalidationsInProgressException;
import software.amazon.awssdk.services.cloudfront.model.TooManyKeyGroupsAssociatedToDistributionException;
import software.amazon.awssdk.services.cloudfront.model.TooManyKeyGroupsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyLambdaFunctionAssociationsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyOriginAccessControlsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyOriginCustomHeadersException;
import software.amazon.awssdk.services.cloudfront.model.TooManyOriginGroupsPerDistributionException;
import software.amazon.awssdk.services.cloudfront.model.TooManyOriginRequestPoliciesException;
import software.amazon.awssdk.services.cloudfront.model.TooManyOriginsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyPublicKeysException;
import software.amazon.awssdk.services.cloudfront.model.TooManyPublicKeysInKeyGroupException;
import software.amazon.awssdk.services.cloudfront.model.TooManyQueryStringParametersException;
import software.amazon.awssdk.services.cloudfront.model.TooManyQueryStringsInCachePolicyException;
import software.amazon.awssdk.services.cloudfront.model.TooManyQueryStringsInOriginRequestPolicyException;
import software.amazon.awssdk.services.cloudfront.model.TooManyRealtimeLogConfigsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyRemoveHeadersInResponseHeadersPolicyException;
import software.amazon.awssdk.services.cloudfront.model.TooManyResponseHeadersPoliciesException;
import software.amazon.awssdk.services.cloudfront.model.TooManyStreamingDistributionCnamEsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyStreamingDistributionsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyTrustedSignersException;
import software.amazon.awssdk.services.cloudfront.model.TrustedKeyGroupDoesNotExistException;
import software.amazon.awssdk.services.cloudfront.model.TrustedSignerDoesNotExistException;
import software.amazon.awssdk.services.cloudfront.model.UnsupportedOperationException;
import software.amazon.awssdk.services.cloudfront.model.UntagResourceRequest;
import software.amazon.awssdk.services.cloudfront.model.UntagResourceResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateCachePolicyRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateCachePolicyResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateCloudFrontOriginAccessIdentityRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateCloudFrontOriginAccessIdentityResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateContinuousDeploymentPolicyRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateContinuousDeploymentPolicyResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateDistributionResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateDistributionWithStagingConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateDistributionWithStagingConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateFieldLevelEncryptionConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateFieldLevelEncryptionConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateFieldLevelEncryptionProfileRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateFieldLevelEncryptionProfileResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateFunctionRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateFunctionResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateKeyGroupRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateKeyGroupResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateOriginAccessControlRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateOriginAccessControlResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateOriginRequestPolicyRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateOriginRequestPolicyResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdatePublicKeyRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdatePublicKeyResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateRealtimeLogConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateRealtimeLogConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateResponseHeadersPolicyRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateResponseHeadersPolicyResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateStreamingDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateStreamingDistributionResponse;
import software.amazon.awssdk.services.cloudfront.transform.AssociateAliasRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CopyDistributionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateCachePolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateCloudFrontOriginAccessIdentityRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateContinuousDeploymentPolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateDistributionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateDistributionWithTagsRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateFieldLevelEncryptionConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateFieldLevelEncryptionProfileRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateFunctionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateInvalidationRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateKeyGroupRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateMonitoringSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateOriginAccessControlRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateOriginRequestPolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreatePublicKeyRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateRealtimeLogConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateResponseHeadersPolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateStreamingDistributionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateStreamingDistributionWithTagsRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.DeleteCachePolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.DeleteCloudFrontOriginAccessIdentityRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.DeleteContinuousDeploymentPolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.DeleteDistributionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.DeleteFieldLevelEncryptionConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.DeleteFieldLevelEncryptionProfileRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.DeleteFunctionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.DeleteKeyGroupRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.DeleteMonitoringSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.DeleteOriginAccessControlRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.DeleteOriginRequestPolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.DeletePublicKeyRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.DeleteRealtimeLogConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.DeleteResponseHeadersPolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.DeleteStreamingDistributionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.DescribeFunctionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetCachePolicyConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetCachePolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetCloudFrontOriginAccessIdentityConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetCloudFrontOriginAccessIdentityRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetContinuousDeploymentPolicyConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetContinuousDeploymentPolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetDistributionConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetDistributionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetFieldLevelEncryptionConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetFieldLevelEncryptionProfileConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetFieldLevelEncryptionProfileRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetFieldLevelEncryptionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetFunctionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetInvalidationRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetKeyGroupConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetKeyGroupRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetMonitoringSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetOriginAccessControlConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetOriginAccessControlRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetOriginRequestPolicyConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetOriginRequestPolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetPublicKeyConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetPublicKeyRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetRealtimeLogConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetResponseHeadersPolicyConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetResponseHeadersPolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetStreamingDistributionConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetStreamingDistributionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListCachePoliciesRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListCloudFrontOriginAccessIdentitiesRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListConflictingAliasesRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListContinuousDeploymentPoliciesRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListDistributionsByCachePolicyIdRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListDistributionsByKeyGroupRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListDistributionsByOriginRequestPolicyIdRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListDistributionsByRealtimeLogConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListDistributionsByResponseHeadersPolicyIdRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListDistributionsByWebAclIdRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListDistributionsRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListFieldLevelEncryptionConfigsRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListFieldLevelEncryptionProfilesRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListFunctionsRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListInvalidationsRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListKeyGroupsRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListOriginAccessControlsRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListOriginRequestPoliciesRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListPublicKeysRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListRealtimeLogConfigsRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListResponseHeadersPoliciesRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListStreamingDistributionsRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.PublishFunctionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.TestFunctionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.UpdateCachePolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.UpdateCloudFrontOriginAccessIdentityRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.UpdateContinuousDeploymentPolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.UpdateDistributionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.UpdateDistributionWithStagingConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.UpdateFieldLevelEncryptionConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.UpdateFieldLevelEncryptionProfileRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.UpdateFunctionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.UpdateKeyGroupRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.UpdateOriginAccessControlRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.UpdateOriginRequestPolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.UpdatePublicKeyRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.UpdateRealtimeLogConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.UpdateResponseHeadersPolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.UpdateStreamingDistributionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.waiters.CloudFrontWaiter;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultCloudFrontClient
implements CloudFrontClient {
    private static final Logger log = Logger.loggerFor(DefaultCloudFrontClient.class);
    private final SyncClientHandler clientHandler;
    private final AwsXmlProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultCloudFrontClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AssociateAliasResponse associateAlias(AssociateAliasRequest associateAliasRequest) throws InvalidArgumentException, NoSuchDistributionException, TooManyDistributionCnamEsException, IllegalUpdateException, AccessDeniedException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(AssociateAliasResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, associateAliasRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssociateAlias");
            AssociateAliasResponse associateAliasResponse = (AssociateAliasResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateAlias").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)associateAliasRequest).withMarshaller((Marshaller)new AssociateAliasRequestMarshaller(this.protocolFactory)));
            return associateAliasResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$associateAlias$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CopyDistributionResponse copyDistribution(CopyDistributionRequest copyDistributionRequest) throws CnameAlreadyExistsException, DistributionAlreadyExistsException, InvalidOriginException, InvalidOriginAccessIdentityException, InvalidOriginAccessControlException, InvalidIfMatchVersionException, NoSuchDistributionException, PreconditionFailedException, AccessDeniedException, TooManyTrustedSignersException, TrustedSignerDoesNotExistException, InvalidViewerCertificateException, InvalidMinimumProtocolVersionException, MissingBodyException, TooManyDistributionCnamEsException, TooManyDistributionsException, InvalidDefaultRootObjectException, InvalidRelativePathException, InvalidErrorCodeException, InvalidResponseCodeException, InvalidArgumentException, InvalidRequiredProtocolException, NoSuchOriginException, TooManyOriginsException, TooManyOriginGroupsPerDistributionException, TooManyCacheBehaviorsException, TooManyCookieNamesInWhiteListException, InvalidForwardCookiesException, TooManyHeadersInForwardedValuesException, InvalidHeadersForS3OriginException, InconsistentQuantitiesException, TooManyCertificatesException, InvalidLocationCodeException, InvalidGeoRestrictionParameterException, InvalidProtocolSettingsException, InvalidTtlOrderException, InvalidWebAclIdException, TooManyOriginCustomHeadersException, TooManyQueryStringParametersException, InvalidQueryStringParametersException, TooManyDistributionsWithLambdaAssociationsException, TooManyDistributionsWithSingleFunctionArnException, TooManyLambdaFunctionAssociationsException, InvalidLambdaFunctionAssociationException, TooManyDistributionsWithFunctionAssociationsException, TooManyFunctionAssociationsException, InvalidFunctionAssociationException, InvalidOriginReadTimeoutException, InvalidOriginKeepaliveTimeoutException, NoSuchFieldLevelEncryptionConfigException, IllegalFieldLevelEncryptionConfigAssociationWithCacheBehaviorException, TooManyDistributionsAssociatedToFieldLevelEncryptionConfigException, NoSuchCachePolicyException, TooManyDistributionsAssociatedToCachePolicyException, NoSuchResponseHeadersPolicyException, TooManyDistributionsAssociatedToResponseHeadersPolicyException, NoSuchOriginRequestPolicyException, TooManyDistributionsAssociatedToOriginRequestPolicyException, TooManyDistributionsAssociatedToKeyGroupException, TooManyKeyGroupsAssociatedToDistributionException, TrustedKeyGroupDoesNotExistException, NoSuchRealtimeLogConfigException, RealtimeLogConfigOwnerMismatchException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(CopyDistributionResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, copyDistributionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CopyDistribution");
            CopyDistributionResponse copyDistributionResponse = (CopyDistributionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CopyDistribution").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)copyDistributionRequest).withMarshaller((Marshaller)new CopyDistributionRequestMarshaller(this.protocolFactory)));
            return copyDistributionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$copyDistribution$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateCachePolicyResponse createCachePolicy(CreateCachePolicyRequest createCachePolicyRequest) throws AccessDeniedException, InconsistentQuantitiesException, InvalidArgumentException, CachePolicyAlreadyExistsException, TooManyCachePoliciesException, TooManyHeadersInCachePolicyException, TooManyCookiesInCachePolicyException, TooManyQueryStringsInCachePolicyException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(CreateCachePolicyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, createCachePolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateCachePolicy");
            CreateCachePolicyResponse createCachePolicyResponse = (CreateCachePolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateCachePolicy").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createCachePolicyRequest).withMarshaller((Marshaller)new CreateCachePolicyRequestMarshaller(this.protocolFactory)));
            return createCachePolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$createCachePolicy$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateCloudFrontOriginAccessIdentityResponse createCloudFrontOriginAccessIdentity(CreateCloudFrontOriginAccessIdentityRequest createCloudFrontOriginAccessIdentityRequest) throws CloudFrontOriginAccessIdentityAlreadyExistsException, MissingBodyException, TooManyCloudFrontOriginAccessIdentitiesException, InvalidArgumentException, InconsistentQuantitiesException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(CreateCloudFrontOriginAccessIdentityResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, createCloudFrontOriginAccessIdentityRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateCloudFrontOriginAccessIdentity");
            CreateCloudFrontOriginAccessIdentityResponse createCloudFrontOriginAccessIdentityResponse = (CreateCloudFrontOriginAccessIdentityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateCloudFrontOriginAccessIdentity").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createCloudFrontOriginAccessIdentityRequest).withMarshaller((Marshaller)new CreateCloudFrontOriginAccessIdentityRequestMarshaller(this.protocolFactory)));
            return createCloudFrontOriginAccessIdentityResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$createCloudFrontOriginAccessIdentity$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateContinuousDeploymentPolicyResponse createContinuousDeploymentPolicy(CreateContinuousDeploymentPolicyRequest createContinuousDeploymentPolicyRequest) throws AccessDeniedException, InvalidArgumentException, InconsistentQuantitiesException, ContinuousDeploymentPolicyAlreadyExistsException, TooManyContinuousDeploymentPoliciesException, StagingDistributionInUseException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(CreateContinuousDeploymentPolicyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, createContinuousDeploymentPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateContinuousDeploymentPolicy");
            CreateContinuousDeploymentPolicyResponse createContinuousDeploymentPolicyResponse = (CreateContinuousDeploymentPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateContinuousDeploymentPolicy").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createContinuousDeploymentPolicyRequest).withMarshaller((Marshaller)new CreateContinuousDeploymentPolicyRequestMarshaller(this.protocolFactory)));
            return createContinuousDeploymentPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$createContinuousDeploymentPolicy$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateDistributionResponse createDistribution(CreateDistributionRequest createDistributionRequest) throws CnameAlreadyExistsException, DistributionAlreadyExistsException, InvalidOriginException, InvalidOriginAccessIdentityException, InvalidOriginAccessControlException, IllegalOriginAccessConfigurationException, TooManyDistributionsAssociatedToOriginAccessControlException, AccessDeniedException, TooManyTrustedSignersException, TrustedSignerDoesNotExistException, InvalidViewerCertificateException, InvalidMinimumProtocolVersionException, MissingBodyException, TooManyDistributionCnamEsException, TooManyDistributionsException, InvalidDefaultRootObjectException, InvalidRelativePathException, InvalidErrorCodeException, InvalidResponseCodeException, InvalidArgumentException, InvalidRequiredProtocolException, NoSuchOriginException, TooManyOriginsException, TooManyOriginGroupsPerDistributionException, TooManyCacheBehaviorsException, TooManyCookieNamesInWhiteListException, InvalidForwardCookiesException, TooManyHeadersInForwardedValuesException, InvalidHeadersForS3OriginException, InconsistentQuantitiesException, TooManyCertificatesException, InvalidLocationCodeException, InvalidGeoRestrictionParameterException, InvalidProtocolSettingsException, InvalidTtlOrderException, InvalidWebAclIdException, TooManyOriginCustomHeadersException, TooManyQueryStringParametersException, InvalidQueryStringParametersException, TooManyDistributionsWithLambdaAssociationsException, TooManyDistributionsWithSingleFunctionArnException, TooManyLambdaFunctionAssociationsException, InvalidLambdaFunctionAssociationException, TooManyDistributionsWithFunctionAssociationsException, TooManyFunctionAssociationsException, InvalidFunctionAssociationException, InvalidOriginReadTimeoutException, InvalidOriginKeepaliveTimeoutException, NoSuchFieldLevelEncryptionConfigException, IllegalFieldLevelEncryptionConfigAssociationWithCacheBehaviorException, TooManyDistributionsAssociatedToFieldLevelEncryptionConfigException, NoSuchCachePolicyException, TooManyDistributionsAssociatedToCachePolicyException, NoSuchResponseHeadersPolicyException, TooManyDistributionsAssociatedToResponseHeadersPolicyException, NoSuchOriginRequestPolicyException, TooManyDistributionsAssociatedToOriginRequestPolicyException, TooManyDistributionsAssociatedToKeyGroupException, TooManyKeyGroupsAssociatedToDistributionException, TrustedKeyGroupDoesNotExistException, NoSuchRealtimeLogConfigException, RealtimeLogConfigOwnerMismatchException, ContinuousDeploymentPolicyInUseException, NoSuchContinuousDeploymentPolicyException, InvalidDomainNameForOriginAccessControlException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(CreateDistributionResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, createDistributionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDistribution");
            CreateDistributionResponse createDistributionResponse = (CreateDistributionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDistribution").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createDistributionRequest).withMarshaller((Marshaller)new CreateDistributionRequestMarshaller(this.protocolFactory)));
            return createDistributionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$createDistribution$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateDistributionWithTagsResponse createDistributionWithTags(CreateDistributionWithTagsRequest createDistributionWithTagsRequest) throws CnameAlreadyExistsException, DistributionAlreadyExistsException, InvalidOriginException, InvalidOriginAccessIdentityException, InvalidOriginAccessControlException, AccessDeniedException, TooManyTrustedSignersException, TrustedSignerDoesNotExistException, InvalidViewerCertificateException, InvalidMinimumProtocolVersionException, MissingBodyException, TooManyDistributionCnamEsException, TooManyDistributionsException, InvalidDefaultRootObjectException, InvalidRelativePathException, InvalidErrorCodeException, InvalidResponseCodeException, InvalidArgumentException, InvalidRequiredProtocolException, NoSuchOriginException, TooManyOriginsException, TooManyOriginGroupsPerDistributionException, TooManyCacheBehaviorsException, TooManyCookieNamesInWhiteListException, InvalidForwardCookiesException, TooManyHeadersInForwardedValuesException, InvalidHeadersForS3OriginException, InconsistentQuantitiesException, TooManyCertificatesException, InvalidLocationCodeException, InvalidGeoRestrictionParameterException, InvalidProtocolSettingsException, InvalidTtlOrderException, InvalidWebAclIdException, TooManyOriginCustomHeadersException, InvalidTaggingException, TooManyQueryStringParametersException, InvalidQueryStringParametersException, TooManyDistributionsWithLambdaAssociationsException, TooManyDistributionsWithSingleFunctionArnException, TooManyLambdaFunctionAssociationsException, InvalidLambdaFunctionAssociationException, TooManyDistributionsWithFunctionAssociationsException, TooManyFunctionAssociationsException, InvalidFunctionAssociationException, InvalidOriginReadTimeoutException, InvalidOriginKeepaliveTimeoutException, NoSuchFieldLevelEncryptionConfigException, IllegalFieldLevelEncryptionConfigAssociationWithCacheBehaviorException, TooManyDistributionsAssociatedToFieldLevelEncryptionConfigException, NoSuchCachePolicyException, TooManyDistributionsAssociatedToCachePolicyException, NoSuchResponseHeadersPolicyException, TooManyDistributionsAssociatedToResponseHeadersPolicyException, NoSuchOriginRequestPolicyException, TooManyDistributionsAssociatedToOriginRequestPolicyException, TooManyDistributionsAssociatedToKeyGroupException, TooManyKeyGroupsAssociatedToDistributionException, TrustedKeyGroupDoesNotExistException, NoSuchRealtimeLogConfigException, RealtimeLogConfigOwnerMismatchException, ContinuousDeploymentPolicyInUseException, NoSuchContinuousDeploymentPolicyException, InvalidDomainNameForOriginAccessControlException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(CreateDistributionWithTagsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, createDistributionWithTagsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDistributionWithTags");
            CreateDistributionWithTagsResponse createDistributionWithTagsResponse = (CreateDistributionWithTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDistributionWithTags").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createDistributionWithTagsRequest).withMarshaller((Marshaller)new CreateDistributionWithTagsRequestMarshaller(this.protocolFactory)));
            return createDistributionWithTagsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$createDistributionWithTags$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateFieldLevelEncryptionConfigResponse createFieldLevelEncryptionConfig(CreateFieldLevelEncryptionConfigRequest createFieldLevelEncryptionConfigRequest) throws InconsistentQuantitiesException, InvalidArgumentException, NoSuchFieldLevelEncryptionProfileException, FieldLevelEncryptionConfigAlreadyExistsException, TooManyFieldLevelEncryptionConfigsException, TooManyFieldLevelEncryptionQueryArgProfilesException, TooManyFieldLevelEncryptionContentTypeProfilesException, QueryArgProfileEmptyException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(CreateFieldLevelEncryptionConfigResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, createFieldLevelEncryptionConfigRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateFieldLevelEncryptionConfig");
            CreateFieldLevelEncryptionConfigResponse createFieldLevelEncryptionConfigResponse = (CreateFieldLevelEncryptionConfigResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateFieldLevelEncryptionConfig").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createFieldLevelEncryptionConfigRequest).withMarshaller((Marshaller)new CreateFieldLevelEncryptionConfigRequestMarshaller(this.protocolFactory)));
            return createFieldLevelEncryptionConfigResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$createFieldLevelEncryptionConfig$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateFieldLevelEncryptionProfileResponse createFieldLevelEncryptionProfile(CreateFieldLevelEncryptionProfileRequest createFieldLevelEncryptionProfileRequest) throws InconsistentQuantitiesException, InvalidArgumentException, NoSuchPublicKeyException, FieldLevelEncryptionProfileAlreadyExistsException, FieldLevelEncryptionProfileSizeExceededException, TooManyFieldLevelEncryptionProfilesException, TooManyFieldLevelEncryptionEncryptionEntitiesException, TooManyFieldLevelEncryptionFieldPatternsException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(CreateFieldLevelEncryptionProfileResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, createFieldLevelEncryptionProfileRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateFieldLevelEncryptionProfile");
            CreateFieldLevelEncryptionProfileResponse createFieldLevelEncryptionProfileResponse = (CreateFieldLevelEncryptionProfileResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateFieldLevelEncryptionProfile").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createFieldLevelEncryptionProfileRequest).withMarshaller((Marshaller)new CreateFieldLevelEncryptionProfileRequestMarshaller(this.protocolFactory)));
            return createFieldLevelEncryptionProfileResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$createFieldLevelEncryptionProfile$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateFunctionResponse createFunction(CreateFunctionRequest createFunctionRequest) throws TooManyFunctionsException, FunctionAlreadyExistsException, FunctionSizeLimitExceededException, InvalidArgumentException, UnsupportedOperationException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(CreateFunctionResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, createFunctionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateFunction");
            CreateFunctionResponse createFunctionResponse = (CreateFunctionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateFunction").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createFunctionRequest).withMarshaller((Marshaller)new CreateFunctionRequestMarshaller(this.protocolFactory)));
            return createFunctionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$createFunction$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateInvalidationResponse createInvalidation(CreateInvalidationRequest createInvalidationRequest) throws AccessDeniedException, MissingBodyException, InvalidArgumentException, NoSuchDistributionException, BatchTooLargeException, TooManyInvalidationsInProgressException, InconsistentQuantitiesException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(CreateInvalidationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, createInvalidationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateInvalidation");
            CreateInvalidationResponse createInvalidationResponse = (CreateInvalidationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateInvalidation").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createInvalidationRequest).withMarshaller((Marshaller)new CreateInvalidationRequestMarshaller(this.protocolFactory)));
            return createInvalidationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$createInvalidation$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateKeyGroupResponse createKeyGroup(CreateKeyGroupRequest createKeyGroupRequest) throws InvalidArgumentException, KeyGroupAlreadyExistsException, TooManyKeyGroupsException, TooManyPublicKeysInKeyGroupException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(CreateKeyGroupResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, createKeyGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateKeyGroup");
            CreateKeyGroupResponse createKeyGroupResponse = (CreateKeyGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateKeyGroup").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createKeyGroupRequest).withMarshaller((Marshaller)new CreateKeyGroupRequestMarshaller(this.protocolFactory)));
            return createKeyGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$createKeyGroup$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateMonitoringSubscriptionResponse createMonitoringSubscription(CreateMonitoringSubscriptionRequest createMonitoringSubscriptionRequest) throws AccessDeniedException, NoSuchDistributionException, MonitoringSubscriptionAlreadyExistsException, UnsupportedOperationException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(CreateMonitoringSubscriptionResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, createMonitoringSubscriptionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateMonitoringSubscription");
            CreateMonitoringSubscriptionResponse createMonitoringSubscriptionResponse = (CreateMonitoringSubscriptionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateMonitoringSubscription").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createMonitoringSubscriptionRequest).withMarshaller((Marshaller)new CreateMonitoringSubscriptionRequestMarshaller(this.protocolFactory)));
            return createMonitoringSubscriptionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$createMonitoringSubscription$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateOriginAccessControlResponse createOriginAccessControl(CreateOriginAccessControlRequest createOriginAccessControlRequest) throws OriginAccessControlAlreadyExistsException, TooManyOriginAccessControlsException, InvalidArgumentException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(CreateOriginAccessControlResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, createOriginAccessControlRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateOriginAccessControl");
            CreateOriginAccessControlResponse createOriginAccessControlResponse = (CreateOriginAccessControlResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateOriginAccessControl").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createOriginAccessControlRequest).withMarshaller((Marshaller)new CreateOriginAccessControlRequestMarshaller(this.protocolFactory)));
            return createOriginAccessControlResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$createOriginAccessControl$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateOriginRequestPolicyResponse createOriginRequestPolicy(CreateOriginRequestPolicyRequest createOriginRequestPolicyRequest) throws AccessDeniedException, InconsistentQuantitiesException, InvalidArgumentException, OriginRequestPolicyAlreadyExistsException, TooManyOriginRequestPoliciesException, TooManyHeadersInOriginRequestPolicyException, TooManyCookiesInOriginRequestPolicyException, TooManyQueryStringsInOriginRequestPolicyException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(CreateOriginRequestPolicyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, createOriginRequestPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateOriginRequestPolicy");
            CreateOriginRequestPolicyResponse createOriginRequestPolicyResponse = (CreateOriginRequestPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateOriginRequestPolicy").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createOriginRequestPolicyRequest).withMarshaller((Marshaller)new CreateOriginRequestPolicyRequestMarshaller(this.protocolFactory)));
            return createOriginRequestPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$createOriginRequestPolicy$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreatePublicKeyResponse createPublicKey(CreatePublicKeyRequest createPublicKeyRequest) throws PublicKeyAlreadyExistsException, InvalidArgumentException, TooManyPublicKeysException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(CreatePublicKeyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, createPublicKeyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreatePublicKey");
            CreatePublicKeyResponse createPublicKeyResponse = (CreatePublicKeyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreatePublicKey").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createPublicKeyRequest).withMarshaller((Marshaller)new CreatePublicKeyRequestMarshaller(this.protocolFactory)));
            return createPublicKeyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$createPublicKey$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateRealtimeLogConfigResponse createRealtimeLogConfig(CreateRealtimeLogConfigRequest createRealtimeLogConfigRequest) throws RealtimeLogConfigAlreadyExistsException, TooManyRealtimeLogConfigsException, InvalidArgumentException, AccessDeniedException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(CreateRealtimeLogConfigResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, createRealtimeLogConfigRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateRealtimeLogConfig");
            CreateRealtimeLogConfigResponse createRealtimeLogConfigResponse = (CreateRealtimeLogConfigResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateRealtimeLogConfig").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createRealtimeLogConfigRequest).withMarshaller((Marshaller)new CreateRealtimeLogConfigRequestMarshaller(this.protocolFactory)));
            return createRealtimeLogConfigResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$createRealtimeLogConfig$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateResponseHeadersPolicyResponse createResponseHeadersPolicy(CreateResponseHeadersPolicyRequest createResponseHeadersPolicyRequest) throws AccessDeniedException, InconsistentQuantitiesException, InvalidArgumentException, ResponseHeadersPolicyAlreadyExistsException, TooManyResponseHeadersPoliciesException, TooManyCustomHeadersInResponseHeadersPolicyException, TooLongCspInResponseHeadersPolicyException, TooManyRemoveHeadersInResponseHeadersPolicyException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(CreateResponseHeadersPolicyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, createResponseHeadersPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateResponseHeadersPolicy");
            CreateResponseHeadersPolicyResponse createResponseHeadersPolicyResponse = (CreateResponseHeadersPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateResponseHeadersPolicy").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createResponseHeadersPolicyRequest).withMarshaller((Marshaller)new CreateResponseHeadersPolicyRequestMarshaller(this.protocolFactory)));
            return createResponseHeadersPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$createResponseHeadersPolicy$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateStreamingDistributionResponse createStreamingDistribution(CreateStreamingDistributionRequest createStreamingDistributionRequest) throws CnameAlreadyExistsException, StreamingDistributionAlreadyExistsException, InvalidOriginException, InvalidOriginAccessIdentityException, InvalidOriginAccessControlException, AccessDeniedException, TooManyTrustedSignersException, TrustedSignerDoesNotExistException, MissingBodyException, TooManyStreamingDistributionCnamEsException, TooManyStreamingDistributionsException, InvalidArgumentException, InconsistentQuantitiesException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(CreateStreamingDistributionResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, createStreamingDistributionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateStreamingDistribution");
            CreateStreamingDistributionResponse createStreamingDistributionResponse = (CreateStreamingDistributionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateStreamingDistribution").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createStreamingDistributionRequest).withMarshaller((Marshaller)new CreateStreamingDistributionRequestMarshaller(this.protocolFactory)));
            return createStreamingDistributionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$createStreamingDistribution$18((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateStreamingDistributionWithTagsResponse createStreamingDistributionWithTags(CreateStreamingDistributionWithTagsRequest createStreamingDistributionWithTagsRequest) throws CnameAlreadyExistsException, StreamingDistributionAlreadyExistsException, InvalidOriginException, InvalidOriginAccessIdentityException, InvalidOriginAccessControlException, AccessDeniedException, TooManyTrustedSignersException, TrustedSignerDoesNotExistException, MissingBodyException, TooManyStreamingDistributionCnamEsException, TooManyStreamingDistributionsException, InvalidArgumentException, InconsistentQuantitiesException, InvalidTaggingException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(CreateStreamingDistributionWithTagsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, createStreamingDistributionWithTagsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateStreamingDistributionWithTags");
            CreateStreamingDistributionWithTagsResponse createStreamingDistributionWithTagsResponse = (CreateStreamingDistributionWithTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateStreamingDistributionWithTags").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createStreamingDistributionWithTagsRequest).withMarshaller((Marshaller)new CreateStreamingDistributionWithTagsRequestMarshaller(this.protocolFactory)));
            return createStreamingDistributionWithTagsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$createStreamingDistributionWithTags$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteCachePolicyResponse deleteCachePolicy(DeleteCachePolicyRequest deleteCachePolicyRequest) throws AccessDeniedException, InvalidIfMatchVersionException, NoSuchCachePolicyException, PreconditionFailedException, IllegalDeleteException, CachePolicyInUseException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteCachePolicyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, deleteCachePolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteCachePolicy");
            DeleteCachePolicyResponse deleteCachePolicyResponse = (DeleteCachePolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteCachePolicy").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteCachePolicyRequest).withMarshaller((Marshaller)new DeleteCachePolicyRequestMarshaller(this.protocolFactory)));
            return deleteCachePolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$deleteCachePolicy$20((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteCloudFrontOriginAccessIdentityResponse deleteCloudFrontOriginAccessIdentity(DeleteCloudFrontOriginAccessIdentityRequest deleteCloudFrontOriginAccessIdentityRequest) throws AccessDeniedException, InvalidIfMatchVersionException, NoSuchCloudFrontOriginAccessIdentityException, PreconditionFailedException, CloudFrontOriginAccessIdentityInUseException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteCloudFrontOriginAccessIdentityResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, deleteCloudFrontOriginAccessIdentityRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteCloudFrontOriginAccessIdentity");
            DeleteCloudFrontOriginAccessIdentityResponse deleteCloudFrontOriginAccessIdentityResponse = (DeleteCloudFrontOriginAccessIdentityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteCloudFrontOriginAccessIdentity").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteCloudFrontOriginAccessIdentityRequest).withMarshaller((Marshaller)new DeleteCloudFrontOriginAccessIdentityRequestMarshaller(this.protocolFactory)));
            return deleteCloudFrontOriginAccessIdentityResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$deleteCloudFrontOriginAccessIdentity$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteContinuousDeploymentPolicyResponse deleteContinuousDeploymentPolicy(DeleteContinuousDeploymentPolicyRequest deleteContinuousDeploymentPolicyRequest) throws InvalidIfMatchVersionException, InvalidArgumentException, AccessDeniedException, PreconditionFailedException, ContinuousDeploymentPolicyInUseException, NoSuchContinuousDeploymentPolicyException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteContinuousDeploymentPolicyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, deleteContinuousDeploymentPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteContinuousDeploymentPolicy");
            DeleteContinuousDeploymentPolicyResponse deleteContinuousDeploymentPolicyResponse = (DeleteContinuousDeploymentPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteContinuousDeploymentPolicy").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteContinuousDeploymentPolicyRequest).withMarshaller((Marshaller)new DeleteContinuousDeploymentPolicyRequestMarshaller(this.protocolFactory)));
            return deleteContinuousDeploymentPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$deleteContinuousDeploymentPolicy$22((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteDistributionResponse deleteDistribution(DeleteDistributionRequest deleteDistributionRequest) throws AccessDeniedException, DistributionNotDisabledException, InvalidIfMatchVersionException, NoSuchDistributionException, PreconditionFailedException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteDistributionResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, deleteDistributionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDistribution");
            DeleteDistributionResponse deleteDistributionResponse = (DeleteDistributionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDistribution").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteDistributionRequest).withMarshaller((Marshaller)new DeleteDistributionRequestMarshaller(this.protocolFactory)));
            return deleteDistributionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$deleteDistribution$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteFieldLevelEncryptionConfigResponse deleteFieldLevelEncryptionConfig(DeleteFieldLevelEncryptionConfigRequest deleteFieldLevelEncryptionConfigRequest) throws AccessDeniedException, InvalidIfMatchVersionException, NoSuchFieldLevelEncryptionConfigException, PreconditionFailedException, FieldLevelEncryptionConfigInUseException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteFieldLevelEncryptionConfigResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, deleteFieldLevelEncryptionConfigRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteFieldLevelEncryptionConfig");
            DeleteFieldLevelEncryptionConfigResponse deleteFieldLevelEncryptionConfigResponse = (DeleteFieldLevelEncryptionConfigResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteFieldLevelEncryptionConfig").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteFieldLevelEncryptionConfigRequest).withMarshaller((Marshaller)new DeleteFieldLevelEncryptionConfigRequestMarshaller(this.protocolFactory)));
            return deleteFieldLevelEncryptionConfigResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$deleteFieldLevelEncryptionConfig$24((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteFieldLevelEncryptionProfileResponse deleteFieldLevelEncryptionProfile(DeleteFieldLevelEncryptionProfileRequest deleteFieldLevelEncryptionProfileRequest) throws AccessDeniedException, InvalidIfMatchVersionException, NoSuchFieldLevelEncryptionProfileException, PreconditionFailedException, FieldLevelEncryptionProfileInUseException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteFieldLevelEncryptionProfileResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, deleteFieldLevelEncryptionProfileRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteFieldLevelEncryptionProfile");
            DeleteFieldLevelEncryptionProfileResponse deleteFieldLevelEncryptionProfileResponse = (DeleteFieldLevelEncryptionProfileResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteFieldLevelEncryptionProfile").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteFieldLevelEncryptionProfileRequest).withMarshaller((Marshaller)new DeleteFieldLevelEncryptionProfileRequestMarshaller(this.protocolFactory)));
            return deleteFieldLevelEncryptionProfileResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$deleteFieldLevelEncryptionProfile$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteFunctionResponse deleteFunction(DeleteFunctionRequest deleteFunctionRequest) throws InvalidIfMatchVersionException, NoSuchFunctionExistsException, FunctionInUseException, PreconditionFailedException, UnsupportedOperationException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteFunctionResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, deleteFunctionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteFunction");
            DeleteFunctionResponse deleteFunctionResponse = (DeleteFunctionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteFunction").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteFunctionRequest).withMarshaller((Marshaller)new DeleteFunctionRequestMarshaller(this.protocolFactory)));
            return deleteFunctionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$deleteFunction$26((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteKeyGroupResponse deleteKeyGroup(DeleteKeyGroupRequest deleteKeyGroupRequest) throws InvalidIfMatchVersionException, NoSuchResourceException, PreconditionFailedException, ResourceInUseException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteKeyGroupResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, deleteKeyGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteKeyGroup");
            DeleteKeyGroupResponse deleteKeyGroupResponse = (DeleteKeyGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteKeyGroup").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteKeyGroupRequest).withMarshaller((Marshaller)new DeleteKeyGroupRequestMarshaller(this.protocolFactory)));
            return deleteKeyGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$deleteKeyGroup$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteMonitoringSubscriptionResponse deleteMonitoringSubscription(DeleteMonitoringSubscriptionRequest deleteMonitoringSubscriptionRequest) throws AccessDeniedException, NoSuchDistributionException, NoSuchMonitoringSubscriptionException, UnsupportedOperationException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteMonitoringSubscriptionResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, deleteMonitoringSubscriptionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteMonitoringSubscription");
            DeleteMonitoringSubscriptionResponse deleteMonitoringSubscriptionResponse = (DeleteMonitoringSubscriptionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteMonitoringSubscription").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteMonitoringSubscriptionRequest).withMarshaller((Marshaller)new DeleteMonitoringSubscriptionRequestMarshaller(this.protocolFactory)));
            return deleteMonitoringSubscriptionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$deleteMonitoringSubscription$28((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteOriginAccessControlResponse deleteOriginAccessControl(DeleteOriginAccessControlRequest deleteOriginAccessControlRequest) throws AccessDeniedException, InvalidIfMatchVersionException, NoSuchOriginAccessControlException, PreconditionFailedException, OriginAccessControlInUseException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteOriginAccessControlResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, deleteOriginAccessControlRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteOriginAccessControl");
            DeleteOriginAccessControlResponse deleteOriginAccessControlResponse = (DeleteOriginAccessControlResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteOriginAccessControl").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteOriginAccessControlRequest).withMarshaller((Marshaller)new DeleteOriginAccessControlRequestMarshaller(this.protocolFactory)));
            return deleteOriginAccessControlResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$deleteOriginAccessControl$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteOriginRequestPolicyResponse deleteOriginRequestPolicy(DeleteOriginRequestPolicyRequest deleteOriginRequestPolicyRequest) throws AccessDeniedException, InvalidIfMatchVersionException, NoSuchOriginRequestPolicyException, PreconditionFailedException, IllegalDeleteException, OriginRequestPolicyInUseException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteOriginRequestPolicyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, deleteOriginRequestPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteOriginRequestPolicy");
            DeleteOriginRequestPolicyResponse deleteOriginRequestPolicyResponse = (DeleteOriginRequestPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteOriginRequestPolicy").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteOriginRequestPolicyRequest).withMarshaller((Marshaller)new DeleteOriginRequestPolicyRequestMarshaller(this.protocolFactory)));
            return deleteOriginRequestPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$deleteOriginRequestPolicy$30((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeletePublicKeyResponse deletePublicKey(DeletePublicKeyRequest deletePublicKeyRequest) throws AccessDeniedException, PublicKeyInUseException, InvalidIfMatchVersionException, NoSuchPublicKeyException, PreconditionFailedException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeletePublicKeyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, deletePublicKeyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeletePublicKey");
            DeletePublicKeyResponse deletePublicKeyResponse = (DeletePublicKeyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeletePublicKey").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deletePublicKeyRequest).withMarshaller((Marshaller)new DeletePublicKeyRequestMarshaller(this.protocolFactory)));
            return deletePublicKeyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$deletePublicKey$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteRealtimeLogConfigResponse deleteRealtimeLogConfig(DeleteRealtimeLogConfigRequest deleteRealtimeLogConfigRequest) throws NoSuchRealtimeLogConfigException, RealtimeLogConfigInUseException, InvalidArgumentException, AccessDeniedException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteRealtimeLogConfigResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, deleteRealtimeLogConfigRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteRealtimeLogConfig");
            DeleteRealtimeLogConfigResponse deleteRealtimeLogConfigResponse = (DeleteRealtimeLogConfigResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteRealtimeLogConfig").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteRealtimeLogConfigRequest).withMarshaller((Marshaller)new DeleteRealtimeLogConfigRequestMarshaller(this.protocolFactory)));
            return deleteRealtimeLogConfigResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$deleteRealtimeLogConfig$32((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteResponseHeadersPolicyResponse deleteResponseHeadersPolicy(DeleteResponseHeadersPolicyRequest deleteResponseHeadersPolicyRequest) throws AccessDeniedException, InvalidIfMatchVersionException, NoSuchResponseHeadersPolicyException, PreconditionFailedException, IllegalDeleteException, ResponseHeadersPolicyInUseException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteResponseHeadersPolicyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, deleteResponseHeadersPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteResponseHeadersPolicy");
            DeleteResponseHeadersPolicyResponse deleteResponseHeadersPolicyResponse = (DeleteResponseHeadersPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteResponseHeadersPolicy").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteResponseHeadersPolicyRequest).withMarshaller((Marshaller)new DeleteResponseHeadersPolicyRequestMarshaller(this.protocolFactory)));
            return deleteResponseHeadersPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$deleteResponseHeadersPolicy$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteStreamingDistributionResponse deleteStreamingDistribution(DeleteStreamingDistributionRequest deleteStreamingDistributionRequest) throws AccessDeniedException, StreamingDistributionNotDisabledException, InvalidIfMatchVersionException, NoSuchStreamingDistributionException, PreconditionFailedException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteStreamingDistributionResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, deleteStreamingDistributionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteStreamingDistribution");
            DeleteStreamingDistributionResponse deleteStreamingDistributionResponse = (DeleteStreamingDistributionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteStreamingDistribution").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteStreamingDistributionRequest).withMarshaller((Marshaller)new DeleteStreamingDistributionRequestMarshaller(this.protocolFactory)));
            return deleteStreamingDistributionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$deleteStreamingDistribution$34((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeFunctionResponse describeFunction(DescribeFunctionRequest describeFunctionRequest) throws NoSuchFunctionExistsException, UnsupportedOperationException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DescribeFunctionResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, describeFunctionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeFunction");
            DescribeFunctionResponse describeFunctionResponse = (DescribeFunctionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeFunction").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeFunctionRequest).withMarshaller((Marshaller)new DescribeFunctionRequestMarshaller(this.protocolFactory)));
            return describeFunctionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$describeFunction$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetCachePolicyResponse getCachePolicy(GetCachePolicyRequest getCachePolicyRequest) throws AccessDeniedException, NoSuchCachePolicyException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetCachePolicyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, getCachePolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetCachePolicy");
            GetCachePolicyResponse getCachePolicyResponse = (GetCachePolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCachePolicy").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getCachePolicyRequest).withMarshaller((Marshaller)new GetCachePolicyRequestMarshaller(this.protocolFactory)));
            return getCachePolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$getCachePolicy$36((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetCachePolicyConfigResponse getCachePolicyConfig(GetCachePolicyConfigRequest getCachePolicyConfigRequest) throws AccessDeniedException, NoSuchCachePolicyException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetCachePolicyConfigResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, getCachePolicyConfigRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetCachePolicyConfig");
            GetCachePolicyConfigResponse getCachePolicyConfigResponse = (GetCachePolicyConfigResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCachePolicyConfig").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getCachePolicyConfigRequest).withMarshaller((Marshaller)new GetCachePolicyConfigRequestMarshaller(this.protocolFactory)));
            return getCachePolicyConfigResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$getCachePolicyConfig$37((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetCloudFrontOriginAccessIdentityResponse getCloudFrontOriginAccessIdentity(GetCloudFrontOriginAccessIdentityRequest getCloudFrontOriginAccessIdentityRequest) throws NoSuchCloudFrontOriginAccessIdentityException, AccessDeniedException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetCloudFrontOriginAccessIdentityResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, getCloudFrontOriginAccessIdentityRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetCloudFrontOriginAccessIdentity");
            GetCloudFrontOriginAccessIdentityResponse getCloudFrontOriginAccessIdentityResponse = (GetCloudFrontOriginAccessIdentityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCloudFrontOriginAccessIdentity").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getCloudFrontOriginAccessIdentityRequest).withMarshaller((Marshaller)new GetCloudFrontOriginAccessIdentityRequestMarshaller(this.protocolFactory)));
            return getCloudFrontOriginAccessIdentityResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$getCloudFrontOriginAccessIdentity$38((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetCloudFrontOriginAccessIdentityConfigResponse getCloudFrontOriginAccessIdentityConfig(GetCloudFrontOriginAccessIdentityConfigRequest getCloudFrontOriginAccessIdentityConfigRequest) throws NoSuchCloudFrontOriginAccessIdentityException, AccessDeniedException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetCloudFrontOriginAccessIdentityConfigResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, getCloudFrontOriginAccessIdentityConfigRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetCloudFrontOriginAccessIdentityConfig");
            GetCloudFrontOriginAccessIdentityConfigResponse getCloudFrontOriginAccessIdentityConfigResponse = (GetCloudFrontOriginAccessIdentityConfigResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCloudFrontOriginAccessIdentityConfig").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getCloudFrontOriginAccessIdentityConfigRequest).withMarshaller((Marshaller)new GetCloudFrontOriginAccessIdentityConfigRequestMarshaller(this.protocolFactory)));
            return getCloudFrontOriginAccessIdentityConfigResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$getCloudFrontOriginAccessIdentityConfig$39((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetContinuousDeploymentPolicyResponse getContinuousDeploymentPolicy(GetContinuousDeploymentPolicyRequest getContinuousDeploymentPolicyRequest) throws AccessDeniedException, NoSuchContinuousDeploymentPolicyException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetContinuousDeploymentPolicyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, getContinuousDeploymentPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetContinuousDeploymentPolicy");
            GetContinuousDeploymentPolicyResponse getContinuousDeploymentPolicyResponse = (GetContinuousDeploymentPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetContinuousDeploymentPolicy").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getContinuousDeploymentPolicyRequest).withMarshaller((Marshaller)new GetContinuousDeploymentPolicyRequestMarshaller(this.protocolFactory)));
            return getContinuousDeploymentPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$getContinuousDeploymentPolicy$40((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetContinuousDeploymentPolicyConfigResponse getContinuousDeploymentPolicyConfig(GetContinuousDeploymentPolicyConfigRequest getContinuousDeploymentPolicyConfigRequest) throws AccessDeniedException, NoSuchContinuousDeploymentPolicyException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetContinuousDeploymentPolicyConfigResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, getContinuousDeploymentPolicyConfigRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetContinuousDeploymentPolicyConfig");
            GetContinuousDeploymentPolicyConfigResponse getContinuousDeploymentPolicyConfigResponse = (GetContinuousDeploymentPolicyConfigResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetContinuousDeploymentPolicyConfig").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getContinuousDeploymentPolicyConfigRequest).withMarshaller((Marshaller)new GetContinuousDeploymentPolicyConfigRequestMarshaller(this.protocolFactory)));
            return getContinuousDeploymentPolicyConfigResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$getContinuousDeploymentPolicyConfig$41((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDistributionResponse getDistribution(GetDistributionRequest getDistributionRequest) throws NoSuchDistributionException, AccessDeniedException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetDistributionResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, getDistributionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDistribution");
            GetDistributionResponse getDistributionResponse = (GetDistributionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDistribution").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getDistributionRequest).withMarshaller((Marshaller)new GetDistributionRequestMarshaller(this.protocolFactory)));
            return getDistributionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$getDistribution$42((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDistributionConfigResponse getDistributionConfig(GetDistributionConfigRequest getDistributionConfigRequest) throws NoSuchDistributionException, AccessDeniedException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetDistributionConfigResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, getDistributionConfigRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDistributionConfig");
            GetDistributionConfigResponse getDistributionConfigResponse = (GetDistributionConfigResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDistributionConfig").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getDistributionConfigRequest).withMarshaller((Marshaller)new GetDistributionConfigRequestMarshaller(this.protocolFactory)));
            return getDistributionConfigResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$getDistributionConfig$43((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetFieldLevelEncryptionResponse getFieldLevelEncryption(GetFieldLevelEncryptionRequest getFieldLevelEncryptionRequest) throws AccessDeniedException, NoSuchFieldLevelEncryptionConfigException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetFieldLevelEncryptionResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, getFieldLevelEncryptionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetFieldLevelEncryption");
            GetFieldLevelEncryptionResponse getFieldLevelEncryptionResponse = (GetFieldLevelEncryptionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetFieldLevelEncryption").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getFieldLevelEncryptionRequest).withMarshaller((Marshaller)new GetFieldLevelEncryptionRequestMarshaller(this.protocolFactory)));
            return getFieldLevelEncryptionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$getFieldLevelEncryption$44((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetFieldLevelEncryptionConfigResponse getFieldLevelEncryptionConfig(GetFieldLevelEncryptionConfigRequest getFieldLevelEncryptionConfigRequest) throws AccessDeniedException, NoSuchFieldLevelEncryptionConfigException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetFieldLevelEncryptionConfigResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, getFieldLevelEncryptionConfigRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetFieldLevelEncryptionConfig");
            GetFieldLevelEncryptionConfigResponse getFieldLevelEncryptionConfigResponse = (GetFieldLevelEncryptionConfigResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetFieldLevelEncryptionConfig").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getFieldLevelEncryptionConfigRequest).withMarshaller((Marshaller)new GetFieldLevelEncryptionConfigRequestMarshaller(this.protocolFactory)));
            return getFieldLevelEncryptionConfigResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$getFieldLevelEncryptionConfig$45((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetFieldLevelEncryptionProfileResponse getFieldLevelEncryptionProfile(GetFieldLevelEncryptionProfileRequest getFieldLevelEncryptionProfileRequest) throws AccessDeniedException, NoSuchFieldLevelEncryptionProfileException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetFieldLevelEncryptionProfileResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, getFieldLevelEncryptionProfileRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetFieldLevelEncryptionProfile");
            GetFieldLevelEncryptionProfileResponse getFieldLevelEncryptionProfileResponse = (GetFieldLevelEncryptionProfileResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetFieldLevelEncryptionProfile").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getFieldLevelEncryptionProfileRequest).withMarshaller((Marshaller)new GetFieldLevelEncryptionProfileRequestMarshaller(this.protocolFactory)));
            return getFieldLevelEncryptionProfileResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$getFieldLevelEncryptionProfile$46((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetFieldLevelEncryptionProfileConfigResponse getFieldLevelEncryptionProfileConfig(GetFieldLevelEncryptionProfileConfigRequest getFieldLevelEncryptionProfileConfigRequest) throws AccessDeniedException, NoSuchFieldLevelEncryptionProfileException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetFieldLevelEncryptionProfileConfigResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, getFieldLevelEncryptionProfileConfigRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetFieldLevelEncryptionProfileConfig");
            GetFieldLevelEncryptionProfileConfigResponse getFieldLevelEncryptionProfileConfigResponse = (GetFieldLevelEncryptionProfileConfigResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetFieldLevelEncryptionProfileConfig").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getFieldLevelEncryptionProfileConfigRequest).withMarshaller((Marshaller)new GetFieldLevelEncryptionProfileConfigRequestMarshaller(this.protocolFactory)));
            return getFieldLevelEncryptionProfileConfigResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$getFieldLevelEncryptionProfileConfig$47((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetFunctionResponse getFunction(GetFunctionRequest getFunctionRequest) throws NoSuchFunctionExistsException, UnsupportedOperationException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetFunctionResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, getFunctionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetFunction");
            GetFunctionResponse getFunctionResponse = (GetFunctionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetFunction").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getFunctionRequest).withMarshaller((Marshaller)new GetFunctionRequestMarshaller(this.protocolFactory)));
            return getFunctionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$getFunction$48((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetInvalidationResponse getInvalidation(GetInvalidationRequest getInvalidationRequest) throws NoSuchInvalidationException, NoSuchDistributionException, AccessDeniedException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetInvalidationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, getInvalidationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetInvalidation");
            GetInvalidationResponse getInvalidationResponse = (GetInvalidationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetInvalidation").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getInvalidationRequest).withMarshaller((Marshaller)new GetInvalidationRequestMarshaller(this.protocolFactory)));
            return getInvalidationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$getInvalidation$49((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetKeyGroupResponse getKeyGroup(GetKeyGroupRequest getKeyGroupRequest) throws NoSuchResourceException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetKeyGroupResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, getKeyGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetKeyGroup");
            GetKeyGroupResponse getKeyGroupResponse = (GetKeyGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetKeyGroup").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getKeyGroupRequest).withMarshaller((Marshaller)new GetKeyGroupRequestMarshaller(this.protocolFactory)));
            return getKeyGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$getKeyGroup$50((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetKeyGroupConfigResponse getKeyGroupConfig(GetKeyGroupConfigRequest getKeyGroupConfigRequest) throws NoSuchResourceException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetKeyGroupConfigResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, getKeyGroupConfigRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetKeyGroupConfig");
            GetKeyGroupConfigResponse getKeyGroupConfigResponse = (GetKeyGroupConfigResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetKeyGroupConfig").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getKeyGroupConfigRequest).withMarshaller((Marshaller)new GetKeyGroupConfigRequestMarshaller(this.protocolFactory)));
            return getKeyGroupConfigResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$getKeyGroupConfig$51((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetMonitoringSubscriptionResponse getMonitoringSubscription(GetMonitoringSubscriptionRequest getMonitoringSubscriptionRequest) throws AccessDeniedException, NoSuchDistributionException, NoSuchMonitoringSubscriptionException, UnsupportedOperationException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetMonitoringSubscriptionResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, getMonitoringSubscriptionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetMonitoringSubscription");
            GetMonitoringSubscriptionResponse getMonitoringSubscriptionResponse = (GetMonitoringSubscriptionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetMonitoringSubscription").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getMonitoringSubscriptionRequest).withMarshaller((Marshaller)new GetMonitoringSubscriptionRequestMarshaller(this.protocolFactory)));
            return getMonitoringSubscriptionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$getMonitoringSubscription$52((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetOriginAccessControlResponse getOriginAccessControl(GetOriginAccessControlRequest getOriginAccessControlRequest) throws NoSuchOriginAccessControlException, AccessDeniedException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetOriginAccessControlResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, getOriginAccessControlRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetOriginAccessControl");
            GetOriginAccessControlResponse getOriginAccessControlResponse = (GetOriginAccessControlResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetOriginAccessControl").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getOriginAccessControlRequest).withMarshaller((Marshaller)new GetOriginAccessControlRequestMarshaller(this.protocolFactory)));
            return getOriginAccessControlResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$getOriginAccessControl$53((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetOriginAccessControlConfigResponse getOriginAccessControlConfig(GetOriginAccessControlConfigRequest getOriginAccessControlConfigRequest) throws NoSuchOriginAccessControlException, AccessDeniedException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetOriginAccessControlConfigResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, getOriginAccessControlConfigRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetOriginAccessControlConfig");
            GetOriginAccessControlConfigResponse getOriginAccessControlConfigResponse = (GetOriginAccessControlConfigResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetOriginAccessControlConfig").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getOriginAccessControlConfigRequest).withMarshaller((Marshaller)new GetOriginAccessControlConfigRequestMarshaller(this.protocolFactory)));
            return getOriginAccessControlConfigResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$getOriginAccessControlConfig$54((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetOriginRequestPolicyResponse getOriginRequestPolicy(GetOriginRequestPolicyRequest getOriginRequestPolicyRequest) throws AccessDeniedException, NoSuchOriginRequestPolicyException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetOriginRequestPolicyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, getOriginRequestPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetOriginRequestPolicy");
            GetOriginRequestPolicyResponse getOriginRequestPolicyResponse = (GetOriginRequestPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetOriginRequestPolicy").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getOriginRequestPolicyRequest).withMarshaller((Marshaller)new GetOriginRequestPolicyRequestMarshaller(this.protocolFactory)));
            return getOriginRequestPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$getOriginRequestPolicy$55((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetOriginRequestPolicyConfigResponse getOriginRequestPolicyConfig(GetOriginRequestPolicyConfigRequest getOriginRequestPolicyConfigRequest) throws AccessDeniedException, NoSuchOriginRequestPolicyException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetOriginRequestPolicyConfigResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, getOriginRequestPolicyConfigRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetOriginRequestPolicyConfig");
            GetOriginRequestPolicyConfigResponse getOriginRequestPolicyConfigResponse = (GetOriginRequestPolicyConfigResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetOriginRequestPolicyConfig").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getOriginRequestPolicyConfigRequest).withMarshaller((Marshaller)new GetOriginRequestPolicyConfigRequestMarshaller(this.protocolFactory)));
            return getOriginRequestPolicyConfigResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$getOriginRequestPolicyConfig$56((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetPublicKeyResponse getPublicKey(GetPublicKeyRequest getPublicKeyRequest) throws AccessDeniedException, NoSuchPublicKeyException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetPublicKeyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, getPublicKeyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetPublicKey");
            GetPublicKeyResponse getPublicKeyResponse = (GetPublicKeyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetPublicKey").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getPublicKeyRequest).withMarshaller((Marshaller)new GetPublicKeyRequestMarshaller(this.protocolFactory)));
            return getPublicKeyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$getPublicKey$57((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetPublicKeyConfigResponse getPublicKeyConfig(GetPublicKeyConfigRequest getPublicKeyConfigRequest) throws AccessDeniedException, NoSuchPublicKeyException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetPublicKeyConfigResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, getPublicKeyConfigRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetPublicKeyConfig");
            GetPublicKeyConfigResponse getPublicKeyConfigResponse = (GetPublicKeyConfigResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetPublicKeyConfig").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getPublicKeyConfigRequest).withMarshaller((Marshaller)new GetPublicKeyConfigRequestMarshaller(this.protocolFactory)));
            return getPublicKeyConfigResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$getPublicKeyConfig$58((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetRealtimeLogConfigResponse getRealtimeLogConfig(GetRealtimeLogConfigRequest getRealtimeLogConfigRequest) throws NoSuchRealtimeLogConfigException, InvalidArgumentException, AccessDeniedException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetRealtimeLogConfigResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, getRealtimeLogConfigRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRealtimeLogConfig");
            GetRealtimeLogConfigResponse getRealtimeLogConfigResponse = (GetRealtimeLogConfigResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRealtimeLogConfig").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getRealtimeLogConfigRequest).withMarshaller((Marshaller)new GetRealtimeLogConfigRequestMarshaller(this.protocolFactory)));
            return getRealtimeLogConfigResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$getRealtimeLogConfig$59((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetResponseHeadersPolicyResponse getResponseHeadersPolicy(GetResponseHeadersPolicyRequest getResponseHeadersPolicyRequest) throws AccessDeniedException, NoSuchResponseHeadersPolicyException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetResponseHeadersPolicyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, getResponseHeadersPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetResponseHeadersPolicy");
            GetResponseHeadersPolicyResponse getResponseHeadersPolicyResponse = (GetResponseHeadersPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetResponseHeadersPolicy").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getResponseHeadersPolicyRequest).withMarshaller((Marshaller)new GetResponseHeadersPolicyRequestMarshaller(this.protocolFactory)));
            return getResponseHeadersPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$getResponseHeadersPolicy$60((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetResponseHeadersPolicyConfigResponse getResponseHeadersPolicyConfig(GetResponseHeadersPolicyConfigRequest getResponseHeadersPolicyConfigRequest) throws AccessDeniedException, NoSuchResponseHeadersPolicyException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetResponseHeadersPolicyConfigResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, getResponseHeadersPolicyConfigRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetResponseHeadersPolicyConfig");
            GetResponseHeadersPolicyConfigResponse getResponseHeadersPolicyConfigResponse = (GetResponseHeadersPolicyConfigResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetResponseHeadersPolicyConfig").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getResponseHeadersPolicyConfigRequest).withMarshaller((Marshaller)new GetResponseHeadersPolicyConfigRequestMarshaller(this.protocolFactory)));
            return getResponseHeadersPolicyConfigResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$getResponseHeadersPolicyConfig$61((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetStreamingDistributionResponse getStreamingDistribution(GetStreamingDistributionRequest getStreamingDistributionRequest) throws NoSuchStreamingDistributionException, AccessDeniedException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetStreamingDistributionResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, getStreamingDistributionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetStreamingDistribution");
            GetStreamingDistributionResponse getStreamingDistributionResponse = (GetStreamingDistributionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetStreamingDistribution").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getStreamingDistributionRequest).withMarshaller((Marshaller)new GetStreamingDistributionRequestMarshaller(this.protocolFactory)));
            return getStreamingDistributionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$getStreamingDistribution$62((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetStreamingDistributionConfigResponse getStreamingDistributionConfig(GetStreamingDistributionConfigRequest getStreamingDistributionConfigRequest) throws NoSuchStreamingDistributionException, AccessDeniedException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetStreamingDistributionConfigResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, getStreamingDistributionConfigRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetStreamingDistributionConfig");
            GetStreamingDistributionConfigResponse getStreamingDistributionConfigResponse = (GetStreamingDistributionConfigResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetStreamingDistributionConfig").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getStreamingDistributionConfigRequest).withMarshaller((Marshaller)new GetStreamingDistributionConfigRequestMarshaller(this.protocolFactory)));
            return getStreamingDistributionConfigResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$getStreamingDistributionConfig$63((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListCachePoliciesResponse listCachePolicies(ListCachePoliciesRequest listCachePoliciesRequest) throws AccessDeniedException, NoSuchCachePolicyException, InvalidArgumentException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListCachePoliciesResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, listCachePoliciesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListCachePolicies");
            ListCachePoliciesResponse listCachePoliciesResponse = (ListCachePoliciesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListCachePolicies").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listCachePoliciesRequest).withMarshaller((Marshaller)new ListCachePoliciesRequestMarshaller(this.protocolFactory)));
            return listCachePoliciesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$listCachePolicies$64((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListCloudFrontOriginAccessIdentitiesResponse listCloudFrontOriginAccessIdentities(ListCloudFrontOriginAccessIdentitiesRequest listCloudFrontOriginAccessIdentitiesRequest) throws InvalidArgumentException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListCloudFrontOriginAccessIdentitiesResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, listCloudFrontOriginAccessIdentitiesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListCloudFrontOriginAccessIdentities");
            ListCloudFrontOriginAccessIdentitiesResponse listCloudFrontOriginAccessIdentitiesResponse = (ListCloudFrontOriginAccessIdentitiesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListCloudFrontOriginAccessIdentities").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listCloudFrontOriginAccessIdentitiesRequest).withMarshaller((Marshaller)new ListCloudFrontOriginAccessIdentitiesRequestMarshaller(this.protocolFactory)));
            return listCloudFrontOriginAccessIdentitiesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$listCloudFrontOriginAccessIdentities$65((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListConflictingAliasesResponse listConflictingAliases(ListConflictingAliasesRequest listConflictingAliasesRequest) throws InvalidArgumentException, NoSuchDistributionException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListConflictingAliasesResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, listConflictingAliasesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListConflictingAliases");
            ListConflictingAliasesResponse listConflictingAliasesResponse = (ListConflictingAliasesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListConflictingAliases").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listConflictingAliasesRequest).withMarshaller((Marshaller)new ListConflictingAliasesRequestMarshaller(this.protocolFactory)));
            return listConflictingAliasesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$listConflictingAliases$66((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListContinuousDeploymentPoliciesResponse listContinuousDeploymentPolicies(ListContinuousDeploymentPoliciesRequest listContinuousDeploymentPoliciesRequest) throws InvalidArgumentException, AccessDeniedException, NoSuchContinuousDeploymentPolicyException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListContinuousDeploymentPoliciesResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, listContinuousDeploymentPoliciesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListContinuousDeploymentPolicies");
            ListContinuousDeploymentPoliciesResponse listContinuousDeploymentPoliciesResponse = (ListContinuousDeploymentPoliciesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListContinuousDeploymentPolicies").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listContinuousDeploymentPoliciesRequest).withMarshaller((Marshaller)new ListContinuousDeploymentPoliciesRequestMarshaller(this.protocolFactory)));
            return listContinuousDeploymentPoliciesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$listContinuousDeploymentPolicies$67((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDistributionsResponse listDistributions(ListDistributionsRequest listDistributionsRequest) throws InvalidArgumentException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListDistributionsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, listDistributionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDistributions");
            ListDistributionsResponse listDistributionsResponse = (ListDistributionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDistributions").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listDistributionsRequest).withMarshaller((Marshaller)new ListDistributionsRequestMarshaller(this.protocolFactory)));
            return listDistributionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$listDistributions$68((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDistributionsByCachePolicyIdResponse listDistributionsByCachePolicyId(ListDistributionsByCachePolicyIdRequest listDistributionsByCachePolicyIdRequest) throws NoSuchCachePolicyException, InvalidArgumentException, AccessDeniedException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListDistributionsByCachePolicyIdResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, listDistributionsByCachePolicyIdRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDistributionsByCachePolicyId");
            ListDistributionsByCachePolicyIdResponse listDistributionsByCachePolicyIdResponse = (ListDistributionsByCachePolicyIdResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDistributionsByCachePolicyId").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listDistributionsByCachePolicyIdRequest).withMarshaller((Marshaller)new ListDistributionsByCachePolicyIdRequestMarshaller(this.protocolFactory)));
            return listDistributionsByCachePolicyIdResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$listDistributionsByCachePolicyId$69((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDistributionsByKeyGroupResponse listDistributionsByKeyGroup(ListDistributionsByKeyGroupRequest listDistributionsByKeyGroupRequest) throws NoSuchResourceException, InvalidArgumentException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListDistributionsByKeyGroupResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, listDistributionsByKeyGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDistributionsByKeyGroup");
            ListDistributionsByKeyGroupResponse listDistributionsByKeyGroupResponse = (ListDistributionsByKeyGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDistributionsByKeyGroup").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listDistributionsByKeyGroupRequest).withMarshaller((Marshaller)new ListDistributionsByKeyGroupRequestMarshaller(this.protocolFactory)));
            return listDistributionsByKeyGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$listDistributionsByKeyGroup$70((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDistributionsByOriginRequestPolicyIdResponse listDistributionsByOriginRequestPolicyId(ListDistributionsByOriginRequestPolicyIdRequest listDistributionsByOriginRequestPolicyIdRequest) throws NoSuchOriginRequestPolicyException, InvalidArgumentException, AccessDeniedException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListDistributionsByOriginRequestPolicyIdResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, listDistributionsByOriginRequestPolicyIdRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDistributionsByOriginRequestPolicyId");
            ListDistributionsByOriginRequestPolicyIdResponse listDistributionsByOriginRequestPolicyIdResponse = (ListDistributionsByOriginRequestPolicyIdResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDistributionsByOriginRequestPolicyId").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listDistributionsByOriginRequestPolicyIdRequest).withMarshaller((Marshaller)new ListDistributionsByOriginRequestPolicyIdRequestMarshaller(this.protocolFactory)));
            return listDistributionsByOriginRequestPolicyIdResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$listDistributionsByOriginRequestPolicyId$71((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDistributionsByRealtimeLogConfigResponse listDistributionsByRealtimeLogConfig(ListDistributionsByRealtimeLogConfigRequest listDistributionsByRealtimeLogConfigRequest) throws InvalidArgumentException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListDistributionsByRealtimeLogConfigResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, listDistributionsByRealtimeLogConfigRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDistributionsByRealtimeLogConfig");
            ListDistributionsByRealtimeLogConfigResponse listDistributionsByRealtimeLogConfigResponse = (ListDistributionsByRealtimeLogConfigResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDistributionsByRealtimeLogConfig").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listDistributionsByRealtimeLogConfigRequest).withMarshaller((Marshaller)new ListDistributionsByRealtimeLogConfigRequestMarshaller(this.protocolFactory)));
            return listDistributionsByRealtimeLogConfigResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$listDistributionsByRealtimeLogConfig$72((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDistributionsByResponseHeadersPolicyIdResponse listDistributionsByResponseHeadersPolicyId(ListDistributionsByResponseHeadersPolicyIdRequest listDistributionsByResponseHeadersPolicyIdRequest) throws NoSuchResponseHeadersPolicyException, InvalidArgumentException, AccessDeniedException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListDistributionsByResponseHeadersPolicyIdResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, listDistributionsByResponseHeadersPolicyIdRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDistributionsByResponseHeadersPolicyId");
            ListDistributionsByResponseHeadersPolicyIdResponse listDistributionsByResponseHeadersPolicyIdResponse = (ListDistributionsByResponseHeadersPolicyIdResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDistributionsByResponseHeadersPolicyId").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listDistributionsByResponseHeadersPolicyIdRequest).withMarshaller((Marshaller)new ListDistributionsByResponseHeadersPolicyIdRequestMarshaller(this.protocolFactory)));
            return listDistributionsByResponseHeadersPolicyIdResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$listDistributionsByResponseHeadersPolicyId$73((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDistributionsByWebAclIdResponse listDistributionsByWebACLId(ListDistributionsByWebAclIdRequest listDistributionsByWebAclIdRequest) throws InvalidArgumentException, InvalidWebAclIdException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListDistributionsByWebAclIdResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, listDistributionsByWebAclIdRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDistributionsByWebACLId");
            ListDistributionsByWebAclIdResponse listDistributionsByWebAclIdResponse = (ListDistributionsByWebAclIdResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDistributionsByWebACLId").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listDistributionsByWebAclIdRequest).withMarshaller((Marshaller)new ListDistributionsByWebAclIdRequestMarshaller(this.protocolFactory)));
            return listDistributionsByWebAclIdResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$listDistributionsByWebACLId$74((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListFieldLevelEncryptionConfigsResponse listFieldLevelEncryptionConfigs(ListFieldLevelEncryptionConfigsRequest listFieldLevelEncryptionConfigsRequest) throws InvalidArgumentException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListFieldLevelEncryptionConfigsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, listFieldLevelEncryptionConfigsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListFieldLevelEncryptionConfigs");
            ListFieldLevelEncryptionConfigsResponse listFieldLevelEncryptionConfigsResponse = (ListFieldLevelEncryptionConfigsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListFieldLevelEncryptionConfigs").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listFieldLevelEncryptionConfigsRequest).withMarshaller((Marshaller)new ListFieldLevelEncryptionConfigsRequestMarshaller(this.protocolFactory)));
            return listFieldLevelEncryptionConfigsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$listFieldLevelEncryptionConfigs$75((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListFieldLevelEncryptionProfilesResponse listFieldLevelEncryptionProfiles(ListFieldLevelEncryptionProfilesRequest listFieldLevelEncryptionProfilesRequest) throws InvalidArgumentException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListFieldLevelEncryptionProfilesResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, listFieldLevelEncryptionProfilesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListFieldLevelEncryptionProfiles");
            ListFieldLevelEncryptionProfilesResponse listFieldLevelEncryptionProfilesResponse = (ListFieldLevelEncryptionProfilesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListFieldLevelEncryptionProfiles").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listFieldLevelEncryptionProfilesRequest).withMarshaller((Marshaller)new ListFieldLevelEncryptionProfilesRequestMarshaller(this.protocolFactory)));
            return listFieldLevelEncryptionProfilesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$listFieldLevelEncryptionProfiles$76((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListFunctionsResponse listFunctions(ListFunctionsRequest listFunctionsRequest) throws InvalidArgumentException, UnsupportedOperationException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListFunctionsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, listFunctionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListFunctions");
            ListFunctionsResponse listFunctionsResponse = (ListFunctionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListFunctions").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listFunctionsRequest).withMarshaller((Marshaller)new ListFunctionsRequestMarshaller(this.protocolFactory)));
            return listFunctionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$listFunctions$77((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListInvalidationsResponse listInvalidations(ListInvalidationsRequest listInvalidationsRequest) throws InvalidArgumentException, NoSuchDistributionException, AccessDeniedException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListInvalidationsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, listInvalidationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListInvalidations");
            ListInvalidationsResponse listInvalidationsResponse = (ListInvalidationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListInvalidations").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listInvalidationsRequest).withMarshaller((Marshaller)new ListInvalidationsRequestMarshaller(this.protocolFactory)));
            return listInvalidationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$listInvalidations$78((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListKeyGroupsResponse listKeyGroups(ListKeyGroupsRequest listKeyGroupsRequest) throws InvalidArgumentException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListKeyGroupsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, listKeyGroupsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListKeyGroups");
            ListKeyGroupsResponse listKeyGroupsResponse = (ListKeyGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListKeyGroups").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listKeyGroupsRequest).withMarshaller((Marshaller)new ListKeyGroupsRequestMarshaller(this.protocolFactory)));
            return listKeyGroupsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$listKeyGroups$79((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListOriginAccessControlsResponse listOriginAccessControls(ListOriginAccessControlsRequest listOriginAccessControlsRequest) throws InvalidArgumentException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListOriginAccessControlsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, listOriginAccessControlsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListOriginAccessControls");
            ListOriginAccessControlsResponse listOriginAccessControlsResponse = (ListOriginAccessControlsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListOriginAccessControls").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listOriginAccessControlsRequest).withMarshaller((Marshaller)new ListOriginAccessControlsRequestMarshaller(this.protocolFactory)));
            return listOriginAccessControlsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$listOriginAccessControls$80((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListOriginRequestPoliciesResponse listOriginRequestPolicies(ListOriginRequestPoliciesRequest listOriginRequestPoliciesRequest) throws AccessDeniedException, NoSuchOriginRequestPolicyException, InvalidArgumentException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListOriginRequestPoliciesResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, listOriginRequestPoliciesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListOriginRequestPolicies");
            ListOriginRequestPoliciesResponse listOriginRequestPoliciesResponse = (ListOriginRequestPoliciesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListOriginRequestPolicies").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listOriginRequestPoliciesRequest).withMarshaller((Marshaller)new ListOriginRequestPoliciesRequestMarshaller(this.protocolFactory)));
            return listOriginRequestPoliciesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$listOriginRequestPolicies$81((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListPublicKeysResponse listPublicKeys(ListPublicKeysRequest listPublicKeysRequest) throws InvalidArgumentException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListPublicKeysResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, listPublicKeysRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListPublicKeys");
            ListPublicKeysResponse listPublicKeysResponse = (ListPublicKeysResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPublicKeys").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listPublicKeysRequest).withMarshaller((Marshaller)new ListPublicKeysRequestMarshaller(this.protocolFactory)));
            return listPublicKeysResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$listPublicKeys$82((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListRealtimeLogConfigsResponse listRealtimeLogConfigs(ListRealtimeLogConfigsRequest listRealtimeLogConfigsRequest) throws InvalidArgumentException, AccessDeniedException, NoSuchRealtimeLogConfigException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListRealtimeLogConfigsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, listRealtimeLogConfigsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListRealtimeLogConfigs");
            ListRealtimeLogConfigsResponse listRealtimeLogConfigsResponse = (ListRealtimeLogConfigsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListRealtimeLogConfigs").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listRealtimeLogConfigsRequest).withMarshaller((Marshaller)new ListRealtimeLogConfigsRequestMarshaller(this.protocolFactory)));
            return listRealtimeLogConfigsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$listRealtimeLogConfigs$83((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListResponseHeadersPoliciesResponse listResponseHeadersPolicies(ListResponseHeadersPoliciesRequest listResponseHeadersPoliciesRequest) throws AccessDeniedException, NoSuchResponseHeadersPolicyException, InvalidArgumentException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListResponseHeadersPoliciesResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, listResponseHeadersPoliciesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListResponseHeadersPolicies");
            ListResponseHeadersPoliciesResponse listResponseHeadersPoliciesResponse = (ListResponseHeadersPoliciesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListResponseHeadersPolicies").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listResponseHeadersPoliciesRequest).withMarshaller((Marshaller)new ListResponseHeadersPoliciesRequestMarshaller(this.protocolFactory)));
            return listResponseHeadersPoliciesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$listResponseHeadersPolicies$84((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListStreamingDistributionsResponse listStreamingDistributions(ListStreamingDistributionsRequest listStreamingDistributionsRequest) throws InvalidArgumentException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListStreamingDistributionsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, listStreamingDistributionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListStreamingDistributions");
            ListStreamingDistributionsResponse listStreamingDistributionsResponse = (ListStreamingDistributionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListStreamingDistributions").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listStreamingDistributionsRequest).withMarshaller((Marshaller)new ListStreamingDistributionsRequestMarshaller(this.protocolFactory)));
            return listStreamingDistributionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$listStreamingDistributions$85((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws AccessDeniedException, InvalidArgumentException, InvalidTaggingException, NoSuchResourceException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListTagsForResourceResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listTagsForResourceRequest).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller(this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$listTagsForResource$86((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PublishFunctionResponse publishFunction(PublishFunctionRequest publishFunctionRequest) throws InvalidArgumentException, InvalidIfMatchVersionException, NoSuchFunctionExistsException, PreconditionFailedException, UnsupportedOperationException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PublishFunctionResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, publishFunctionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PublishFunction");
            PublishFunctionResponse publishFunctionResponse = (PublishFunctionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PublishFunction").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)publishFunctionRequest).withMarshaller((Marshaller)new PublishFunctionRequestMarshaller(this.protocolFactory)));
            return publishFunctionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$publishFunction$87((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws AccessDeniedException, InvalidArgumentException, InvalidTaggingException, NoSuchResourceException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(TagResourceResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)tagResourceRequest).withMarshaller((Marshaller)new TagResourceRequestMarshaller(this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$tagResource$88((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TestFunctionResponse testFunction(TestFunctionRequest testFunctionRequest) throws InvalidArgumentException, InvalidIfMatchVersionException, NoSuchFunctionExistsException, TestFunctionFailedException, UnsupportedOperationException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(TestFunctionResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, testFunctionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TestFunction");
            TestFunctionResponse testFunctionResponse = (TestFunctionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TestFunction").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)testFunctionRequest).withMarshaller((Marshaller)new TestFunctionRequestMarshaller(this.protocolFactory)));
            return testFunctionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$testFunction$89((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws AccessDeniedException, InvalidArgumentException, InvalidTaggingException, NoSuchResourceException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(UntagResourceResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)untagResourceRequest).withMarshaller((Marshaller)new UntagResourceRequestMarshaller(this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$untagResource$90((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateCachePolicyResponse updateCachePolicy(UpdateCachePolicyRequest updateCachePolicyRequest) throws AccessDeniedException, IllegalUpdateException, InconsistentQuantitiesException, InvalidArgumentException, InvalidIfMatchVersionException, NoSuchCachePolicyException, PreconditionFailedException, CachePolicyAlreadyExistsException, TooManyHeadersInCachePolicyException, TooManyCookiesInCachePolicyException, TooManyQueryStringsInCachePolicyException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(UpdateCachePolicyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, updateCachePolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateCachePolicy");
            UpdateCachePolicyResponse updateCachePolicyResponse = (UpdateCachePolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateCachePolicy").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateCachePolicyRequest).withMarshaller((Marshaller)new UpdateCachePolicyRequestMarshaller(this.protocolFactory)));
            return updateCachePolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$updateCachePolicy$91((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateCloudFrontOriginAccessIdentityResponse updateCloudFrontOriginAccessIdentity(UpdateCloudFrontOriginAccessIdentityRequest updateCloudFrontOriginAccessIdentityRequest) throws AccessDeniedException, IllegalUpdateException, InvalidIfMatchVersionException, MissingBodyException, NoSuchCloudFrontOriginAccessIdentityException, PreconditionFailedException, InvalidArgumentException, InconsistentQuantitiesException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(UpdateCloudFrontOriginAccessIdentityResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, updateCloudFrontOriginAccessIdentityRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateCloudFrontOriginAccessIdentity");
            UpdateCloudFrontOriginAccessIdentityResponse updateCloudFrontOriginAccessIdentityResponse = (UpdateCloudFrontOriginAccessIdentityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateCloudFrontOriginAccessIdentity").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateCloudFrontOriginAccessIdentityRequest).withMarshaller((Marshaller)new UpdateCloudFrontOriginAccessIdentityRequestMarshaller(this.protocolFactory)));
            return updateCloudFrontOriginAccessIdentityResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$updateCloudFrontOriginAccessIdentity$92((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateContinuousDeploymentPolicyResponse updateContinuousDeploymentPolicy(UpdateContinuousDeploymentPolicyRequest updateContinuousDeploymentPolicyRequest) throws InvalidIfMatchVersionException, InvalidArgumentException, AccessDeniedException, InconsistentQuantitiesException, PreconditionFailedException, StagingDistributionInUseException, NoSuchContinuousDeploymentPolicyException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(UpdateContinuousDeploymentPolicyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, updateContinuousDeploymentPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateContinuousDeploymentPolicy");
            UpdateContinuousDeploymentPolicyResponse updateContinuousDeploymentPolicyResponse = (UpdateContinuousDeploymentPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateContinuousDeploymentPolicy").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateContinuousDeploymentPolicyRequest).withMarshaller((Marshaller)new UpdateContinuousDeploymentPolicyRequestMarshaller(this.protocolFactory)));
            return updateContinuousDeploymentPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$updateContinuousDeploymentPolicy$93((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateDistributionResponse updateDistribution(UpdateDistributionRequest updateDistributionRequest) throws AccessDeniedException, CnameAlreadyExistsException, IllegalUpdateException, InvalidIfMatchVersionException, MissingBodyException, NoSuchDistributionException, PreconditionFailedException, TooManyDistributionCnamEsException, InvalidDefaultRootObjectException, InvalidRelativePathException, InvalidErrorCodeException, InvalidResponseCodeException, InvalidArgumentException, InvalidOriginAccessIdentityException, InvalidOriginAccessControlException, TooManyTrustedSignersException, TrustedSignerDoesNotExistException, InvalidViewerCertificateException, InvalidMinimumProtocolVersionException, InvalidRequiredProtocolException, NoSuchOriginException, TooManyOriginsException, TooManyOriginGroupsPerDistributionException, TooManyCacheBehaviorsException, TooManyCookieNamesInWhiteListException, InvalidForwardCookiesException, TooManyHeadersInForwardedValuesException, InvalidHeadersForS3OriginException, InconsistentQuantitiesException, TooManyCertificatesException, InvalidLocationCodeException, InvalidGeoRestrictionParameterException, InvalidTtlOrderException, InvalidWebAclIdException, TooManyOriginCustomHeadersException, TooManyQueryStringParametersException, InvalidQueryStringParametersException, TooManyDistributionsWithLambdaAssociationsException, TooManyDistributionsWithSingleFunctionArnException, TooManyLambdaFunctionAssociationsException, InvalidLambdaFunctionAssociationException, TooManyDistributionsWithFunctionAssociationsException, TooManyFunctionAssociationsException, InvalidFunctionAssociationException, InvalidOriginReadTimeoutException, InvalidOriginKeepaliveTimeoutException, NoSuchFieldLevelEncryptionConfigException, IllegalFieldLevelEncryptionConfigAssociationWithCacheBehaviorException, TooManyDistributionsAssociatedToFieldLevelEncryptionConfigException, NoSuchCachePolicyException, TooManyDistributionsAssociatedToCachePolicyException, NoSuchResponseHeadersPolicyException, TooManyDistributionsAssociatedToResponseHeadersPolicyException, NoSuchOriginRequestPolicyException, TooManyDistributionsAssociatedToOriginRequestPolicyException, TooManyDistributionsAssociatedToKeyGroupException, TooManyKeyGroupsAssociatedToDistributionException, TrustedKeyGroupDoesNotExistException, NoSuchRealtimeLogConfigException, RealtimeLogConfigOwnerMismatchException, ContinuousDeploymentPolicyInUseException, NoSuchContinuousDeploymentPolicyException, StagingDistributionInUseException, IllegalOriginAccessConfigurationException, InvalidDomainNameForOriginAccessControlException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(UpdateDistributionResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, updateDistributionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateDistribution");
            UpdateDistributionResponse updateDistributionResponse = (UpdateDistributionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateDistribution").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateDistributionRequest).withMarshaller((Marshaller)new UpdateDistributionRequestMarshaller(this.protocolFactory)));
            return updateDistributionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$updateDistribution$94((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateDistributionWithStagingConfigResponse updateDistributionWithStagingConfig(UpdateDistributionWithStagingConfigRequest updateDistributionWithStagingConfigRequest) throws AccessDeniedException, CnameAlreadyExistsException, IllegalUpdateException, InvalidIfMatchVersionException, MissingBodyException, NoSuchDistributionException, PreconditionFailedException, TooManyDistributionCnamEsException, InvalidDefaultRootObjectException, InvalidRelativePathException, InvalidErrorCodeException, InvalidResponseCodeException, InvalidArgumentException, InvalidOriginAccessIdentityException, InvalidOriginAccessControlException, TooManyTrustedSignersException, TrustedSignerDoesNotExistException, InvalidViewerCertificateException, InvalidMinimumProtocolVersionException, InvalidRequiredProtocolException, NoSuchOriginException, TooManyOriginsException, TooManyOriginGroupsPerDistributionException, TooManyCacheBehaviorsException, TooManyCookieNamesInWhiteListException, InvalidForwardCookiesException, TooManyHeadersInForwardedValuesException, InvalidHeadersForS3OriginException, InconsistentQuantitiesException, TooManyCertificatesException, InvalidLocationCodeException, InvalidGeoRestrictionParameterException, InvalidTtlOrderException, InvalidWebAclIdException, TooManyOriginCustomHeadersException, TooManyQueryStringParametersException, InvalidQueryStringParametersException, TooManyDistributionsWithLambdaAssociationsException, TooManyDistributionsWithSingleFunctionArnException, TooManyLambdaFunctionAssociationsException, InvalidLambdaFunctionAssociationException, TooManyDistributionsWithFunctionAssociationsException, TooManyFunctionAssociationsException, InvalidFunctionAssociationException, InvalidOriginReadTimeoutException, InvalidOriginKeepaliveTimeoutException, NoSuchFieldLevelEncryptionConfigException, IllegalFieldLevelEncryptionConfigAssociationWithCacheBehaviorException, TooManyDistributionsAssociatedToFieldLevelEncryptionConfigException, NoSuchCachePolicyException, TooManyDistributionsAssociatedToCachePolicyException, NoSuchResponseHeadersPolicyException, TooManyDistributionsAssociatedToResponseHeadersPolicyException, NoSuchOriginRequestPolicyException, TooManyDistributionsAssociatedToOriginRequestPolicyException, TooManyDistributionsAssociatedToKeyGroupException, TooManyKeyGroupsAssociatedToDistributionException, TrustedKeyGroupDoesNotExistException, NoSuchRealtimeLogConfigException, RealtimeLogConfigOwnerMismatchException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(UpdateDistributionWithStagingConfigResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, updateDistributionWithStagingConfigRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateDistributionWithStagingConfig");
            UpdateDistributionWithStagingConfigResponse updateDistributionWithStagingConfigResponse = (UpdateDistributionWithStagingConfigResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateDistributionWithStagingConfig").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateDistributionWithStagingConfigRequest).withMarshaller((Marshaller)new UpdateDistributionWithStagingConfigRequestMarshaller(this.protocolFactory)));
            return updateDistributionWithStagingConfigResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$updateDistributionWithStagingConfig$95((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateFieldLevelEncryptionConfigResponse updateFieldLevelEncryptionConfig(UpdateFieldLevelEncryptionConfigRequest updateFieldLevelEncryptionConfigRequest) throws AccessDeniedException, IllegalUpdateException, InconsistentQuantitiesException, InvalidArgumentException, InvalidIfMatchVersionException, NoSuchFieldLevelEncryptionProfileException, NoSuchFieldLevelEncryptionConfigException, PreconditionFailedException, TooManyFieldLevelEncryptionQueryArgProfilesException, TooManyFieldLevelEncryptionContentTypeProfilesException, QueryArgProfileEmptyException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(UpdateFieldLevelEncryptionConfigResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, updateFieldLevelEncryptionConfigRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateFieldLevelEncryptionConfig");
            UpdateFieldLevelEncryptionConfigResponse updateFieldLevelEncryptionConfigResponse = (UpdateFieldLevelEncryptionConfigResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateFieldLevelEncryptionConfig").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateFieldLevelEncryptionConfigRequest).withMarshaller((Marshaller)new UpdateFieldLevelEncryptionConfigRequestMarshaller(this.protocolFactory)));
            return updateFieldLevelEncryptionConfigResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$updateFieldLevelEncryptionConfig$96((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateFieldLevelEncryptionProfileResponse updateFieldLevelEncryptionProfile(UpdateFieldLevelEncryptionProfileRequest updateFieldLevelEncryptionProfileRequest) throws AccessDeniedException, FieldLevelEncryptionProfileAlreadyExistsException, IllegalUpdateException, InconsistentQuantitiesException, InvalidArgumentException, InvalidIfMatchVersionException, NoSuchPublicKeyException, NoSuchFieldLevelEncryptionProfileException, PreconditionFailedException, FieldLevelEncryptionProfileSizeExceededException, TooManyFieldLevelEncryptionEncryptionEntitiesException, TooManyFieldLevelEncryptionFieldPatternsException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(UpdateFieldLevelEncryptionProfileResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, updateFieldLevelEncryptionProfileRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateFieldLevelEncryptionProfile");
            UpdateFieldLevelEncryptionProfileResponse updateFieldLevelEncryptionProfileResponse = (UpdateFieldLevelEncryptionProfileResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateFieldLevelEncryptionProfile").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateFieldLevelEncryptionProfileRequest).withMarshaller((Marshaller)new UpdateFieldLevelEncryptionProfileRequestMarshaller(this.protocolFactory)));
            return updateFieldLevelEncryptionProfileResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$updateFieldLevelEncryptionProfile$97((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateFunctionResponse updateFunction(UpdateFunctionRequest updateFunctionRequest) throws InvalidArgumentException, InvalidIfMatchVersionException, NoSuchFunctionExistsException, PreconditionFailedException, FunctionSizeLimitExceededException, UnsupportedOperationException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(UpdateFunctionResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, updateFunctionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateFunction");
            UpdateFunctionResponse updateFunctionResponse = (UpdateFunctionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateFunction").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateFunctionRequest).withMarshaller((Marshaller)new UpdateFunctionRequestMarshaller(this.protocolFactory)));
            return updateFunctionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$updateFunction$98((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateKeyGroupResponse updateKeyGroup(UpdateKeyGroupRequest updateKeyGroupRequest) throws InvalidIfMatchVersionException, NoSuchResourceException, PreconditionFailedException, KeyGroupAlreadyExistsException, InvalidArgumentException, TooManyPublicKeysInKeyGroupException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(UpdateKeyGroupResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, updateKeyGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateKeyGroup");
            UpdateKeyGroupResponse updateKeyGroupResponse = (UpdateKeyGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateKeyGroup").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateKeyGroupRequest).withMarshaller((Marshaller)new UpdateKeyGroupRequestMarshaller(this.protocolFactory)));
            return updateKeyGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$updateKeyGroup$99((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateOriginAccessControlResponse updateOriginAccessControl(UpdateOriginAccessControlRequest updateOriginAccessControlRequest) throws AccessDeniedException, IllegalUpdateException, InvalidIfMatchVersionException, OriginAccessControlAlreadyExistsException, NoSuchOriginAccessControlException, PreconditionFailedException, InvalidArgumentException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(UpdateOriginAccessControlResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, updateOriginAccessControlRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateOriginAccessControl");
            UpdateOriginAccessControlResponse updateOriginAccessControlResponse = (UpdateOriginAccessControlResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateOriginAccessControl").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateOriginAccessControlRequest).withMarshaller((Marshaller)new UpdateOriginAccessControlRequestMarshaller(this.protocolFactory)));
            return updateOriginAccessControlResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$updateOriginAccessControl$100((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateOriginRequestPolicyResponse updateOriginRequestPolicy(UpdateOriginRequestPolicyRequest updateOriginRequestPolicyRequest) throws AccessDeniedException, IllegalUpdateException, InconsistentQuantitiesException, InvalidArgumentException, InvalidIfMatchVersionException, NoSuchOriginRequestPolicyException, PreconditionFailedException, OriginRequestPolicyAlreadyExistsException, TooManyHeadersInOriginRequestPolicyException, TooManyCookiesInOriginRequestPolicyException, TooManyQueryStringsInOriginRequestPolicyException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(UpdateOriginRequestPolicyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, updateOriginRequestPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateOriginRequestPolicy");
            UpdateOriginRequestPolicyResponse updateOriginRequestPolicyResponse = (UpdateOriginRequestPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateOriginRequestPolicy").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateOriginRequestPolicyRequest).withMarshaller((Marshaller)new UpdateOriginRequestPolicyRequestMarshaller(this.protocolFactory)));
            return updateOriginRequestPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$updateOriginRequestPolicy$101((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdatePublicKeyResponse updatePublicKey(UpdatePublicKeyRequest updatePublicKeyRequest) throws AccessDeniedException, CannotChangeImmutablePublicKeyFieldsException, InvalidArgumentException, InvalidIfMatchVersionException, IllegalUpdateException, NoSuchPublicKeyException, PreconditionFailedException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(UpdatePublicKeyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, updatePublicKeyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdatePublicKey");
            UpdatePublicKeyResponse updatePublicKeyResponse = (UpdatePublicKeyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdatePublicKey").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updatePublicKeyRequest).withMarshaller((Marshaller)new UpdatePublicKeyRequestMarshaller(this.protocolFactory)));
            return updatePublicKeyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$updatePublicKey$102((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateRealtimeLogConfigResponse updateRealtimeLogConfig(UpdateRealtimeLogConfigRequest updateRealtimeLogConfigRequest) throws NoSuchRealtimeLogConfigException, InvalidArgumentException, AccessDeniedException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(UpdateRealtimeLogConfigResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, updateRealtimeLogConfigRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateRealtimeLogConfig");
            UpdateRealtimeLogConfigResponse updateRealtimeLogConfigResponse = (UpdateRealtimeLogConfigResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateRealtimeLogConfig").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateRealtimeLogConfigRequest).withMarshaller((Marshaller)new UpdateRealtimeLogConfigRequestMarshaller(this.protocolFactory)));
            return updateRealtimeLogConfigResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$updateRealtimeLogConfig$103((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateResponseHeadersPolicyResponse updateResponseHeadersPolicy(UpdateResponseHeadersPolicyRequest updateResponseHeadersPolicyRequest) throws AccessDeniedException, IllegalUpdateException, InconsistentQuantitiesException, InvalidArgumentException, InvalidIfMatchVersionException, NoSuchResponseHeadersPolicyException, PreconditionFailedException, ResponseHeadersPolicyAlreadyExistsException, TooManyCustomHeadersInResponseHeadersPolicyException, TooLongCspInResponseHeadersPolicyException, TooManyRemoveHeadersInResponseHeadersPolicyException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(UpdateResponseHeadersPolicyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, updateResponseHeadersPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateResponseHeadersPolicy");
            UpdateResponseHeadersPolicyResponse updateResponseHeadersPolicyResponse = (UpdateResponseHeadersPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateResponseHeadersPolicy").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateResponseHeadersPolicyRequest).withMarshaller((Marshaller)new UpdateResponseHeadersPolicyRequestMarshaller(this.protocolFactory)));
            return updateResponseHeadersPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$updateResponseHeadersPolicy$104((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateStreamingDistributionResponse updateStreamingDistribution(UpdateStreamingDistributionRequest updateStreamingDistributionRequest) throws AccessDeniedException, CnameAlreadyExistsException, IllegalUpdateException, InvalidIfMatchVersionException, MissingBodyException, NoSuchStreamingDistributionException, PreconditionFailedException, TooManyStreamingDistributionCnamEsException, InvalidArgumentException, InvalidOriginAccessIdentityException, InvalidOriginAccessControlException, TooManyTrustedSignersException, TrustedSignerDoesNotExistException, InconsistentQuantitiesException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(UpdateStreamingDistributionResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultCloudFrontClient.resolveMetricPublishers(this.clientConfiguration, updateStreamingDistributionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateStreamingDistribution");
            UpdateStreamingDistributionResponse updateStreamingDistributionResponse = (UpdateStreamingDistributionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateStreamingDistribution").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateStreamingDistributionRequest).withMarshaller((Marshaller)new UpdateStreamingDistributionRequestMarshaller(this.protocolFactory)));
            return updateStreamingDistributionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontClient.lambda$updateStreamingDistribution$105((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public CloudFrontUtilities utilities() {
        return CloudFrontUtilities.create();
    }

    @Override
    public CloudFrontWaiter waiter() {
        return CloudFrontWaiter.builder().client(this).build();
    }

    private <T extends CloudFrontRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.20.8").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((CloudFrontRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public final String serviceName() {
        return "cloudfront";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private AwsXmlProtocolFactory init() {
        return AwsXmlProtocolFactory.builder().registerModeledException(ExceptionMetadata.builder().errorCode("StreamingDistributionAlreadyExists").exceptionBuilderSupplier(StreamingDistributionAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchInvalidation").exceptionBuilderSupplier(NoSuchInvalidationException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooLongCSPInResponseHeadersPolicy").exceptionBuilderSupplier(TooLongCspInResponseHeadersPolicyException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchFieldLevelEncryptionConfig").exceptionBuilderSupplier(NoSuchFieldLevelEncryptionConfigException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("OriginRequestPolicyAlreadyExists").exceptionBuilderSupplier(OriginRequestPolicyAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyKeyGroupsAssociatedToDistribution").exceptionBuilderSupplier(TooManyKeyGroupsAssociatedToDistributionException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidMinimumProtocolVersion").exceptionBuilderSupplier(InvalidMinimumProtocolVersionException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyInvalidationsInProgress").exceptionBuilderSupplier(TooManyInvalidationsInProgressException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyFieldLevelEncryptionConfigs").exceptionBuilderSupplier(TooManyFieldLevelEncryptionConfigsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyPublicKeys").exceptionBuilderSupplier(TooManyPublicKeysException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyCacheBehaviors").exceptionBuilderSupplier(TooManyCacheBehaviorsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CloudFrontOriginAccessIdentityInUse").exceptionBuilderSupplier(CloudFrontOriginAccessIdentityInUseException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("FieldLevelEncryptionProfileAlreadyExists").exceptionBuilderSupplier(FieldLevelEncryptionProfileAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidOriginAccessControl").exceptionBuilderSupplier(InvalidOriginAccessControlException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("MissingBody").exceptionBuilderSupplier(MissingBodyException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyResponseHeadersPolicies").exceptionBuilderSupplier(TooManyResponseHeadersPoliciesException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyOrigins").exceptionBuilderSupplier(TooManyOriginsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("FunctionSizeLimitExceeded").exceptionBuilderSupplier(FunctionSizeLimitExceededException::builder).httpStatusCode(Integer.valueOf(413)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UnsupportedOperation").exceptionBuilderSupplier(UnsupportedOperationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("BatchTooLarge").exceptionBuilderSupplier(BatchTooLargeException::builder).httpStatusCode(Integer.valueOf(413)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("RealtimeLogConfigInUse").exceptionBuilderSupplier(RealtimeLogConfigInUseException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidResponseCode").exceptionBuilderSupplier(InvalidResponseCodeException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("FieldLevelEncryptionConfigAlreadyExists").exceptionBuilderSupplier(FieldLevelEncryptionConfigAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidOriginKeepaliveTimeout").exceptionBuilderSupplier(InvalidOriginKeepaliveTimeoutException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyStreamingDistributionCNAMEs").exceptionBuilderSupplier(TooManyStreamingDistributionCnamEsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("OriginAccessControlAlreadyExists").exceptionBuilderSupplier(OriginAccessControlAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("StreamingDistributionNotDisabled").exceptionBuilderSupplier(StreamingDistributionNotDisabledException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyDistributionCNAMEs").exceptionBuilderSupplier(TooManyDistributionCnamEsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyQueryStringParameters").exceptionBuilderSupplier(TooManyQueryStringParametersException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyFieldLevelEncryptionEncryptionEntities").exceptionBuilderSupplier(TooManyFieldLevelEncryptionEncryptionEntitiesException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("FieldLevelEncryptionConfigInUse").exceptionBuilderSupplier(FieldLevelEncryptionConfigInUseException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CloudFrontOriginAccessIdentityAlreadyExists").exceptionBuilderSupplier(CloudFrontOriginAccessIdentityAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchOriginAccessControl").exceptionBuilderSupplier(NoSuchOriginAccessControlException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchRealtimeLogConfig").exceptionBuilderSupplier(NoSuchRealtimeLogConfigException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidProtocolSettings").exceptionBuilderSupplier(InvalidProtocolSettingsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyFieldLevelEncryptionProfiles").exceptionBuilderSupplier(TooManyFieldLevelEncryptionProfilesException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceInUse").exceptionBuilderSupplier(ResourceInUseException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidForwardCookies").exceptionBuilderSupplier(InvalidForwardCookiesException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyPublicKeysInKeyGroup").exceptionBuilderSupplier(TooManyPublicKeysInKeyGroupException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidOriginAccessIdentity").exceptionBuilderSupplier(InvalidOriginAccessIdentityException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("IllegalUpdate").exceptionBuilderSupplier(IllegalUpdateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyCookieNamesInWhiteList").exceptionBuilderSupplier(TooManyCookieNamesInWhiteListException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TrustedKeyGroupDoesNotExist").exceptionBuilderSupplier(TrustedKeyGroupDoesNotExistException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyDistributionsAssociatedToResponseHeadersPolicy").exceptionBuilderSupplier(TooManyDistributionsAssociatedToResponseHeadersPolicyException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchDistribution").exceptionBuilderSupplier(NoSuchDistributionException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchResponseHeadersPolicy").exceptionBuilderSupplier(NoSuchResponseHeadersPolicyException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CNAMEAlreadyExists").exceptionBuilderSupplier(CnameAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidTTLOrder").exceptionBuilderSupplier(InvalidTtlOrderException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("FunctionInUse").exceptionBuilderSupplier(FunctionInUseException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidViewerCertificate").exceptionBuilderSupplier(InvalidViewerCertificateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyCachePolicies").exceptionBuilderSupplier(TooManyCachePoliciesException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyQueryStringsInCachePolicy").exceptionBuilderSupplier(TooManyQueryStringsInCachePolicyException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("FunctionAlreadyExists").exceptionBuilderSupplier(FunctionAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CachePolicyInUse").exceptionBuilderSupplier(CachePolicyInUseException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidDefaultRootObject").exceptionBuilderSupplier(InvalidDefaultRootObjectException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("StagingDistributionInUse").exceptionBuilderSupplier(StagingDistributionInUseException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyCloudFrontOriginAccessIdentities").exceptionBuilderSupplier(TooManyCloudFrontOriginAccessIdentitiesException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyFieldLevelEncryptionContentTypeProfiles").exceptionBuilderSupplier(TooManyFieldLevelEncryptionContentTypeProfilesException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidRelativePath").exceptionBuilderSupplier(InvalidRelativePathException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyDistributionsWithLambdaAssociations").exceptionBuilderSupplier(TooManyDistributionsWithLambdaAssociationsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidHeadersForS3Origin").exceptionBuilderSupplier(InvalidHeadersForS3OriginException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("RealtimeLogConfigAlreadyExists").exceptionBuilderSupplier(RealtimeLogConfigAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyDistributions").exceptionBuilderSupplier(TooManyDistributionsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyDistributionsAssociatedToOriginRequestPolicy").exceptionBuilderSupplier(TooManyDistributionsAssociatedToOriginRequestPolicyException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CannotChangeImmutablePublicKeyFields").exceptionBuilderSupplier(CannotChangeImmutablePublicKeyFieldsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyFieldLevelEncryptionQueryArgProfiles").exceptionBuilderSupplier(TooManyFieldLevelEncryptionQueryArgProfilesException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyCookiesInOriginRequestPolicy").exceptionBuilderSupplier(TooManyCookiesInOriginRequestPolicyException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("IllegalDelete").exceptionBuilderSupplier(IllegalDeleteException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidOrigin").exceptionBuilderSupplier(InvalidOriginException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TestFunctionFailed").exceptionBuilderSupplier(TestFunctionFailedException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidGeoRestrictionParameter").exceptionBuilderSupplier(InvalidGeoRestrictionParameterException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyRemoveHeadersInResponseHeadersPolicy").exceptionBuilderSupplier(TooManyRemoveHeadersInResponseHeadersPolicyException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyCustomHeadersInResponseHeadersPolicy").exceptionBuilderSupplier(TooManyCustomHeadersInResponseHeadersPolicyException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TrustedSignerDoesNotExist").exceptionBuilderSupplier(TrustedSignerDoesNotExistException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResponseHeadersPolicyInUse").exceptionBuilderSupplier(ResponseHeadersPolicyInUseException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyHeadersInForwardedValues").exceptionBuilderSupplier(TooManyHeadersInForwardedValuesException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidOriginReadTimeout").exceptionBuilderSupplier(InvalidOriginReadTimeoutException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("OriginAccessControlInUse").exceptionBuilderSupplier(OriginAccessControlInUseException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("OriginRequestPolicyInUse").exceptionBuilderSupplier(OriginRequestPolicyInUseException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyDistributionsAssociatedToKeyGroup").exceptionBuilderSupplier(TooManyDistributionsAssociatedToKeyGroupException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidErrorCode").exceptionBuilderSupplier(InvalidErrorCodeException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ContinuousDeploymentPolicyAlreadyExists").exceptionBuilderSupplier(ContinuousDeploymentPolicyAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyFieldLevelEncryptionFieldPatterns").exceptionBuilderSupplier(TooManyFieldLevelEncryptionFieldPatternsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior").exceptionBuilderSupplier(IllegalFieldLevelEncryptionConfigAssociationWithCacheBehaviorException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidRequiredProtocol").exceptionBuilderSupplier(InvalidRequiredProtocolException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchOriginRequestPolicy").exceptionBuilderSupplier(NoSuchOriginRequestPolicyException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchOrigin").exceptionBuilderSupplier(NoSuchOriginException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyQueryStringsInOriginRequestPolicy").exceptionBuilderSupplier(TooManyQueryStringsInOriginRequestPolicyException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyTrustedSigners").exceptionBuilderSupplier(TooManyTrustedSignersException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyFunctions").exceptionBuilderSupplier(TooManyFunctionsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyDistributionsWithFunctionAssociations").exceptionBuilderSupplier(TooManyDistributionsWithFunctionAssociationsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyStreamingDistributions").exceptionBuilderSupplier(TooManyStreamingDistributionsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyDistributionsWithSingleFunctionARN").exceptionBuilderSupplier(TooManyDistributionsWithSingleFunctionArnException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PublicKeyInUse").exceptionBuilderSupplier(PublicKeyInUseException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchContinuousDeploymentPolicy").exceptionBuilderSupplier(NoSuchContinuousDeploymentPolicyException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PreconditionFailed").exceptionBuilderSupplier(PreconditionFailedException::builder).httpStatusCode(Integer.valueOf(412)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyKeyGroups").exceptionBuilderSupplier(TooManyKeyGroupsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DistributionAlreadyExists").exceptionBuilderSupplier(DistributionAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CachePolicyAlreadyExists").exceptionBuilderSupplier(CachePolicyAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ContinuousDeploymentPolicyInUse").exceptionBuilderSupplier(ContinuousDeploymentPolicyInUseException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidDomainNameForOriginAccessControl").exceptionBuilderSupplier(InvalidDomainNameForOriginAccessControlException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyOriginCustomHeaders").exceptionBuilderSupplier(TooManyOriginCustomHeadersException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidLocationCode").exceptionBuilderSupplier(InvalidLocationCodeException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyContinuousDeploymentPolicies").exceptionBuilderSupplier(TooManyContinuousDeploymentPoliciesException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyFunctionAssociations").exceptionBuilderSupplier(TooManyFunctionAssociationsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("FieldLevelEncryptionProfileSizeExceeded").exceptionBuilderSupplier(FieldLevelEncryptionProfileSizeExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyCertificates").exceptionBuilderSupplier(TooManyCertificatesException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("QueryArgProfileEmpty").exceptionBuilderSupplier(QueryArgProfileEmptyException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("MonitoringSubscriptionAlreadyExists").exceptionBuilderSupplier(MonitoringSubscriptionAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyRealtimeLogConfigs").exceptionBuilderSupplier(TooManyRealtimeLogConfigsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidQueryStringParameters").exceptionBuilderSupplier(InvalidQueryStringParametersException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchFunctionExists").exceptionBuilderSupplier(NoSuchFunctionExistsException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyHeadersInCachePolicy").exceptionBuilderSupplier(TooManyHeadersInCachePolicyException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("RealtimeLogConfigOwnerMismatch").exceptionBuilderSupplier(RealtimeLogConfigOwnerMismatchException::builder).httpStatusCode(Integer.valueOf(401)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchFieldLevelEncryptionProfile").exceptionBuilderSupplier(NoSuchFieldLevelEncryptionProfileException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchResource").exceptionBuilderSupplier(NoSuchResourceException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InconsistentQuantities").exceptionBuilderSupplier(InconsistentQuantitiesException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidFunctionAssociation").exceptionBuilderSupplier(InvalidFunctionAssociationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchMonitoringSubscription").exceptionBuilderSupplier(NoSuchMonitoringSubscriptionException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidLambdaFunctionAssociation").exceptionBuilderSupplier(InvalidLambdaFunctionAssociationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyLambdaFunctionAssociations").exceptionBuilderSupplier(TooManyLambdaFunctionAssociationsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DistributionNotDisabled").exceptionBuilderSupplier(DistributionNotDisabledException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResponseHeadersPolicyAlreadyExists").exceptionBuilderSupplier(ResponseHeadersPolicyAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyOriginGroupsPerDistribution").exceptionBuilderSupplier(TooManyOriginGroupsPerDistributionException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AccessDenied").exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyDistributionsAssociatedToOriginAccessControl").exceptionBuilderSupplier(TooManyDistributionsAssociatedToOriginAccessControlException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("IllegalOriginAccessConfiguration").exceptionBuilderSupplier(IllegalOriginAccessConfigurationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyCookiesInCachePolicy").exceptionBuilderSupplier(TooManyCookiesInCachePolicyException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyOriginAccessControls").exceptionBuilderSupplier(TooManyOriginAccessControlsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidArgument").exceptionBuilderSupplier(InvalidArgumentException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyOriginRequestPolicies").exceptionBuilderSupplier(TooManyOriginRequestPoliciesException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchCachePolicy").exceptionBuilderSupplier(NoSuchCachePolicyException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("KeyGroupAlreadyExists").exceptionBuilderSupplier(KeyGroupAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchStreamingDistribution").exceptionBuilderSupplier(NoSuchStreamingDistributionException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchPublicKey").exceptionBuilderSupplier(NoSuchPublicKeyException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidWebACLId").exceptionBuilderSupplier(InvalidWebAclIdException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyDistributionsAssociatedToFieldLevelEncryptionConfig").exceptionBuilderSupplier(TooManyDistributionsAssociatedToFieldLevelEncryptionConfigException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyDistributionsAssociatedToCachePolicy").exceptionBuilderSupplier(TooManyDistributionsAssociatedToCachePolicyException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PublicKeyAlreadyExists").exceptionBuilderSupplier(PublicKeyAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("FieldLevelEncryptionProfileInUse").exceptionBuilderSupplier(FieldLevelEncryptionProfileInUseException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidIfMatchVersion").exceptionBuilderSupplier(InvalidIfMatchVersionException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidTagging").exceptionBuilderSupplier(InvalidTaggingException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyHeadersInOriginRequestPolicy").exceptionBuilderSupplier(TooManyHeadersInOriginRequestPolicyException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchCloudFrontOriginAccessIdentity").exceptionBuilderSupplier(NoSuchCloudFrontOriginAccessIdentityException::builder).httpStatusCode(Integer.valueOf(404)).build()).clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(CloudFrontException::builder).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateStreamingDistribution$105(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateResponseHeadersPolicy$104(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateRealtimeLogConfig$103(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updatePublicKey$102(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateOriginRequestPolicy$101(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateOriginAccessControl$100(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateKeyGroup$99(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateFunction$98(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateFieldLevelEncryptionProfile$97(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateFieldLevelEncryptionConfig$96(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateDistributionWithStagingConfig$95(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateDistribution$94(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateContinuousDeploymentPolicy$93(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateCloudFrontOriginAccessIdentity$92(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateCachePolicy$91(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$90(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$testFunction$89(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$88(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$publishFunction$87(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$86(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listStreamingDistributions$85(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listResponseHeadersPolicies$84(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listRealtimeLogConfigs$83(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listPublicKeys$82(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listOriginRequestPolicies$81(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listOriginAccessControls$80(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listKeyGroups$79(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listInvalidations$78(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listFunctions$77(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listFieldLevelEncryptionProfiles$76(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listFieldLevelEncryptionConfigs$75(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDistributionsByWebACLId$74(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDistributionsByResponseHeadersPolicyId$73(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDistributionsByRealtimeLogConfig$72(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDistributionsByOriginRequestPolicyId$71(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDistributionsByKeyGroup$70(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDistributionsByCachePolicyId$69(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDistributions$68(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listContinuousDeploymentPolicies$67(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listConflictingAliases$66(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listCloudFrontOriginAccessIdentities$65(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listCachePolicies$64(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getStreamingDistributionConfig$63(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getStreamingDistribution$62(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getResponseHeadersPolicyConfig$61(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getResponseHeadersPolicy$60(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRealtimeLogConfig$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getPublicKeyConfig$58(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getPublicKey$57(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getOriginRequestPolicyConfig$56(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getOriginRequestPolicy$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getOriginAccessControlConfig$54(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getOriginAccessControl$53(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getMonitoringSubscription$52(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getKeyGroupConfig$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getKeyGroup$50(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getInvalidation$49(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getFunction$48(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getFieldLevelEncryptionProfileConfig$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getFieldLevelEncryptionProfile$46(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getFieldLevelEncryptionConfig$45(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getFieldLevelEncryption$44(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDistributionConfig$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDistribution$42(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getContinuousDeploymentPolicyConfig$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getContinuousDeploymentPolicy$40(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getCloudFrontOriginAccessIdentityConfig$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getCloudFrontOriginAccessIdentity$38(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getCachePolicyConfig$37(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getCachePolicy$36(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeFunction$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteStreamingDistribution$34(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteResponseHeadersPolicy$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteRealtimeLogConfig$32(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deletePublicKey$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteOriginRequestPolicy$30(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteOriginAccessControl$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteMonitoringSubscription$28(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteKeyGroup$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteFunction$26(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteFieldLevelEncryptionProfile$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteFieldLevelEncryptionConfig$24(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteDistribution$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteContinuousDeploymentPolicy$22(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteCloudFrontOriginAccessIdentity$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteCachePolicy$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createStreamingDistributionWithTags$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createStreamingDistribution$18(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createResponseHeadersPolicy$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createRealtimeLogConfig$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createPublicKey$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createOriginRequestPolicy$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createOriginAccessControl$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createMonitoringSubscription$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createKeyGroup$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createInvalidation$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createFunction$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createFieldLevelEncryptionProfile$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createFieldLevelEncryptionConfig$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDistributionWithTags$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDistribution$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createContinuousDeploymentPolicy$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createCloudFrontOriginAccessIdentity$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createCachePolicy$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$copyDistribution$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$associateAlias$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

