/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.FieldPatterns;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EncryptionEntity
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EncryptionEntity> {
    private static final SdkField<String> PUBLIC_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PublicKeyId").getter(EncryptionEntity.getter(EncryptionEntity::publicKeyId)).setter(EncryptionEntity.setter(Builder::publicKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicKeyId").unmarshallLocationName("PublicKeyId").build()}).build();
    private static final SdkField<String> PROVIDER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProviderId").getter(EncryptionEntity.getter(EncryptionEntity::providerId)).setter(EncryptionEntity.setter(Builder::providerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProviderId").unmarshallLocationName("ProviderId").build()}).build();
    private static final SdkField<FieldPatterns> FIELD_PATTERNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FieldPatterns").getter(EncryptionEntity.getter(EncryptionEntity::fieldPatterns)).setter(EncryptionEntity.setter(Builder::fieldPatterns)).constructor(FieldPatterns::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldPatterns").unmarshallLocationName("FieldPatterns").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PUBLIC_KEY_ID_FIELD, PROVIDER_ID_FIELD, FIELD_PATTERNS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String publicKeyId;
    private final String providerId;
    private final FieldPatterns fieldPatterns;

    private EncryptionEntity(BuilderImpl builder) {
        this.publicKeyId = builder.publicKeyId;
        this.providerId = builder.providerId;
        this.fieldPatterns = builder.fieldPatterns;
    }

    public final String publicKeyId() {
        return this.publicKeyId;
    }

    public final String providerId() {
        return this.providerId;
    }

    public final FieldPatterns fieldPatterns() {
        return this.fieldPatterns;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.publicKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.providerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldPatterns());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EncryptionEntity)) {
            return false;
        }
        EncryptionEntity other = (EncryptionEntity)obj;
        return Objects.equals(this.publicKeyId(), other.publicKeyId()) && Objects.equals(this.providerId(), other.providerId()) && Objects.equals(this.fieldPatterns(), other.fieldPatterns());
    }

    public final String toString() {
        return ToString.builder((String)"EncryptionEntity").add("PublicKeyId", (Object)this.publicKeyId()).add("ProviderId", (Object)this.providerId()).add("FieldPatterns", (Object)this.fieldPatterns()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PublicKeyId": {
                return Optional.ofNullable(clazz.cast(this.publicKeyId()));
            }
            case "ProviderId": {
                return Optional.ofNullable(clazz.cast(this.providerId()));
            }
            case "FieldPatterns": {
                return Optional.ofNullable(clazz.cast(this.fieldPatterns()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EncryptionEntity, T> g) {
        return obj -> g.apply((EncryptionEntity)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String publicKeyId;
        private String providerId;
        private FieldPatterns fieldPatterns;

        private BuilderImpl() {
        }

        private BuilderImpl(EncryptionEntity model) {
            this.publicKeyId(model.publicKeyId);
            this.providerId(model.providerId);
            this.fieldPatterns(model.fieldPatterns);
        }

        public final String getPublicKeyId() {
            return this.publicKeyId;
        }

        public final void setPublicKeyId(String publicKeyId) {
            this.publicKeyId = publicKeyId;
        }

        @Override
        public final Builder publicKeyId(String publicKeyId) {
            this.publicKeyId = publicKeyId;
            return this;
        }

        public final String getProviderId() {
            return this.providerId;
        }

        public final void setProviderId(String providerId) {
            this.providerId = providerId;
        }

        @Override
        public final Builder providerId(String providerId) {
            this.providerId = providerId;
            return this;
        }

        public final FieldPatterns.Builder getFieldPatterns() {
            return this.fieldPatterns != null ? this.fieldPatterns.toBuilder() : null;
        }

        public final void setFieldPatterns(FieldPatterns.BuilderImpl fieldPatterns) {
            this.fieldPatterns = fieldPatterns != null ? fieldPatterns.build() : null;
        }

        @Override
        public final Builder fieldPatterns(FieldPatterns fieldPatterns) {
            this.fieldPatterns = fieldPatterns;
            return this;
        }

        public EncryptionEntity build() {
            return new EncryptionEntity(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EncryptionEntity> {
        public Builder publicKeyId(String var1);

        public Builder providerId(String var1);

        public Builder fieldPatterns(FieldPatterns var1);

        default public Builder fieldPatterns(Consumer<FieldPatterns.Builder> fieldPatterns) {
            return this.fieldPatterns((FieldPatterns)((FieldPatterns.Builder)FieldPatterns.builder().applyMutation(fieldPatterns)).build());
        }
    }
}

