/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.endpoints.internal;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.services.cloudfront.endpoints.CloudFrontEndpointParams;
import software.amazon.awssdk.services.cloudfront.endpoints.CloudFrontEndpointProvider;
import software.amazon.awssdk.services.cloudfront.endpoints.internal.AwsEndpointProviderUtils;
import software.amazon.awssdk.services.cloudfront.endpoints.internal.Condition;
import software.amazon.awssdk.services.cloudfront.endpoints.internal.DefaultRuleEngine;
import software.amazon.awssdk.services.cloudfront.endpoints.internal.EndpointResult;
import software.amazon.awssdk.services.cloudfront.endpoints.internal.EndpointRuleset;
import software.amazon.awssdk.services.cloudfront.endpoints.internal.Expr;
import software.amazon.awssdk.services.cloudfront.endpoints.internal.FnNode;
import software.amazon.awssdk.services.cloudfront.endpoints.internal.Identifier;
import software.amazon.awssdk.services.cloudfront.endpoints.internal.Literal;
import software.amazon.awssdk.services.cloudfront.endpoints.internal.Parameter;
import software.amazon.awssdk.services.cloudfront.endpoints.internal.ParameterType;
import software.amazon.awssdk.services.cloudfront.endpoints.internal.Parameters;
import software.amazon.awssdk.services.cloudfront.endpoints.internal.Rule;
import software.amazon.awssdk.services.cloudfront.endpoints.internal.Value;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.MapUtils;

@SdkInternalApi
public final class DefaultCloudFrontEndpointProvider
implements CloudFrontEndpointProvider {
    private static final EndpointRuleset ENDPOINT_RULE_SET = DefaultCloudFrontEndpointProvider.ruleSet();

    @Override
    public CompletableFuture<Endpoint> resolveEndpoint(CloudFrontEndpointParams endpointParams) {
        Value res = new DefaultRuleEngine().evaluate(ENDPOINT_RULE_SET, DefaultCloudFrontEndpointProvider.toIdentifierValueMap(endpointParams));
        try {
            return CompletableFuture.completedFuture(AwsEndpointProviderUtils.valueAsEndpointOrThrow(res));
        }
        catch (Exception error) {
            return CompletableFutureUtils.failedFuture((Throwable)error);
        }
    }

    private static Map<Identifier, Value> toIdentifierValueMap(CloudFrontEndpointParams params) {
        HashMap<Identifier, Value> paramsMap = new HashMap<Identifier, Value>();
        if (params.region() != null) {
            paramsMap.put(Identifier.of("Region"), Value.fromStr(params.region().id()));
        }
        if (params.useDualStack() != null) {
            paramsMap.put(Identifier.of("UseDualStack"), Value.fromBool(params.useDualStack()));
        }
        if (params.useFips() != null) {
            paramsMap.put(Identifier.of("UseFIPS"), Value.fromBool(params.useFips()));
        }
        if (params.endpoint() != null) {
            paramsMap.put(Identifier.of("Endpoint"), Value.fromStr(params.endpoint()));
        }
        return paramsMap;
    }

    private static Rule endpointRule_1() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).error("Invalid Configuration: FIPS and custom endpoint are not supported");
    }

    private static Rule endpointRule_3() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).error("Invalid Configuration: Dualstack and custom endpoint are not supported");
    }

    private static Rule endpointRule_4() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.ref(Identifier.of("Endpoint"))).build());
    }

    private static Rule endpointRule_2() {
        return Rule.builder().treeRule(Arrays.asList(DefaultCloudFrontEndpointProvider.endpointRule_3(), DefaultCloudFrontEndpointProvider.endpointRule_4()));
    }

    private static Rule endpointRule_0() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).build()).treeRule(Arrays.asList(DefaultCloudFrontEndpointProvider.endpointRule_1(), DefaultCloudFrontEndpointProvider.endpointRule_2()));
    }

    private static Rule endpointRule_11() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://cloudfront-fips.{Region}.api.aws")).build());
    }

    private static Rule endpointRule_10() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.of(true), FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("supportsFIPS"))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.of(true), FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("supportsDualStack"))).build().validate())).build().validate()).build()).treeRule(Arrays.asList(DefaultCloudFrontEndpointProvider.endpointRule_11()));
    }

    private static Rule endpointRule_12() {
        return Rule.builder().error("FIPS and DualStack are enabled, but this partition does not support one or both");
    }

    private static Rule endpointRule_9() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultCloudFrontEndpointProvider.endpointRule_10(), DefaultCloudFrontEndpointProvider.endpointRule_12()));
    }

    private static Rule endpointRule_15() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://cloudfront-fips.amazonaws.com")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("cloudfront"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("us-east-1")))))).build());
    }

    private static Rule endpointRule_14() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.of(true), FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("supportsFIPS"))).build().validate())).build().validate()).build()).treeRule(Arrays.asList(DefaultCloudFrontEndpointProvider.endpointRule_15()));
    }

    private static Rule endpointRule_16() {
        return Rule.builder().error("FIPS is enabled but this partition does not support FIPS");
    }

    private static Rule endpointRule_13() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultCloudFrontEndpointProvider.endpointRule_14(), DefaultCloudFrontEndpointProvider.endpointRule_16()));
    }

    private static Rule endpointRule_19() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://cloudfront.{Region}.api.aws")).build());
    }

    private static Rule endpointRule_18() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.of(true), FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("supportsDualStack"))).build().validate())).build().validate()).build()).treeRule(Arrays.asList(DefaultCloudFrontEndpointProvider.endpointRule_19()));
    }

    private static Rule endpointRule_20() {
        return Rule.builder().error("DualStack is enabled but this partition does not support DualStack");
    }

    private static Rule endpointRule_17() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultCloudFrontEndpointProvider.endpointRule_18(), DefaultCloudFrontEndpointProvider.endpointRule_20()));
    }

    private static Rule endpointRule_21() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://cloudfront.amazonaws.com")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("cloudfront"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("us-east-1")))))).build());
    }

    private static Rule endpointRule_8() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("name"))).build().validate(), Expr.of("aws"))).build().validate()).build()).treeRule(Arrays.asList(DefaultCloudFrontEndpointProvider.endpointRule_9(), DefaultCloudFrontEndpointProvider.endpointRule_13(), DefaultCloudFrontEndpointProvider.endpointRule_17(), DefaultCloudFrontEndpointProvider.endpointRule_21()));
    }

    private static Rule endpointRule_25() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://cloudfront-fips.{Region}.api.amazonwebservices.com.cn")).build());
    }

    private static Rule endpointRule_24() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.of(true), FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("supportsFIPS"))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.of(true), FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("supportsDualStack"))).build().validate())).build().validate()).build()).treeRule(Arrays.asList(DefaultCloudFrontEndpointProvider.endpointRule_25()));
    }

    private static Rule endpointRule_26() {
        return Rule.builder().error("FIPS and DualStack are enabled, but this partition does not support one or both");
    }

    private static Rule endpointRule_23() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultCloudFrontEndpointProvider.endpointRule_24(), DefaultCloudFrontEndpointProvider.endpointRule_26()));
    }

    private static Rule endpointRule_29() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://cloudfront-fips.{Region}.amazonaws.com.cn")).build());
    }

    private static Rule endpointRule_28() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.of(true), FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("supportsFIPS"))).build().validate())).build().validate()).build()).treeRule(Arrays.asList(DefaultCloudFrontEndpointProvider.endpointRule_29()));
    }

    private static Rule endpointRule_30() {
        return Rule.builder().error("FIPS is enabled but this partition does not support FIPS");
    }

    private static Rule endpointRule_27() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultCloudFrontEndpointProvider.endpointRule_28(), DefaultCloudFrontEndpointProvider.endpointRule_30()));
    }

    private static Rule endpointRule_33() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://cloudfront.{Region}.api.amazonwebservices.com.cn")).build());
    }

    private static Rule endpointRule_32() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.of(true), FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("supportsDualStack"))).build().validate())).build().validate()).build()).treeRule(Arrays.asList(DefaultCloudFrontEndpointProvider.endpointRule_33()));
    }

    private static Rule endpointRule_34() {
        return Rule.builder().error("DualStack is enabled but this partition does not support DualStack");
    }

    private static Rule endpointRule_31() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultCloudFrontEndpointProvider.endpointRule_32(), DefaultCloudFrontEndpointProvider.endpointRule_34()));
    }

    private static Rule endpointRule_35() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://cloudfront.cn-northwest-1.amazonaws.com.cn")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("cloudfront"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("cn-northwest-1")))))).build());
    }

    private static Rule endpointRule_22() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("name"))).build().validate(), Expr.of("aws-cn"))).build().validate()).build()).treeRule(Arrays.asList(DefaultCloudFrontEndpointProvider.endpointRule_23(), DefaultCloudFrontEndpointProvider.endpointRule_27(), DefaultCloudFrontEndpointProvider.endpointRule_31(), DefaultCloudFrontEndpointProvider.endpointRule_35()));
    }

    private static Rule endpointRule_39() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://cloudfront-fips.{Region}.{PartitionResult#dualStackDnsSuffix}")).build());
    }

    private static Rule endpointRule_38() {
        return Rule.builder().treeRule(Arrays.asList(DefaultCloudFrontEndpointProvider.endpointRule_39()));
    }

    private static Rule endpointRule_37() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.of(true), FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("supportsFIPS"))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.of(true), FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("supportsDualStack"))).build().validate())).build().validate()).build()).treeRule(Arrays.asList(DefaultCloudFrontEndpointProvider.endpointRule_38()));
    }

    private static Rule endpointRule_40() {
        return Rule.builder().error("FIPS and DualStack are enabled, but this partition does not support one or both");
    }

    private static Rule endpointRule_36() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultCloudFrontEndpointProvider.endpointRule_37(), DefaultCloudFrontEndpointProvider.endpointRule_40()));
    }

    private static Rule endpointRule_44() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://cloudfront-fips.amazonaws.com")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("cloudfront"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("us-east-1")))))).build());
    }

    private static Rule endpointRule_45() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://cloudfront-fips.{Region}.{PartitionResult#dnsSuffix}")).build());
    }

    private static Rule endpointRule_43() {
        return Rule.builder().treeRule(Arrays.asList(DefaultCloudFrontEndpointProvider.endpointRule_44(), DefaultCloudFrontEndpointProvider.endpointRule_45()));
    }

    private static Rule endpointRule_42() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.of(true), FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("supportsFIPS"))).build().validate())).build().validate()).build()).treeRule(Arrays.asList(DefaultCloudFrontEndpointProvider.endpointRule_43()));
    }

    private static Rule endpointRule_46() {
        return Rule.builder().error("FIPS is enabled but this partition does not support FIPS");
    }

    private static Rule endpointRule_41() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultCloudFrontEndpointProvider.endpointRule_42(), DefaultCloudFrontEndpointProvider.endpointRule_46()));
    }

    private static Rule endpointRule_50() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://cloudfront.{Region}.{PartitionResult#dualStackDnsSuffix}")).build());
    }

    private static Rule endpointRule_49() {
        return Rule.builder().treeRule(Arrays.asList(DefaultCloudFrontEndpointProvider.endpointRule_50()));
    }

    private static Rule endpointRule_48() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.of(true), FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("supportsDualStack"))).build().validate())).build().validate()).build()).treeRule(Arrays.asList(DefaultCloudFrontEndpointProvider.endpointRule_49()));
    }

    private static Rule endpointRule_51() {
        return Rule.builder().error("DualStack is enabled but this partition does not support DualStack");
    }

    private static Rule endpointRule_47() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultCloudFrontEndpointProvider.endpointRule_48(), DefaultCloudFrontEndpointProvider.endpointRule_51()));
    }

    private static Rule endpointRule_53() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://cloudfront.amazonaws.com")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("cloudfront"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("us-east-1")))))).build());
    }

    private static Rule endpointRule_54() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-cn-global"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://cloudfront.cn-northwest-1.amazonaws.com.cn")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("cloudfront"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("cn-northwest-1")))))).build());
    }

    private static Rule endpointRule_55() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://cloudfront.{Region}.{PartitionResult#dnsSuffix}")).build());
    }

    private static Rule endpointRule_52() {
        return Rule.builder().treeRule(Arrays.asList(DefaultCloudFrontEndpointProvider.endpointRule_53(), DefaultCloudFrontEndpointProvider.endpointRule_54(), DefaultCloudFrontEndpointProvider.endpointRule_55()));
    }

    private static Rule endpointRule_7() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("aws.partition").argv(Arrays.asList(Expr.ref(Identifier.of("Region")))).build().validate()).result("PartitionResult").build()).treeRule(Arrays.asList(DefaultCloudFrontEndpointProvider.endpointRule_8(), DefaultCloudFrontEndpointProvider.endpointRule_22(), DefaultCloudFrontEndpointProvider.endpointRule_36(), DefaultCloudFrontEndpointProvider.endpointRule_41(), DefaultCloudFrontEndpointProvider.endpointRule_47(), DefaultCloudFrontEndpointProvider.endpointRule_52()));
    }

    private static Rule endpointRule_6() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Region")))).build().validate()).build()).treeRule(Arrays.asList(DefaultCloudFrontEndpointProvider.endpointRule_7()));
    }

    private static Rule endpointRule_56() {
        return Rule.builder().error("Invalid Configuration: Missing Region");
    }

    private static Rule endpointRule_5() {
        return Rule.builder().treeRule(Arrays.asList(DefaultCloudFrontEndpointProvider.endpointRule_6(), DefaultCloudFrontEndpointProvider.endpointRule_56()));
    }

    private static EndpointRuleset ruleSet() {
        return EndpointRuleset.builder().version("1.0").serviceId(null).parameters(Parameters.builder().addParameter(Parameter.builder().name("Region").type(ParameterType.fromValue("String")).required(false).builtIn("AWS::Region").documentation("The AWS region used to dispatch the request.").build()).addParameter(Parameter.builder().name("UseDualStack").type(ParameterType.fromValue("Boolean")).required(true).builtIn("AWS::UseDualStack").documentation("When true, use the dual-stack endpoint. If the configured endpoint does not support dual-stack, dispatching the request MAY return an error.").defaultValue(Value.fromBool(false)).build()).addParameter(Parameter.builder().name("UseFIPS").type(ParameterType.fromValue("Boolean")).required(true).builtIn("AWS::UseFIPS").documentation("When true, send this request to the FIPS-compliant regional endpoint. If the configured endpoint does not have a FIPS compliant endpoint, dispatching the request will return an error.").defaultValue(Value.fromBool(false)).build()).addParameter(Parameter.builder().name("Endpoint").type(ParameterType.fromValue("String")).required(false).builtIn("SDK::Endpoint").documentation("Override the endpoint used to send this request").build()).build()).addRule(DefaultCloudFrontEndpointProvider.endpointRule_0()).addRule(DefaultCloudFrontEndpointProvider.endpointRule_5()).build();
    }
}

