/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.FunctionStage;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FunctionMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FunctionMetadata> {
    private static final SdkField<String> FUNCTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FunctionARN").getter(FunctionMetadata.getter(FunctionMetadata::functionARN)).setter(FunctionMetadata.setter(Builder::functionARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionARN").unmarshallLocationName("FunctionARN").build()}).build();
    private static final SdkField<String> STAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Stage").getter(FunctionMetadata.getter(FunctionMetadata::stageAsString)).setter(FunctionMetadata.setter(Builder::stage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Stage").unmarshallLocationName("Stage").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTime").getter(FunctionMetadata.getter(FunctionMetadata::createdTime)).setter(FunctionMetadata.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").unmarshallLocationName("CreatedTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(FunctionMetadata.getter(FunctionMetadata::lastModifiedTime)).setter(FunctionMetadata.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").unmarshallLocationName("LastModifiedTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FUNCTION_ARN_FIELD, STAGE_FIELD, CREATED_TIME_FIELD, LAST_MODIFIED_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String functionARN;
    private final String stage;
    private final Instant createdTime;
    private final Instant lastModifiedTime;

    private FunctionMetadata(BuilderImpl builder) {
        this.functionARN = builder.functionARN;
        this.stage = builder.stage;
        this.createdTime = builder.createdTime;
        this.lastModifiedTime = builder.lastModifiedTime;
    }

    public final String functionARN() {
        return this.functionARN;
    }

    public final FunctionStage stage() {
        return FunctionStage.fromValue(this.stage);
    }

    public final String stageAsString() {
        return this.stage;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.functionARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.stageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FunctionMetadata)) {
            return false;
        }
        FunctionMetadata other = (FunctionMetadata)obj;
        return Objects.equals(this.functionARN(), other.functionARN()) && Objects.equals(this.stageAsString(), other.stageAsString()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime());
    }

    public final String toString() {
        return ToString.builder((String)"FunctionMetadata").add("FunctionARN", (Object)this.functionARN()).add("Stage", (Object)this.stageAsString()).add("CreatedTime", (Object)this.createdTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FunctionARN": {
                return Optional.ofNullable(clazz.cast(this.functionARN()));
            }
            case "Stage": {
                return Optional.ofNullable(clazz.cast(this.stageAsString()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FunctionMetadata, T> g) {
        return obj -> g.apply((FunctionMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String functionARN;
        private String stage;
        private Instant createdTime;
        private Instant lastModifiedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(FunctionMetadata model) {
            this.functionARN(model.functionARN);
            this.stage(model.stage);
            this.createdTime(model.createdTime);
            this.lastModifiedTime(model.lastModifiedTime);
        }

        public final String getFunctionARN() {
            return this.functionARN;
        }

        public final void setFunctionARN(String functionARN) {
            this.functionARN = functionARN;
        }

        @Override
        @Transient
        public final Builder functionARN(String functionARN) {
            this.functionARN = functionARN;
            return this;
        }

        public final String getStage() {
            return this.stage;
        }

        public final void setStage(String stage) {
            this.stage = stage;
        }

        @Override
        @Transient
        public final Builder stage(String stage) {
            this.stage = stage;
            return this;
        }

        @Override
        @Transient
        public final Builder stage(FunctionStage stage) {
            this.stage(stage == null ? null : stage.toString());
            return this;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        @Transient
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        @Transient
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public FunctionMetadata build() {
            return new FunctionMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FunctionMetadata> {
        public Builder functionARN(String var1);

        public Builder stage(String var1);

        public Builder stage(FunctionStage var1);

        public Builder createdTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);
    }
}

