/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontResponse;
import software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicyConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetResponseHeadersPolicyConfigResponse
extends CloudFrontResponse
implements ToCopyableBuilder<Builder, GetResponseHeadersPolicyConfigResponse> {
    private static final SdkField<ResponseHeadersPolicyConfig> RESPONSE_HEADERS_POLICY_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResponseHeadersPolicyConfig").getter(GetResponseHeadersPolicyConfigResponse.getter(GetResponseHeadersPolicyConfigResponse::responseHeadersPolicyConfig)).setter(GetResponseHeadersPolicyConfigResponse.setter(Builder::responseHeadersPolicyConfig)).constructor(ResponseHeadersPolicyConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResponseHeadersPolicyConfig").unmarshallLocationName("ResponseHeadersPolicyConfig").build(), PayloadTrait.create()}).build();
    private static final SdkField<String> E_TAG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ETag").getter(GetResponseHeadersPolicyConfigResponse.getter(GetResponseHeadersPolicyConfigResponse::eTag)).setter(GetResponseHeadersPolicyConfigResponse.setter(Builder::eTag)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("ETag").unmarshallLocationName("ETag").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESPONSE_HEADERS_POLICY_CONFIG_FIELD, E_TAG_FIELD));
    private final ResponseHeadersPolicyConfig responseHeadersPolicyConfig;
    private final String eTag;

    private GetResponseHeadersPolicyConfigResponse(BuilderImpl builder) {
        super(builder);
        this.responseHeadersPolicyConfig = builder.responseHeadersPolicyConfig;
        this.eTag = builder.eTag;
    }

    public final ResponseHeadersPolicyConfig responseHeadersPolicyConfig() {
        return this.responseHeadersPolicyConfig;
    }

    public final String eTag() {
        return this.eTag;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.responseHeadersPolicyConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.eTag());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResponseHeadersPolicyConfigResponse)) {
            return false;
        }
        GetResponseHeadersPolicyConfigResponse other = (GetResponseHeadersPolicyConfigResponse)((Object)obj);
        return Objects.equals(this.responseHeadersPolicyConfig(), other.responseHeadersPolicyConfig()) && Objects.equals(this.eTag(), other.eTag());
    }

    public final String toString() {
        return ToString.builder((String)"GetResponseHeadersPolicyConfigResponse").add("ResponseHeadersPolicyConfig", (Object)this.responseHeadersPolicyConfig()).add("ETag", (Object)this.eTag()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResponseHeadersPolicyConfig": {
                return Optional.ofNullable(clazz.cast(this.responseHeadersPolicyConfig()));
            }
            case "ETag": {
                return Optional.ofNullable(clazz.cast(this.eTag()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetResponseHeadersPolicyConfigResponse, T> g) {
        return obj -> g.apply((GetResponseHeadersPolicyConfigResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFrontResponse.BuilderImpl
    implements Builder {
        private ResponseHeadersPolicyConfig responseHeadersPolicyConfig;
        private String eTag;

        private BuilderImpl() {
        }

        private BuilderImpl(GetResponseHeadersPolicyConfigResponse model) {
            super(model);
            this.responseHeadersPolicyConfig(model.responseHeadersPolicyConfig);
            this.eTag(model.eTag);
        }

        public final ResponseHeadersPolicyConfig.Builder getResponseHeadersPolicyConfig() {
            return this.responseHeadersPolicyConfig != null ? this.responseHeadersPolicyConfig.toBuilder() : null;
        }

        public final void setResponseHeadersPolicyConfig(ResponseHeadersPolicyConfig.BuilderImpl responseHeadersPolicyConfig) {
            this.responseHeadersPolicyConfig = responseHeadersPolicyConfig != null ? responseHeadersPolicyConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder responseHeadersPolicyConfig(ResponseHeadersPolicyConfig responseHeadersPolicyConfig) {
            this.responseHeadersPolicyConfig = responseHeadersPolicyConfig;
            return this;
        }

        public final String getETag() {
            return this.eTag;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        @Transient
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        @Override
        public GetResponseHeadersPolicyConfigResponse build() {
            return new GetResponseHeadersPolicyConfigResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudFrontResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetResponseHeadersPolicyConfigResponse> {
        public Builder responseHeadersPolicyConfig(ResponseHeadersPolicyConfig var1);

        default public Builder responseHeadersPolicyConfig(Consumer<ResponseHeadersPolicyConfig.Builder> responseHeadersPolicyConfig) {
            return this.responseHeadersPolicyConfig((ResponseHeadersPolicyConfig)((ResponseHeadersPolicyConfig.Builder)ResponseHeadersPolicyConfig.builder().applyMutation(responseHeadersPolicyConfig)).build());
        }

        public Builder eTag(String var1);
    }
}

