/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudfront.model.FunctionExecutionLogListCopier;
import software.amazon.awssdk.services.cloudfront.model.FunctionSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TestResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TestResult> {
    private static final SdkField<FunctionSummary> FUNCTION_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FunctionSummary").getter(TestResult.getter(TestResult::functionSummary)).setter(TestResult.setter(Builder::functionSummary)).constructor(FunctionSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionSummary").unmarshallLocationName("FunctionSummary").build()}).build();
    private static final SdkField<String> COMPUTE_UTILIZATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ComputeUtilization").getter(TestResult.getter(TestResult::computeUtilization)).setter(TestResult.setter(Builder::computeUtilization)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeUtilization").unmarshallLocationName("ComputeUtilization").build()}).build();
    private static final SdkField<List<String>> FUNCTION_EXECUTION_LOGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FunctionExecutionLogs").getter(TestResult.getter(TestResult::functionExecutionLogs)).setter(TestResult.setter(Builder::functionExecutionLogs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionExecutionLogs").unmarshallLocationName("FunctionExecutionLogs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").unmarshallLocationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> FUNCTION_ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FunctionErrorMessage").getter(TestResult.getter(TestResult::functionErrorMessage)).setter(TestResult.setter(Builder::functionErrorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionErrorMessage").unmarshallLocationName("FunctionErrorMessage").build()}).build();
    private static final SdkField<String> FUNCTION_OUTPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FunctionOutput").getter(TestResult.getter(TestResult::functionOutput)).setter(TestResult.setter(Builder::functionOutput)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionOutput").unmarshallLocationName("FunctionOutput").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FUNCTION_SUMMARY_FIELD, COMPUTE_UTILIZATION_FIELD, FUNCTION_EXECUTION_LOGS_FIELD, FUNCTION_ERROR_MESSAGE_FIELD, FUNCTION_OUTPUT_FIELD));
    private static final long serialVersionUID = 1L;
    private final FunctionSummary functionSummary;
    private final String computeUtilization;
    private final List<String> functionExecutionLogs;
    private final String functionErrorMessage;
    private final String functionOutput;

    private TestResult(BuilderImpl builder) {
        this.functionSummary = builder.functionSummary;
        this.computeUtilization = builder.computeUtilization;
        this.functionExecutionLogs = builder.functionExecutionLogs;
        this.functionErrorMessage = builder.functionErrorMessage;
        this.functionOutput = builder.functionOutput;
    }

    public final FunctionSummary functionSummary() {
        return this.functionSummary;
    }

    public final String computeUtilization() {
        return this.computeUtilization;
    }

    public final boolean hasFunctionExecutionLogs() {
        return this.functionExecutionLogs != null && !(this.functionExecutionLogs instanceof SdkAutoConstructList);
    }

    public final List<String> functionExecutionLogs() {
        return this.functionExecutionLogs;
    }

    public final String functionErrorMessage() {
        return this.functionErrorMessage;
    }

    public final String functionOutput() {
        return this.functionOutput;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.functionSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.computeUtilization());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFunctionExecutionLogs() ? this.functionExecutionLogs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.functionErrorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.functionOutput());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestResult)) {
            return false;
        }
        TestResult other = (TestResult)obj;
        return Objects.equals(this.functionSummary(), other.functionSummary()) && Objects.equals(this.computeUtilization(), other.computeUtilization()) && this.hasFunctionExecutionLogs() == other.hasFunctionExecutionLogs() && Objects.equals(this.functionExecutionLogs(), other.functionExecutionLogs()) && Objects.equals(this.functionErrorMessage(), other.functionErrorMessage()) && Objects.equals(this.functionOutput(), other.functionOutput());
    }

    public final String toString() {
        return ToString.builder((String)"TestResult").add("FunctionSummary", (Object)this.functionSummary()).add("ComputeUtilization", (Object)this.computeUtilization()).add("FunctionExecutionLogs", this.hasFunctionExecutionLogs() ? this.functionExecutionLogs() : null).add("FunctionErrorMessage", (Object)this.functionErrorMessage()).add("FunctionOutput", (Object)this.functionOutput()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FunctionSummary": {
                return Optional.ofNullable(clazz.cast(this.functionSummary()));
            }
            case "ComputeUtilization": {
                return Optional.ofNullable(clazz.cast(this.computeUtilization()));
            }
            case "FunctionExecutionLogs": {
                return Optional.ofNullable(clazz.cast(this.functionExecutionLogs()));
            }
            case "FunctionErrorMessage": {
                return Optional.ofNullable(clazz.cast(this.functionErrorMessage()));
            }
            case "FunctionOutput": {
                return Optional.ofNullable(clazz.cast(this.functionOutput()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TestResult, T> g) {
        return obj -> g.apply((TestResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private FunctionSummary functionSummary;
        private String computeUtilization;
        private List<String> functionExecutionLogs = DefaultSdkAutoConstructList.getInstance();
        private String functionErrorMessage;
        private String functionOutput;

        private BuilderImpl() {
        }

        private BuilderImpl(TestResult model) {
            this.functionSummary(model.functionSummary);
            this.computeUtilization(model.computeUtilization);
            this.functionExecutionLogs(model.functionExecutionLogs);
            this.functionErrorMessage(model.functionErrorMessage);
            this.functionOutput(model.functionOutput);
        }

        public final FunctionSummary.Builder getFunctionSummary() {
            return this.functionSummary != null ? this.functionSummary.toBuilder() : null;
        }

        public final void setFunctionSummary(FunctionSummary.BuilderImpl functionSummary) {
            this.functionSummary = functionSummary != null ? functionSummary.build() : null;
        }

        @Override
        @Transient
        public final Builder functionSummary(FunctionSummary functionSummary) {
            this.functionSummary = functionSummary;
            return this;
        }

        public final String getComputeUtilization() {
            return this.computeUtilization;
        }

        public final void setComputeUtilization(String computeUtilization) {
            this.computeUtilization = computeUtilization;
        }

        @Override
        @Transient
        public final Builder computeUtilization(String computeUtilization) {
            this.computeUtilization = computeUtilization;
            return this;
        }

        public final Collection<String> getFunctionExecutionLogs() {
            if (this.functionExecutionLogs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.functionExecutionLogs;
        }

        public final void setFunctionExecutionLogs(Collection<String> functionExecutionLogs) {
            this.functionExecutionLogs = FunctionExecutionLogListCopier.copy(functionExecutionLogs);
        }

        @Override
        @Transient
        public final Builder functionExecutionLogs(Collection<String> functionExecutionLogs) {
            this.functionExecutionLogs = FunctionExecutionLogListCopier.copy(functionExecutionLogs);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder functionExecutionLogs(String ... functionExecutionLogs) {
            this.functionExecutionLogs(Arrays.asList(functionExecutionLogs));
            return this;
        }

        public final String getFunctionErrorMessage() {
            return this.functionErrorMessage;
        }

        public final void setFunctionErrorMessage(String functionErrorMessage) {
            this.functionErrorMessage = functionErrorMessage;
        }

        @Override
        @Transient
        public final Builder functionErrorMessage(String functionErrorMessage) {
            this.functionErrorMessage = functionErrorMessage;
            return this;
        }

        public final String getFunctionOutput() {
            return this.functionOutput;
        }

        public final void setFunctionOutput(String functionOutput) {
            this.functionOutput = functionOutput;
        }

        @Override
        @Transient
        public final Builder functionOutput(String functionOutput) {
            this.functionOutput = functionOutput;
            return this;
        }

        public TestResult build() {
            return new TestResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TestResult> {
        public Builder functionSummary(FunctionSummary var1);

        default public Builder functionSummary(Consumer<FunctionSummary.Builder> functionSummary) {
            return this.functionSummary((FunctionSummary)((FunctionSummary.Builder)FunctionSummary.builder().applyMutation(functionSummary)).build());
        }

        public Builder computeUtilization(String var1);

        public Builder functionExecutionLogs(Collection<String> var1);

        public Builder functionExecutionLogs(String ... var1);

        public Builder functionErrorMessage(String var1);

        public Builder functionOutput(String var1);
    }
}

