/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.FunctionConfig;
import software.amazon.awssdk.services.cloudfront.model.FunctionMetadata;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FunctionSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FunctionSummary> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(FunctionSummary.getter(FunctionSummary::name)).setter(FunctionSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").unmarshallLocationName("Name").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(FunctionSummary.getter(FunctionSummary::status)).setter(FunctionSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").unmarshallLocationName("Status").build()}).build();
    private static final SdkField<FunctionConfig> FUNCTION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FunctionConfig").getter(FunctionSummary.getter(FunctionSummary::functionConfig)).setter(FunctionSummary.setter(Builder::functionConfig)).constructor(FunctionConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionConfig").unmarshallLocationName("FunctionConfig").build()}).build();
    private static final SdkField<FunctionMetadata> FUNCTION_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FunctionMetadata").getter(FunctionSummary.getter(FunctionSummary::functionMetadata)).setter(FunctionSummary.setter(Builder::functionMetadata)).constructor(FunctionMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionMetadata").unmarshallLocationName("FunctionMetadata").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, STATUS_FIELD, FUNCTION_CONFIG_FIELD, FUNCTION_METADATA_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String status;
    private final FunctionConfig functionConfig;
    private final FunctionMetadata functionMetadata;

    private FunctionSummary(BuilderImpl builder) {
        this.name = builder.name;
        this.status = builder.status;
        this.functionConfig = builder.functionConfig;
        this.functionMetadata = builder.functionMetadata;
    }

    public final String name() {
        return this.name;
    }

    public final String status() {
        return this.status;
    }

    public final FunctionConfig functionConfig() {
        return this.functionConfig;
    }

    public final FunctionMetadata functionMetadata() {
        return this.functionMetadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.functionConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.functionMetadata());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FunctionSummary)) {
            return false;
        }
        FunctionSummary other = (FunctionSummary)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.functionConfig(), other.functionConfig()) && Objects.equals(this.functionMetadata(), other.functionMetadata());
    }

    public final String toString() {
        return ToString.builder((String)"FunctionSummary").add("Name", (Object)this.name()).add("Status", (Object)this.status()).add("FunctionConfig", (Object)this.functionConfig()).add("FunctionMetadata", (Object)this.functionMetadata()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "FunctionConfig": {
                return Optional.ofNullable(clazz.cast(this.functionConfig()));
            }
            case "FunctionMetadata": {
                return Optional.ofNullable(clazz.cast(this.functionMetadata()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FunctionSummary, T> g) {
        return obj -> g.apply((FunctionSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String status;
        private FunctionConfig functionConfig;
        private FunctionMetadata functionMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(FunctionSummary model) {
            this.name(model.name);
            this.status(model.status);
            this.functionConfig(model.functionConfig);
            this.functionMetadata(model.functionMetadata);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final FunctionConfig.Builder getFunctionConfig() {
            return this.functionConfig != null ? this.functionConfig.toBuilder() : null;
        }

        public final void setFunctionConfig(FunctionConfig.BuilderImpl functionConfig) {
            this.functionConfig = functionConfig != null ? functionConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder functionConfig(FunctionConfig functionConfig) {
            this.functionConfig = functionConfig;
            return this;
        }

        public final FunctionMetadata.Builder getFunctionMetadata() {
            return this.functionMetadata != null ? this.functionMetadata.toBuilder() : null;
        }

        public final void setFunctionMetadata(FunctionMetadata.BuilderImpl functionMetadata) {
            this.functionMetadata = functionMetadata != null ? functionMetadata.build() : null;
        }

        @Override
        @Transient
        public final Builder functionMetadata(FunctionMetadata functionMetadata) {
            this.functionMetadata = functionMetadata;
            return this;
        }

        public FunctionSummary build() {
            return new FunctionSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FunctionSummary> {
        public Builder name(String var1);

        public Builder status(String var1);

        public Builder functionConfig(FunctionConfig var1);

        default public Builder functionConfig(Consumer<FunctionConfig.Builder> functionConfig) {
            return this.functionConfig((FunctionConfig)((FunctionConfig.Builder)FunctionConfig.builder().applyMutation(functionConfig)).build());
        }

        public Builder functionMetadata(FunctionMetadata var1);

        default public Builder functionMetadata(Consumer<FunctionMetadata.Builder> functionMetadata) {
            return this.functionMetadata((FunctionMetadata)((FunctionMetadata.Builder)FunctionMetadata.builder().applyMutation(functionMetadata)).build());
        }
    }
}

