/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ViewerProtocolPolicy {
    ALLOW_ALL("allow-all"),
    HTTPS_ONLY("https-only"),
    REDIRECT_TO_HTTPS("redirect-to-https"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ViewerProtocolPolicy> VALUE_MAP;
    private final String value;

    private ViewerProtocolPolicy(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ViewerProtocolPolicy fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ViewerProtocolPolicy> knownValues() {
        EnumSet<ViewerProtocolPolicy> knownValues = EnumSet.allOf(ViewerProtocolPolicy.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ViewerProtocolPolicy.class, ViewerProtocolPolicy::toString);
    }
}

