/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.KeyPairIds;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Signer
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Signer> {
    private static final SdkField<String> AWS_ACCOUNT_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsAccountNumber").getter(Signer.getter(Signer::awsAccountNumber)).setter(Signer.setter(Builder::awsAccountNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsAccountNumber").unmarshallLocationName("AwsAccountNumber").build()}).build();
    private static final SdkField<KeyPairIds> KEY_PAIR_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("KeyPairIds").getter(Signer.getter(Signer::keyPairIds)).setter(Signer.setter(Builder::keyPairIds)).constructor(KeyPairIds::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyPairIds").unmarshallLocationName("KeyPairIds").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_NUMBER_FIELD, KEY_PAIR_IDS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String awsAccountNumber;
    private final KeyPairIds keyPairIds;

    private Signer(BuilderImpl builder) {
        this.awsAccountNumber = builder.awsAccountNumber;
        this.keyPairIds = builder.keyPairIds;
    }

    public final String awsAccountNumber() {
        return this.awsAccountNumber;
    }

    public final KeyPairIds keyPairIds() {
        return this.keyPairIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyPairIds());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Signer)) {
            return false;
        }
        Signer other = (Signer)obj;
        return Objects.equals(this.awsAccountNumber(), other.awsAccountNumber()) && Objects.equals(this.keyPairIds(), other.keyPairIds());
    }

    public final String toString() {
        return ToString.builder((String)"Signer").add("AwsAccountNumber", (Object)this.awsAccountNumber()).add("KeyPairIds", (Object)this.keyPairIds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AwsAccountNumber": {
                return Optional.ofNullable(clazz.cast(this.awsAccountNumber()));
            }
            case "KeyPairIds": {
                return Optional.ofNullable(clazz.cast(this.keyPairIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Signer, T> g) {
        return obj -> g.apply((Signer)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String awsAccountNumber;
        private KeyPairIds keyPairIds;

        private BuilderImpl() {
        }

        private BuilderImpl(Signer model) {
            this.awsAccountNumber(model.awsAccountNumber);
            this.keyPairIds(model.keyPairIds);
        }

        public final String getAwsAccountNumber() {
            return this.awsAccountNumber;
        }

        public final void setAwsAccountNumber(String awsAccountNumber) {
            this.awsAccountNumber = awsAccountNumber;
        }

        @Override
        @Transient
        public final Builder awsAccountNumber(String awsAccountNumber) {
            this.awsAccountNumber = awsAccountNumber;
            return this;
        }

        public final KeyPairIds.Builder getKeyPairIds() {
            return this.keyPairIds != null ? this.keyPairIds.toBuilder() : null;
        }

        public final void setKeyPairIds(KeyPairIds.BuilderImpl keyPairIds) {
            this.keyPairIds = keyPairIds != null ? keyPairIds.build() : null;
        }

        @Override
        @Transient
        public final Builder keyPairIds(KeyPairIds keyPairIds) {
            this.keyPairIds = keyPairIds;
            return this;
        }

        public Signer build() {
            return new Signer(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Signer> {
        public Builder awsAccountNumber(String var1);

        public Builder keyPairIds(KeyPairIds var1);

        default public Builder keyPairIds(Consumer<KeyPairIds.Builder> keyPairIds) {
            return this.keyPairIds((KeyPairIds)((KeyPairIds.Builder)KeyPairIds.builder().applyMutation(keyPairIds)).build());
        }
    }
}

