/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontResponse;
import software.amazon.awssdk.services.cloudfront.model.FunctionSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PublishFunctionResponse
extends CloudFrontResponse
implements ToCopyableBuilder<Builder, PublishFunctionResponse> {
    private static final SdkField<FunctionSummary> FUNCTION_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FunctionSummary").getter(PublishFunctionResponse.getter(PublishFunctionResponse::functionSummary)).setter(PublishFunctionResponse.setter(Builder::functionSummary)).constructor(FunctionSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionSummary").unmarshallLocationName("FunctionSummary").build(), PayloadTrait.create()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FUNCTION_SUMMARY_FIELD));
    private final FunctionSummary functionSummary;

    private PublishFunctionResponse(BuilderImpl builder) {
        super(builder);
        this.functionSummary = builder.functionSummary;
    }

    public final FunctionSummary functionSummary() {
        return this.functionSummary;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.functionSummary());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PublishFunctionResponse)) {
            return false;
        }
        PublishFunctionResponse other = (PublishFunctionResponse)((Object)obj);
        return Objects.equals(this.functionSummary(), other.functionSummary());
    }

    public final String toString() {
        return ToString.builder((String)"PublishFunctionResponse").add("FunctionSummary", (Object)this.functionSummary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FunctionSummary": {
                return Optional.ofNullable(clazz.cast(this.functionSummary()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PublishFunctionResponse, T> g) {
        return obj -> g.apply((PublishFunctionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFrontResponse.BuilderImpl
    implements Builder {
        private FunctionSummary functionSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(PublishFunctionResponse model) {
            super(model);
            this.functionSummary(model.functionSummary);
        }

        public final FunctionSummary.Builder getFunctionSummary() {
            return this.functionSummary != null ? this.functionSummary.toBuilder() : null;
        }

        public final void setFunctionSummary(FunctionSummary.BuilderImpl functionSummary) {
            this.functionSummary = functionSummary != null ? functionSummary.build() : null;
        }

        @Override
        @Transient
        public final Builder functionSummary(FunctionSummary functionSummary) {
            this.functionSummary = functionSummary;
            return this;
        }

        @Override
        public PublishFunctionResponse build() {
            return new PublishFunctionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudFrontResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PublishFunctionResponse> {
        public Builder functionSummary(FunctionSummary var1);

        default public Builder functionSummary(Consumer<FunctionSummary.Builder> functionSummary) {
            return this.functionSummary((FunctionSummary)((FunctionSummary.Builder)FunctionSummary.builder().applyMutation(functionSummary)).build());
        }
    }
}

