/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.AllowedMethods;
import software.amazon.awssdk.services.cloudfront.model.ForwardedValues;
import software.amazon.awssdk.services.cloudfront.model.FunctionAssociations;
import software.amazon.awssdk.services.cloudfront.model.LambdaFunctionAssociations;
import software.amazon.awssdk.services.cloudfront.model.TrustedKeyGroups;
import software.amazon.awssdk.services.cloudfront.model.TrustedSigners;
import software.amazon.awssdk.services.cloudfront.model.ViewerProtocolPolicy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DefaultCacheBehavior
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DefaultCacheBehavior> {
    private static final SdkField<String> TARGET_ORIGIN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetOriginId").getter(DefaultCacheBehavior.getter(DefaultCacheBehavior::targetOriginId)).setter(DefaultCacheBehavior.setter(Builder::targetOriginId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetOriginId").unmarshallLocationName("TargetOriginId").build()}).build();
    private static final SdkField<TrustedSigners> TRUSTED_SIGNERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TrustedSigners").getter(DefaultCacheBehavior.getter(DefaultCacheBehavior::trustedSigners)).setter(DefaultCacheBehavior.setter(Builder::trustedSigners)).constructor(TrustedSigners::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustedSigners").unmarshallLocationName("TrustedSigners").build()}).build();
    private static final SdkField<TrustedKeyGroups> TRUSTED_KEY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TrustedKeyGroups").getter(DefaultCacheBehavior.getter(DefaultCacheBehavior::trustedKeyGroups)).setter(DefaultCacheBehavior.setter(Builder::trustedKeyGroups)).constructor(TrustedKeyGroups::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustedKeyGroups").unmarshallLocationName("TrustedKeyGroups").build()}).build();
    private static final SdkField<String> VIEWER_PROTOCOL_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ViewerProtocolPolicy").getter(DefaultCacheBehavior.getter(DefaultCacheBehavior::viewerProtocolPolicyAsString)).setter(DefaultCacheBehavior.setter(Builder::viewerProtocolPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViewerProtocolPolicy").unmarshallLocationName("ViewerProtocolPolicy").build()}).build();
    private static final SdkField<AllowedMethods> ALLOWED_METHODS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AllowedMethods").getter(DefaultCacheBehavior.getter(DefaultCacheBehavior::allowedMethods)).setter(DefaultCacheBehavior.setter(Builder::allowedMethods)).constructor(AllowedMethods::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedMethods").unmarshallLocationName("AllowedMethods").build()}).build();
    private static final SdkField<Boolean> SMOOTH_STREAMING_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SmoothStreaming").getter(DefaultCacheBehavior.getter(DefaultCacheBehavior::smoothStreaming)).setter(DefaultCacheBehavior.setter(Builder::smoothStreaming)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SmoothStreaming").unmarshallLocationName("SmoothStreaming").build()}).build();
    private static final SdkField<Boolean> COMPRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Compress").getter(DefaultCacheBehavior.getter(DefaultCacheBehavior::compress)).setter(DefaultCacheBehavior.setter(Builder::compress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Compress").unmarshallLocationName("Compress").build()}).build();
    private static final SdkField<LambdaFunctionAssociations> LAMBDA_FUNCTION_ASSOCIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LambdaFunctionAssociations").getter(DefaultCacheBehavior.getter(DefaultCacheBehavior::lambdaFunctionAssociations)).setter(DefaultCacheBehavior.setter(Builder::lambdaFunctionAssociations)).constructor(LambdaFunctionAssociations::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LambdaFunctionAssociations").unmarshallLocationName("LambdaFunctionAssociations").build()}).build();
    private static final SdkField<FunctionAssociations> FUNCTION_ASSOCIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FunctionAssociations").getter(DefaultCacheBehavior.getter(DefaultCacheBehavior::functionAssociations)).setter(DefaultCacheBehavior.setter(Builder::functionAssociations)).constructor(FunctionAssociations::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionAssociations").unmarshallLocationName("FunctionAssociations").build()}).build();
    private static final SdkField<String> FIELD_LEVEL_ENCRYPTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FieldLevelEncryptionId").getter(DefaultCacheBehavior.getter(DefaultCacheBehavior::fieldLevelEncryptionId)).setter(DefaultCacheBehavior.setter(Builder::fieldLevelEncryptionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldLevelEncryptionId").unmarshallLocationName("FieldLevelEncryptionId").build()}).build();
    private static final SdkField<String> REALTIME_LOG_CONFIG_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RealtimeLogConfigArn").getter(DefaultCacheBehavior.getter(DefaultCacheBehavior::realtimeLogConfigArn)).setter(DefaultCacheBehavior.setter(Builder::realtimeLogConfigArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RealtimeLogConfigArn").unmarshallLocationName("RealtimeLogConfigArn").build()}).build();
    private static final SdkField<String> CACHE_POLICY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CachePolicyId").getter(DefaultCacheBehavior.getter(DefaultCacheBehavior::cachePolicyId)).setter(DefaultCacheBehavior.setter(Builder::cachePolicyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CachePolicyId").unmarshallLocationName("CachePolicyId").build()}).build();
    private static final SdkField<String> ORIGIN_REQUEST_POLICY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OriginRequestPolicyId").getter(DefaultCacheBehavior.getter(DefaultCacheBehavior::originRequestPolicyId)).setter(DefaultCacheBehavior.setter(Builder::originRequestPolicyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginRequestPolicyId").unmarshallLocationName("OriginRequestPolicyId").build()}).build();
    private static final SdkField<ForwardedValues> FORWARDED_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ForwardedValues").getter(DefaultCacheBehavior.getter(DefaultCacheBehavior::forwardedValues)).setter(DefaultCacheBehavior.setter(Builder::forwardedValues)).constructor(ForwardedValues::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForwardedValues").unmarshallLocationName("ForwardedValues").build()}).build();
    private static final SdkField<Long> MIN_TTL_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("MinTTL").getter(DefaultCacheBehavior.getter(DefaultCacheBehavior::minTTL)).setter(DefaultCacheBehavior.setter(Builder::minTTL)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinTTL").unmarshallLocationName("MinTTL").build()}).build();
    private static final SdkField<Long> DEFAULT_TTL_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("DefaultTTL").getter(DefaultCacheBehavior.getter(DefaultCacheBehavior::defaultTTL)).setter(DefaultCacheBehavior.setter(Builder::defaultTTL)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultTTL").unmarshallLocationName("DefaultTTL").build()}).build();
    private static final SdkField<Long> MAX_TTL_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("MaxTTL").getter(DefaultCacheBehavior.getter(DefaultCacheBehavior::maxTTL)).setter(DefaultCacheBehavior.setter(Builder::maxTTL)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxTTL").unmarshallLocationName("MaxTTL").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_ORIGIN_ID_FIELD, TRUSTED_SIGNERS_FIELD, TRUSTED_KEY_GROUPS_FIELD, VIEWER_PROTOCOL_POLICY_FIELD, ALLOWED_METHODS_FIELD, SMOOTH_STREAMING_FIELD, COMPRESS_FIELD, LAMBDA_FUNCTION_ASSOCIATIONS_FIELD, FUNCTION_ASSOCIATIONS_FIELD, FIELD_LEVEL_ENCRYPTION_ID_FIELD, REALTIME_LOG_CONFIG_ARN_FIELD, CACHE_POLICY_ID_FIELD, ORIGIN_REQUEST_POLICY_ID_FIELD, FORWARDED_VALUES_FIELD, MIN_TTL_FIELD, DEFAULT_TTL_FIELD, MAX_TTL_FIELD));
    private static final long serialVersionUID = 1L;
    private final String targetOriginId;
    private final TrustedSigners trustedSigners;
    private final TrustedKeyGroups trustedKeyGroups;
    private final String viewerProtocolPolicy;
    private final AllowedMethods allowedMethods;
    private final Boolean smoothStreaming;
    private final Boolean compress;
    private final LambdaFunctionAssociations lambdaFunctionAssociations;
    private final FunctionAssociations functionAssociations;
    private final String fieldLevelEncryptionId;
    private final String realtimeLogConfigArn;
    private final String cachePolicyId;
    private final String originRequestPolicyId;
    private final ForwardedValues forwardedValues;
    private final Long minTTL;
    private final Long defaultTTL;
    private final Long maxTTL;

    private DefaultCacheBehavior(BuilderImpl builder) {
        this.targetOriginId = builder.targetOriginId;
        this.trustedSigners = builder.trustedSigners;
        this.trustedKeyGroups = builder.trustedKeyGroups;
        this.viewerProtocolPolicy = builder.viewerProtocolPolicy;
        this.allowedMethods = builder.allowedMethods;
        this.smoothStreaming = builder.smoothStreaming;
        this.compress = builder.compress;
        this.lambdaFunctionAssociations = builder.lambdaFunctionAssociations;
        this.functionAssociations = builder.functionAssociations;
        this.fieldLevelEncryptionId = builder.fieldLevelEncryptionId;
        this.realtimeLogConfigArn = builder.realtimeLogConfigArn;
        this.cachePolicyId = builder.cachePolicyId;
        this.originRequestPolicyId = builder.originRequestPolicyId;
        this.forwardedValues = builder.forwardedValues;
        this.minTTL = builder.minTTL;
        this.defaultTTL = builder.defaultTTL;
        this.maxTTL = builder.maxTTL;
    }

    public final String targetOriginId() {
        return this.targetOriginId;
    }

    public final TrustedSigners trustedSigners() {
        return this.trustedSigners;
    }

    public final TrustedKeyGroups trustedKeyGroups() {
        return this.trustedKeyGroups;
    }

    public final ViewerProtocolPolicy viewerProtocolPolicy() {
        return ViewerProtocolPolicy.fromValue(this.viewerProtocolPolicy);
    }

    public final String viewerProtocolPolicyAsString() {
        return this.viewerProtocolPolicy;
    }

    public final AllowedMethods allowedMethods() {
        return this.allowedMethods;
    }

    public final Boolean smoothStreaming() {
        return this.smoothStreaming;
    }

    public final Boolean compress() {
        return this.compress;
    }

    public final LambdaFunctionAssociations lambdaFunctionAssociations() {
        return this.lambdaFunctionAssociations;
    }

    public final FunctionAssociations functionAssociations() {
        return this.functionAssociations;
    }

    public final String fieldLevelEncryptionId() {
        return this.fieldLevelEncryptionId;
    }

    public final String realtimeLogConfigArn() {
        return this.realtimeLogConfigArn;
    }

    public final String cachePolicyId() {
        return this.cachePolicyId;
    }

    public final String originRequestPolicyId() {
        return this.originRequestPolicyId;
    }

    @Deprecated
    public final ForwardedValues forwardedValues() {
        return this.forwardedValues;
    }

    @Deprecated
    public final Long minTTL() {
        return this.minTTL;
    }

    @Deprecated
    public final Long defaultTTL() {
        return this.defaultTTL;
    }

    @Deprecated
    public final Long maxTTL() {
        return this.maxTTL;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.targetOriginId());
        hashCode = 31 * hashCode + Objects.hashCode(this.trustedSigners());
        hashCode = 31 * hashCode + Objects.hashCode(this.trustedKeyGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.viewerProtocolPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowedMethods());
        hashCode = 31 * hashCode + Objects.hashCode(this.smoothStreaming());
        hashCode = 31 * hashCode + Objects.hashCode(this.compress());
        hashCode = 31 * hashCode + Objects.hashCode(this.lambdaFunctionAssociations());
        hashCode = 31 * hashCode + Objects.hashCode(this.functionAssociations());
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldLevelEncryptionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.realtimeLogConfigArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.cachePolicyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.originRequestPolicyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.forwardedValues());
        hashCode = 31 * hashCode + Objects.hashCode(this.minTTL());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultTTL());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxTTL());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefaultCacheBehavior)) {
            return false;
        }
        DefaultCacheBehavior other = (DefaultCacheBehavior)obj;
        return Objects.equals(this.targetOriginId(), other.targetOriginId()) && Objects.equals(this.trustedSigners(), other.trustedSigners()) && Objects.equals(this.trustedKeyGroups(), other.trustedKeyGroups()) && Objects.equals(this.viewerProtocolPolicyAsString(), other.viewerProtocolPolicyAsString()) && Objects.equals(this.allowedMethods(), other.allowedMethods()) && Objects.equals(this.smoothStreaming(), other.smoothStreaming()) && Objects.equals(this.compress(), other.compress()) && Objects.equals(this.lambdaFunctionAssociations(), other.lambdaFunctionAssociations()) && Objects.equals(this.functionAssociations(), other.functionAssociations()) && Objects.equals(this.fieldLevelEncryptionId(), other.fieldLevelEncryptionId()) && Objects.equals(this.realtimeLogConfigArn(), other.realtimeLogConfigArn()) && Objects.equals(this.cachePolicyId(), other.cachePolicyId()) && Objects.equals(this.originRequestPolicyId(), other.originRequestPolicyId()) && Objects.equals(this.forwardedValues(), other.forwardedValues()) && Objects.equals(this.minTTL(), other.minTTL()) && Objects.equals(this.defaultTTL(), other.defaultTTL()) && Objects.equals(this.maxTTL(), other.maxTTL());
    }

    public final String toString() {
        return ToString.builder((String)"DefaultCacheBehavior").add("TargetOriginId", (Object)this.targetOriginId()).add("TrustedSigners", (Object)this.trustedSigners()).add("TrustedKeyGroups", (Object)this.trustedKeyGroups()).add("ViewerProtocolPolicy", (Object)this.viewerProtocolPolicyAsString()).add("AllowedMethods", (Object)this.allowedMethods()).add("SmoothStreaming", (Object)this.smoothStreaming()).add("Compress", (Object)this.compress()).add("LambdaFunctionAssociations", (Object)this.lambdaFunctionAssociations()).add("FunctionAssociations", (Object)this.functionAssociations()).add("FieldLevelEncryptionId", (Object)this.fieldLevelEncryptionId()).add("RealtimeLogConfigArn", (Object)this.realtimeLogConfigArn()).add("CachePolicyId", (Object)this.cachePolicyId()).add("OriginRequestPolicyId", (Object)this.originRequestPolicyId()).add("ForwardedValues", (Object)this.forwardedValues()).add("MinTTL", (Object)this.minTTL()).add("DefaultTTL", (Object)this.defaultTTL()).add("MaxTTL", (Object)this.maxTTL()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TargetOriginId": {
                return Optional.ofNullable(clazz.cast(this.targetOriginId()));
            }
            case "TrustedSigners": {
                return Optional.ofNullable(clazz.cast(this.trustedSigners()));
            }
            case "TrustedKeyGroups": {
                return Optional.ofNullable(clazz.cast(this.trustedKeyGroups()));
            }
            case "ViewerProtocolPolicy": {
                return Optional.ofNullable(clazz.cast(this.viewerProtocolPolicyAsString()));
            }
            case "AllowedMethods": {
                return Optional.ofNullable(clazz.cast(this.allowedMethods()));
            }
            case "SmoothStreaming": {
                return Optional.ofNullable(clazz.cast(this.smoothStreaming()));
            }
            case "Compress": {
                return Optional.ofNullable(clazz.cast(this.compress()));
            }
            case "LambdaFunctionAssociations": {
                return Optional.ofNullable(clazz.cast(this.lambdaFunctionAssociations()));
            }
            case "FunctionAssociations": {
                return Optional.ofNullable(clazz.cast(this.functionAssociations()));
            }
            case "FieldLevelEncryptionId": {
                return Optional.ofNullable(clazz.cast(this.fieldLevelEncryptionId()));
            }
            case "RealtimeLogConfigArn": {
                return Optional.ofNullable(clazz.cast(this.realtimeLogConfigArn()));
            }
            case "CachePolicyId": {
                return Optional.ofNullable(clazz.cast(this.cachePolicyId()));
            }
            case "OriginRequestPolicyId": {
                return Optional.ofNullable(clazz.cast(this.originRequestPolicyId()));
            }
            case "ForwardedValues": {
                return Optional.ofNullable(clazz.cast(this.forwardedValues()));
            }
            case "MinTTL": {
                return Optional.ofNullable(clazz.cast(this.minTTL()));
            }
            case "DefaultTTL": {
                return Optional.ofNullable(clazz.cast(this.defaultTTL()));
            }
            case "MaxTTL": {
                return Optional.ofNullable(clazz.cast(this.maxTTL()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DefaultCacheBehavior, T> g) {
        return obj -> g.apply((DefaultCacheBehavior)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String targetOriginId;
        private TrustedSigners trustedSigners;
        private TrustedKeyGroups trustedKeyGroups;
        private String viewerProtocolPolicy;
        private AllowedMethods allowedMethods;
        private Boolean smoothStreaming;
        private Boolean compress;
        private LambdaFunctionAssociations lambdaFunctionAssociations;
        private FunctionAssociations functionAssociations;
        private String fieldLevelEncryptionId;
        private String realtimeLogConfigArn;
        private String cachePolicyId;
        private String originRequestPolicyId;
        private ForwardedValues forwardedValues;
        private Long minTTL;
        private Long defaultTTL;
        private Long maxTTL;

        private BuilderImpl() {
        }

        private BuilderImpl(DefaultCacheBehavior model) {
            this.targetOriginId(model.targetOriginId);
            this.trustedSigners(model.trustedSigners);
            this.trustedKeyGroups(model.trustedKeyGroups);
            this.viewerProtocolPolicy(model.viewerProtocolPolicy);
            this.allowedMethods(model.allowedMethods);
            this.smoothStreaming(model.smoothStreaming);
            this.compress(model.compress);
            this.lambdaFunctionAssociations(model.lambdaFunctionAssociations);
            this.functionAssociations(model.functionAssociations);
            this.fieldLevelEncryptionId(model.fieldLevelEncryptionId);
            this.realtimeLogConfigArn(model.realtimeLogConfigArn);
            this.cachePolicyId(model.cachePolicyId);
            this.originRequestPolicyId(model.originRequestPolicyId);
            this.forwardedValues(model.forwardedValues);
            this.minTTL(model.minTTL);
            this.defaultTTL(model.defaultTTL);
            this.maxTTL(model.maxTTL);
        }

        public final String getTargetOriginId() {
            return this.targetOriginId;
        }

        @Override
        public final Builder targetOriginId(String targetOriginId) {
            this.targetOriginId = targetOriginId;
            return this;
        }

        public final void setTargetOriginId(String targetOriginId) {
            this.targetOriginId = targetOriginId;
        }

        public final TrustedSigners.Builder getTrustedSigners() {
            return this.trustedSigners != null ? this.trustedSigners.toBuilder() : null;
        }

        @Override
        public final Builder trustedSigners(TrustedSigners trustedSigners) {
            this.trustedSigners = trustedSigners;
            return this;
        }

        public final void setTrustedSigners(TrustedSigners.BuilderImpl trustedSigners) {
            this.trustedSigners = trustedSigners != null ? trustedSigners.build() : null;
        }

        public final TrustedKeyGroups.Builder getTrustedKeyGroups() {
            return this.trustedKeyGroups != null ? this.trustedKeyGroups.toBuilder() : null;
        }

        @Override
        public final Builder trustedKeyGroups(TrustedKeyGroups trustedKeyGroups) {
            this.trustedKeyGroups = trustedKeyGroups;
            return this;
        }

        public final void setTrustedKeyGroups(TrustedKeyGroups.BuilderImpl trustedKeyGroups) {
            this.trustedKeyGroups = trustedKeyGroups != null ? trustedKeyGroups.build() : null;
        }

        public final String getViewerProtocolPolicy() {
            return this.viewerProtocolPolicy;
        }

        @Override
        public final Builder viewerProtocolPolicy(String viewerProtocolPolicy) {
            this.viewerProtocolPolicy = viewerProtocolPolicy;
            return this;
        }

        @Override
        public final Builder viewerProtocolPolicy(ViewerProtocolPolicy viewerProtocolPolicy) {
            this.viewerProtocolPolicy(viewerProtocolPolicy == null ? null : viewerProtocolPolicy.toString());
            return this;
        }

        public final void setViewerProtocolPolicy(String viewerProtocolPolicy) {
            this.viewerProtocolPolicy = viewerProtocolPolicy;
        }

        public final AllowedMethods.Builder getAllowedMethods() {
            return this.allowedMethods != null ? this.allowedMethods.toBuilder() : null;
        }

        @Override
        public final Builder allowedMethods(AllowedMethods allowedMethods) {
            this.allowedMethods = allowedMethods;
            return this;
        }

        public final void setAllowedMethods(AllowedMethods.BuilderImpl allowedMethods) {
            this.allowedMethods = allowedMethods != null ? allowedMethods.build() : null;
        }

        public final Boolean getSmoothStreaming() {
            return this.smoothStreaming;
        }

        @Override
        public final Builder smoothStreaming(Boolean smoothStreaming) {
            this.smoothStreaming = smoothStreaming;
            return this;
        }

        public final void setSmoothStreaming(Boolean smoothStreaming) {
            this.smoothStreaming = smoothStreaming;
        }

        public final Boolean getCompress() {
            return this.compress;
        }

        @Override
        public final Builder compress(Boolean compress) {
            this.compress = compress;
            return this;
        }

        public final void setCompress(Boolean compress) {
            this.compress = compress;
        }

        public final LambdaFunctionAssociations.Builder getLambdaFunctionAssociations() {
            return this.lambdaFunctionAssociations != null ? this.lambdaFunctionAssociations.toBuilder() : null;
        }

        @Override
        public final Builder lambdaFunctionAssociations(LambdaFunctionAssociations lambdaFunctionAssociations) {
            this.lambdaFunctionAssociations = lambdaFunctionAssociations;
            return this;
        }

        public final void setLambdaFunctionAssociations(LambdaFunctionAssociations.BuilderImpl lambdaFunctionAssociations) {
            this.lambdaFunctionAssociations = lambdaFunctionAssociations != null ? lambdaFunctionAssociations.build() : null;
        }

        public final FunctionAssociations.Builder getFunctionAssociations() {
            return this.functionAssociations != null ? this.functionAssociations.toBuilder() : null;
        }

        @Override
        public final Builder functionAssociations(FunctionAssociations functionAssociations) {
            this.functionAssociations = functionAssociations;
            return this;
        }

        public final void setFunctionAssociations(FunctionAssociations.BuilderImpl functionAssociations) {
            this.functionAssociations = functionAssociations != null ? functionAssociations.build() : null;
        }

        public final String getFieldLevelEncryptionId() {
            return this.fieldLevelEncryptionId;
        }

        @Override
        public final Builder fieldLevelEncryptionId(String fieldLevelEncryptionId) {
            this.fieldLevelEncryptionId = fieldLevelEncryptionId;
            return this;
        }

        public final void setFieldLevelEncryptionId(String fieldLevelEncryptionId) {
            this.fieldLevelEncryptionId = fieldLevelEncryptionId;
        }

        public final String getRealtimeLogConfigArn() {
            return this.realtimeLogConfigArn;
        }

        @Override
        public final Builder realtimeLogConfigArn(String realtimeLogConfigArn) {
            this.realtimeLogConfigArn = realtimeLogConfigArn;
            return this;
        }

        public final void setRealtimeLogConfigArn(String realtimeLogConfigArn) {
            this.realtimeLogConfigArn = realtimeLogConfigArn;
        }

        public final String getCachePolicyId() {
            return this.cachePolicyId;
        }

        @Override
        public final Builder cachePolicyId(String cachePolicyId) {
            this.cachePolicyId = cachePolicyId;
            return this;
        }

        public final void setCachePolicyId(String cachePolicyId) {
            this.cachePolicyId = cachePolicyId;
        }

        public final String getOriginRequestPolicyId() {
            return this.originRequestPolicyId;
        }

        @Override
        public final Builder originRequestPolicyId(String originRequestPolicyId) {
            this.originRequestPolicyId = originRequestPolicyId;
            return this;
        }

        public final void setOriginRequestPolicyId(String originRequestPolicyId) {
            this.originRequestPolicyId = originRequestPolicyId;
        }

        @Deprecated
        public final ForwardedValues.Builder getForwardedValues() {
            return this.forwardedValues != null ? this.forwardedValues.toBuilder() : null;
        }

        @Override
        @Deprecated
        public final Builder forwardedValues(ForwardedValues forwardedValues) {
            this.forwardedValues = forwardedValues;
            return this;
        }

        @Deprecated
        public final void setForwardedValues(ForwardedValues.BuilderImpl forwardedValues) {
            this.forwardedValues = forwardedValues != null ? forwardedValues.build() : null;
        }

        @Deprecated
        public final Long getMinTTL() {
            return this.minTTL;
        }

        @Override
        @Deprecated
        public final Builder minTTL(Long minTTL) {
            this.minTTL = minTTL;
            return this;
        }

        @Deprecated
        public final void setMinTTL(Long minTTL) {
            this.minTTL = minTTL;
        }

        @Deprecated
        public final Long getDefaultTTL() {
            return this.defaultTTL;
        }

        @Override
        @Deprecated
        public final Builder defaultTTL(Long defaultTTL) {
            this.defaultTTL = defaultTTL;
            return this;
        }

        @Deprecated
        public final void setDefaultTTL(Long defaultTTL) {
            this.defaultTTL = defaultTTL;
        }

        @Deprecated
        public final Long getMaxTTL() {
            return this.maxTTL;
        }

        @Override
        @Deprecated
        public final Builder maxTTL(Long maxTTL) {
            this.maxTTL = maxTTL;
            return this;
        }

        @Deprecated
        public final void setMaxTTL(Long maxTTL) {
            this.maxTTL = maxTTL;
        }

        public DefaultCacheBehavior build() {
            return new DefaultCacheBehavior(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DefaultCacheBehavior> {
        public Builder targetOriginId(String var1);

        public Builder trustedSigners(TrustedSigners var1);

        default public Builder trustedSigners(Consumer<TrustedSigners.Builder> trustedSigners) {
            return this.trustedSigners((TrustedSigners)((TrustedSigners.Builder)TrustedSigners.builder().applyMutation(trustedSigners)).build());
        }

        public Builder trustedKeyGroups(TrustedKeyGroups var1);

        default public Builder trustedKeyGroups(Consumer<TrustedKeyGroups.Builder> trustedKeyGroups) {
            return this.trustedKeyGroups((TrustedKeyGroups)((TrustedKeyGroups.Builder)TrustedKeyGroups.builder().applyMutation(trustedKeyGroups)).build());
        }

        public Builder viewerProtocolPolicy(String var1);

        public Builder viewerProtocolPolicy(ViewerProtocolPolicy var1);

        public Builder allowedMethods(AllowedMethods var1);

        default public Builder allowedMethods(Consumer<AllowedMethods.Builder> allowedMethods) {
            return this.allowedMethods((AllowedMethods)((AllowedMethods.Builder)AllowedMethods.builder().applyMutation(allowedMethods)).build());
        }

        public Builder smoothStreaming(Boolean var1);

        public Builder compress(Boolean var1);

        public Builder lambdaFunctionAssociations(LambdaFunctionAssociations var1);

        default public Builder lambdaFunctionAssociations(Consumer<LambdaFunctionAssociations.Builder> lambdaFunctionAssociations) {
            return this.lambdaFunctionAssociations((LambdaFunctionAssociations)((LambdaFunctionAssociations.Builder)LambdaFunctionAssociations.builder().applyMutation(lambdaFunctionAssociations)).build());
        }

        public Builder functionAssociations(FunctionAssociations var1);

        default public Builder functionAssociations(Consumer<FunctionAssociations.Builder> functionAssociations) {
            return this.functionAssociations((FunctionAssociations)((FunctionAssociations.Builder)FunctionAssociations.builder().applyMutation(functionAssociations)).build());
        }

        public Builder fieldLevelEncryptionId(String var1);

        public Builder realtimeLogConfigArn(String var1);

        public Builder cachePolicyId(String var1);

        public Builder originRequestPolicyId(String var1);

        @Deprecated
        public Builder forwardedValues(ForwardedValues var1);

        @Deprecated
        default public Builder forwardedValues(Consumer<ForwardedValues.Builder> forwardedValues) {
            return this.forwardedValues((ForwardedValues)((ForwardedValues.Builder)ForwardedValues.builder().applyMutation(forwardedValues)).build());
        }

        @Deprecated
        public Builder minTTL(Long var1);

        @Deprecated
        public Builder defaultTTL(Long var1);

        @Deprecated
        public Builder maxTTL(Long var1);
    }
}

