/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains an origin request policy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OriginRequestPolicySummary implements SdkPojo, Serializable,
        ToCopyableBuilder<OriginRequestPolicySummary.Builder, OriginRequestPolicySummary> {
    private static final SdkField<String> TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Type")
            .getter(getter(OriginRequestPolicySummary::typeAsString))
            .setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type")
                    .unmarshallLocationName("Type").build()).build();

    private static final SdkField<OriginRequestPolicy> ORIGIN_REQUEST_POLICY_FIELD = SdkField
            .<OriginRequestPolicy> builder(MarshallingType.SDK_POJO)
            .memberName("OriginRequestPolicy")
            .getter(getter(OriginRequestPolicySummary::originRequestPolicy))
            .setter(setter(Builder::originRequestPolicy))
            .constructor(OriginRequestPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginRequestPolicy")
                    .unmarshallLocationName("OriginRequestPolicy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD,
            ORIGIN_REQUEST_POLICY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private final OriginRequestPolicy originRequestPolicy;

    private OriginRequestPolicySummary(BuilderImpl builder) {
        this.type = builder.type;
        this.originRequestPolicy = builder.originRequestPolicy;
    }

    /**
     * <p>
     * The type of origin request policy, either <code>managed</code> (created by Amazon Web Services) or
     * <code>custom</code> (created in this Amazon Web Services account).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link OriginRequestPolicyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of origin request policy, either <code>managed</code> (created by Amazon Web Services) or
     *         <code>custom</code> (created in this Amazon Web Services account).
     * @see OriginRequestPolicyType
     */
    public final OriginRequestPolicyType type() {
        return OriginRequestPolicyType.fromValue(type);
    }

    /**
     * <p>
     * The type of origin request policy, either <code>managed</code> (created by Amazon Web Services) or
     * <code>custom</code> (created in this Amazon Web Services account).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link OriginRequestPolicyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of origin request policy, either <code>managed</code> (created by Amazon Web Services) or
     *         <code>custom</code> (created in this Amazon Web Services account).
     * @see OriginRequestPolicyType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The origin request policy.
     * </p>
     * 
     * @return The origin request policy.
     */
    public final OriginRequestPolicy originRequestPolicy() {
        return originRequestPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(originRequestPolicy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OriginRequestPolicySummary)) {
            return false;
        }
        OriginRequestPolicySummary other = (OriginRequestPolicySummary) obj;
        return Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(originRequestPolicy(), other.originRequestPolicy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OriginRequestPolicySummary").add("Type", typeAsString())
                .add("OriginRequestPolicy", originRequestPolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "OriginRequestPolicy":
            return Optional.ofNullable(clazz.cast(originRequestPolicy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OriginRequestPolicySummary, T> g) {
        return obj -> g.apply((OriginRequestPolicySummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OriginRequestPolicySummary> {
        /**
         * <p>
         * The type of origin request policy, either <code>managed</code> (created by Amazon Web Services) or
         * <code>custom</code> (created in this Amazon Web Services account).
         * </p>
         * 
         * @param type
         *        The type of origin request policy, either <code>managed</code> (created by Amazon Web Services) or
         *        <code>custom</code> (created in this Amazon Web Services account).
         * @see OriginRequestPolicyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OriginRequestPolicyType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of origin request policy, either <code>managed</code> (created by Amazon Web Services) or
         * <code>custom</code> (created in this Amazon Web Services account).
         * </p>
         * 
         * @param type
         *        The type of origin request policy, either <code>managed</code> (created by Amazon Web Services) or
         *        <code>custom</code> (created in this Amazon Web Services account).
         * @see OriginRequestPolicyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OriginRequestPolicyType
         */
        Builder type(OriginRequestPolicyType type);

        /**
         * <p>
         * The origin request policy.
         * </p>
         * 
         * @param originRequestPolicy
         *        The origin request policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originRequestPolicy(OriginRequestPolicy originRequestPolicy);

        /**
         * <p>
         * The origin request policy.
         * </p>
         * This is a convenience that creates an instance of the {@link OriginRequestPolicy.Builder} avoiding the need
         * to create one manually via {@link OriginRequestPolicy#builder()}.
         *
         * When the {@link Consumer} completes, {@link OriginRequestPolicy.Builder#build()} is called immediately and
         * its result is passed to {@link #originRequestPolicy(OriginRequestPolicy)}.
         * 
         * @param originRequestPolicy
         *        a consumer that will call methods on {@link OriginRequestPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #originRequestPolicy(OriginRequestPolicy)
         */
        default Builder originRequestPolicy(Consumer<OriginRequestPolicy.Builder> originRequestPolicy) {
            return originRequestPolicy(OriginRequestPolicy.builder().applyMutation(originRequestPolicy).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private OriginRequestPolicy originRequestPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(OriginRequestPolicySummary model) {
            type(model.type);
            originRequestPolicy(model.originRequestPolicy);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        @Transient
        public final Builder type(OriginRequestPolicyType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final OriginRequestPolicy.Builder getOriginRequestPolicy() {
            return originRequestPolicy != null ? originRequestPolicy.toBuilder() : null;
        }

        public final void setOriginRequestPolicy(OriginRequestPolicy.BuilderImpl originRequestPolicy) {
            this.originRequestPolicy = originRequestPolicy != null ? originRequestPolicy.build() : null;
        }

        @Override
        @Transient
        public final Builder originRequestPolicy(OriginRequestPolicy originRequestPolicy) {
            this.originRequestPolicy = originRequestPolicy;
            return this;
        }

        @Override
        public OriginRequestPolicySummary build() {
            return new OriginRequestPolicySummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
