/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontResponse;
import software.amazon.awssdk.services.cloudfront.model.FunctionSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateFunctionResponse
extends CloudFrontResponse
implements ToCopyableBuilder<Builder, UpdateFunctionResponse> {
    private static final SdkField<FunctionSummary> FUNCTION_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FunctionSummary").getter(UpdateFunctionResponse.getter(UpdateFunctionResponse::functionSummary)).setter(UpdateFunctionResponse.setter(Builder::functionSummary)).constructor(FunctionSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionSummary").unmarshallLocationName("FunctionSummary").build(), PayloadTrait.create()}).build();
    private static final SdkField<String> E_TAG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ETag").getter(UpdateFunctionResponse.getter(UpdateFunctionResponse::eTag)).setter(UpdateFunctionResponse.setter(Builder::eTag)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("ETtag").unmarshallLocationName("ETtag").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FUNCTION_SUMMARY_FIELD, E_TAG_FIELD));
    private final FunctionSummary functionSummary;
    private final String eTag;

    private UpdateFunctionResponse(BuilderImpl builder) {
        super(builder);
        this.functionSummary = builder.functionSummary;
        this.eTag = builder.eTag;
    }

    public final FunctionSummary functionSummary() {
        return this.functionSummary;
    }

    public final String eTag() {
        return this.eTag;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.functionSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.eTag());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFunctionResponse)) {
            return false;
        }
        UpdateFunctionResponse other = (UpdateFunctionResponse)((Object)obj);
        return Objects.equals(this.functionSummary(), other.functionSummary()) && Objects.equals(this.eTag(), other.eTag());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateFunctionResponse").add("FunctionSummary", (Object)this.functionSummary()).add("ETag", (Object)this.eTag()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FunctionSummary": {
                return Optional.ofNullable(clazz.cast(this.functionSummary()));
            }
            case "ETag": {
                return Optional.ofNullable(clazz.cast(this.eTag()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateFunctionResponse, T> g) {
        return obj -> g.apply((UpdateFunctionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFrontResponse.BuilderImpl
    implements Builder {
        private FunctionSummary functionSummary;
        private String eTag;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFunctionResponse model) {
            super(model);
            this.functionSummary(model.functionSummary);
            this.eTag(model.eTag);
        }

        public final FunctionSummary.Builder getFunctionSummary() {
            return this.functionSummary != null ? this.functionSummary.toBuilder() : null;
        }

        @Override
        public final Builder functionSummary(FunctionSummary functionSummary) {
            this.functionSummary = functionSummary;
            return this;
        }

        public final void setFunctionSummary(FunctionSummary.BuilderImpl functionSummary) {
            this.functionSummary = functionSummary != null ? functionSummary.build() : null;
        }

        public final String getETag() {
            return this.eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        public UpdateFunctionResponse build() {
            return new UpdateFunctionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudFrontResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateFunctionResponse> {
        public Builder functionSummary(FunctionSummary var1);

        default public Builder functionSummary(Consumer<FunctionSummary.Builder> functionSummary) {
            return this.functionSummary((FunctionSummary)((FunctionSummary.Builder)FunctionSummary.builder().applyMutation(functionSummary)).build());
        }

        public Builder eTag(String var1);
    }
}

