/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.CachePolicyCookiesConfig;
import software.amazon.awssdk.services.cloudfront.model.CachePolicyHeadersConfig;
import software.amazon.awssdk.services.cloudfront.model.CachePolicyQueryStringsConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ParametersInCacheKeyAndForwardedToOrigin
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ParametersInCacheKeyAndForwardedToOrigin> {
    private static final SdkField<Boolean> ENABLE_ACCEPT_ENCODING_GZIP_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableAcceptEncodingGzip").getter(ParametersInCacheKeyAndForwardedToOrigin.getter(ParametersInCacheKeyAndForwardedToOrigin::enableAcceptEncodingGzip)).setter(ParametersInCacheKeyAndForwardedToOrigin.setter(Builder::enableAcceptEncodingGzip)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableAcceptEncodingGzip").unmarshallLocationName("EnableAcceptEncodingGzip").build()}).build();
    private static final SdkField<Boolean> ENABLE_ACCEPT_ENCODING_BROTLI_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableAcceptEncodingBrotli").getter(ParametersInCacheKeyAndForwardedToOrigin.getter(ParametersInCacheKeyAndForwardedToOrigin::enableAcceptEncodingBrotli)).setter(ParametersInCacheKeyAndForwardedToOrigin.setter(Builder::enableAcceptEncodingBrotli)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableAcceptEncodingBrotli").unmarshallLocationName("EnableAcceptEncodingBrotli").build()}).build();
    private static final SdkField<CachePolicyHeadersConfig> HEADERS_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HeadersConfig").getter(ParametersInCacheKeyAndForwardedToOrigin.getter(ParametersInCacheKeyAndForwardedToOrigin::headersConfig)).setter(ParametersInCacheKeyAndForwardedToOrigin.setter(Builder::headersConfig)).constructor(CachePolicyHeadersConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HeadersConfig").unmarshallLocationName("HeadersConfig").build()}).build();
    private static final SdkField<CachePolicyCookiesConfig> COOKIES_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CookiesConfig").getter(ParametersInCacheKeyAndForwardedToOrigin.getter(ParametersInCacheKeyAndForwardedToOrigin::cookiesConfig)).setter(ParametersInCacheKeyAndForwardedToOrigin.setter(Builder::cookiesConfig)).constructor(CachePolicyCookiesConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CookiesConfig").unmarshallLocationName("CookiesConfig").build()}).build();
    private static final SdkField<CachePolicyQueryStringsConfig> QUERY_STRINGS_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("QueryStringsConfig").getter(ParametersInCacheKeyAndForwardedToOrigin.getter(ParametersInCacheKeyAndForwardedToOrigin::queryStringsConfig)).setter(ParametersInCacheKeyAndForwardedToOrigin.setter(Builder::queryStringsConfig)).constructor(CachePolicyQueryStringsConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryStringsConfig").unmarshallLocationName("QueryStringsConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLE_ACCEPT_ENCODING_GZIP_FIELD, ENABLE_ACCEPT_ENCODING_BROTLI_FIELD, HEADERS_CONFIG_FIELD, COOKIES_CONFIG_FIELD, QUERY_STRINGS_CONFIG_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean enableAcceptEncodingGzip;
    private final Boolean enableAcceptEncodingBrotli;
    private final CachePolicyHeadersConfig headersConfig;
    private final CachePolicyCookiesConfig cookiesConfig;
    private final CachePolicyQueryStringsConfig queryStringsConfig;

    private ParametersInCacheKeyAndForwardedToOrigin(BuilderImpl builder) {
        this.enableAcceptEncodingGzip = builder.enableAcceptEncodingGzip;
        this.enableAcceptEncodingBrotli = builder.enableAcceptEncodingBrotli;
        this.headersConfig = builder.headersConfig;
        this.cookiesConfig = builder.cookiesConfig;
        this.queryStringsConfig = builder.queryStringsConfig;
    }

    public final Boolean enableAcceptEncodingGzip() {
        return this.enableAcceptEncodingGzip;
    }

    public final Boolean enableAcceptEncodingBrotli() {
        return this.enableAcceptEncodingBrotli;
    }

    public final CachePolicyHeadersConfig headersConfig() {
        return this.headersConfig;
    }

    public final CachePolicyCookiesConfig cookiesConfig() {
        return this.cookiesConfig;
    }

    public final CachePolicyQueryStringsConfig queryStringsConfig() {
        return this.queryStringsConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.enableAcceptEncodingGzip());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableAcceptEncodingBrotli());
        hashCode = 31 * hashCode + Objects.hashCode(this.headersConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.cookiesConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryStringsConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParametersInCacheKeyAndForwardedToOrigin)) {
            return false;
        }
        ParametersInCacheKeyAndForwardedToOrigin other = (ParametersInCacheKeyAndForwardedToOrigin)obj;
        return Objects.equals(this.enableAcceptEncodingGzip(), other.enableAcceptEncodingGzip()) && Objects.equals(this.enableAcceptEncodingBrotli(), other.enableAcceptEncodingBrotli()) && Objects.equals(this.headersConfig(), other.headersConfig()) && Objects.equals(this.cookiesConfig(), other.cookiesConfig()) && Objects.equals(this.queryStringsConfig(), other.queryStringsConfig());
    }

    public final String toString() {
        return ToString.builder((String)"ParametersInCacheKeyAndForwardedToOrigin").add("EnableAcceptEncodingGzip", (Object)this.enableAcceptEncodingGzip()).add("EnableAcceptEncodingBrotli", (Object)this.enableAcceptEncodingBrotli()).add("HeadersConfig", (Object)this.headersConfig()).add("CookiesConfig", (Object)this.cookiesConfig()).add("QueryStringsConfig", (Object)this.queryStringsConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EnableAcceptEncodingGzip": {
                return Optional.ofNullable(clazz.cast(this.enableAcceptEncodingGzip()));
            }
            case "EnableAcceptEncodingBrotli": {
                return Optional.ofNullable(clazz.cast(this.enableAcceptEncodingBrotli()));
            }
            case "HeadersConfig": {
                return Optional.ofNullable(clazz.cast(this.headersConfig()));
            }
            case "CookiesConfig": {
                return Optional.ofNullable(clazz.cast(this.cookiesConfig()));
            }
            case "QueryStringsConfig": {
                return Optional.ofNullable(clazz.cast(this.queryStringsConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ParametersInCacheKeyAndForwardedToOrigin, T> g) {
        return obj -> g.apply((ParametersInCacheKeyAndForwardedToOrigin)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean enableAcceptEncodingGzip;
        private Boolean enableAcceptEncodingBrotli;
        private CachePolicyHeadersConfig headersConfig;
        private CachePolicyCookiesConfig cookiesConfig;
        private CachePolicyQueryStringsConfig queryStringsConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(ParametersInCacheKeyAndForwardedToOrigin model) {
            this.enableAcceptEncodingGzip(model.enableAcceptEncodingGzip);
            this.enableAcceptEncodingBrotli(model.enableAcceptEncodingBrotli);
            this.headersConfig(model.headersConfig);
            this.cookiesConfig(model.cookiesConfig);
            this.queryStringsConfig(model.queryStringsConfig);
        }

        public final Boolean getEnableAcceptEncodingGzip() {
            return this.enableAcceptEncodingGzip;
        }

        @Override
        public final Builder enableAcceptEncodingGzip(Boolean enableAcceptEncodingGzip) {
            this.enableAcceptEncodingGzip = enableAcceptEncodingGzip;
            return this;
        }

        public final void setEnableAcceptEncodingGzip(Boolean enableAcceptEncodingGzip) {
            this.enableAcceptEncodingGzip = enableAcceptEncodingGzip;
        }

        public final Boolean getEnableAcceptEncodingBrotli() {
            return this.enableAcceptEncodingBrotli;
        }

        @Override
        public final Builder enableAcceptEncodingBrotli(Boolean enableAcceptEncodingBrotli) {
            this.enableAcceptEncodingBrotli = enableAcceptEncodingBrotli;
            return this;
        }

        public final void setEnableAcceptEncodingBrotli(Boolean enableAcceptEncodingBrotli) {
            this.enableAcceptEncodingBrotli = enableAcceptEncodingBrotli;
        }

        public final CachePolicyHeadersConfig.Builder getHeadersConfig() {
            return this.headersConfig != null ? this.headersConfig.toBuilder() : null;
        }

        @Override
        public final Builder headersConfig(CachePolicyHeadersConfig headersConfig) {
            this.headersConfig = headersConfig;
            return this;
        }

        public final void setHeadersConfig(CachePolicyHeadersConfig.BuilderImpl headersConfig) {
            this.headersConfig = headersConfig != null ? headersConfig.build() : null;
        }

        public final CachePolicyCookiesConfig.Builder getCookiesConfig() {
            return this.cookiesConfig != null ? this.cookiesConfig.toBuilder() : null;
        }

        @Override
        public final Builder cookiesConfig(CachePolicyCookiesConfig cookiesConfig) {
            this.cookiesConfig = cookiesConfig;
            return this;
        }

        public final void setCookiesConfig(CachePolicyCookiesConfig.BuilderImpl cookiesConfig) {
            this.cookiesConfig = cookiesConfig != null ? cookiesConfig.build() : null;
        }

        public final CachePolicyQueryStringsConfig.Builder getQueryStringsConfig() {
            return this.queryStringsConfig != null ? this.queryStringsConfig.toBuilder() : null;
        }

        @Override
        public final Builder queryStringsConfig(CachePolicyQueryStringsConfig queryStringsConfig) {
            this.queryStringsConfig = queryStringsConfig;
            return this;
        }

        public final void setQueryStringsConfig(CachePolicyQueryStringsConfig.BuilderImpl queryStringsConfig) {
            this.queryStringsConfig = queryStringsConfig != null ? queryStringsConfig.build() : null;
        }

        public ParametersInCacheKeyAndForwardedToOrigin build() {
            return new ParametersInCacheKeyAndForwardedToOrigin(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ParametersInCacheKeyAndForwardedToOrigin> {
        public Builder enableAcceptEncodingGzip(Boolean var1);

        public Builder enableAcceptEncodingBrotli(Boolean var1);

        public Builder headersConfig(CachePolicyHeadersConfig var1);

        default public Builder headersConfig(Consumer<CachePolicyHeadersConfig.Builder> headersConfig) {
            return this.headersConfig((CachePolicyHeadersConfig)((CachePolicyHeadersConfig.Builder)CachePolicyHeadersConfig.builder().applyMutation(headersConfig)).build());
        }

        public Builder cookiesConfig(CachePolicyCookiesConfig var1);

        default public Builder cookiesConfig(Consumer<CachePolicyCookiesConfig.Builder> cookiesConfig) {
            return this.cookiesConfig((CachePolicyCookiesConfig)((CachePolicyCookiesConfig.Builder)CachePolicyCookiesConfig.builder().applyMutation(cookiesConfig)).build());
        }

        public Builder queryStringsConfig(CachePolicyQueryStringsConfig var1);

        default public Builder queryStringsConfig(Consumer<CachePolicyQueryStringsConfig.Builder> queryStringsConfig) {
            return this.queryStringsConfig((CachePolicyQueryStringsConfig)((CachePolicyQueryStringsConfig.Builder)CachePolicyQueryStringsConfig.builder().applyMutation(queryStringsConfig)).build());
        }
    }
}

