/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.CachePolicy;
import software.amazon.awssdk.services.cloudfront.model.CachePolicyType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CachePolicySummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CachePolicySummary> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(CachePolicySummary.getter(CachePolicySummary::typeAsString)).setter(CachePolicySummary.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").unmarshallLocationName("Type").build()}).build();
    private static final SdkField<CachePolicy> CACHE_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CachePolicy").getter(CachePolicySummary.getter(CachePolicySummary::cachePolicy)).setter(CachePolicySummary.setter(Builder::cachePolicy)).constructor(CachePolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CachePolicy").unmarshallLocationName("CachePolicy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, CACHE_POLICY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String type;
    private final CachePolicy cachePolicy;

    private CachePolicySummary(BuilderImpl builder) {
        this.type = builder.type;
        this.cachePolicy = builder.cachePolicy;
    }

    public final CachePolicyType type() {
        return CachePolicyType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final CachePolicy cachePolicy() {
        return this.cachePolicy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.cachePolicy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CachePolicySummary)) {
            return false;
        }
        CachePolicySummary other = (CachePolicySummary)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.cachePolicy(), other.cachePolicy());
    }

    public final String toString() {
        return ToString.builder((String)"CachePolicySummary").add("Type", (Object)this.typeAsString()).add("CachePolicy", (Object)this.cachePolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "CachePolicy": {
                return Optional.ofNullable(clazz.cast(this.cachePolicy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CachePolicySummary, T> g) {
        return obj -> g.apply((CachePolicySummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private CachePolicy cachePolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(CachePolicySummary model) {
            this.type(model.type);
            this.cachePolicy(model.cachePolicy);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(CachePolicyType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final CachePolicy.Builder getCachePolicy() {
            return this.cachePolicy != null ? this.cachePolicy.toBuilder() : null;
        }

        @Override
        public final Builder cachePolicy(CachePolicy cachePolicy) {
            this.cachePolicy = cachePolicy;
            return this;
        }

        public final void setCachePolicy(CachePolicy.BuilderImpl cachePolicy) {
            this.cachePolicy = cachePolicy != null ? cachePolicy.build() : null;
        }

        public CachePolicySummary build() {
            return new CachePolicySummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CachePolicySummary> {
        public Builder type(String var1);

        public Builder type(CachePolicyType var1);

        public Builder cachePolicy(CachePolicy var1);

        default public Builder cachePolicy(Consumer<CachePolicy.Builder> cachePolicy) {
            return this.cachePolicy((CachePolicy)((CachePolicy.Builder)CachePolicy.builder().applyMutation(cachePolicy)).build());
        }
    }
}

