/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontResponse;
import software.amazon.awssdk.services.cloudfront.model.Invalidation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetInvalidationResponse
extends CloudFrontResponse
implements ToCopyableBuilder<Builder, GetInvalidationResponse> {
    private static final SdkField<Invalidation> INVALIDATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Invalidation").getter(GetInvalidationResponse.getter(GetInvalidationResponse::invalidation)).setter(GetInvalidationResponse.setter(Builder::invalidation)).constructor(Invalidation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Invalidation").unmarshallLocationName("Invalidation").build(), PayloadTrait.create()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INVALIDATION_FIELD));
    private final Invalidation invalidation;

    private GetInvalidationResponse(BuilderImpl builder) {
        super(builder);
        this.invalidation = builder.invalidation;
    }

    public final Invalidation invalidation() {
        return this.invalidation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.invalidation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInvalidationResponse)) {
            return false;
        }
        GetInvalidationResponse other = (GetInvalidationResponse)((Object)obj);
        return Objects.equals(this.invalidation(), other.invalidation());
    }

    public final String toString() {
        return ToString.builder((String)"GetInvalidationResponse").add("Invalidation", (Object)this.invalidation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Invalidation": {
                return Optional.ofNullable(clazz.cast(this.invalidation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetInvalidationResponse, T> g) {
        return obj -> g.apply((GetInvalidationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFrontResponse.BuilderImpl
    implements Builder {
        private Invalidation invalidation;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInvalidationResponse model) {
            super(model);
            this.invalidation(model.invalidation);
        }

        public final Invalidation.Builder getInvalidation() {
            return this.invalidation != null ? this.invalidation.toBuilder() : null;
        }

        @Override
        public final Builder invalidation(Invalidation invalidation) {
            this.invalidation = invalidation;
            return this;
        }

        public final void setInvalidation(Invalidation.BuilderImpl invalidation) {
            this.invalidation = invalidation != null ? invalidation.build() : null;
        }

        @Override
        public GetInvalidationResponse build() {
            return new GetInvalidationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudFrontResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetInvalidationResponse> {
        public Builder invalidation(Invalidation var1);

        default public Builder invalidation(Consumer<Invalidation.Builder> invalidation) {
            return this.invalidation((Invalidation)((Invalidation.Builder)Invalidation.builder().applyMutation(invalidation)).build());
        }
    }
}

