/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of real-time log configurations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RealtimeLogConfigs implements SdkPojo, Serializable,
        ToCopyableBuilder<RealtimeLogConfigs.Builder, RealtimeLogConfigs> {
    private static final SdkField<Integer> MAX_ITEMS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxItems")
            .getter(getter(RealtimeLogConfigs::maxItems))
            .setter(setter(Builder::maxItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxItems")
                    .unmarshallLocationName("MaxItems").build()).build();

    private static final SdkField<List<RealtimeLogConfig>> ITEMS_FIELD = SdkField
            .<List<RealtimeLogConfig>> builder(MarshallingType.LIST)
            .memberName("Items")
            .getter(getter(RealtimeLogConfigs::items))
            .setter(setter(Builder::items))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Items")
                    .unmarshallLocationName("Items").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RealtimeLogConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(RealtimeLogConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").unmarshallLocationName("member").build()).build())
                            .build()).build();

    private static final SdkField<Boolean> IS_TRUNCATED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsTruncated")
            .getter(getter(RealtimeLogConfigs::isTruncated))
            .setter(setter(Builder::isTruncated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsTruncated")
                    .unmarshallLocationName("IsTruncated").build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Marker")
            .getter(getter(RealtimeLogConfigs::marker))
            .setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker")
                    .unmarshallLocationName("Marker").build()).build();

    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextMarker")
            .getter(getter(RealtimeLogConfigs::nextMarker))
            .setter(setter(Builder::nextMarker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker")
                    .unmarshallLocationName("NextMarker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_ITEMS_FIELD, ITEMS_FIELD,
            IS_TRUNCATED_FIELD, MARKER_FIELD, NEXT_MARKER_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer maxItems;

    private final List<RealtimeLogConfig> items;

    private final Boolean isTruncated;

    private final String marker;

    private final String nextMarker;

    private RealtimeLogConfigs(BuilderImpl builder) {
        this.maxItems = builder.maxItems;
        this.items = builder.items;
        this.isTruncated = builder.isTruncated;
        this.marker = builder.marker;
        this.nextMarker = builder.nextMarker;
    }

    /**
     * <p>
     * The maximum number of real-time log configurations requested.
     * </p>
     * 
     * @return The maximum number of real-time log configurations requested.
     */
    public final Integer maxItems() {
        return maxItems;
    }

    /**
     * Returns true if the Items property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasItems() {
        return items != null && !(items instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains the list of real-time log configurations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasItems()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Contains the list of real-time log configurations.
     */
    public final List<RealtimeLogConfig> items() {
        return items;
    }

    /**
     * <p>
     * A flag that indicates whether there are more real-time log configurations than are contained in this list.
     * </p>
     * 
     * @return A flag that indicates whether there are more real-time log configurations than are contained in this
     *         list.
     */
    public final Boolean isTruncated() {
        return isTruncated;
    }

    /**
     * <p>
     * This parameter indicates where this list of real-time log configurations begins. This list includes real-time log
     * configurations that occur after the marker.
     * </p>
     * 
     * @return This parameter indicates where this list of real-time log configurations begins. This list includes
     *         real-time log configurations that occur after the marker.
     */
    public final String marker() {
        return marker;
    }

    /**
     * <p>
     * If there are more items in the list than are in this response, this element is present. It contains the value
     * that you should use in the <code>Marker</code> field of a subsequent request to continue listing real-time log
     * configurations where you left off.
     * </p>
     * 
     * @return If there are more items in the list than are in this response, this element is present. It contains the
     *         value that you should use in the <code>Marker</code> field of a subsequent request to continue listing
     *         real-time log configurations where you left off.
     */
    public final String nextMarker() {
        return nextMarker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maxItems());
        hashCode = 31 * hashCode + Objects.hashCode(hasItems() ? items() : null);
        hashCode = 31 * hashCode + Objects.hashCode(isTruncated());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(nextMarker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RealtimeLogConfigs)) {
            return false;
        }
        RealtimeLogConfigs other = (RealtimeLogConfigs) obj;
        return Objects.equals(maxItems(), other.maxItems()) && hasItems() == other.hasItems()
                && Objects.equals(items(), other.items()) && Objects.equals(isTruncated(), other.isTruncated())
                && Objects.equals(marker(), other.marker()) && Objects.equals(nextMarker(), other.nextMarker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RealtimeLogConfigs").add("MaxItems", maxItems()).add("Items", hasItems() ? items() : null)
                .add("IsTruncated", isTruncated()).add("Marker", marker()).add("NextMarker", nextMarker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaxItems":
            return Optional.ofNullable(clazz.cast(maxItems()));
        case "Items":
            return Optional.ofNullable(clazz.cast(items()));
        case "IsTruncated":
            return Optional.ofNullable(clazz.cast(isTruncated()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "NextMarker":
            return Optional.ofNullable(clazz.cast(nextMarker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RealtimeLogConfigs, T> g) {
        return obj -> g.apply((RealtimeLogConfigs) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RealtimeLogConfigs> {
        /**
         * <p>
         * The maximum number of real-time log configurations requested.
         * </p>
         * 
         * @param maxItems
         *        The maximum number of real-time log configurations requested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(Integer maxItems);

        /**
         * <p>
         * Contains the list of real-time log configurations.
         * </p>
         * 
         * @param items
         *        Contains the list of real-time log configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(Collection<RealtimeLogConfig> items);

        /**
         * <p>
         * Contains the list of real-time log configurations.
         * </p>
         * 
         * @param items
         *        Contains the list of real-time log configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(RealtimeLogConfig... items);

        /**
         * <p>
         * Contains the list of real-time log configurations.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RealtimeLogConfig>.Builder} avoiding the
         * need to create one manually via {@link List<RealtimeLogConfig>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RealtimeLogConfig>.Builder#build()} is called immediately
         * and its result is passed to {@link #items(List<RealtimeLogConfig>)}.
         * 
         * @param items
         *        a consumer that will call methods on {@link List<RealtimeLogConfig>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #items(List<RealtimeLogConfig>)
         */
        Builder items(Consumer<RealtimeLogConfig.Builder>... items);

        /**
         * <p>
         * A flag that indicates whether there are more real-time log configurations than are contained in this list.
         * </p>
         * 
         * @param isTruncated
         *        A flag that indicates whether there are more real-time log configurations than are contained in this
         *        list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isTruncated(Boolean isTruncated);

        /**
         * <p>
         * This parameter indicates where this list of real-time log configurations begins. This list includes real-time
         * log configurations that occur after the marker.
         * </p>
         * 
         * @param marker
         *        This parameter indicates where this list of real-time log configurations begins. This list includes
         *        real-time log configurations that occur after the marker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * If there are more items in the list than are in this response, this element is present. It contains the value
         * that you should use in the <code>Marker</code> field of a subsequent request to continue listing real-time
         * log configurations where you left off.
         * </p>
         * 
         * @param nextMarker
         *        If there are more items in the list than are in this response, this element is present. It contains
         *        the value that you should use in the <code>Marker</code> field of a subsequent request to continue
         *        listing real-time log configurations where you left off.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextMarker(String nextMarker);
    }

    static final class BuilderImpl implements Builder {
        private Integer maxItems;

        private List<RealtimeLogConfig> items = DefaultSdkAutoConstructList.getInstance();

        private Boolean isTruncated;

        private String marker;

        private String nextMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(RealtimeLogConfigs model) {
            maxItems(model.maxItems);
            items(model.items);
            isTruncated(model.isTruncated);
            marker(model.marker);
            nextMarker(model.nextMarker);
        }

        public final Integer getMaxItems() {
            return maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        public final Collection<RealtimeLogConfig.Builder> getItems() {
            if (items instanceof SdkAutoConstructList) {
                return null;
            }
            return items != null ? items.stream().map(RealtimeLogConfig::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder items(Collection<RealtimeLogConfig> items) {
            this.items = RealtimeLogConfigListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(RealtimeLogConfig... items) {
            items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<RealtimeLogConfig.Builder>... items) {
            items(Stream.of(items).map(c -> RealtimeLogConfig.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setItems(Collection<RealtimeLogConfig.BuilderImpl> items) {
            this.items = RealtimeLogConfigListCopier.copyFromBuilder(items);
        }

        public final Boolean getIsTruncated() {
            return isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final String getNextMarker() {
            return nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public RealtimeLogConfigs build() {
            return new RealtimeLogConfigs(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
