/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCachePoliciesResponse extends CloudFrontResponse implements
        ToCopyableBuilder<ListCachePoliciesResponse.Builder, ListCachePoliciesResponse> {
    private static final SdkField<CachePolicyList> CACHE_POLICY_LIST_FIELD = SdkField
            .<CachePolicyList> builder(MarshallingType.SDK_POJO)
            .memberName("CachePolicyList")
            .getter(getter(ListCachePoliciesResponse::cachePolicyList))
            .setter(setter(Builder::cachePolicyList))
            .constructor(CachePolicyList::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CachePolicyList")
                    .unmarshallLocationName("CachePolicyList").build(), PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CACHE_POLICY_LIST_FIELD));

    private final CachePolicyList cachePolicyList;

    private ListCachePoliciesResponse(BuilderImpl builder) {
        super(builder);
        this.cachePolicyList = builder.cachePolicyList;
    }

    /**
     * <p>
     * A list of cache policies.
     * </p>
     * 
     * @return A list of cache policies.
     */
    public final CachePolicyList cachePolicyList() {
        return cachePolicyList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(cachePolicyList());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCachePoliciesResponse)) {
            return false;
        }
        ListCachePoliciesResponse other = (ListCachePoliciesResponse) obj;
        return Objects.equals(cachePolicyList(), other.cachePolicyList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListCachePoliciesResponse").add("CachePolicyList", cachePolicyList()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CachePolicyList":
            return Optional.ofNullable(clazz.cast(cachePolicyList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCachePoliciesResponse, T> g) {
        return obj -> g.apply((ListCachePoliciesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFrontResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListCachePoliciesResponse> {
        /**
         * <p>
         * A list of cache policies.
         * </p>
         * 
         * @param cachePolicyList
         *        A list of cache policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cachePolicyList(CachePolicyList cachePolicyList);

        /**
         * <p>
         * A list of cache policies.
         * </p>
         * This is a convenience that creates an instance of the {@link CachePolicyList.Builder} avoiding the need to
         * create one manually via {@link CachePolicyList#builder()}.
         *
         * When the {@link Consumer} completes, {@link CachePolicyList.Builder#build()} is called immediately and its
         * result is passed to {@link #cachePolicyList(CachePolicyList)}.
         * 
         * @param cachePolicyList
         *        a consumer that will call methods on {@link CachePolicyList.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cachePolicyList(CachePolicyList)
         */
        default Builder cachePolicyList(Consumer<CachePolicyList.Builder> cachePolicyList) {
            return cachePolicyList(CachePolicyList.builder().applyMutation(cachePolicyList).build());
        }
    }

    static final class BuilderImpl extends CloudFrontResponse.BuilderImpl implements Builder {
        private CachePolicyList cachePolicyList;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCachePoliciesResponse model) {
            super(model);
            cachePolicyList(model.cachePolicyList);
        }

        public final CachePolicyList.Builder getCachePolicyList() {
            return cachePolicyList != null ? cachePolicyList.toBuilder() : null;
        }

        @Override
        public final Builder cachePolicyList(CachePolicyList cachePolicyList) {
            this.cachePolicyList = cachePolicyList;
            return this;
        }

        public final void setCachePolicyList(CachePolicyList.BuilderImpl cachePolicyList) {
            this.cachePolicyList = cachePolicyList != null ? cachePolicyList.build() : null;
        }

        @Override
        public ListCachePoliciesResponse build() {
            return new ListCachePoliciesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
