/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the Amazon Kinesis data stream where you are sending real-time log data in a real-time log
 * configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EndPoint implements SdkPojo, Serializable, ToCopyableBuilder<EndPoint.Builder, EndPoint> {
    private static final SdkField<String> STREAM_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("StreamType")
            .getter(getter(EndPoint::streamType))
            .setter(setter(Builder::streamType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamType")
                    .unmarshallLocationName("StreamType").build()).build();

    private static final SdkField<KinesisStreamConfig> KINESIS_STREAM_CONFIG_FIELD = SdkField
            .<KinesisStreamConfig> builder(MarshallingType.SDK_POJO)
            .memberName("KinesisStreamConfig")
            .getter(getter(EndPoint::kinesisStreamConfig))
            .setter(setter(Builder::kinesisStreamConfig))
            .constructor(KinesisStreamConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KinesisStreamConfig")
                    .unmarshallLocationName("KinesisStreamConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_TYPE_FIELD,
            KINESIS_STREAM_CONFIG_FIELD));

    private static final long serialVersionUID = 1L;

    private final String streamType;

    private final KinesisStreamConfig kinesisStreamConfig;

    private EndPoint(BuilderImpl builder) {
        this.streamType = builder.streamType;
        this.kinesisStreamConfig = builder.kinesisStreamConfig;
    }

    /**
     * <p>
     * The type of data stream where you are sending real-time log data. The only valid value is <code>Kinesis</code>.
     * </p>
     * 
     * @return The type of data stream where you are sending real-time log data. The only valid value is
     *         <code>Kinesis</code>.
     */
    public final String streamType() {
        return streamType;
    }

    /**
     * <p>
     * Contains information about the Amazon Kinesis data stream where you are sending real-time log data.
     * </p>
     * 
     * @return Contains information about the Amazon Kinesis data stream where you are sending real-time log data.
     */
    public final KinesisStreamConfig kinesisStreamConfig() {
        return kinesisStreamConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(streamType());
        hashCode = 31 * hashCode + Objects.hashCode(kinesisStreamConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EndPoint)) {
            return false;
        }
        EndPoint other = (EndPoint) obj;
        return Objects.equals(streamType(), other.streamType())
                && Objects.equals(kinesisStreamConfig(), other.kinesisStreamConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EndPoint").add("StreamType", streamType()).add("KinesisStreamConfig", kinesisStreamConfig())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StreamType":
            return Optional.ofNullable(clazz.cast(streamType()));
        case "KinesisStreamConfig":
            return Optional.ofNullable(clazz.cast(kinesisStreamConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EndPoint, T> g) {
        return obj -> g.apply((EndPoint) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EndPoint> {
        /**
         * <p>
         * The type of data stream where you are sending real-time log data. The only valid value is
         * <code>Kinesis</code>.
         * </p>
         * 
         * @param streamType
         *        The type of data stream where you are sending real-time log data. The only valid value is
         *        <code>Kinesis</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamType(String streamType);

        /**
         * <p>
         * Contains information about the Amazon Kinesis data stream where you are sending real-time log data.
         * </p>
         * 
         * @param kinesisStreamConfig
         *        Contains information about the Amazon Kinesis data stream where you are sending real-time log data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kinesisStreamConfig(KinesisStreamConfig kinesisStreamConfig);

        /**
         * <p>
         * Contains information about the Amazon Kinesis data stream where you are sending real-time log data.
         * </p>
         * This is a convenience that creates an instance of the {@link KinesisStreamConfig.Builder} avoiding the need
         * to create one manually via {@link KinesisStreamConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link KinesisStreamConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #kinesisStreamConfig(KinesisStreamConfig)}.
         * 
         * @param kinesisStreamConfig
         *        a consumer that will call methods on {@link KinesisStreamConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kinesisStreamConfig(KinesisStreamConfig)
         */
        default Builder kinesisStreamConfig(Consumer<KinesisStreamConfig.Builder> kinesisStreamConfig) {
            return kinesisStreamConfig(KinesisStreamConfig.builder().applyMutation(kinesisStreamConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String streamType;

        private KinesisStreamConfig kinesisStreamConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(EndPoint model) {
            streamType(model.streamType);
            kinesisStreamConfig(model.kinesisStreamConfig);
        }

        public final String getStreamType() {
            return streamType;
        }

        @Override
        public final Builder streamType(String streamType) {
            this.streamType = streamType;
            return this;
        }

        public final void setStreamType(String streamType) {
            this.streamType = streamType;
        }

        public final KinesisStreamConfig.Builder getKinesisStreamConfig() {
            return kinesisStreamConfig != null ? kinesisStreamConfig.toBuilder() : null;
        }

        @Override
        public final Builder kinesisStreamConfig(KinesisStreamConfig kinesisStreamConfig) {
            this.kinesisStreamConfig = kinesisStreamConfig;
            return this;
        }

        public final void setKinesisStreamConfig(KinesisStreamConfig.BuilderImpl kinesisStreamConfig) {
            this.kinesisStreamConfig = kinesisStreamConfig != null ? kinesisStreamConfig.build() : null;
        }

        @Override
        public EndPoint build() {
            return new EndPoint(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
