/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A field-level encryption content type profile.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContentTypeProfile implements SdkPojo, Serializable,
        ToCopyableBuilder<ContentTypeProfile.Builder, ContentTypeProfile> {
    private static final SdkField<String> FORMAT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Format")
            .getter(getter(ContentTypeProfile::formatAsString))
            .setter(setter(Builder::format))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Format")
                    .unmarshallLocationName("Format").build()).build();

    private static final SdkField<String> PROFILE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ProfileId")
            .getter(getter(ContentTypeProfile::profileId))
            .setter(setter(Builder::profileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileId")
                    .unmarshallLocationName("ProfileId").build()).build();

    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ContentType")
            .getter(getter(ContentTypeProfile::contentType))
            .setter(setter(Builder::contentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentType")
                    .unmarshallLocationName("ContentType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORMAT_FIELD,
            PROFILE_ID_FIELD, CONTENT_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String format;

    private final String profileId;

    private final String contentType;

    private ContentTypeProfile(BuilderImpl builder) {
        this.format = builder.format;
        this.profileId = builder.profileId;
        this.contentType = builder.contentType;
    }

    /**
     * <p>
     * The format for a field-level encryption content type-profile mapping.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link Format#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return The format for a field-level encryption content type-profile mapping.
     * @see Format
     */
    public final Format format() {
        return Format.fromValue(format);
    }

    /**
     * <p>
     * The format for a field-level encryption content type-profile mapping.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link Format#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return The format for a field-level encryption content type-profile mapping.
     * @see Format
     */
    public final String formatAsString() {
        return format;
    }

    /**
     * <p>
     * The profile ID for a field-level encryption content type-profile mapping.
     * </p>
     * 
     * @return The profile ID for a field-level encryption content type-profile mapping.
     */
    public final String profileId() {
        return profileId;
    }

    /**
     * <p>
     * The content type for a field-level encryption content type-profile mapping.
     * </p>
     * 
     * @return The content type for a field-level encryption content type-profile mapping.
     */
    public final String contentType() {
        return contentType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(profileId());
        hashCode = 31 * hashCode + Objects.hashCode(contentType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContentTypeProfile)) {
            return false;
        }
        ContentTypeProfile other = (ContentTypeProfile) obj;
        return Objects.equals(formatAsString(), other.formatAsString()) && Objects.equals(profileId(), other.profileId())
                && Objects.equals(contentType(), other.contentType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContentTypeProfile").add("Format", formatAsString()).add("ProfileId", profileId())
                .add("ContentType", contentType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Format":
            return Optional.ofNullable(clazz.cast(formatAsString()));
        case "ProfileId":
            return Optional.ofNullable(clazz.cast(profileId()));
        case "ContentType":
            return Optional.ofNullable(clazz.cast(contentType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContentTypeProfile, T> g) {
        return obj -> g.apply((ContentTypeProfile) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContentTypeProfile> {
        /**
         * <p>
         * The format for a field-level encryption content type-profile mapping.
         * </p>
         * 
         * @param format
         *        The format for a field-level encryption content type-profile mapping.
         * @see Format
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Format
         */
        Builder format(String format);

        /**
         * <p>
         * The format for a field-level encryption content type-profile mapping.
         * </p>
         * 
         * @param format
         *        The format for a field-level encryption content type-profile mapping.
         * @see Format
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Format
         */
        Builder format(Format format);

        /**
         * <p>
         * The profile ID for a field-level encryption content type-profile mapping.
         * </p>
         * 
         * @param profileId
         *        The profile ID for a field-level encryption content type-profile mapping.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileId(String profileId);

        /**
         * <p>
         * The content type for a field-level encryption content type-profile mapping.
         * </p>
         * 
         * @param contentType
         *        The content type for a field-level encryption content type-profile mapping.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentType(String contentType);
    }

    static final class BuilderImpl implements Builder {
        private String format;

        private String profileId;

        private String contentType;

        private BuilderImpl() {
        }

        private BuilderImpl(ContentTypeProfile model) {
            format(model.format);
            profileId(model.profileId);
            contentType(model.contentType);
        }

        public final String getFormat() {
            return format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(Format format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        public final String getProfileId() {
            return profileId;
        }

        @Override
        public final Builder profileId(String profileId) {
            this.profileId = profileId;
            return this;
        }

        public final void setProfileId(String profileId) {
            this.profileId = profileId;
        }

        public final String getContentType() {
            return contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public ContentTypeProfile build() {
            return new ContentTypeProfile(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
