/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of cache policies.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CachePolicyList implements SdkPojo, Serializable, ToCopyableBuilder<CachePolicyList.Builder, CachePolicyList> {
    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextMarker")
            .getter(getter(CachePolicyList::nextMarker))
            .setter(setter(Builder::nextMarker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker")
                    .unmarshallLocationName("NextMarker").build()).build();

    private static final SdkField<Integer> MAX_ITEMS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxItems")
            .getter(getter(CachePolicyList::maxItems))
            .setter(setter(Builder::maxItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxItems")
                    .unmarshallLocationName("MaxItems").build()).build();

    private static final SdkField<Integer> QUANTITY_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("Quantity")
            .getter(getter(CachePolicyList::quantity))
            .setter(setter(Builder::quantity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Quantity")
                    .unmarshallLocationName("Quantity").build()).build();

    private static final SdkField<List<CachePolicySummary>> ITEMS_FIELD = SdkField
            .<List<CachePolicySummary>> builder(MarshallingType.LIST)
            .memberName("Items")
            .getter(getter(CachePolicyList::items))
            .setter(setter(Builder::items))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Items")
                    .unmarshallLocationName("Items").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("CachePolicySummary")
                            .memberFieldInfo(
                                    SdkField.<CachePolicySummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(CachePolicySummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("CachePolicySummary")
                                                    .unmarshallLocationName("CachePolicySummary").build()).build()).build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_MARKER_FIELD,
            MAX_ITEMS_FIELD, QUANTITY_FIELD, ITEMS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String nextMarker;

    private final Integer maxItems;

    private final Integer quantity;

    private final List<CachePolicySummary> items;

    private CachePolicyList(BuilderImpl builder) {
        this.nextMarker = builder.nextMarker;
        this.maxItems = builder.maxItems;
        this.quantity = builder.quantity;
        this.items = builder.items;
    }

    /**
     * <p>
     * If there are more items in the list than are in this response, this element is present. It contains the value
     * that you should use in the <code>Marker</code> field of a subsequent request to continue listing cache policies
     * where you left off.
     * </p>
     * 
     * @return If there are more items in the list than are in this response, this element is present. It contains the
     *         value that you should use in the <code>Marker</code> field of a subsequent request to continue listing
     *         cache policies where you left off.
     */
    public final String nextMarker() {
        return nextMarker;
    }

    /**
     * <p>
     * The maximum number of cache policies requested.
     * </p>
     * 
     * @return The maximum number of cache policies requested.
     */
    public final Integer maxItems() {
        return maxItems;
    }

    /**
     * <p>
     * The total number of cache policies returned in the response.
     * </p>
     * 
     * @return The total number of cache policies returned in the response.
     */
    public final Integer quantity() {
        return quantity;
    }

    /**
     * Returns true if the Items property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasItems() {
        return items != null && !(items instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains the cache policies in the list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasItems()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Contains the cache policies in the list.
     */
    public final List<CachePolicySummary> items() {
        return items;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nextMarker());
        hashCode = 31 * hashCode + Objects.hashCode(maxItems());
        hashCode = 31 * hashCode + Objects.hashCode(quantity());
        hashCode = 31 * hashCode + Objects.hashCode(hasItems() ? items() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CachePolicyList)) {
            return false;
        }
        CachePolicyList other = (CachePolicyList) obj;
        return Objects.equals(nextMarker(), other.nextMarker()) && Objects.equals(maxItems(), other.maxItems())
                && Objects.equals(quantity(), other.quantity()) && hasItems() == other.hasItems()
                && Objects.equals(items(), other.items());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CachePolicyList").add("NextMarker", nextMarker()).add("MaxItems", maxItems())
                .add("Quantity", quantity()).add("Items", hasItems() ? items() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextMarker":
            return Optional.ofNullable(clazz.cast(nextMarker()));
        case "MaxItems":
            return Optional.ofNullable(clazz.cast(maxItems()));
        case "Quantity":
            return Optional.ofNullable(clazz.cast(quantity()));
        case "Items":
            return Optional.ofNullable(clazz.cast(items()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CachePolicyList, T> g) {
        return obj -> g.apply((CachePolicyList) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CachePolicyList> {
        /**
         * <p>
         * If there are more items in the list than are in this response, this element is present. It contains the value
         * that you should use in the <code>Marker</code> field of a subsequent request to continue listing cache
         * policies where you left off.
         * </p>
         * 
         * @param nextMarker
         *        If there are more items in the list than are in this response, this element is present. It contains
         *        the value that you should use in the <code>Marker</code> field of a subsequent request to continue
         *        listing cache policies where you left off.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextMarker(String nextMarker);

        /**
         * <p>
         * The maximum number of cache policies requested.
         * </p>
         * 
         * @param maxItems
         *        The maximum number of cache policies requested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(Integer maxItems);

        /**
         * <p>
         * The total number of cache policies returned in the response.
         * </p>
         * 
         * @param quantity
         *        The total number of cache policies returned in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quantity(Integer quantity);

        /**
         * <p>
         * Contains the cache policies in the list.
         * </p>
         * 
         * @param items
         *        Contains the cache policies in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(Collection<CachePolicySummary> items);

        /**
         * <p>
         * Contains the cache policies in the list.
         * </p>
         * 
         * @param items
         *        Contains the cache policies in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(CachePolicySummary... items);

        /**
         * <p>
         * Contains the cache policies in the list.
         * </p>
         * This is a convenience that creates an instance of the {@link List<CachePolicySummary>.Builder} avoiding the
         * need to create one manually via {@link List<CachePolicySummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CachePolicySummary>.Builder#build()} is called immediately
         * and its result is passed to {@link #items(List<CachePolicySummary>)}.
         * 
         * @param items
         *        a consumer that will call methods on {@link List<CachePolicySummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #items(List<CachePolicySummary>)
         */
        Builder items(Consumer<CachePolicySummary.Builder>... items);
    }

    static final class BuilderImpl implements Builder {
        private String nextMarker;

        private Integer maxItems;

        private Integer quantity;

        private List<CachePolicySummary> items = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CachePolicyList model) {
            nextMarker(model.nextMarker);
            maxItems(model.maxItems);
            quantity(model.quantity);
            items(model.items);
        }

        public final String getNextMarker() {
            return nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        public final Integer getMaxItems() {
            return maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        public final Integer getQuantity() {
            return quantity;
        }

        @Override
        public final Builder quantity(Integer quantity) {
            this.quantity = quantity;
            return this;
        }

        public final void setQuantity(Integer quantity) {
            this.quantity = quantity;
        }

        public final Collection<CachePolicySummary.Builder> getItems() {
            if (items instanceof SdkAutoConstructList) {
                return null;
            }
            return items != null ? items.stream().map(CachePolicySummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder items(Collection<CachePolicySummary> items) {
            this.items = CachePolicySummaryListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(CachePolicySummary... items) {
            items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<CachePolicySummary.Builder>... items) {
            items(Stream.of(items).map(c -> CachePolicySummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setItems(Collection<CachePolicySummary.BuilderImpl> items) {
            this.items = CachePolicySummaryListCopier.copyFromBuilder(items);
        }

        @Override
        public CachePolicyList build() {
            return new CachePolicyList(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
