/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * AWS services in China customers must file for an Internet Content Provider (ICP) recordal if they want to serve
 * content publicly on an alternate domain name, also known as a CNAME, that they've added to CloudFront.
 * AliasICPRecordal provides the ICP recordal status for CNAMEs associated with distributions. The status is returned in
 * the CloudFront response; you can't configure it yourself.
 * </p>
 * <p>
 * For more information about ICP recordals, see <a
 * href="https://docs.amazonaws.cn/en_us/aws/latest/userguide/accounts-and-credentials.html"> Signup, Accounts, and
 * Credentials</a> in <i>Getting Started with AWS services in China</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AliasICPRecordal implements SdkPojo, Serializable,
        ToCopyableBuilder<AliasICPRecordal.Builder, AliasICPRecordal> {
    private static final SdkField<String> CNAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CNAME")
            .getter(getter(AliasICPRecordal::cname))
            .setter(setter(Builder::cname))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CNAME")
                    .unmarshallLocationName("CNAME").build()).build();

    private static final SdkField<String> ICP_RECORDAL_STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ICPRecordalStatus")
            .getter(getter(AliasICPRecordal::icpRecordalStatusAsString))
            .setter(setter(Builder::icpRecordalStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ICPRecordalStatus")
                    .unmarshallLocationName("ICPRecordalStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CNAME_FIELD,
            ICP_RECORDAL_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String cname;

    private final String icpRecordalStatus;

    private AliasICPRecordal(BuilderImpl builder) {
        this.cname = builder.cname;
        this.icpRecordalStatus = builder.icpRecordalStatus;
    }

    /**
     * <p>
     * A domain name associated with a distribution.
     * </p>
     * 
     * @return A domain name associated with a distribution.
     */
    public final String cname() {
        return cname;
    }

    /**
     * <p>
     * The Internet Content Provider (ICP) recordal status for a CNAME. The ICPRecordalStatus is set to APPROVED for all
     * CNAMEs (aliases) in regions outside of China.
     * </p>
     * <p>
     * The status values returned are the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>APPROVED</b> indicates that the associated CNAME has a valid ICP recordal number. Multiple CNAMEs can be
     * associated with a distribution, and CNAMEs can correspond to different ICP recordals. To be marked as APPROVED,
     * that is, valid to use with China region, a CNAME must have one ICP recordal number associated with it.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>SUSPENDED</b> indicates that the associated CNAME does not have a valid ICP recordal number.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>PENDING</b> indicates that CloudFront can't determine the ICP recordal status of the CNAME associated with the
     * distribution because there was an error in trying to determine the status. You can try again to see if the error
     * is resolved in which case CloudFront returns an APPROVED or SUSPENDED status.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #icpRecordalStatus}
     * will return {@link ICPRecordalStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #icpRecordalStatusAsString}.
     * </p>
     * 
     * @return The Internet Content Provider (ICP) recordal status for a CNAME. The ICPRecordalStatus is set to APPROVED
     *         for all CNAMEs (aliases) in regions outside of China. </p>
     *         <p>
     *         The status values returned are the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>APPROVED</b> indicates that the associated CNAME has a valid ICP recordal number. Multiple CNAMEs can
     *         be associated with a distribution, and CNAMEs can correspond to different ICP recordals. To be marked as
     *         APPROVED, that is, valid to use with China region, a CNAME must have one ICP recordal number associated
     *         with it.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>SUSPENDED</b> indicates that the associated CNAME does not have a valid ICP recordal number.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>PENDING</b> indicates that CloudFront can't determine the ICP recordal status of the CNAME associated
     *         with the distribution because there was an error in trying to determine the status. You can try again to
     *         see if the error is resolved in which case CloudFront returns an APPROVED or SUSPENDED status.
     *         </p>
     *         </li>
     * @see ICPRecordalStatus
     */
    public final ICPRecordalStatus icpRecordalStatus() {
        return ICPRecordalStatus.fromValue(icpRecordalStatus);
    }

    /**
     * <p>
     * The Internet Content Provider (ICP) recordal status for a CNAME. The ICPRecordalStatus is set to APPROVED for all
     * CNAMEs (aliases) in regions outside of China.
     * </p>
     * <p>
     * The status values returned are the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>APPROVED</b> indicates that the associated CNAME has a valid ICP recordal number. Multiple CNAMEs can be
     * associated with a distribution, and CNAMEs can correspond to different ICP recordals. To be marked as APPROVED,
     * that is, valid to use with China region, a CNAME must have one ICP recordal number associated with it.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>SUSPENDED</b> indicates that the associated CNAME does not have a valid ICP recordal number.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>PENDING</b> indicates that CloudFront can't determine the ICP recordal status of the CNAME associated with the
     * distribution because there was an error in trying to determine the status. You can try again to see if the error
     * is resolved in which case CloudFront returns an APPROVED or SUSPENDED status.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #icpRecordalStatus}
     * will return {@link ICPRecordalStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #icpRecordalStatusAsString}.
     * </p>
     * 
     * @return The Internet Content Provider (ICP) recordal status for a CNAME. The ICPRecordalStatus is set to APPROVED
     *         for all CNAMEs (aliases) in regions outside of China. </p>
     *         <p>
     *         The status values returned are the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>APPROVED</b> indicates that the associated CNAME has a valid ICP recordal number. Multiple CNAMEs can
     *         be associated with a distribution, and CNAMEs can correspond to different ICP recordals. To be marked as
     *         APPROVED, that is, valid to use with China region, a CNAME must have one ICP recordal number associated
     *         with it.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>SUSPENDED</b> indicates that the associated CNAME does not have a valid ICP recordal number.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>PENDING</b> indicates that CloudFront can't determine the ICP recordal status of the CNAME associated
     *         with the distribution because there was an error in trying to determine the status. You can try again to
     *         see if the error is resolved in which case CloudFront returns an APPROVED or SUSPENDED status.
     *         </p>
     *         </li>
     * @see ICPRecordalStatus
     */
    public final String icpRecordalStatusAsString() {
        return icpRecordalStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cname());
        hashCode = 31 * hashCode + Objects.hashCode(icpRecordalStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AliasICPRecordal)) {
            return false;
        }
        AliasICPRecordal other = (AliasICPRecordal) obj;
        return Objects.equals(cname(), other.cname())
                && Objects.equals(icpRecordalStatusAsString(), other.icpRecordalStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AliasICPRecordal").add("CNAME", cname()).add("ICPRecordalStatus", icpRecordalStatusAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CNAME":
            return Optional.ofNullable(clazz.cast(cname()));
        case "ICPRecordalStatus":
            return Optional.ofNullable(clazz.cast(icpRecordalStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AliasICPRecordal, T> g) {
        return obj -> g.apply((AliasICPRecordal) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AliasICPRecordal> {
        /**
         * <p>
         * A domain name associated with a distribution.
         * </p>
         * 
         * @param cname
         *        A domain name associated with a distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cname(String cname);

        /**
         * <p>
         * The Internet Content Provider (ICP) recordal status for a CNAME. The ICPRecordalStatus is set to APPROVED for
         * all CNAMEs (aliases) in regions outside of China.
         * </p>
         * <p>
         * The status values returned are the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>APPROVED</b> indicates that the associated CNAME has a valid ICP recordal number. Multiple CNAMEs can be
         * associated with a distribution, and CNAMEs can correspond to different ICP recordals. To be marked as
         * APPROVED, that is, valid to use with China region, a CNAME must have one ICP recordal number associated with
         * it.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>SUSPENDED</b> indicates that the associated CNAME does not have a valid ICP recordal number.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>PENDING</b> indicates that CloudFront can't determine the ICP recordal status of the CNAME associated with
         * the distribution because there was an error in trying to determine the status. You can try again to see if
         * the error is resolved in which case CloudFront returns an APPROVED or SUSPENDED status.
         * </p>
         * </li>
         * </ul>
         * 
         * @param icpRecordalStatus
         *        The Internet Content Provider (ICP) recordal status for a CNAME. The ICPRecordalStatus is set to
         *        APPROVED for all CNAMEs (aliases) in regions outside of China. </p>
         *        <p>
         *        The status values returned are the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>APPROVED</b> indicates that the associated CNAME has a valid ICP recordal number. Multiple CNAMEs
         *        can be associated with a distribution, and CNAMEs can correspond to different ICP recordals. To be
         *        marked as APPROVED, that is, valid to use with China region, a CNAME must have one ICP recordal number
         *        associated with it.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>SUSPENDED</b> indicates that the associated CNAME does not have a valid ICP recordal number.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>PENDING</b> indicates that CloudFront can't determine the ICP recordal status of the CNAME
         *        associated with the distribution because there was an error in trying to determine the status. You can
         *        try again to see if the error is resolved in which case CloudFront returns an APPROVED or SUSPENDED
         *        status.
         *        </p>
         *        </li>
         * @see ICPRecordalStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ICPRecordalStatus
         */
        Builder icpRecordalStatus(String icpRecordalStatus);

        /**
         * <p>
         * The Internet Content Provider (ICP) recordal status for a CNAME. The ICPRecordalStatus is set to APPROVED for
         * all CNAMEs (aliases) in regions outside of China.
         * </p>
         * <p>
         * The status values returned are the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>APPROVED</b> indicates that the associated CNAME has a valid ICP recordal number. Multiple CNAMEs can be
         * associated with a distribution, and CNAMEs can correspond to different ICP recordals. To be marked as
         * APPROVED, that is, valid to use with China region, a CNAME must have one ICP recordal number associated with
         * it.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>SUSPENDED</b> indicates that the associated CNAME does not have a valid ICP recordal number.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>PENDING</b> indicates that CloudFront can't determine the ICP recordal status of the CNAME associated with
         * the distribution because there was an error in trying to determine the status. You can try again to see if
         * the error is resolved in which case CloudFront returns an APPROVED or SUSPENDED status.
         * </p>
         * </li>
         * </ul>
         * 
         * @param icpRecordalStatus
         *        The Internet Content Provider (ICP) recordal status for a CNAME. The ICPRecordalStatus is set to
         *        APPROVED for all CNAMEs (aliases) in regions outside of China. </p>
         *        <p>
         *        The status values returned are the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>APPROVED</b> indicates that the associated CNAME has a valid ICP recordal number. Multiple CNAMEs
         *        can be associated with a distribution, and CNAMEs can correspond to different ICP recordals. To be
         *        marked as APPROVED, that is, valid to use with China region, a CNAME must have one ICP recordal number
         *        associated with it.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>SUSPENDED</b> indicates that the associated CNAME does not have a valid ICP recordal number.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>PENDING</b> indicates that CloudFront can't determine the ICP recordal status of the CNAME
         *        associated with the distribution because there was an error in trying to determine the status. You can
         *        try again to see if the error is resolved in which case CloudFront returns an APPROVED or SUSPENDED
         *        status.
         *        </p>
         *        </li>
         * @see ICPRecordalStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ICPRecordalStatus
         */
        Builder icpRecordalStatus(ICPRecordalStatus icpRecordalStatus);
    }

    static final class BuilderImpl implements Builder {
        private String cname;

        private String icpRecordalStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(AliasICPRecordal model) {
            cname(model.cname);
            icpRecordalStatus(model.icpRecordalStatus);
        }

        public final String getCname() {
            return cname;
        }

        @Override
        public final Builder cname(String cname) {
            this.cname = cname;
            return this;
        }

        public final void setCname(String cname) {
            this.cname = cname;
        }

        public final String getIcpRecordalStatus() {
            return icpRecordalStatus;
        }

        @Override
        public final Builder icpRecordalStatus(String icpRecordalStatus) {
            this.icpRecordalStatus = icpRecordalStatus;
            return this;
        }

        @Override
        public final Builder icpRecordalStatus(ICPRecordalStatus icpRecordalStatus) {
            this.icpRecordalStatus(icpRecordalStatus == null ? null : icpRecordalStatus.toString());
            return this;
        }

        public final void setIcpRecordalStatus(String icpRecordalStatus) {
            this.icpRecordalStatus = icpRecordalStatus;
        }

        @Override
        public AliasICPRecordal build() {
            return new AliasICPRecordal(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
