/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.CookiePreference;
import software.amazon.awssdk.services.cloudfront.model.Headers;
import software.amazon.awssdk.services.cloudfront.model.QueryStringCacheKeys;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ForwardedValues
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ForwardedValues> {
    private static final SdkField<Boolean> QUERY_STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("QueryString").getter(ForwardedValues.getter(ForwardedValues::queryString)).setter(ForwardedValues.setter(Builder::queryString)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryString").unmarshallLocationName("QueryString").build()}).build();
    private static final SdkField<CookiePreference> COOKIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Cookies").getter(ForwardedValues.getter(ForwardedValues::cookies)).setter(ForwardedValues.setter(Builder::cookies)).constructor(CookiePreference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cookies").unmarshallLocationName("Cookies").build()}).build();
    private static final SdkField<Headers> HEADERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Headers").getter(ForwardedValues.getter(ForwardedValues::headers)).setter(ForwardedValues.setter(Builder::headers)).constructor(Headers::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Headers").unmarshallLocationName("Headers").build()}).build();
    private static final SdkField<QueryStringCacheKeys> QUERY_STRING_CACHE_KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("QueryStringCacheKeys").getter(ForwardedValues.getter(ForwardedValues::queryStringCacheKeys)).setter(ForwardedValues.setter(Builder::queryStringCacheKeys)).constructor(QueryStringCacheKeys::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryStringCacheKeys").unmarshallLocationName("QueryStringCacheKeys").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_STRING_FIELD, COOKIES_FIELD, HEADERS_FIELD, QUERY_STRING_CACHE_KEYS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean queryString;
    private final CookiePreference cookies;
    private final Headers headers;
    private final QueryStringCacheKeys queryStringCacheKeys;

    private ForwardedValues(BuilderImpl builder) {
        this.queryString = builder.queryString;
        this.cookies = builder.cookies;
        this.headers = builder.headers;
        this.queryStringCacheKeys = builder.queryStringCacheKeys;
    }

    public final Boolean queryString() {
        return this.queryString;
    }

    public final CookiePreference cookies() {
        return this.cookies;
    }

    public final Headers headers() {
        return this.headers;
    }

    public final QueryStringCacheKeys queryStringCacheKeys() {
        return this.queryStringCacheKeys;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.queryString());
        hashCode = 31 * hashCode + Objects.hashCode(this.cookies());
        hashCode = 31 * hashCode + Objects.hashCode(this.headers());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryStringCacheKeys());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ForwardedValues)) {
            return false;
        }
        ForwardedValues other = (ForwardedValues)obj;
        return Objects.equals(this.queryString(), other.queryString()) && Objects.equals(this.cookies(), other.cookies()) && Objects.equals(this.headers(), other.headers()) && Objects.equals(this.queryStringCacheKeys(), other.queryStringCacheKeys());
    }

    public final String toString() {
        return ToString.builder((String)"ForwardedValues").add("QueryString", (Object)this.queryString()).add("Cookies", (Object)this.cookies()).add("Headers", (Object)this.headers()).add("QueryStringCacheKeys", (Object)this.queryStringCacheKeys()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "QueryString": {
                return Optional.ofNullable(clazz.cast(this.queryString()));
            }
            case "Cookies": {
                return Optional.ofNullable(clazz.cast(this.cookies()));
            }
            case "Headers": {
                return Optional.ofNullable(clazz.cast(this.headers()));
            }
            case "QueryStringCacheKeys": {
                return Optional.ofNullable(clazz.cast(this.queryStringCacheKeys()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ForwardedValues, T> g) {
        return obj -> g.apply((ForwardedValues)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean queryString;
        private CookiePreference cookies;
        private Headers headers;
        private QueryStringCacheKeys queryStringCacheKeys;

        private BuilderImpl() {
        }

        private BuilderImpl(ForwardedValues model) {
            this.queryString(model.queryString);
            this.cookies(model.cookies);
            this.headers(model.headers);
            this.queryStringCacheKeys(model.queryStringCacheKeys);
        }

        public final Boolean getQueryString() {
            return this.queryString;
        }

        @Override
        public final Builder queryString(Boolean queryString) {
            this.queryString = queryString;
            return this;
        }

        public final void setQueryString(Boolean queryString) {
            this.queryString = queryString;
        }

        public final CookiePreference.Builder getCookies() {
            return this.cookies != null ? this.cookies.toBuilder() : null;
        }

        @Override
        public final Builder cookies(CookiePreference cookies) {
            this.cookies = cookies;
            return this;
        }

        public final void setCookies(CookiePreference.BuilderImpl cookies) {
            this.cookies = cookies != null ? cookies.build() : null;
        }

        public final Headers.Builder getHeaders() {
            return this.headers != null ? this.headers.toBuilder() : null;
        }

        @Override
        public final Builder headers(Headers headers) {
            this.headers = headers;
            return this;
        }

        public final void setHeaders(Headers.BuilderImpl headers) {
            this.headers = headers != null ? headers.build() : null;
        }

        public final QueryStringCacheKeys.Builder getQueryStringCacheKeys() {
            return this.queryStringCacheKeys != null ? this.queryStringCacheKeys.toBuilder() : null;
        }

        @Override
        public final Builder queryStringCacheKeys(QueryStringCacheKeys queryStringCacheKeys) {
            this.queryStringCacheKeys = queryStringCacheKeys;
            return this;
        }

        public final void setQueryStringCacheKeys(QueryStringCacheKeys.BuilderImpl queryStringCacheKeys) {
            this.queryStringCacheKeys = queryStringCacheKeys != null ? queryStringCacheKeys.build() : null;
        }

        public ForwardedValues build() {
            return new ForwardedValues(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ForwardedValues> {
        public Builder queryString(Boolean var1);

        public Builder cookies(CookiePreference var1);

        default public Builder cookies(Consumer<CookiePreference.Builder> cookies) {
            return this.cookies((CookiePreference)((CookiePreference.Builder)CookiePreference.builder().applyMutation(cookies)).build());
        }

        public Builder headers(Headers var1);

        default public Builder headers(Consumer<Headers.Builder> headers) {
            return this.headers((Headers)((Headers.Builder)Headers.builder().applyMutation(headers)).build());
        }

        public Builder queryStringCacheKeys(QueryStringCacheKeys var1);

        default public Builder queryStringCacheKeys(Consumer<QueryStringCacheKeys.Builder> queryStringCacheKeys) {
            return this.queryStringCacheKeys((QueryStringCacheKeys)((QueryStringCacheKeys.Builder)QueryStringCacheKeys.builder().applyMutation(queryStringCacheKeys)).build());
        }
    }
}

