/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.PublicKeyConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PublicKey
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PublicKey> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(PublicKey.getter(PublicKey::id)).setter(PublicKey.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").unmarshallLocationName("Id").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTime").getter(PublicKey.getter(PublicKey::createdTime)).setter(PublicKey.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").unmarshallLocationName("CreatedTime").build()}).build();
    private static final SdkField<PublicKeyConfig> PUBLIC_KEY_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PublicKeyConfig").getter(PublicKey.getter(PublicKey::publicKeyConfig)).setter(PublicKey.setter(Builder::publicKeyConfig)).constructor(PublicKeyConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicKeyConfig").unmarshallLocationName("PublicKeyConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, CREATED_TIME_FIELD, PUBLIC_KEY_CONFIG_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final Instant createdTime;
    private final PublicKeyConfig publicKeyConfig;

    private PublicKey(BuilderImpl builder) {
        this.id = builder.id;
        this.createdTime = builder.createdTime;
        this.publicKeyConfig = builder.publicKeyConfig;
    }

    public String id() {
        return this.id;
    }

    public Instant createdTime() {
        return this.createdTime;
    }

    public PublicKeyConfig publicKeyConfig() {
        return this.publicKeyConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicKeyConfig());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PublicKey)) {
            return false;
        }
        PublicKey other = (PublicKey)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.publicKeyConfig(), other.publicKeyConfig());
    }

    public String toString() {
        return ToString.builder((String)"PublicKey").add("Id", (Object)this.id()).add("CreatedTime", (Object)this.createdTime()).add("PublicKeyConfig", (Object)this.publicKeyConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "PublicKeyConfig": {
                return Optional.ofNullable(clazz.cast(this.publicKeyConfig()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PublicKey, T> g) {
        return obj -> g.apply((PublicKey)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private Instant createdTime;
        private PublicKeyConfig publicKeyConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(PublicKey model) {
            this.id(model.id);
            this.createdTime(model.createdTime);
            this.publicKeyConfig(model.publicKeyConfig);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        public final PublicKeyConfig.Builder getPublicKeyConfig() {
            return this.publicKeyConfig != null ? this.publicKeyConfig.toBuilder() : null;
        }

        @Override
        public final Builder publicKeyConfig(PublicKeyConfig publicKeyConfig) {
            this.publicKeyConfig = publicKeyConfig;
            return this;
        }

        public final void setPublicKeyConfig(PublicKeyConfig.BuilderImpl publicKeyConfig) {
            this.publicKeyConfig = publicKeyConfig != null ? publicKeyConfig.build() : null;
        }

        public PublicKey build() {
            return new PublicKey(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PublicKey> {
        public Builder id(String var1);

        public Builder createdTime(Instant var1);

        public Builder publicKeyConfig(PublicKeyConfig var1);

        default public Builder publicKeyConfig(Consumer<PublicKeyConfig.Builder> publicKeyConfig) {
            return this.publicKeyConfig((PublicKeyConfig)((PublicKeyConfig.Builder)PublicKeyConfig.builder().applyMutation(publicKeyConfig)).build());
        }
    }
}

