/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetInvalidationRequest
extends CloudFrontRequest
implements ToCopyableBuilder<Builder, GetInvalidationRequest> {
    private static final SdkField<String> DISTRIBUTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DistributionId").getter(GetInvalidationRequest.getter(GetInvalidationRequest::distributionId)).setter(GetInvalidationRequest.setter(Builder::distributionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("DistributionId").unmarshallLocationName("DistributionId").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(GetInvalidationRequest.getter(GetInvalidationRequest::id)).setter(GetInvalidationRequest.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("Id").unmarshallLocationName("Id").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISTRIBUTION_ID_FIELD, ID_FIELD));
    private final String distributionId;
    private final String id;

    private GetInvalidationRequest(BuilderImpl builder) {
        super(builder);
        this.distributionId = builder.distributionId;
        this.id = builder.id;
    }

    public String distributionId() {
        return this.distributionId;
    }

    public String id() {
        return this.id;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.distributionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInvalidationRequest)) {
            return false;
        }
        GetInvalidationRequest other = (GetInvalidationRequest)((Object)obj);
        return Objects.equals(this.distributionId(), other.distributionId()) && Objects.equals(this.id(), other.id());
    }

    public String toString() {
        return ToString.builder((String)"GetInvalidationRequest").add("DistributionId", (Object)this.distributionId()).add("Id", (Object)this.id()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DistributionId": {
                return Optional.ofNullable(clazz.cast(this.distributionId()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetInvalidationRequest, T> g) {
        return obj -> g.apply((GetInvalidationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFrontRequest.BuilderImpl
    implements Builder {
        private String distributionId;
        private String id;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInvalidationRequest model) {
            super(model);
            this.distributionId(model.distributionId);
            this.id(model.id);
        }

        public final String getDistributionId() {
            return this.distributionId;
        }

        @Override
        public final Builder distributionId(String distributionId) {
            this.distributionId = distributionId;
            return this;
        }

        public final void setDistributionId(String distributionId) {
            this.distributionId = distributionId;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetInvalidationRequest build() {
            return new GetInvalidationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudFrontRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetInvalidationRequest> {
        public Builder distributionId(String var1);

        public Builder id(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

