/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudfront.model.PublicKeyIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KeyGroupConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KeyGroupConfig> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(KeyGroupConfig.getter(KeyGroupConfig::name)).setter(KeyGroupConfig.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").unmarshallLocationName("Name").build()}).build();
    private static final SdkField<List<String>> ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Items").getter(KeyGroupConfig.getter(KeyGroupConfig::items)).setter(KeyGroupConfig.setter(Builder::items)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Items").unmarshallLocationName("Items").build(), ListTrait.builder().memberLocationName("PublicKey").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicKey").unmarshallLocationName("PublicKey").build()}).build()).build()}).build();
    private static final SdkField<String> COMMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Comment").getter(KeyGroupConfig.getter(KeyGroupConfig::comment)).setter(KeyGroupConfig.setter(Builder::comment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Comment").unmarshallLocationName("Comment").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ITEMS_FIELD, COMMENT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final List<String> items;
    private final String comment;

    private KeyGroupConfig(BuilderImpl builder) {
        this.name = builder.name;
        this.items = builder.items;
        this.comment = builder.comment;
    }

    public String name() {
        return this.name;
    }

    public boolean hasItems() {
        return this.items != null && !(this.items instanceof SdkAutoConstructList);
    }

    public List<String> items() {
        return this.items;
    }

    public String comment() {
        return this.comment;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasItems() ? this.items() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.comment());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KeyGroupConfig)) {
            return false;
        }
        KeyGroupConfig other = (KeyGroupConfig)obj;
        return Objects.equals(this.name(), other.name()) && this.hasItems() == other.hasItems() && Objects.equals(this.items(), other.items()) && Objects.equals(this.comment(), other.comment());
    }

    public String toString() {
        return ToString.builder((String)"KeyGroupConfig").add("Name", (Object)this.name()).add("Items", this.hasItems() ? this.items() : null).add("Comment", (Object)this.comment()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Items": {
                return Optional.ofNullable(clazz.cast(this.items()));
            }
            case "Comment": {
                return Optional.ofNullable(clazz.cast(this.comment()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KeyGroupConfig, T> g) {
        return obj -> g.apply((KeyGroupConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private List<String> items = DefaultSdkAutoConstructList.getInstance();
        private String comment;

        private BuilderImpl() {
        }

        private BuilderImpl(KeyGroupConfig model) {
            this.name(model.name);
            this.items(model.items);
            this.comment(model.comment);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<String> getItems() {
            if (this.items instanceof SdkAutoConstructList) {
                return null;
            }
            return this.items;
        }

        @Override
        public final Builder items(Collection<String> items) {
            this.items = PublicKeyIdListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(String ... items) {
            this.items(Arrays.asList(items));
            return this;
        }

        public final void setItems(Collection<String> items) {
            this.items = PublicKeyIdListCopier.copy(items);
        }

        public final String getComment() {
            return this.comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        public KeyGroupConfig build() {
            return new KeyGroupConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KeyGroupConfig> {
        public Builder name(String var1);

        public Builder items(Collection<String> var1);

        public Builder items(String ... var1);

        public Builder comment(String var1);
    }
}

