/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontRequest;
import software.amazon.awssdk.services.cloudfront.model.PublicKeyConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreatePublicKeyRequest
extends CloudFrontRequest
implements ToCopyableBuilder<Builder, CreatePublicKeyRequest> {
    private static final SdkField<PublicKeyConfig> PUBLIC_KEY_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PublicKeyConfig").getter(CreatePublicKeyRequest.getter(CreatePublicKeyRequest::publicKeyConfig)).setter(CreatePublicKeyRequest.setter(Builder::publicKeyConfig)).constructor(PublicKeyConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicKeyConfig").unmarshallLocationName("PublicKeyConfig").build(), PayloadTrait.create()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PUBLIC_KEY_CONFIG_FIELD));
    private final PublicKeyConfig publicKeyConfig;

    private CreatePublicKeyRequest(BuilderImpl builder) {
        super(builder);
        this.publicKeyConfig = builder.publicKeyConfig;
    }

    public PublicKeyConfig publicKeyConfig() {
        return this.publicKeyConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.publicKeyConfig());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePublicKeyRequest)) {
            return false;
        }
        CreatePublicKeyRequest other = (CreatePublicKeyRequest)((Object)obj);
        return Objects.equals(this.publicKeyConfig(), other.publicKeyConfig());
    }

    public String toString() {
        return ToString.builder((String)"CreatePublicKeyRequest").add("PublicKeyConfig", (Object)this.publicKeyConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PublicKeyConfig": {
                return Optional.ofNullable(clazz.cast(this.publicKeyConfig()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreatePublicKeyRequest, T> g) {
        return obj -> g.apply((CreatePublicKeyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFrontRequest.BuilderImpl
    implements Builder {
        private PublicKeyConfig publicKeyConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePublicKeyRequest model) {
            super(model);
            this.publicKeyConfig(model.publicKeyConfig);
        }

        public final PublicKeyConfig.Builder getPublicKeyConfig() {
            return this.publicKeyConfig != null ? this.publicKeyConfig.toBuilder() : null;
        }

        @Override
        public final Builder publicKeyConfig(PublicKeyConfig publicKeyConfig) {
            this.publicKeyConfig = publicKeyConfig;
            return this;
        }

        public final void setPublicKeyConfig(PublicKeyConfig.BuilderImpl publicKeyConfig) {
            this.publicKeyConfig = publicKeyConfig != null ? publicKeyConfig.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePublicKeyRequest build() {
            return new CreatePublicKeyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudFrontRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreatePublicKeyRequest> {
        public Builder publicKeyConfig(PublicKeyConfig var1);

        default public Builder publicKeyConfig(Consumer<PublicKeyConfig.Builder> publicKeyConfig) {
            return this.publicKeyConfig((PublicKeyConfig)((PublicKeyConfig.Builder)PublicKeyConfig.builder().applyMutation(publicKeyConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

