/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontOriginAccessIdentity;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateCloudFrontOriginAccessIdentityResponse
extends CloudFrontResponse
implements ToCopyableBuilder<Builder, UpdateCloudFrontOriginAccessIdentityResponse> {
    private static final SdkField<CloudFrontOriginAccessIdentity> CLOUD_FRONT_ORIGIN_ACCESS_IDENTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(UpdateCloudFrontOriginAccessIdentityResponse.getter(UpdateCloudFrontOriginAccessIdentityResponse::cloudFrontOriginAccessIdentity)).setter(UpdateCloudFrontOriginAccessIdentityResponse.setter(Builder::cloudFrontOriginAccessIdentity)).constructor(CloudFrontOriginAccessIdentity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudFrontOriginAccessIdentity").unmarshallLocationName("CloudFrontOriginAccessIdentity").build(), PayloadTrait.create()}).build();
    private static final SdkField<String> E_TAG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateCloudFrontOriginAccessIdentityResponse.getter(UpdateCloudFrontOriginAccessIdentityResponse::eTag)).setter(UpdateCloudFrontOriginAccessIdentityResponse.setter(Builder::eTag)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("ETag").unmarshallLocationName("ETag").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOUD_FRONT_ORIGIN_ACCESS_IDENTITY_FIELD, E_TAG_FIELD));
    private final CloudFrontOriginAccessIdentity cloudFrontOriginAccessIdentity;
    private final String eTag;

    private UpdateCloudFrontOriginAccessIdentityResponse(BuilderImpl builder) {
        super(builder);
        this.cloudFrontOriginAccessIdentity = builder.cloudFrontOriginAccessIdentity;
        this.eTag = builder.eTag;
    }

    public CloudFrontOriginAccessIdentity cloudFrontOriginAccessIdentity() {
        return this.cloudFrontOriginAccessIdentity;
    }

    public String eTag() {
        return this.eTag;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudFrontOriginAccessIdentity());
        hashCode = 31 * hashCode + Objects.hashCode(this.eTag());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCloudFrontOriginAccessIdentityResponse)) {
            return false;
        }
        UpdateCloudFrontOriginAccessIdentityResponse other = (UpdateCloudFrontOriginAccessIdentityResponse)((Object)obj);
        return Objects.equals(this.cloudFrontOriginAccessIdentity(), other.cloudFrontOriginAccessIdentity()) && Objects.equals(this.eTag(), other.eTag());
    }

    public String toString() {
        return ToString.builder((String)"UpdateCloudFrontOriginAccessIdentityResponse").add("CloudFrontOriginAccessIdentity", (Object)this.cloudFrontOriginAccessIdentity()).add("ETag", (Object)this.eTag()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CloudFrontOriginAccessIdentity": {
                return Optional.ofNullable(clazz.cast(this.cloudFrontOriginAccessIdentity()));
            }
            case "ETag": {
                return Optional.ofNullable(clazz.cast(this.eTag()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateCloudFrontOriginAccessIdentityResponse, T> g) {
        return obj -> g.apply((UpdateCloudFrontOriginAccessIdentityResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFrontResponse.BuilderImpl
    implements Builder {
        private CloudFrontOriginAccessIdentity cloudFrontOriginAccessIdentity;
        private String eTag;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCloudFrontOriginAccessIdentityResponse model) {
            super(model);
            this.cloudFrontOriginAccessIdentity(model.cloudFrontOriginAccessIdentity);
            this.eTag(model.eTag);
        }

        public final CloudFrontOriginAccessIdentity.Builder getCloudFrontOriginAccessIdentity() {
            return this.cloudFrontOriginAccessIdentity != null ? this.cloudFrontOriginAccessIdentity.toBuilder() : null;
        }

        @Override
        public final Builder cloudFrontOriginAccessIdentity(CloudFrontOriginAccessIdentity cloudFrontOriginAccessIdentity) {
            this.cloudFrontOriginAccessIdentity = cloudFrontOriginAccessIdentity;
            return this;
        }

        public final void setCloudFrontOriginAccessIdentity(CloudFrontOriginAccessIdentity.BuilderImpl cloudFrontOriginAccessIdentity) {
            this.cloudFrontOriginAccessIdentity = cloudFrontOriginAccessIdentity != null ? cloudFrontOriginAccessIdentity.build() : null;
        }

        public final String getETag() {
            return this.eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        public UpdateCloudFrontOriginAccessIdentityResponse build() {
            return new UpdateCloudFrontOriginAccessIdentityResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudFrontResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateCloudFrontOriginAccessIdentityResponse> {
        public Builder cloudFrontOriginAccessIdentity(CloudFrontOriginAccessIdentity var1);

        default public Builder cloudFrontOriginAccessIdentity(Consumer<CloudFrontOriginAccessIdentity.Builder> cloudFrontOriginAccessIdentity) {
            return this.cloudFrontOriginAccessIdentity((CloudFrontOriginAccessIdentity)((CloudFrontOriginAccessIdentity.Builder)CloudFrontOriginAccessIdentity.builder().applyMutation(cloudFrontOriginAccessIdentity)).build());
        }

        public Builder eTag(String var1);
    }
}

