/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum HttpVersion {
    HTTP1_1("http1.1"),
    HTTP2("http2"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private HttpVersion(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static HttpVersion fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(HttpVersion.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<HttpVersion> knownValues() {
        return Stream.of(HttpVersion.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

