/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.xml.AwsXmlProtocolFactory;
import software.amazon.awssdk.protocols.xml.XmlOperationMetadata;
import software.amazon.awssdk.services.cloudfront.CloudFrontAsyncClient;
import software.amazon.awssdk.services.cloudfront.model.AccessDeniedException;
import software.amazon.awssdk.services.cloudfront.model.BatchTooLargeException;
import software.amazon.awssdk.services.cloudfront.model.CannotChangeImmutablePublicKeyFieldsException;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontException;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontOriginAccessIdentityAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontOriginAccessIdentityInUseException;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontRequest;
import software.amazon.awssdk.services.cloudfront.model.CnameAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.CreateCloudFrontOriginAccessIdentityRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateCloudFrontOriginAccessIdentityResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateDistributionResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateDistributionWithTagsRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateDistributionWithTagsResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateFieldLevelEncryptionConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateFieldLevelEncryptionConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateFieldLevelEncryptionProfileRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateFieldLevelEncryptionProfileResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateInvalidationRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateInvalidationResponse;
import software.amazon.awssdk.services.cloudfront.model.CreatePublicKeyRequest;
import software.amazon.awssdk.services.cloudfront.model.CreatePublicKeyResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateStreamingDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateStreamingDistributionResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateStreamingDistributionWithTagsRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateStreamingDistributionWithTagsResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteCloudFrontOriginAccessIdentityRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteCloudFrontOriginAccessIdentityResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteDistributionResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteFieldLevelEncryptionConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteFieldLevelEncryptionConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteFieldLevelEncryptionProfileRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteFieldLevelEncryptionProfileResponse;
import software.amazon.awssdk.services.cloudfront.model.DeletePublicKeyRequest;
import software.amazon.awssdk.services.cloudfront.model.DeletePublicKeyResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteStreamingDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteStreamingDistributionResponse;
import software.amazon.awssdk.services.cloudfront.model.DistributionAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.DistributionNotDisabledException;
import software.amazon.awssdk.services.cloudfront.model.FieldLevelEncryptionConfigAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.FieldLevelEncryptionConfigInUseException;
import software.amazon.awssdk.services.cloudfront.model.FieldLevelEncryptionProfileAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.FieldLevelEncryptionProfileInUseException;
import software.amazon.awssdk.services.cloudfront.model.FieldLevelEncryptionProfileSizeExceededException;
import software.amazon.awssdk.services.cloudfront.model.GetCloudFrontOriginAccessIdentityConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetCloudFrontOriginAccessIdentityConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetCloudFrontOriginAccessIdentityRequest;
import software.amazon.awssdk.services.cloudfront.model.GetCloudFrontOriginAccessIdentityResponse;
import software.amazon.awssdk.services.cloudfront.model.GetDistributionConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetDistributionConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.GetDistributionResponse;
import software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionProfileConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionProfileConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionProfileRequest;
import software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionProfileResponse;
import software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionRequest;
import software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionResponse;
import software.amazon.awssdk.services.cloudfront.model.GetInvalidationRequest;
import software.amazon.awssdk.services.cloudfront.model.GetInvalidationResponse;
import software.amazon.awssdk.services.cloudfront.model.GetPublicKeyConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetPublicKeyConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetPublicKeyRequest;
import software.amazon.awssdk.services.cloudfront.model.GetPublicKeyResponse;
import software.amazon.awssdk.services.cloudfront.model.GetStreamingDistributionConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetStreamingDistributionConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetStreamingDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.GetStreamingDistributionResponse;
import software.amazon.awssdk.services.cloudfront.model.IllegalFieldLevelEncryptionConfigAssociationWithCacheBehaviorException;
import software.amazon.awssdk.services.cloudfront.model.IllegalUpdateException;
import software.amazon.awssdk.services.cloudfront.model.InconsistentQuantitiesException;
import software.amazon.awssdk.services.cloudfront.model.InvalidArgumentException;
import software.amazon.awssdk.services.cloudfront.model.InvalidDefaultRootObjectException;
import software.amazon.awssdk.services.cloudfront.model.InvalidErrorCodeException;
import software.amazon.awssdk.services.cloudfront.model.InvalidForwardCookiesException;
import software.amazon.awssdk.services.cloudfront.model.InvalidGeoRestrictionParameterException;
import software.amazon.awssdk.services.cloudfront.model.InvalidHeadersForS3OriginException;
import software.amazon.awssdk.services.cloudfront.model.InvalidIfMatchVersionException;
import software.amazon.awssdk.services.cloudfront.model.InvalidLambdaFunctionAssociationException;
import software.amazon.awssdk.services.cloudfront.model.InvalidLocationCodeException;
import software.amazon.awssdk.services.cloudfront.model.InvalidMinimumProtocolVersionException;
import software.amazon.awssdk.services.cloudfront.model.InvalidOriginAccessIdentityException;
import software.amazon.awssdk.services.cloudfront.model.InvalidOriginException;
import software.amazon.awssdk.services.cloudfront.model.InvalidOriginKeepaliveTimeoutException;
import software.amazon.awssdk.services.cloudfront.model.InvalidOriginReadTimeoutException;
import software.amazon.awssdk.services.cloudfront.model.InvalidProtocolSettingsException;
import software.amazon.awssdk.services.cloudfront.model.InvalidQueryStringParametersException;
import software.amazon.awssdk.services.cloudfront.model.InvalidRelativePathException;
import software.amazon.awssdk.services.cloudfront.model.InvalidRequiredProtocolException;
import software.amazon.awssdk.services.cloudfront.model.InvalidResponseCodeException;
import software.amazon.awssdk.services.cloudfront.model.InvalidTaggingException;
import software.amazon.awssdk.services.cloudfront.model.InvalidTtlOrderException;
import software.amazon.awssdk.services.cloudfront.model.InvalidViewerCertificateException;
import software.amazon.awssdk.services.cloudfront.model.InvalidWebAclIdException;
import software.amazon.awssdk.services.cloudfront.model.ListCloudFrontOriginAccessIdentitiesRequest;
import software.amazon.awssdk.services.cloudfront.model.ListCloudFrontOriginAccessIdentitiesResponse;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsByWebAclIdRequest;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsByWebAclIdResponse;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsRequest;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsResponse;
import software.amazon.awssdk.services.cloudfront.model.ListFieldLevelEncryptionConfigsRequest;
import software.amazon.awssdk.services.cloudfront.model.ListFieldLevelEncryptionConfigsResponse;
import software.amazon.awssdk.services.cloudfront.model.ListFieldLevelEncryptionProfilesRequest;
import software.amazon.awssdk.services.cloudfront.model.ListFieldLevelEncryptionProfilesResponse;
import software.amazon.awssdk.services.cloudfront.model.ListInvalidationsRequest;
import software.amazon.awssdk.services.cloudfront.model.ListInvalidationsResponse;
import software.amazon.awssdk.services.cloudfront.model.ListPublicKeysRequest;
import software.amazon.awssdk.services.cloudfront.model.ListPublicKeysResponse;
import software.amazon.awssdk.services.cloudfront.model.ListStreamingDistributionsRequest;
import software.amazon.awssdk.services.cloudfront.model.ListStreamingDistributionsResponse;
import software.amazon.awssdk.services.cloudfront.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.cloudfront.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.cloudfront.model.MissingBodyException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchCloudFrontOriginAccessIdentityException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchDistributionException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchFieldLevelEncryptionConfigException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchFieldLevelEncryptionProfileException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchInvalidationException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchOriginException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchPublicKeyException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchResourceException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchStreamingDistributionException;
import software.amazon.awssdk.services.cloudfront.model.PreconditionFailedException;
import software.amazon.awssdk.services.cloudfront.model.PublicKeyAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.PublicKeyInUseException;
import software.amazon.awssdk.services.cloudfront.model.QueryArgProfileEmptyException;
import software.amazon.awssdk.services.cloudfront.model.StreamingDistributionAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.StreamingDistributionNotDisabledException;
import software.amazon.awssdk.services.cloudfront.model.TagResourceRequest;
import software.amazon.awssdk.services.cloudfront.model.TagResourceResponse;
import software.amazon.awssdk.services.cloudfront.model.TooManyCacheBehaviorsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyCertificatesException;
import software.amazon.awssdk.services.cloudfront.model.TooManyCloudFrontOriginAccessIdentitiesException;
import software.amazon.awssdk.services.cloudfront.model.TooManyCookieNamesInWhiteListException;
import software.amazon.awssdk.services.cloudfront.model.TooManyDistributionCnamEsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyDistributionsAssociatedToFieldLevelEncryptionConfigException;
import software.amazon.awssdk.services.cloudfront.model.TooManyDistributionsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyDistributionsWithLambdaAssociationsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyFieldLevelEncryptionConfigsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyFieldLevelEncryptionContentTypeProfilesException;
import software.amazon.awssdk.services.cloudfront.model.TooManyFieldLevelEncryptionEncryptionEntitiesException;
import software.amazon.awssdk.services.cloudfront.model.TooManyFieldLevelEncryptionFieldPatternsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyFieldLevelEncryptionProfilesException;
import software.amazon.awssdk.services.cloudfront.model.TooManyFieldLevelEncryptionQueryArgProfilesException;
import software.amazon.awssdk.services.cloudfront.model.TooManyHeadersInForwardedValuesException;
import software.amazon.awssdk.services.cloudfront.model.TooManyInvalidationsInProgressException;
import software.amazon.awssdk.services.cloudfront.model.TooManyLambdaFunctionAssociationsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyOriginCustomHeadersException;
import software.amazon.awssdk.services.cloudfront.model.TooManyOriginGroupsPerDistributionException;
import software.amazon.awssdk.services.cloudfront.model.TooManyOriginsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyPublicKeysException;
import software.amazon.awssdk.services.cloudfront.model.TooManyQueryStringParametersException;
import software.amazon.awssdk.services.cloudfront.model.TooManyStreamingDistributionCnamEsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyStreamingDistributionsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyTrustedSignersException;
import software.amazon.awssdk.services.cloudfront.model.TrustedSignerDoesNotExistException;
import software.amazon.awssdk.services.cloudfront.model.UntagResourceRequest;
import software.amazon.awssdk.services.cloudfront.model.UntagResourceResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateCloudFrontOriginAccessIdentityRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateCloudFrontOriginAccessIdentityResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateDistributionResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateFieldLevelEncryptionConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateFieldLevelEncryptionConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateFieldLevelEncryptionProfileRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateFieldLevelEncryptionProfileResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdatePublicKeyRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdatePublicKeyResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateStreamingDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateStreamingDistributionResponse;
import software.amazon.awssdk.services.cloudfront.transform.CreateCloudFrontOriginAccessIdentityRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateDistributionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateDistributionWithTagsRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateFieldLevelEncryptionConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateFieldLevelEncryptionProfileRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateInvalidationRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreatePublicKeyRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateStreamingDistributionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateStreamingDistributionWithTagsRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.DeleteCloudFrontOriginAccessIdentityRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.DeleteDistributionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.DeleteFieldLevelEncryptionConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.DeleteFieldLevelEncryptionProfileRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.DeletePublicKeyRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.DeleteStreamingDistributionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetCloudFrontOriginAccessIdentityConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetCloudFrontOriginAccessIdentityRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetDistributionConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetDistributionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetFieldLevelEncryptionConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetFieldLevelEncryptionProfileConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetFieldLevelEncryptionProfileRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetFieldLevelEncryptionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetInvalidationRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetPublicKeyConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetPublicKeyRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetStreamingDistributionConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetStreamingDistributionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListCloudFrontOriginAccessIdentitiesRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListDistributionsByWebAclIdRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListDistributionsRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListFieldLevelEncryptionConfigsRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListFieldLevelEncryptionProfilesRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListInvalidationsRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListPublicKeysRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListStreamingDistributionsRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.UpdateCloudFrontOriginAccessIdentityRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.UpdateDistributionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.UpdateFieldLevelEncryptionConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.UpdateFieldLevelEncryptionProfileRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.UpdatePublicKeyRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.UpdateStreamingDistributionRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultCloudFrontAsyncClient
implements CloudFrontAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultCloudFrontAsyncClient.class);
    private final AsyncClientHandler clientHandler;
    private final AwsXmlProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultCloudFrontAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init();
    }

    public final String serviceName() {
        return "cloudfront";
    }

    @Override
    public CompletableFuture<CreateCloudFrontOriginAccessIdentityResponse> createCloudFrontOriginAccessIdentity(CreateCloudFrontOriginAccessIdentityRequest createCloudFrontOriginAccessIdentityRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateCloudFrontOriginAccessIdentity");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(CreateCloudFrontOriginAccessIdentityResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateCloudFrontOriginAccessIdentity").withMarshaller((Marshaller)new CreateCloudFrontOriginAccessIdentityRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)createCloudFrontOriginAccessIdentityRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createCloudFrontOriginAccessIdentityRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, createCloudFrontOriginAccessIdentityRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateDistributionResponse> createDistribution(CreateDistributionRequest createDistributionRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDistribution");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(CreateDistributionResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDistribution").withMarshaller((Marshaller)new CreateDistributionRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)createDistributionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createDistributionRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, createDistributionRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateDistributionWithTagsResponse> createDistributionWithTags(CreateDistributionWithTagsRequest createDistributionWithTagsRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDistributionWithTags");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(CreateDistributionWithTagsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDistributionWithTags").withMarshaller((Marshaller)new CreateDistributionWithTagsRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)createDistributionWithTagsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createDistributionWithTagsRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, createDistributionWithTagsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateFieldLevelEncryptionConfigResponse> createFieldLevelEncryptionConfig(CreateFieldLevelEncryptionConfigRequest createFieldLevelEncryptionConfigRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateFieldLevelEncryptionConfig");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(CreateFieldLevelEncryptionConfigResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateFieldLevelEncryptionConfig").withMarshaller((Marshaller)new CreateFieldLevelEncryptionConfigRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)createFieldLevelEncryptionConfigRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createFieldLevelEncryptionConfigRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, createFieldLevelEncryptionConfigRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateFieldLevelEncryptionProfileResponse> createFieldLevelEncryptionProfile(CreateFieldLevelEncryptionProfileRequest createFieldLevelEncryptionProfileRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateFieldLevelEncryptionProfile");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(CreateFieldLevelEncryptionProfileResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateFieldLevelEncryptionProfile").withMarshaller((Marshaller)new CreateFieldLevelEncryptionProfileRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)createFieldLevelEncryptionProfileRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createFieldLevelEncryptionProfileRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, createFieldLevelEncryptionProfileRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateInvalidationResponse> createInvalidation(CreateInvalidationRequest createInvalidationRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateInvalidation");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(CreateInvalidationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateInvalidation").withMarshaller((Marshaller)new CreateInvalidationRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)createInvalidationRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createInvalidationRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, createInvalidationRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreatePublicKeyResponse> createPublicKey(CreatePublicKeyRequest createPublicKeyRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreatePublicKey");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(CreatePublicKeyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreatePublicKey").withMarshaller((Marshaller)new CreatePublicKeyRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)createPublicKeyRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createPublicKeyRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, createPublicKeyRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateStreamingDistributionResponse> createStreamingDistribution(CreateStreamingDistributionRequest createStreamingDistributionRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateStreamingDistribution");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(CreateStreamingDistributionResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateStreamingDistribution").withMarshaller((Marshaller)new CreateStreamingDistributionRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)createStreamingDistributionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createStreamingDistributionRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, createStreamingDistributionRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateStreamingDistributionWithTagsResponse> createStreamingDistributionWithTags(CreateStreamingDistributionWithTagsRequest createStreamingDistributionWithTagsRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateStreamingDistributionWithTags");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(CreateStreamingDistributionWithTagsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateStreamingDistributionWithTags").withMarshaller((Marshaller)new CreateStreamingDistributionWithTagsRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)createStreamingDistributionWithTagsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createStreamingDistributionWithTagsRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, createStreamingDistributionWithTagsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteCloudFrontOriginAccessIdentityResponse> deleteCloudFrontOriginAccessIdentity(DeleteCloudFrontOriginAccessIdentityRequest deleteCloudFrontOriginAccessIdentityRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteCloudFrontOriginAccessIdentity");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteCloudFrontOriginAccessIdentityResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteCloudFrontOriginAccessIdentity").withMarshaller((Marshaller)new DeleteCloudFrontOriginAccessIdentityRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)deleteCloudFrontOriginAccessIdentityRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteCloudFrontOriginAccessIdentityRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteCloudFrontOriginAccessIdentityRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteDistributionResponse> deleteDistribution(DeleteDistributionRequest deleteDistributionRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDistribution");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteDistributionResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDistribution").withMarshaller((Marshaller)new DeleteDistributionRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)deleteDistributionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteDistributionRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteDistributionRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteFieldLevelEncryptionConfigResponse> deleteFieldLevelEncryptionConfig(DeleteFieldLevelEncryptionConfigRequest deleteFieldLevelEncryptionConfigRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteFieldLevelEncryptionConfig");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteFieldLevelEncryptionConfigResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteFieldLevelEncryptionConfig").withMarshaller((Marshaller)new DeleteFieldLevelEncryptionConfigRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)deleteFieldLevelEncryptionConfigRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteFieldLevelEncryptionConfigRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteFieldLevelEncryptionConfigRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteFieldLevelEncryptionProfileResponse> deleteFieldLevelEncryptionProfile(DeleteFieldLevelEncryptionProfileRequest deleteFieldLevelEncryptionProfileRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteFieldLevelEncryptionProfile");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteFieldLevelEncryptionProfileResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteFieldLevelEncryptionProfile").withMarshaller((Marshaller)new DeleteFieldLevelEncryptionProfileRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)deleteFieldLevelEncryptionProfileRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteFieldLevelEncryptionProfileRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteFieldLevelEncryptionProfileRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeletePublicKeyResponse> deletePublicKey(DeletePublicKeyRequest deletePublicKeyRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeletePublicKey");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeletePublicKeyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeletePublicKey").withMarshaller((Marshaller)new DeletePublicKeyRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)deletePublicKeyRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deletePublicKeyRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, deletePublicKeyRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteStreamingDistributionResponse> deleteStreamingDistribution(DeleteStreamingDistributionRequest deleteStreamingDistributionRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteStreamingDistribution");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteStreamingDistributionResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteStreamingDistribution").withMarshaller((Marshaller)new DeleteStreamingDistributionRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)deleteStreamingDistributionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteStreamingDistributionRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteStreamingDistributionRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetCloudFrontOriginAccessIdentityResponse> getCloudFrontOriginAccessIdentity(GetCloudFrontOriginAccessIdentityRequest getCloudFrontOriginAccessIdentityRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetCloudFrontOriginAccessIdentity");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetCloudFrontOriginAccessIdentityResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCloudFrontOriginAccessIdentity").withMarshaller((Marshaller)new GetCloudFrontOriginAccessIdentityRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)getCloudFrontOriginAccessIdentityRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getCloudFrontOriginAccessIdentityRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, getCloudFrontOriginAccessIdentityRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetCloudFrontOriginAccessIdentityConfigResponse> getCloudFrontOriginAccessIdentityConfig(GetCloudFrontOriginAccessIdentityConfigRequest getCloudFrontOriginAccessIdentityConfigRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetCloudFrontOriginAccessIdentityConfig");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetCloudFrontOriginAccessIdentityConfigResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCloudFrontOriginAccessIdentityConfig").withMarshaller((Marshaller)new GetCloudFrontOriginAccessIdentityConfigRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)getCloudFrontOriginAccessIdentityConfigRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getCloudFrontOriginAccessIdentityConfigRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, getCloudFrontOriginAccessIdentityConfigRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetDistributionResponse> getDistribution(GetDistributionRequest getDistributionRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDistribution");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetDistributionResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDistribution").withMarshaller((Marshaller)new GetDistributionRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)getDistributionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getDistributionRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, getDistributionRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetDistributionConfigResponse> getDistributionConfig(GetDistributionConfigRequest getDistributionConfigRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDistributionConfig");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetDistributionConfigResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDistributionConfig").withMarshaller((Marshaller)new GetDistributionConfigRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)getDistributionConfigRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getDistributionConfigRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, getDistributionConfigRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetFieldLevelEncryptionResponse> getFieldLevelEncryption(GetFieldLevelEncryptionRequest getFieldLevelEncryptionRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetFieldLevelEncryption");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetFieldLevelEncryptionResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetFieldLevelEncryption").withMarshaller((Marshaller)new GetFieldLevelEncryptionRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)getFieldLevelEncryptionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getFieldLevelEncryptionRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, getFieldLevelEncryptionRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetFieldLevelEncryptionConfigResponse> getFieldLevelEncryptionConfig(GetFieldLevelEncryptionConfigRequest getFieldLevelEncryptionConfigRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetFieldLevelEncryptionConfig");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetFieldLevelEncryptionConfigResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetFieldLevelEncryptionConfig").withMarshaller((Marshaller)new GetFieldLevelEncryptionConfigRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)getFieldLevelEncryptionConfigRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getFieldLevelEncryptionConfigRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, getFieldLevelEncryptionConfigRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetFieldLevelEncryptionProfileResponse> getFieldLevelEncryptionProfile(GetFieldLevelEncryptionProfileRequest getFieldLevelEncryptionProfileRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetFieldLevelEncryptionProfile");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetFieldLevelEncryptionProfileResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetFieldLevelEncryptionProfile").withMarshaller((Marshaller)new GetFieldLevelEncryptionProfileRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)getFieldLevelEncryptionProfileRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getFieldLevelEncryptionProfileRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, getFieldLevelEncryptionProfileRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetFieldLevelEncryptionProfileConfigResponse> getFieldLevelEncryptionProfileConfig(GetFieldLevelEncryptionProfileConfigRequest getFieldLevelEncryptionProfileConfigRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetFieldLevelEncryptionProfileConfig");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetFieldLevelEncryptionProfileConfigResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetFieldLevelEncryptionProfileConfig").withMarshaller((Marshaller)new GetFieldLevelEncryptionProfileConfigRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)getFieldLevelEncryptionProfileConfigRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getFieldLevelEncryptionProfileConfigRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, getFieldLevelEncryptionProfileConfigRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetInvalidationResponse> getInvalidation(GetInvalidationRequest getInvalidationRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetInvalidation");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetInvalidationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetInvalidation").withMarshaller((Marshaller)new GetInvalidationRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)getInvalidationRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getInvalidationRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, getInvalidationRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetPublicKeyResponse> getPublicKey(GetPublicKeyRequest getPublicKeyRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetPublicKey");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetPublicKeyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetPublicKey").withMarshaller((Marshaller)new GetPublicKeyRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)getPublicKeyRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getPublicKeyRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, getPublicKeyRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetPublicKeyConfigResponse> getPublicKeyConfig(GetPublicKeyConfigRequest getPublicKeyConfigRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetPublicKeyConfig");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetPublicKeyConfigResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetPublicKeyConfig").withMarshaller((Marshaller)new GetPublicKeyConfigRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)getPublicKeyConfigRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getPublicKeyConfigRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, getPublicKeyConfigRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetStreamingDistributionResponse> getStreamingDistribution(GetStreamingDistributionRequest getStreamingDistributionRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetStreamingDistribution");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetStreamingDistributionResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetStreamingDistribution").withMarshaller((Marshaller)new GetStreamingDistributionRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)getStreamingDistributionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getStreamingDistributionRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, getStreamingDistributionRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetStreamingDistributionConfigResponse> getStreamingDistributionConfig(GetStreamingDistributionConfigRequest getStreamingDistributionConfigRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetStreamingDistributionConfig");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetStreamingDistributionConfigResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetStreamingDistributionConfig").withMarshaller((Marshaller)new GetStreamingDistributionConfigRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)getStreamingDistributionConfigRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getStreamingDistributionConfigRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, getStreamingDistributionConfigRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListCloudFrontOriginAccessIdentitiesResponse> listCloudFrontOriginAccessIdentities(ListCloudFrontOriginAccessIdentitiesRequest listCloudFrontOriginAccessIdentitiesRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListCloudFrontOriginAccessIdentities");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListCloudFrontOriginAccessIdentitiesResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListCloudFrontOriginAccessIdentities").withMarshaller((Marshaller)new ListCloudFrontOriginAccessIdentitiesRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)listCloudFrontOriginAccessIdentitiesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listCloudFrontOriginAccessIdentitiesRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, listCloudFrontOriginAccessIdentitiesRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListDistributionsResponse> listDistributions(ListDistributionsRequest listDistributionsRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDistributions");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListDistributionsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDistributions").withMarshaller((Marshaller)new ListDistributionsRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)listDistributionsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listDistributionsRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, listDistributionsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListDistributionsByWebAclIdResponse> listDistributionsByWebACLId(ListDistributionsByWebAclIdRequest listDistributionsByWebAclIdRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDistributionsByWebACLId");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListDistributionsByWebAclIdResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDistributionsByWebACLId").withMarshaller((Marshaller)new ListDistributionsByWebAclIdRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)listDistributionsByWebAclIdRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listDistributionsByWebAclIdRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, listDistributionsByWebAclIdRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListFieldLevelEncryptionConfigsResponse> listFieldLevelEncryptionConfigs(ListFieldLevelEncryptionConfigsRequest listFieldLevelEncryptionConfigsRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListFieldLevelEncryptionConfigs");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListFieldLevelEncryptionConfigsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListFieldLevelEncryptionConfigs").withMarshaller((Marshaller)new ListFieldLevelEncryptionConfigsRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)listFieldLevelEncryptionConfigsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listFieldLevelEncryptionConfigsRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, listFieldLevelEncryptionConfigsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListFieldLevelEncryptionProfilesResponse> listFieldLevelEncryptionProfiles(ListFieldLevelEncryptionProfilesRequest listFieldLevelEncryptionProfilesRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListFieldLevelEncryptionProfiles");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListFieldLevelEncryptionProfilesResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListFieldLevelEncryptionProfiles").withMarshaller((Marshaller)new ListFieldLevelEncryptionProfilesRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)listFieldLevelEncryptionProfilesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listFieldLevelEncryptionProfilesRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, listFieldLevelEncryptionProfilesRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListInvalidationsResponse> listInvalidations(ListInvalidationsRequest listInvalidationsRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListInvalidations");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListInvalidationsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListInvalidations").withMarshaller((Marshaller)new ListInvalidationsRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)listInvalidationsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listInvalidationsRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, listInvalidationsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListPublicKeysResponse> listPublicKeys(ListPublicKeysRequest listPublicKeysRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListPublicKeys");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListPublicKeysResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPublicKeys").withMarshaller((Marshaller)new ListPublicKeysRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)listPublicKeysRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listPublicKeysRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, listPublicKeysRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListStreamingDistributionsResponse> listStreamingDistributions(ListStreamingDistributionsRequest listStreamingDistributionsRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListStreamingDistributions");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListStreamingDistributionsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListStreamingDistributions").withMarshaller((Marshaller)new ListStreamingDistributionsRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)listStreamingDistributionsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listStreamingDistributionsRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, listStreamingDistributionsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListTagsForResourceResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)listTagsForResourceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listTagsForResourceRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(TagResourceResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withMarshaller((Marshaller)new TagResourceRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)tagResourceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = tagResourceRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(UntagResourceResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withMarshaller((Marshaller)new UntagResourceRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)untagResourceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = untagResourceRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateCloudFrontOriginAccessIdentityResponse> updateCloudFrontOriginAccessIdentity(UpdateCloudFrontOriginAccessIdentityRequest updateCloudFrontOriginAccessIdentityRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateCloudFrontOriginAccessIdentity");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(UpdateCloudFrontOriginAccessIdentityResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateCloudFrontOriginAccessIdentity").withMarshaller((Marshaller)new UpdateCloudFrontOriginAccessIdentityRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)updateCloudFrontOriginAccessIdentityRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateCloudFrontOriginAccessIdentityRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateCloudFrontOriginAccessIdentityRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateDistributionResponse> updateDistribution(UpdateDistributionRequest updateDistributionRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateDistribution");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(UpdateDistributionResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateDistribution").withMarshaller((Marshaller)new UpdateDistributionRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)updateDistributionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateDistributionRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateDistributionRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateFieldLevelEncryptionConfigResponse> updateFieldLevelEncryptionConfig(UpdateFieldLevelEncryptionConfigRequest updateFieldLevelEncryptionConfigRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateFieldLevelEncryptionConfig");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(UpdateFieldLevelEncryptionConfigResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateFieldLevelEncryptionConfig").withMarshaller((Marshaller)new UpdateFieldLevelEncryptionConfigRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)updateFieldLevelEncryptionConfigRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateFieldLevelEncryptionConfigRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateFieldLevelEncryptionConfigRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateFieldLevelEncryptionProfileResponse> updateFieldLevelEncryptionProfile(UpdateFieldLevelEncryptionProfileRequest updateFieldLevelEncryptionProfileRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateFieldLevelEncryptionProfile");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(UpdateFieldLevelEncryptionProfileResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateFieldLevelEncryptionProfile").withMarshaller((Marshaller)new UpdateFieldLevelEncryptionProfileRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)updateFieldLevelEncryptionProfileRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateFieldLevelEncryptionProfileRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateFieldLevelEncryptionProfileRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdatePublicKeyResponse> updatePublicKey(UpdatePublicKeyRequest updatePublicKeyRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdatePublicKey");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(UpdatePublicKeyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdatePublicKey").withMarshaller((Marshaller)new UpdatePublicKeyRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)updatePublicKeyRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updatePublicKeyRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, updatePublicKeyRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateStreamingDistributionResponse> updateStreamingDistribution(UpdateStreamingDistributionRequest updateStreamingDistributionRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateStreamingDistribution");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(UpdateStreamingDistributionResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateStreamingDistribution").withMarshaller((Marshaller)new UpdateStreamingDistributionRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)updateStreamingDistributionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateStreamingDistributionRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateStreamingDistributionRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    public void close() {
        this.clientHandler.close();
    }

    private AwsXmlProtocolFactory init() {
        return AwsXmlProtocolFactory.builder().registerModeledException(ExceptionMetadata.builder().errorCode("StreamingDistributionAlreadyExists").exceptionBuilderSupplier(StreamingDistributionAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TrustedSignerDoesNotExist").exceptionBuilderSupplier(TrustedSignerDoesNotExistException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchInvalidation").exceptionBuilderSupplier(NoSuchInvalidationException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchFieldLevelEncryptionConfig").exceptionBuilderSupplier(NoSuchFieldLevelEncryptionConfigException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyHeadersInForwardedValues").exceptionBuilderSupplier(TooManyHeadersInForwardedValuesException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidOriginReadTimeout").exceptionBuilderSupplier(InvalidOriginReadTimeoutException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidMinimumProtocolVersion").exceptionBuilderSupplier(InvalidMinimumProtocolVersionException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyInvalidationsInProgress").exceptionBuilderSupplier(TooManyInvalidationsInProgressException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyFieldLevelEncryptionConfigs").exceptionBuilderSupplier(TooManyFieldLevelEncryptionConfigsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyPublicKeys").exceptionBuilderSupplier(TooManyPublicKeysException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidErrorCode").exceptionBuilderSupplier(InvalidErrorCodeException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyCacheBehaviors").exceptionBuilderSupplier(TooManyCacheBehaviorsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CloudFrontOriginAccessIdentityInUse").exceptionBuilderSupplier(CloudFrontOriginAccessIdentityInUseException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("FieldLevelEncryptionProfileAlreadyExists").exceptionBuilderSupplier(FieldLevelEncryptionProfileAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyFieldLevelEncryptionFieldPatterns").exceptionBuilderSupplier(TooManyFieldLevelEncryptionFieldPatternsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("MissingBody").exceptionBuilderSupplier(MissingBodyException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyOrigins").exceptionBuilderSupplier(TooManyOriginsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior").exceptionBuilderSupplier(IllegalFieldLevelEncryptionConfigAssociationWithCacheBehaviorException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidRequiredProtocol").exceptionBuilderSupplier(InvalidRequiredProtocolException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchOrigin").exceptionBuilderSupplier(NoSuchOriginException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyTrustedSigners").exceptionBuilderSupplier(TooManyTrustedSignersException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("BatchTooLarge").exceptionBuilderSupplier(BatchTooLargeException::builder).httpStatusCode(Integer.valueOf(413)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidResponseCode").exceptionBuilderSupplier(InvalidResponseCodeException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("FieldLevelEncryptionConfigAlreadyExists").exceptionBuilderSupplier(FieldLevelEncryptionConfigAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidOriginKeepaliveTimeout").exceptionBuilderSupplier(InvalidOriginKeepaliveTimeoutException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyStreamingDistributionCNAMEs").exceptionBuilderSupplier(TooManyStreamingDistributionCnamEsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyStreamingDistributions").exceptionBuilderSupplier(TooManyStreamingDistributionsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PublicKeyInUse").exceptionBuilderSupplier(PublicKeyInUseException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("StreamingDistributionNotDisabled").exceptionBuilderSupplier(StreamingDistributionNotDisabledException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyDistributionCNAMEs").exceptionBuilderSupplier(TooManyDistributionCnamEsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PreconditionFailed").exceptionBuilderSupplier(PreconditionFailedException::builder).httpStatusCode(Integer.valueOf(412)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyQueryStringParameters").exceptionBuilderSupplier(TooManyQueryStringParametersException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyFieldLevelEncryptionEncryptionEntities").exceptionBuilderSupplier(TooManyFieldLevelEncryptionEncryptionEntitiesException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("FieldLevelEncryptionConfigInUse").exceptionBuilderSupplier(FieldLevelEncryptionConfigInUseException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DistributionAlreadyExists").exceptionBuilderSupplier(DistributionAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CloudFrontOriginAccessIdentityAlreadyExists").exceptionBuilderSupplier(CloudFrontOriginAccessIdentityAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidProtocolSettings").exceptionBuilderSupplier(InvalidProtocolSettingsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyFieldLevelEncryptionProfiles").exceptionBuilderSupplier(TooManyFieldLevelEncryptionProfilesException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyOriginCustomHeaders").exceptionBuilderSupplier(TooManyOriginCustomHeadersException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidLocationCode").exceptionBuilderSupplier(InvalidLocationCodeException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidForwardCookies").exceptionBuilderSupplier(InvalidForwardCookiesException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("FieldLevelEncryptionProfileSizeExceeded").exceptionBuilderSupplier(FieldLevelEncryptionProfileSizeExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyCertificates").exceptionBuilderSupplier(TooManyCertificatesException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("QueryArgProfileEmpty").exceptionBuilderSupplier(QueryArgProfileEmptyException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidOriginAccessIdentity").exceptionBuilderSupplier(InvalidOriginAccessIdentityException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidQueryStringParameters").exceptionBuilderSupplier(InvalidQueryStringParametersException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("IllegalUpdate").exceptionBuilderSupplier(IllegalUpdateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyCookieNamesInWhiteList").exceptionBuilderSupplier(TooManyCookieNamesInWhiteListException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchDistribution").exceptionBuilderSupplier(NoSuchDistributionException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CNAMEAlreadyExists").exceptionBuilderSupplier(CnameAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchFieldLevelEncryptionProfile").exceptionBuilderSupplier(NoSuchFieldLevelEncryptionProfileException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchResource").exceptionBuilderSupplier(NoSuchResourceException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidTTLOrder").exceptionBuilderSupplier(InvalidTtlOrderException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InconsistentQuantities").exceptionBuilderSupplier(InconsistentQuantitiesException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidLambdaFunctionAssociation").exceptionBuilderSupplier(InvalidLambdaFunctionAssociationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyLambdaFunctionAssociations").exceptionBuilderSupplier(TooManyLambdaFunctionAssociationsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidViewerCertificate").exceptionBuilderSupplier(InvalidViewerCertificateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DistributionNotDisabled").exceptionBuilderSupplier(DistributionNotDisabledException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyOriginGroupsPerDistribution").exceptionBuilderSupplier(TooManyOriginGroupsPerDistributionException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidDefaultRootObject").exceptionBuilderSupplier(InvalidDefaultRootObjectException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AccessDenied").exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidArgument").exceptionBuilderSupplier(InvalidArgumentException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchStreamingDistribution").exceptionBuilderSupplier(NoSuchStreamingDistributionException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyCloudFrontOriginAccessIdentities").exceptionBuilderSupplier(TooManyCloudFrontOriginAccessIdentitiesException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchPublicKey").exceptionBuilderSupplier(NoSuchPublicKeyException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyFieldLevelEncryptionContentTypeProfiles").exceptionBuilderSupplier(TooManyFieldLevelEncryptionContentTypeProfilesException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidRelativePath").exceptionBuilderSupplier(InvalidRelativePathException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidWebACLId").exceptionBuilderSupplier(InvalidWebAclIdException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyDistributionsAssociatedToFieldLevelEncryptionConfig").exceptionBuilderSupplier(TooManyDistributionsAssociatedToFieldLevelEncryptionConfigException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyDistributionsWithLambdaAssociations").exceptionBuilderSupplier(TooManyDistributionsWithLambdaAssociationsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidHeadersForS3Origin").exceptionBuilderSupplier(InvalidHeadersForS3OriginException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyDistributions").exceptionBuilderSupplier(TooManyDistributionsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CannotChangeImmutablePublicKeyFields").exceptionBuilderSupplier(CannotChangeImmutablePublicKeyFieldsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyFieldLevelEncryptionQueryArgProfiles").exceptionBuilderSupplier(TooManyFieldLevelEncryptionQueryArgProfilesException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PublicKeyAlreadyExists").exceptionBuilderSupplier(PublicKeyAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("FieldLevelEncryptionProfileInUse").exceptionBuilderSupplier(FieldLevelEncryptionProfileInUseException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidIfMatchVersion").exceptionBuilderSupplier(InvalidIfMatchVersionException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidTagging").exceptionBuilderSupplier(InvalidTaggingException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidOrigin").exceptionBuilderSupplier(InvalidOriginException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchCloudFrontOriginAccessIdentity").exceptionBuilderSupplier(NoSuchCloudFrontOriginAccessIdentityException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidGeoRestrictionParameter").exceptionBuilderSupplier(InvalidGeoRestrictionParameterException::builder).httpStatusCode(Integer.valueOf(400)).build()).clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(CloudFrontException::builder).build();
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private <T extends CloudFrontRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.13.52").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((CloudFrontRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }
}

