/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum SslProtocol {
    SSL_V3("SSLv3"),
    TLS_V1("TLSv1"),
    TLS_V1_1("TLSv1.1"),
    TLS_V1_2("TLSv1.2"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private SslProtocol(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SslProtocol fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(SslProtocol.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SslProtocol> knownValues() {
        return Stream.of(SslProtocol.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

