/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateFieldLevelEncryptionProfileResponse extends CloudFrontResponse implements
        ToCopyableBuilder<UpdateFieldLevelEncryptionProfileResponse.Builder, UpdateFieldLevelEncryptionProfileResponse> {
    private static final SdkField<FieldLevelEncryptionProfile> FIELD_LEVEL_ENCRYPTION_PROFILE_FIELD = SdkField
            .<FieldLevelEncryptionProfile> builder(MarshallingType.SDK_POJO)
            .getter(getter(UpdateFieldLevelEncryptionProfileResponse::fieldLevelEncryptionProfile))
            .setter(setter(Builder::fieldLevelEncryptionProfile))
            .constructor(FieldLevelEncryptionProfile::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldLevelEncryptionProfile")
                    .unmarshallLocationName("FieldLevelEncryptionProfile").build(), PayloadTrait.create()).build();

    private static final SdkField<String> E_TAG_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateFieldLevelEncryptionProfileResponse::eTag))
            .setter(setter(Builder::eTag))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("ETag").unmarshallLocationName("ETag")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            FIELD_LEVEL_ENCRYPTION_PROFILE_FIELD, E_TAG_FIELD));

    private final FieldLevelEncryptionProfile fieldLevelEncryptionProfile;

    private final String eTag;

    private UpdateFieldLevelEncryptionProfileResponse(BuilderImpl builder) {
        super(builder);
        this.fieldLevelEncryptionProfile = builder.fieldLevelEncryptionProfile;
        this.eTag = builder.eTag;
    }

    /**
     * <p>
     * Return the results of updating the profile.
     * </p>
     * 
     * @return Return the results of updating the profile.
     */
    public FieldLevelEncryptionProfile fieldLevelEncryptionProfile() {
        return fieldLevelEncryptionProfile;
    }

    /**
     * <p>
     * The result of the field-level encryption profile request.
     * </p>
     * 
     * @return The result of the field-level encryption profile request.
     */
    public String eTag() {
        return eTag;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(fieldLevelEncryptionProfile());
        hashCode = 31 * hashCode + Objects.hashCode(eTag());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFieldLevelEncryptionProfileResponse)) {
            return false;
        }
        UpdateFieldLevelEncryptionProfileResponse other = (UpdateFieldLevelEncryptionProfileResponse) obj;
        return Objects.equals(fieldLevelEncryptionProfile(), other.fieldLevelEncryptionProfile())
                && Objects.equals(eTag(), other.eTag());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateFieldLevelEncryptionProfileResponse")
                .add("FieldLevelEncryptionProfile", fieldLevelEncryptionProfile()).add("ETag", eTag()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FieldLevelEncryptionProfile":
            return Optional.ofNullable(clazz.cast(fieldLevelEncryptionProfile()));
        case "ETag":
            return Optional.ofNullable(clazz.cast(eTag()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateFieldLevelEncryptionProfileResponse, T> g) {
        return obj -> g.apply((UpdateFieldLevelEncryptionProfileResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFrontResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateFieldLevelEncryptionProfileResponse> {
        /**
         * <p>
         * Return the results of updating the profile.
         * </p>
         * 
         * @param fieldLevelEncryptionProfile
         *        Return the results of updating the profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldLevelEncryptionProfile(FieldLevelEncryptionProfile fieldLevelEncryptionProfile);

        /**
         * <p>
         * Return the results of updating the profile.
         * </p>
         * This is a convenience that creates an instance of the {@link FieldLevelEncryptionProfile.Builder} avoiding
         * the need to create one manually via {@link FieldLevelEncryptionProfile#builder()}.
         *
         * When the {@link Consumer} completes, {@link FieldLevelEncryptionProfile.Builder#build()} is called
         * immediately and its result is passed to {@link #fieldLevelEncryptionProfile(FieldLevelEncryptionProfile)}.
         * 
         * @param fieldLevelEncryptionProfile
         *        a consumer that will call methods on {@link FieldLevelEncryptionProfile.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fieldLevelEncryptionProfile(FieldLevelEncryptionProfile)
         */
        default Builder fieldLevelEncryptionProfile(Consumer<FieldLevelEncryptionProfile.Builder> fieldLevelEncryptionProfile) {
            return fieldLevelEncryptionProfile(FieldLevelEncryptionProfile.builder().applyMutation(fieldLevelEncryptionProfile)
                    .build());
        }

        /**
         * <p>
         * The result of the field-level encryption profile request.
         * </p>
         * 
         * @param eTag
         *        The result of the field-level encryption profile request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eTag(String eTag);
    }

    static final class BuilderImpl extends CloudFrontResponse.BuilderImpl implements Builder {
        private FieldLevelEncryptionProfile fieldLevelEncryptionProfile;

        private String eTag;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFieldLevelEncryptionProfileResponse model) {
            super(model);
            fieldLevelEncryptionProfile(model.fieldLevelEncryptionProfile);
            eTag(model.eTag);
        }

        public final FieldLevelEncryptionProfile.Builder getFieldLevelEncryptionProfile() {
            return fieldLevelEncryptionProfile != null ? fieldLevelEncryptionProfile.toBuilder() : null;
        }

        @Override
        public final Builder fieldLevelEncryptionProfile(FieldLevelEncryptionProfile fieldLevelEncryptionProfile) {
            this.fieldLevelEncryptionProfile = fieldLevelEncryptionProfile;
            return this;
        }

        public final void setFieldLevelEncryptionProfile(FieldLevelEncryptionProfile.BuilderImpl fieldLevelEncryptionProfile) {
            this.fieldLevelEncryptionProfile = fieldLevelEncryptionProfile != null ? fieldLevelEncryptionProfile.build() : null;
        }

        public final String getETag() {
            return eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        public UpdateFieldLevelEncryptionProfileResponse build() {
            return new UpdateFieldLevelEncryptionProfileResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
