/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains information about the Amazon S3 origin. If the origin is a custom origin, use the
 * <code>CustomOriginConfig</code> element instead.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3OriginConfig implements SdkPojo, Serializable, ToCopyableBuilder<S3OriginConfig.Builder, S3OriginConfig> {
    private static final SdkField<String> ORIGIN_ACCESS_IDENTITY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(S3OriginConfig::originAccessIdentity))
            .setter(setter(Builder::originAccessIdentity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginAccessIdentity")
                    .unmarshallLocationName("OriginAccessIdentity").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORIGIN_ACCESS_IDENTITY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String originAccessIdentity;

    private S3OriginConfig(BuilderImpl builder) {
        this.originAccessIdentity = builder.originAccessIdentity;
    }

    /**
     * <p>
     * The CloudFront origin access identity to associate with the origin. Use an origin access identity to configure
     * the origin so that viewers can <i>only</i> access objects in an Amazon S3 bucket through CloudFront. The format
     * of the value is:
     * </p>
     * <p>
     * origin-access-identity/cloudfront/<i>ID-of-origin-access-identity</i>
     * </p>
     * <p>
     * where <code> <i>ID-of-origin-access-identity</i> </code> is the value that CloudFront returned in the
     * <code>ID</code> element when you created the origin access identity.
     * </p>
     * <p>
     * If you want viewers to be able to access objects using either the CloudFront URL or the Amazon S3 URL, specify an
     * empty <code>OriginAccessIdentity</code> element.
     * </p>
     * <p>
     * To delete the origin access identity from an existing distribution, update the distribution configuration and
     * include an empty <code>OriginAccessIdentity</code> element.
     * </p>
     * <p>
     * To replace the origin access identity, update the distribution configuration and specify the new origin access
     * identity.
     * </p>
     * <p>
     * For more information about the origin access identity, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving Private
     * Content through CloudFront</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * 
     * @return The CloudFront origin access identity to associate with the origin. Use an origin access identity to
     *         configure the origin so that viewers can <i>only</i> access objects in an Amazon S3 bucket through
     *         CloudFront. The format of the value is:</p>
     *         <p>
     *         origin-access-identity/cloudfront/<i>ID-of-origin-access-identity</i>
     *         </p>
     *         <p>
     *         where <code> <i>ID-of-origin-access-identity</i> </code> is the value that CloudFront returned in the
     *         <code>ID</code> element when you created the origin access identity.
     *         </p>
     *         <p>
     *         If you want viewers to be able to access objects using either the CloudFront URL or the Amazon S3 URL,
     *         specify an empty <code>OriginAccessIdentity</code> element.
     *         </p>
     *         <p>
     *         To delete the origin access identity from an existing distribution, update the distribution configuration
     *         and include an empty <code>OriginAccessIdentity</code> element.
     *         </p>
     *         <p>
     *         To replace the origin access identity, update the distribution configuration and specify the new origin
     *         access identity.
     *         </p>
     *         <p>
     *         For more information about the origin access identity, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving
     *         Private Content through CloudFront</a> in the <i>Amazon CloudFront Developer Guide</i>.
     */
    public String originAccessIdentity() {
        return originAccessIdentity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(originAccessIdentity());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3OriginConfig)) {
            return false;
        }
        S3OriginConfig other = (S3OriginConfig) obj;
        return Objects.equals(originAccessIdentity(), other.originAccessIdentity());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("S3OriginConfig").add("OriginAccessIdentity", originAccessIdentity()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OriginAccessIdentity":
            return Optional.ofNullable(clazz.cast(originAccessIdentity()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3OriginConfig, T> g) {
        return obj -> g.apply((S3OriginConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3OriginConfig> {
        /**
         * <p>
         * The CloudFront origin access identity to associate with the origin. Use an origin access identity to
         * configure the origin so that viewers can <i>only</i> access objects in an Amazon S3 bucket through
         * CloudFront. The format of the value is:
         * </p>
         * <p>
         * origin-access-identity/cloudfront/<i>ID-of-origin-access-identity</i>
         * </p>
         * <p>
         * where <code> <i>ID-of-origin-access-identity</i> </code> is the value that CloudFront returned in the
         * <code>ID</code> element when you created the origin access identity.
         * </p>
         * <p>
         * If you want viewers to be able to access objects using either the CloudFront URL or the Amazon S3 URL,
         * specify an empty <code>OriginAccessIdentity</code> element.
         * </p>
         * <p>
         * To delete the origin access identity from an existing distribution, update the distribution configuration and
         * include an empty <code>OriginAccessIdentity</code> element.
         * </p>
         * <p>
         * To replace the origin access identity, update the distribution configuration and specify the new origin
         * access identity.
         * </p>
         * <p>
         * For more information about the origin access identity, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving Private
         * Content through CloudFront</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * 
         * @param originAccessIdentity
         *        The CloudFront origin access identity to associate with the origin. Use an origin access identity to
         *        configure the origin so that viewers can <i>only</i> access objects in an Amazon S3 bucket through
         *        CloudFront. The format of the value is:</p>
         *        <p>
         *        origin-access-identity/cloudfront/<i>ID-of-origin-access-identity</i>
         *        </p>
         *        <p>
         *        where <code> <i>ID-of-origin-access-identity</i> </code> is the value that CloudFront returned in the
         *        <code>ID</code> element when you created the origin access identity.
         *        </p>
         *        <p>
         *        If you want viewers to be able to access objects using either the CloudFront URL or the Amazon S3 URL,
         *        specify an empty <code>OriginAccessIdentity</code> element.
         *        </p>
         *        <p>
         *        To delete the origin access identity from an existing distribution, update the distribution
         *        configuration and include an empty <code>OriginAccessIdentity</code> element.
         *        </p>
         *        <p>
         *        To replace the origin access identity, update the distribution configuration and specify the new
         *        origin access identity.
         *        </p>
         *        <p>
         *        For more information about the origin access identity, see <a
         *        href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving
         *        Private Content through CloudFront</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originAccessIdentity(String originAccessIdentity);
    }

    static final class BuilderImpl implements Builder {
        private String originAccessIdentity;

        private BuilderImpl() {
        }

        private BuilderImpl(S3OriginConfig model) {
            originAccessIdentity(model.originAccessIdentity);
        }

        public final String getOriginAccessIdentity() {
            return originAccessIdentity;
        }

        @Override
        public final Builder originAccessIdentity(String originAccessIdentity) {
            this.originAccessIdentity = originAccessIdentity;
            return this;
        }

        public final void setOriginAccessIdentity(String originAccessIdentity) {
            this.originAccessIdentity = originAccessIdentity;
        }

        @Override
        public S3OriginConfig build() {
            return new S3OriginConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
