/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration for query argument-profile mapping for field-level encryption.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class QueryArgProfileConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<QueryArgProfileConfig.Builder, QueryArgProfileConfig> {
    private static final SdkField<Boolean> FORWARD_WHEN_QUERY_ARG_PROFILE_IS_UNKNOWN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(QueryArgProfileConfig::forwardWhenQueryArgProfileIsUnknown))
            .setter(setter(Builder::forwardWhenQueryArgProfileIsUnknown))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ForwardWhenQueryArgProfileIsUnknown")
                    .unmarshallLocationName("ForwardWhenQueryArgProfileIsUnknown").build()).build();

    private static final SdkField<QueryArgProfiles> QUERY_ARG_PROFILES_FIELD = SdkField
            .<QueryArgProfiles> builder(MarshallingType.SDK_POJO)
            .getter(getter(QueryArgProfileConfig::queryArgProfiles))
            .setter(setter(Builder::queryArgProfiles))
            .constructor(QueryArgProfiles::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryArgProfiles")
                    .unmarshallLocationName("QueryArgProfiles").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            FORWARD_WHEN_QUERY_ARG_PROFILE_IS_UNKNOWN_FIELD, QUERY_ARG_PROFILES_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean forwardWhenQueryArgProfileIsUnknown;

    private final QueryArgProfiles queryArgProfiles;

    private QueryArgProfileConfig(BuilderImpl builder) {
        this.forwardWhenQueryArgProfileIsUnknown = builder.forwardWhenQueryArgProfileIsUnknown;
        this.queryArgProfiles = builder.queryArgProfiles;
    }

    /**
     * <p>
     * Flag to set if you want a request to be forwarded to the origin even if the profile specified by the field-level
     * encryption query argument, fle-profile, is unknown.
     * </p>
     * 
     * @return Flag to set if you want a request to be forwarded to the origin even if the profile specified by the
     *         field-level encryption query argument, fle-profile, is unknown.
     */
    public Boolean forwardWhenQueryArgProfileIsUnknown() {
        return forwardWhenQueryArgProfileIsUnknown;
    }

    /**
     * <p>
     * Profiles specified for query argument-profile mapping for field-level encryption.
     * </p>
     * 
     * @return Profiles specified for query argument-profile mapping for field-level encryption.
     */
    public QueryArgProfiles queryArgProfiles() {
        return queryArgProfiles;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(forwardWhenQueryArgProfileIsUnknown());
        hashCode = 31 * hashCode + Objects.hashCode(queryArgProfiles());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryArgProfileConfig)) {
            return false;
        }
        QueryArgProfileConfig other = (QueryArgProfileConfig) obj;
        return Objects.equals(forwardWhenQueryArgProfileIsUnknown(), other.forwardWhenQueryArgProfileIsUnknown())
                && Objects.equals(queryArgProfiles(), other.queryArgProfiles());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("QueryArgProfileConfig")
                .add("ForwardWhenQueryArgProfileIsUnknown", forwardWhenQueryArgProfileIsUnknown())
                .add("QueryArgProfiles", queryArgProfiles()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ForwardWhenQueryArgProfileIsUnknown":
            return Optional.ofNullable(clazz.cast(forwardWhenQueryArgProfileIsUnknown()));
        case "QueryArgProfiles":
            return Optional.ofNullable(clazz.cast(queryArgProfiles()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<QueryArgProfileConfig, T> g) {
        return obj -> g.apply((QueryArgProfileConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, QueryArgProfileConfig> {
        /**
         * <p>
         * Flag to set if you want a request to be forwarded to the origin even if the profile specified by the
         * field-level encryption query argument, fle-profile, is unknown.
         * </p>
         * 
         * @param forwardWhenQueryArgProfileIsUnknown
         *        Flag to set if you want a request to be forwarded to the origin even if the profile specified by the
         *        field-level encryption query argument, fle-profile, is unknown.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forwardWhenQueryArgProfileIsUnknown(Boolean forwardWhenQueryArgProfileIsUnknown);

        /**
         * <p>
         * Profiles specified for query argument-profile mapping for field-level encryption.
         * </p>
         * 
         * @param queryArgProfiles
         *        Profiles specified for query argument-profile mapping for field-level encryption.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryArgProfiles(QueryArgProfiles queryArgProfiles);

        /**
         * <p>
         * Profiles specified for query argument-profile mapping for field-level encryption.
         * </p>
         * This is a convenience that creates an instance of the {@link QueryArgProfiles.Builder} avoiding the need to
         * create one manually via {@link QueryArgProfiles#builder()}.
         *
         * When the {@link Consumer} completes, {@link QueryArgProfiles.Builder#build()} is called immediately and its
         * result is passed to {@link #queryArgProfiles(QueryArgProfiles)}.
         * 
         * @param queryArgProfiles
         *        a consumer that will call methods on {@link QueryArgProfiles.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #queryArgProfiles(QueryArgProfiles)
         */
        default Builder queryArgProfiles(Consumer<QueryArgProfiles.Builder> queryArgProfiles) {
            return queryArgProfiles(QueryArgProfiles.builder().applyMutation(queryArgProfiles).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Boolean forwardWhenQueryArgProfileIsUnknown;

        private QueryArgProfiles queryArgProfiles;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryArgProfileConfig model) {
            forwardWhenQueryArgProfileIsUnknown(model.forwardWhenQueryArgProfileIsUnknown);
            queryArgProfiles(model.queryArgProfiles);
        }

        public final Boolean getForwardWhenQueryArgProfileIsUnknown() {
            return forwardWhenQueryArgProfileIsUnknown;
        }

        @Override
        public final Builder forwardWhenQueryArgProfileIsUnknown(Boolean forwardWhenQueryArgProfileIsUnknown) {
            this.forwardWhenQueryArgProfileIsUnknown = forwardWhenQueryArgProfileIsUnknown;
            return this;
        }

        public final void setForwardWhenQueryArgProfileIsUnknown(Boolean forwardWhenQueryArgProfileIsUnknown) {
            this.forwardWhenQueryArgProfileIsUnknown = forwardWhenQueryArgProfileIsUnknown;
        }

        public final QueryArgProfiles.Builder getQueryArgProfiles() {
            return queryArgProfiles != null ? queryArgProfiles.toBuilder() : null;
        }

        @Override
        public final Builder queryArgProfiles(QueryArgProfiles queryArgProfiles) {
            this.queryArgProfiles = queryArgProfiles;
            return this;
        }

        public final void setQueryArgProfiles(QueryArgProfiles.BuilderImpl queryArgProfiles) {
            this.queryArgProfiles = queryArgProfiles != null ? queryArgProfiles.build() : null;
        }

        @Override
        public QueryArgProfileConfig build() {
            return new QueryArgProfileConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
