/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.Response;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.util.VersionInfo;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.xml.AwsXmlProtocolFactory;
import software.amazon.awssdk.protocols.xml.XmlOperationMetadata;
import software.amazon.awssdk.services.cloudfront.model.AccessDeniedException;
import software.amazon.awssdk.services.cloudfront.model.BatchTooLargeException;
import software.amazon.awssdk.services.cloudfront.model.CannotChangeImmutablePublicKeyFieldsException;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontException;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontOriginAccessIdentityAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontOriginAccessIdentityInUseException;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontRequest;
import software.amazon.awssdk.services.cloudfront.model.CnameAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.CreateCloudFrontOriginAccessIdentityRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateCloudFrontOriginAccessIdentityResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateDistributionResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateDistributionWithTagsRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateDistributionWithTagsResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateFieldLevelEncryptionConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateFieldLevelEncryptionConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateFieldLevelEncryptionProfileRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateFieldLevelEncryptionProfileResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateInvalidationRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateInvalidationResponse;
import software.amazon.awssdk.services.cloudfront.model.CreatePublicKeyRequest;
import software.amazon.awssdk.services.cloudfront.model.CreatePublicKeyResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateStreamingDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateStreamingDistributionResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateStreamingDistributionWithTagsRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateStreamingDistributionWithTagsResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteCloudFrontOriginAccessIdentityRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteCloudFrontOriginAccessIdentityResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteDistributionResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteFieldLevelEncryptionConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteFieldLevelEncryptionConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteFieldLevelEncryptionProfileRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteFieldLevelEncryptionProfileResponse;
import software.amazon.awssdk.services.cloudfront.model.DeletePublicKeyRequest;
import software.amazon.awssdk.services.cloudfront.model.DeletePublicKeyResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteStreamingDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteStreamingDistributionResponse;
import software.amazon.awssdk.services.cloudfront.model.DistributionAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.DistributionNotDisabledException;
import software.amazon.awssdk.services.cloudfront.model.FieldLevelEncryptionConfigAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.FieldLevelEncryptionConfigInUseException;
import software.amazon.awssdk.services.cloudfront.model.FieldLevelEncryptionProfileAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.FieldLevelEncryptionProfileInUseException;
import software.amazon.awssdk.services.cloudfront.model.FieldLevelEncryptionProfileSizeExceededException;
import software.amazon.awssdk.services.cloudfront.model.GetCloudFrontOriginAccessIdentityConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetCloudFrontOriginAccessIdentityConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetCloudFrontOriginAccessIdentityRequest;
import software.amazon.awssdk.services.cloudfront.model.GetCloudFrontOriginAccessIdentityResponse;
import software.amazon.awssdk.services.cloudfront.model.GetDistributionConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetDistributionConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.GetDistributionResponse;
import software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionProfileConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionProfileConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionProfileRequest;
import software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionProfileResponse;
import software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionRequest;
import software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionResponse;
import software.amazon.awssdk.services.cloudfront.model.GetInvalidationRequest;
import software.amazon.awssdk.services.cloudfront.model.GetInvalidationResponse;
import software.amazon.awssdk.services.cloudfront.model.GetPublicKeyConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetPublicKeyConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetPublicKeyRequest;
import software.amazon.awssdk.services.cloudfront.model.GetPublicKeyResponse;
import software.amazon.awssdk.services.cloudfront.model.GetStreamingDistributionConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetStreamingDistributionConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetStreamingDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.GetStreamingDistributionResponse;
import software.amazon.awssdk.services.cloudfront.model.IllegalFieldLevelEncryptionConfigAssociationWithCacheBehaviorException;
import software.amazon.awssdk.services.cloudfront.model.IllegalUpdateException;
import software.amazon.awssdk.services.cloudfront.model.InconsistentQuantitiesException;
import software.amazon.awssdk.services.cloudfront.model.InvalidArgumentException;
import software.amazon.awssdk.services.cloudfront.model.InvalidDefaultRootObjectException;
import software.amazon.awssdk.services.cloudfront.model.InvalidErrorCodeException;
import software.amazon.awssdk.services.cloudfront.model.InvalidForwardCookiesException;
import software.amazon.awssdk.services.cloudfront.model.InvalidGeoRestrictionParameterException;
import software.amazon.awssdk.services.cloudfront.model.InvalidHeadersForS3OriginException;
import software.amazon.awssdk.services.cloudfront.model.InvalidIfMatchVersionException;
import software.amazon.awssdk.services.cloudfront.model.InvalidLambdaFunctionAssociationException;
import software.amazon.awssdk.services.cloudfront.model.InvalidLocationCodeException;
import software.amazon.awssdk.services.cloudfront.model.InvalidMinimumProtocolVersionException;
import software.amazon.awssdk.services.cloudfront.model.InvalidOriginAccessIdentityException;
import software.amazon.awssdk.services.cloudfront.model.InvalidOriginException;
import software.amazon.awssdk.services.cloudfront.model.InvalidOriginKeepaliveTimeoutException;
import software.amazon.awssdk.services.cloudfront.model.InvalidOriginReadTimeoutException;
import software.amazon.awssdk.services.cloudfront.model.InvalidProtocolSettingsException;
import software.amazon.awssdk.services.cloudfront.model.InvalidQueryStringParametersException;
import software.amazon.awssdk.services.cloudfront.model.InvalidRelativePathException;
import software.amazon.awssdk.services.cloudfront.model.InvalidRequiredProtocolException;
import software.amazon.awssdk.services.cloudfront.model.InvalidResponseCodeException;
import software.amazon.awssdk.services.cloudfront.model.InvalidTaggingException;
import software.amazon.awssdk.services.cloudfront.model.InvalidTtlOrderException;
import software.amazon.awssdk.services.cloudfront.model.InvalidViewerCertificateException;
import software.amazon.awssdk.services.cloudfront.model.InvalidWebAclIdException;
import software.amazon.awssdk.services.cloudfront.model.ListCloudFrontOriginAccessIdentitiesRequest;
import software.amazon.awssdk.services.cloudfront.model.ListCloudFrontOriginAccessIdentitiesResponse;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsByWebAclIdRequest;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsByWebAclIdResponse;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsRequest;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsResponse;
import software.amazon.awssdk.services.cloudfront.model.ListFieldLevelEncryptionConfigsRequest;
import software.amazon.awssdk.services.cloudfront.model.ListFieldLevelEncryptionConfigsResponse;
import software.amazon.awssdk.services.cloudfront.model.ListFieldLevelEncryptionProfilesRequest;
import software.amazon.awssdk.services.cloudfront.model.ListFieldLevelEncryptionProfilesResponse;
import software.amazon.awssdk.services.cloudfront.model.ListInvalidationsRequest;
import software.amazon.awssdk.services.cloudfront.model.ListInvalidationsResponse;
import software.amazon.awssdk.services.cloudfront.model.ListPublicKeysRequest;
import software.amazon.awssdk.services.cloudfront.model.ListPublicKeysResponse;
import software.amazon.awssdk.services.cloudfront.model.ListStreamingDistributionsRequest;
import software.amazon.awssdk.services.cloudfront.model.ListStreamingDistributionsResponse;
import software.amazon.awssdk.services.cloudfront.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.cloudfront.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.cloudfront.model.MissingBodyException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchCloudFrontOriginAccessIdentityException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchDistributionException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchFieldLevelEncryptionConfigException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchFieldLevelEncryptionProfileException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchInvalidationException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchOriginException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchPublicKeyException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchResourceException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchStreamingDistributionException;
import software.amazon.awssdk.services.cloudfront.model.PreconditionFailedException;
import software.amazon.awssdk.services.cloudfront.model.PublicKeyAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.PublicKeyInUseException;
import software.amazon.awssdk.services.cloudfront.model.QueryArgProfileEmptyException;
import software.amazon.awssdk.services.cloudfront.model.StreamingDistributionAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.StreamingDistributionNotDisabledException;
import software.amazon.awssdk.services.cloudfront.model.TagResourceRequest;
import software.amazon.awssdk.services.cloudfront.model.TagResourceResponse;
import software.amazon.awssdk.services.cloudfront.model.TooManyCacheBehaviorsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyCertificatesException;
import software.amazon.awssdk.services.cloudfront.model.TooManyCloudFrontOriginAccessIdentitiesException;
import software.amazon.awssdk.services.cloudfront.model.TooManyCookieNamesInWhiteListException;
import software.amazon.awssdk.services.cloudfront.model.TooManyDistributionCnamEsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyDistributionsAssociatedToFieldLevelEncryptionConfigException;
import software.amazon.awssdk.services.cloudfront.model.TooManyDistributionsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyDistributionsWithLambdaAssociationsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyFieldLevelEncryptionConfigsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyFieldLevelEncryptionContentTypeProfilesException;
import software.amazon.awssdk.services.cloudfront.model.TooManyFieldLevelEncryptionEncryptionEntitiesException;
import software.amazon.awssdk.services.cloudfront.model.TooManyFieldLevelEncryptionFieldPatternsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyFieldLevelEncryptionProfilesException;
import software.amazon.awssdk.services.cloudfront.model.TooManyFieldLevelEncryptionQueryArgProfilesException;
import software.amazon.awssdk.services.cloudfront.model.TooManyHeadersInForwardedValuesException;
import software.amazon.awssdk.services.cloudfront.model.TooManyInvalidationsInProgressException;
import software.amazon.awssdk.services.cloudfront.model.TooManyLambdaFunctionAssociationsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyOriginCustomHeadersException;
import software.amazon.awssdk.services.cloudfront.model.TooManyOriginGroupsPerDistributionException;
import software.amazon.awssdk.services.cloudfront.model.TooManyOriginsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyPublicKeysException;
import software.amazon.awssdk.services.cloudfront.model.TooManyQueryStringParametersException;
import software.amazon.awssdk.services.cloudfront.model.TooManyStreamingDistributionCnamEsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyStreamingDistributionsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyTrustedSignersException;
import software.amazon.awssdk.services.cloudfront.model.TrustedSignerDoesNotExistException;
import software.amazon.awssdk.services.cloudfront.model.UntagResourceRequest;
import software.amazon.awssdk.services.cloudfront.model.UntagResourceResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateCloudFrontOriginAccessIdentityRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateCloudFrontOriginAccessIdentityResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateDistributionResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateFieldLevelEncryptionConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateFieldLevelEncryptionConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateFieldLevelEncryptionProfileRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateFieldLevelEncryptionProfileResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdatePublicKeyRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdatePublicKeyResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateStreamingDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateStreamingDistributionResponse;
import software.amazon.awssdk.services.cloudfront.transform.CreateCloudFrontOriginAccessIdentityRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateDistributionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateDistributionWithTagsRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateFieldLevelEncryptionConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateFieldLevelEncryptionProfileRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateInvalidationRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreatePublicKeyRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateStreamingDistributionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateStreamingDistributionWithTagsRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.DeleteCloudFrontOriginAccessIdentityRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.DeleteDistributionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.DeleteFieldLevelEncryptionConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.DeleteFieldLevelEncryptionProfileRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.DeletePublicKeyRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.DeleteStreamingDistributionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetCloudFrontOriginAccessIdentityConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetCloudFrontOriginAccessIdentityRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetDistributionConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetDistributionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetFieldLevelEncryptionConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetFieldLevelEncryptionProfileConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetFieldLevelEncryptionProfileRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetFieldLevelEncryptionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetInvalidationRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetPublicKeyConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetPublicKeyRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetStreamingDistributionConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetStreamingDistributionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListCloudFrontOriginAccessIdentitiesRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListDistributionsByWebAclIdRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListDistributionsRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListFieldLevelEncryptionConfigsRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListFieldLevelEncryptionProfilesRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListInvalidationsRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListPublicKeysRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListStreamingDistributionsRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.UpdateCloudFrontOriginAccessIdentityRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.UpdateDistributionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.UpdateFieldLevelEncryptionConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.UpdateFieldLevelEncryptionProfileRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.UpdatePublicKeyRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.UpdateStreamingDistributionRequestMarshaller;

/**
 * Internal implementation of {@link CloudFrontClient}.
 *
 * @see CloudFrontClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultCloudFrontClient implements CloudFrontClient {
    private final SyncClientHandler clientHandler;

    private final AwsXmlProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultCloudFrontClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = init();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    /**
     * <p>
     * Creates a new origin access identity. If you're using Amazon S3 for your origin, you can use an origin access
     * identity to require users to access your content using a CloudFront URL instead of the Amazon S3 URL. For more
     * information about how to use origin access identities, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving Private
     * Content through CloudFront</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     *
     * @param createCloudFrontOriginAccessIdentityRequest
     *        The request to create a new origin access identity (OAI). An origin access identity is a special
     *        CloudFront user that you can associate with Amazon S3 origins, so that you can secure all or just some of
     *        your Amazon S3 content. For more information, see <a href=
     *        "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-s3.html"
     *        > Restricting Access to Amazon S3 Content by Using an Origin Access Identity</a> in the <i>Amazon
     *        CloudFront Developer Guide</i>.
     * @return Result of the CreateCloudFrontOriginAccessIdentity operation returned by the service.
     * @throws CloudFrontOriginAccessIdentityAlreadyExistsException
     *         If the <code>CallerReference</code> is a value you already sent in a previous request to create an
     *         identity but the content of the <code>CloudFrontOriginAccessIdentityConfig</code> is different from the
     *         original request, CloudFront returns a <code>CloudFrontOriginAccessIdentityAlreadyExists</code> error.
     * @throws MissingBodyException
     *         This operation requires a body. Ensure that the body is present and the <code>Content-Type</code> header
     *         is set.
     * @throws TooManyCloudFrontOriginAccessIdentitiesException
     *         Processing your request would cause you to exceed the maximum number of origin access identities allowed.
     * @throws InvalidArgumentException
     *         The argument is invalid.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.CreateCloudFrontOriginAccessIdentity
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/CreateCloudFrontOriginAccessIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateCloudFrontOriginAccessIdentityResponse createCloudFrontOriginAccessIdentity(
            CreateCloudFrontOriginAccessIdentityRequest createCloudFrontOriginAccessIdentityRequest)
            throws CloudFrontOriginAccessIdentityAlreadyExistsException, MissingBodyException,
            TooManyCloudFrontOriginAccessIdentitiesException, InvalidArgumentException, InconsistentQuantitiesException,
            AwsServiceException, SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<CreateCloudFrontOriginAccessIdentityResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(CreateCloudFrontOriginAccessIdentityResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

        return clientHandler
                .execute(new ClientExecutionParams<CreateCloudFrontOriginAccessIdentityRequest, CreateCloudFrontOriginAccessIdentityResponse>()
                        .withOperationName("CreateCloudFrontOriginAccessIdentity").withCombinedResponseHandler(responseHandler)
                        .withInput(createCloudFrontOriginAccessIdentityRequest)
                        .withMarshaller(new CreateCloudFrontOriginAccessIdentityRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates a new web distribution. You create a CloudFront distribution to tell CloudFront where you want content to
     * be delivered from, and the details about how to track and manage content delivery. Send a <code>POST</code>
     * request to the <code>/<i>CloudFront API version</i>/distribution</code>/<code>distribution ID</code> resource.
     * </p>
     * <important>
     * <p>
     * When you update a distribution, there are more required fields than when you create a distribution. When you
     * update your distribution by using <a
     * href="https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_UpdateDistribution.html"
     * >UpdateDistribution</a>, follow the steps included in the documentation to get the current configuration and then
     * make your updates. This helps to make sure that you include all of the required fields. To view a summary, see <a
     * href
     * ="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-overview-required-fields.html"
     * >Required Fields for Create Distribution and Update Distribution</a> in the <i>Amazon CloudFront Developer
     * Guide</i>.
     * </p>
     * </important>
     *
     * @param createDistributionRequest
     *        The request to create a new distribution.
     * @return Result of the CreateDistribution operation returned by the service.
     * @throws CnameAlreadyExistsException
     *         The CNAME specified is already defined for CloudFront.
     * @throws DistributionAlreadyExistsException
     *         The caller reference you attempted to create the distribution with is associated with another
     *         distribution.
     * @throws InvalidOriginException
     *         The Amazon S3 origin server specified does not refer to a valid Amazon S3 bucket.
     * @throws InvalidOriginAccessIdentityException
     *         The origin access identity is not valid or doesn't exist.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws TooManyTrustedSignersException
     *         Your request contains more trusted signers than are allowed per distribution.
     * @throws TrustedSignerDoesNotExistException
     *         One or more of your trusted signers don't exist.
     * @throws InvalidViewerCertificateException
     *         A viewer certificate specified is not valid.
     * @throws InvalidMinimumProtocolVersionException
     *         The minimum protocol version specified is not valid.
     * @throws MissingBodyException
     *         This operation requires a body. Ensure that the body is present and the <code>Content-Type</code> header
     *         is set.
     * @throws TooManyDistributionCnamEsException
     *         Your request contains more CNAMEs than are allowed per distribution.
     * @throws TooManyDistributionsException
     *         Processing your request would cause you to exceed the maximum number of distributions allowed.
     * @throws InvalidDefaultRootObjectException
     *         The default root object file name is too big or contains an invalid character.
     * @throws InvalidRelativePathException
     *         The relative path is too big, is not URL-encoded, or does not begin with a slash (/).
     * @throws InvalidErrorCodeException
     *         An invalid error code was specified.
     * @throws InvalidResponseCodeException
     *         A response code is not valid.
     * @throws InvalidArgumentException
     *         The argument is invalid.
     * @throws InvalidRequiredProtocolException
     *         This operation requires the HTTPS protocol. Ensure that you specify the HTTPS protocol in your request,
     *         or omit the <code>RequiredProtocols</code> element from your distribution configuration.
     * @throws NoSuchOriginException
     *         No origin exists with the specified <code>Origin Id</code>.
     * @throws TooManyOriginsException
     *         You cannot create more origins for the distribution.
     * @throws TooManyOriginGroupsPerDistributionException
     *         Processing your request would cause you to exceed the maximum number of origin groups allowed.
     * @throws TooManyCacheBehaviorsException
     *         You cannot create more cache behaviors for the distribution.
     * @throws TooManyCookieNamesInWhiteListException
     *         Your request contains more cookie names in the whitelist than are allowed per cache behavior.
     * @throws InvalidForwardCookiesException
     *         Your request contains forward cookies option which doesn't match with the expectation for the
     *         <code>whitelisted</code> list of cookie names. Either list of cookie names has been specified when not
     *         allowed or list of cookie names is missing when expected.
     * @throws TooManyHeadersInForwardedValuesException
     *         Your request contains too many headers in forwarded values.
     * @throws InvalidHeadersForS3OriginException
     *         The headers specified are not valid for an Amazon S3 origin.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws TooManyCertificatesException
     *         You cannot create anymore custom SSL/TLS certificates.
     * @throws InvalidLocationCodeException
     *         The location code specified is not valid.
     * @throws InvalidGeoRestrictionParameterException
     *         The specified geo restriction parameter is not valid.
     * @throws InvalidProtocolSettingsException
     *         You cannot specify SSLv3 as the minimum protocol version if you only want to support only clients that
     *         support Server Name Indication (SNI).
     * @throws InvalidTtlOrderException
     *         The TTL order specified is not valid.
     * @throws InvalidWebAclIdException
     *         A web ACL ID specified is not valid. To specify a web ACL created using the latest version of AWS WAF,
     *         use the ACL ARN, for example
     *         <code>arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/473e64fd-f30b-4765-81a0-62ad96dd167a</code>
     *         . To specify a web ACL created using AWS WAF Classic, use the ACL ID, for example
     *         <code>473e64fd-f30b-4765-81a0-62ad96dd167a</code>.
     * @throws TooManyOriginCustomHeadersException
     *         Your request contains too many origin custom headers.
     * @throws TooManyQueryStringParametersException
     *         Your request contains too many query string parameters.
     * @throws InvalidQueryStringParametersException
     *         The query string parameters specified are not valid.
     * @throws TooManyDistributionsWithLambdaAssociationsException
     *         Processing your request would cause the maximum number of distributions with Lambda function associations
     *         per owner to be exceeded.
     * @throws TooManyLambdaFunctionAssociationsException
     *         Your request contains more Lambda function associations than are allowed per distribution.
     * @throws InvalidLambdaFunctionAssociationException
     *         The specified Lambda function association is invalid.
     * @throws InvalidOriginReadTimeoutException
     *         The read timeout specified for the origin is not valid.
     * @throws InvalidOriginKeepaliveTimeoutException
     *         The keep alive timeout specified for the origin is not valid.
     * @throws NoSuchFieldLevelEncryptionConfigException
     *         The specified configuration for field-level encryption doesn't exist.
     * @throws IllegalFieldLevelEncryptionConfigAssociationWithCacheBehaviorException
     *         The specified configuration for field-level encryption can't be associated with the specified cache
     *         behavior.
     * @throws TooManyDistributionsAssociatedToFieldLevelEncryptionConfigException
     *         The maximum number of distributions have been associated with the specified configuration for field-level
     *         encryption.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.CreateDistribution
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/CreateDistribution" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateDistributionResponse createDistribution(CreateDistributionRequest createDistributionRequest)
            throws CnameAlreadyExistsException, DistributionAlreadyExistsException, InvalidOriginException,
            InvalidOriginAccessIdentityException, AccessDeniedException, TooManyTrustedSignersException,
            TrustedSignerDoesNotExistException, InvalidViewerCertificateException, InvalidMinimumProtocolVersionException,
            MissingBodyException, TooManyDistributionCnamEsException, TooManyDistributionsException,
            InvalidDefaultRootObjectException, InvalidRelativePathException, InvalidErrorCodeException,
            InvalidResponseCodeException, InvalidArgumentException, InvalidRequiredProtocolException, NoSuchOriginException,
            TooManyOriginsException, TooManyOriginGroupsPerDistributionException, TooManyCacheBehaviorsException,
            TooManyCookieNamesInWhiteListException, InvalidForwardCookiesException, TooManyHeadersInForwardedValuesException,
            InvalidHeadersForS3OriginException, InconsistentQuantitiesException, TooManyCertificatesException,
            InvalidLocationCodeException, InvalidGeoRestrictionParameterException, InvalidProtocolSettingsException,
            InvalidTtlOrderException, InvalidWebAclIdException, TooManyOriginCustomHeadersException,
            TooManyQueryStringParametersException, InvalidQueryStringParametersException,
            TooManyDistributionsWithLambdaAssociationsException, TooManyLambdaFunctionAssociationsException,
            InvalidLambdaFunctionAssociationException, InvalidOriginReadTimeoutException, InvalidOriginKeepaliveTimeoutException,
            NoSuchFieldLevelEncryptionConfigException, IllegalFieldLevelEncryptionConfigAssociationWithCacheBehaviorException,
            TooManyDistributionsAssociatedToFieldLevelEncryptionConfigException, AwsServiceException, SdkClientException,
            CloudFrontException {

        HttpResponseHandler<Response<CreateDistributionResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(CreateDistributionResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

        return clientHandler.execute(new ClientExecutionParams<CreateDistributionRequest, CreateDistributionResponse>()
                .withOperationName("CreateDistribution").withCombinedResponseHandler(responseHandler)
                .withInput(createDistributionRequest).withMarshaller(new CreateDistributionRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Create a new distribution with tags.
     * </p>
     *
     * @param createDistributionWithTagsRequest
     *        The request to create a new distribution with tags.
     * @return Result of the CreateDistributionWithTags operation returned by the service.
     * @throws CnameAlreadyExistsException
     *         The CNAME specified is already defined for CloudFront.
     * @throws DistributionAlreadyExistsException
     *         The caller reference you attempted to create the distribution with is associated with another
     *         distribution.
     * @throws InvalidOriginException
     *         The Amazon S3 origin server specified does not refer to a valid Amazon S3 bucket.
     * @throws InvalidOriginAccessIdentityException
     *         The origin access identity is not valid or doesn't exist.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws TooManyTrustedSignersException
     *         Your request contains more trusted signers than are allowed per distribution.
     * @throws TrustedSignerDoesNotExistException
     *         One or more of your trusted signers don't exist.
     * @throws InvalidViewerCertificateException
     *         A viewer certificate specified is not valid.
     * @throws InvalidMinimumProtocolVersionException
     *         The minimum protocol version specified is not valid.
     * @throws MissingBodyException
     *         This operation requires a body. Ensure that the body is present and the <code>Content-Type</code> header
     *         is set.
     * @throws TooManyDistributionCnamEsException
     *         Your request contains more CNAMEs than are allowed per distribution.
     * @throws TooManyDistributionsException
     *         Processing your request would cause you to exceed the maximum number of distributions allowed.
     * @throws InvalidDefaultRootObjectException
     *         The default root object file name is too big or contains an invalid character.
     * @throws InvalidRelativePathException
     *         The relative path is too big, is not URL-encoded, or does not begin with a slash (/).
     * @throws InvalidErrorCodeException
     *         An invalid error code was specified.
     * @throws InvalidResponseCodeException
     *         A response code is not valid.
     * @throws InvalidArgumentException
     *         The argument is invalid.
     * @throws InvalidRequiredProtocolException
     *         This operation requires the HTTPS protocol. Ensure that you specify the HTTPS protocol in your request,
     *         or omit the <code>RequiredProtocols</code> element from your distribution configuration.
     * @throws NoSuchOriginException
     *         No origin exists with the specified <code>Origin Id</code>.
     * @throws TooManyOriginsException
     *         You cannot create more origins for the distribution.
     * @throws TooManyOriginGroupsPerDistributionException
     *         Processing your request would cause you to exceed the maximum number of origin groups allowed.
     * @throws TooManyCacheBehaviorsException
     *         You cannot create more cache behaviors for the distribution.
     * @throws TooManyCookieNamesInWhiteListException
     *         Your request contains more cookie names in the whitelist than are allowed per cache behavior.
     * @throws InvalidForwardCookiesException
     *         Your request contains forward cookies option which doesn't match with the expectation for the
     *         <code>whitelisted</code> list of cookie names. Either list of cookie names has been specified when not
     *         allowed or list of cookie names is missing when expected.
     * @throws TooManyHeadersInForwardedValuesException
     *         Your request contains too many headers in forwarded values.
     * @throws InvalidHeadersForS3OriginException
     *         The headers specified are not valid for an Amazon S3 origin.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws TooManyCertificatesException
     *         You cannot create anymore custom SSL/TLS certificates.
     * @throws InvalidLocationCodeException
     *         The location code specified is not valid.
     * @throws InvalidGeoRestrictionParameterException
     *         The specified geo restriction parameter is not valid.
     * @throws InvalidProtocolSettingsException
     *         You cannot specify SSLv3 as the minimum protocol version if you only want to support only clients that
     *         support Server Name Indication (SNI).
     * @throws InvalidTtlOrderException
     *         The TTL order specified is not valid.
     * @throws InvalidWebAclIdException
     *         A web ACL ID specified is not valid. To specify a web ACL created using the latest version of AWS WAF,
     *         use the ACL ARN, for example
     *         <code>arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/473e64fd-f30b-4765-81a0-62ad96dd167a</code>
     *         . To specify a web ACL created using AWS WAF Classic, use the ACL ID, for example
     *         <code>473e64fd-f30b-4765-81a0-62ad96dd167a</code>.
     * @throws TooManyOriginCustomHeadersException
     *         Your request contains too many origin custom headers.
     * @throws InvalidTaggingException
     *         The tagging specified is not valid.
     * @throws TooManyQueryStringParametersException
     *         Your request contains too many query string parameters.
     * @throws InvalidQueryStringParametersException
     *         The query string parameters specified are not valid.
     * @throws TooManyDistributionsWithLambdaAssociationsException
     *         Processing your request would cause the maximum number of distributions with Lambda function associations
     *         per owner to be exceeded.
     * @throws TooManyLambdaFunctionAssociationsException
     *         Your request contains more Lambda function associations than are allowed per distribution.
     * @throws InvalidLambdaFunctionAssociationException
     *         The specified Lambda function association is invalid.
     * @throws InvalidOriginReadTimeoutException
     *         The read timeout specified for the origin is not valid.
     * @throws InvalidOriginKeepaliveTimeoutException
     *         The keep alive timeout specified for the origin is not valid.
     * @throws NoSuchFieldLevelEncryptionConfigException
     *         The specified configuration for field-level encryption doesn't exist.
     * @throws IllegalFieldLevelEncryptionConfigAssociationWithCacheBehaviorException
     *         The specified configuration for field-level encryption can't be associated with the specified cache
     *         behavior.
     * @throws TooManyDistributionsAssociatedToFieldLevelEncryptionConfigException
     *         The maximum number of distributions have been associated with the specified configuration for field-level
     *         encryption.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.CreateDistributionWithTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/CreateDistributionWithTags"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateDistributionWithTagsResponse createDistributionWithTags(
            CreateDistributionWithTagsRequest createDistributionWithTagsRequest) throws CnameAlreadyExistsException,
            DistributionAlreadyExistsException, InvalidOriginException, InvalidOriginAccessIdentityException,
            AccessDeniedException, TooManyTrustedSignersException, TrustedSignerDoesNotExistException,
            InvalidViewerCertificateException, InvalidMinimumProtocolVersionException, MissingBodyException,
            TooManyDistributionCnamEsException, TooManyDistributionsException, InvalidDefaultRootObjectException,
            InvalidRelativePathException, InvalidErrorCodeException, InvalidResponseCodeException, InvalidArgumentException,
            InvalidRequiredProtocolException, NoSuchOriginException, TooManyOriginsException,
            TooManyOriginGroupsPerDistributionException, TooManyCacheBehaviorsException, TooManyCookieNamesInWhiteListException,
            InvalidForwardCookiesException, TooManyHeadersInForwardedValuesException, InvalidHeadersForS3OriginException,
            InconsistentQuantitiesException, TooManyCertificatesException, InvalidLocationCodeException,
            InvalidGeoRestrictionParameterException, InvalidProtocolSettingsException, InvalidTtlOrderException,
            InvalidWebAclIdException, TooManyOriginCustomHeadersException, InvalidTaggingException,
            TooManyQueryStringParametersException, InvalidQueryStringParametersException,
            TooManyDistributionsWithLambdaAssociationsException, TooManyLambdaFunctionAssociationsException,
            InvalidLambdaFunctionAssociationException, InvalidOriginReadTimeoutException, InvalidOriginKeepaliveTimeoutException,
            NoSuchFieldLevelEncryptionConfigException, IllegalFieldLevelEncryptionConfigAssociationWithCacheBehaviorException,
            TooManyDistributionsAssociatedToFieldLevelEncryptionConfigException, AwsServiceException, SdkClientException,
            CloudFrontException {

        HttpResponseHandler<Response<CreateDistributionWithTagsResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(CreateDistributionWithTagsResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

        return clientHandler
                .execute(new ClientExecutionParams<CreateDistributionWithTagsRequest, CreateDistributionWithTagsResponse>()
                        .withOperationName("CreateDistributionWithTags").withCombinedResponseHandler(responseHandler)
                        .withInput(createDistributionWithTagsRequest)
                        .withMarshaller(new CreateDistributionWithTagsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Create a new field-level encryption configuration.
     * </p>
     *
     * @param createFieldLevelEncryptionConfigRequest
     * @return Result of the CreateFieldLevelEncryptionConfig operation returned by the service.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws InvalidArgumentException
     *         The argument is invalid.
     * @throws NoSuchFieldLevelEncryptionProfileException
     *         The specified profile for field-level encryption doesn't exist.
     * @throws FieldLevelEncryptionConfigAlreadyExistsException
     *         The specified configuration for field-level encryption already exists.
     * @throws TooManyFieldLevelEncryptionConfigsException
     *         The maximum number of configurations for field-level encryption have been created.
     * @throws TooManyFieldLevelEncryptionQueryArgProfilesException
     *         The maximum number of query arg profiles for field-level encryption have been created.
     * @throws TooManyFieldLevelEncryptionContentTypeProfilesException
     *         The maximum number of content type profiles for field-level encryption have been created.
     * @throws QueryArgProfileEmptyException
     *         No profile specified for the field-level encryption query argument.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.CreateFieldLevelEncryptionConfig
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/CreateFieldLevelEncryptionConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateFieldLevelEncryptionConfigResponse createFieldLevelEncryptionConfig(
            CreateFieldLevelEncryptionConfigRequest createFieldLevelEncryptionConfigRequest)
            throws InconsistentQuantitiesException, InvalidArgumentException, NoSuchFieldLevelEncryptionProfileException,
            FieldLevelEncryptionConfigAlreadyExistsException, TooManyFieldLevelEncryptionConfigsException,
            TooManyFieldLevelEncryptionQueryArgProfilesException, TooManyFieldLevelEncryptionContentTypeProfilesException,
            QueryArgProfileEmptyException, AwsServiceException, SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<CreateFieldLevelEncryptionConfigResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(CreateFieldLevelEncryptionConfigResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

        return clientHandler
                .execute(new ClientExecutionParams<CreateFieldLevelEncryptionConfigRequest, CreateFieldLevelEncryptionConfigResponse>()
                        .withOperationName("CreateFieldLevelEncryptionConfig").withCombinedResponseHandler(responseHandler)
                        .withInput(createFieldLevelEncryptionConfigRequest)
                        .withMarshaller(new CreateFieldLevelEncryptionConfigRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Create a field-level encryption profile.
     * </p>
     *
     * @param createFieldLevelEncryptionProfileRequest
     * @return Result of the CreateFieldLevelEncryptionProfile operation returned by the service.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws InvalidArgumentException
     *         The argument is invalid.
     * @throws NoSuchPublicKeyException
     *         The specified public key doesn't exist.
     * @throws FieldLevelEncryptionProfileAlreadyExistsException
     *         The specified profile for field-level encryption already exists.
     * @throws FieldLevelEncryptionProfileSizeExceededException
     *         The maximum size of a profile for field-level encryption was exceeded.
     * @throws TooManyFieldLevelEncryptionProfilesException
     *         The maximum number of profiles for field-level encryption have been created.
     * @throws TooManyFieldLevelEncryptionEncryptionEntitiesException
     *         The maximum number of encryption entities for field-level encryption have been created.
     * @throws TooManyFieldLevelEncryptionFieldPatternsException
     *         The maximum number of field patterns for field-level encryption have been created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.CreateFieldLevelEncryptionProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/CreateFieldLevelEncryptionProfile"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateFieldLevelEncryptionProfileResponse createFieldLevelEncryptionProfile(
            CreateFieldLevelEncryptionProfileRequest createFieldLevelEncryptionProfileRequest)
            throws InconsistentQuantitiesException, InvalidArgumentException, NoSuchPublicKeyException,
            FieldLevelEncryptionProfileAlreadyExistsException, FieldLevelEncryptionProfileSizeExceededException,
            TooManyFieldLevelEncryptionProfilesException, TooManyFieldLevelEncryptionEncryptionEntitiesException,
            TooManyFieldLevelEncryptionFieldPatternsException, AwsServiceException, SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<CreateFieldLevelEncryptionProfileResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(CreateFieldLevelEncryptionProfileResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

        return clientHandler
                .execute(new ClientExecutionParams<CreateFieldLevelEncryptionProfileRequest, CreateFieldLevelEncryptionProfileResponse>()
                        .withOperationName("CreateFieldLevelEncryptionProfile").withCombinedResponseHandler(responseHandler)
                        .withInput(createFieldLevelEncryptionProfileRequest)
                        .withMarshaller(new CreateFieldLevelEncryptionProfileRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Create a new invalidation.
     * </p>
     *
     * @param createInvalidationRequest
     *        The request to create an invalidation.
     * @return Result of the CreateInvalidation operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws MissingBodyException
     *         This operation requires a body. Ensure that the body is present and the <code>Content-Type</code> header
     *         is set.
     * @throws InvalidArgumentException
     *         The argument is invalid.
     * @throws NoSuchDistributionException
     *         The specified distribution does not exist.
     * @throws BatchTooLargeException
     *         Invalidation batch specified is too large.
     * @throws TooManyInvalidationsInProgressException
     *         You have exceeded the maximum number of allowable InProgress invalidation batch requests, or invalidation
     *         objects.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.CreateInvalidation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/CreateInvalidation" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateInvalidationResponse createInvalidation(CreateInvalidationRequest createInvalidationRequest)
            throws AccessDeniedException, MissingBodyException, InvalidArgumentException, NoSuchDistributionException,
            BatchTooLargeException, TooManyInvalidationsInProgressException, InconsistentQuantitiesException,
            AwsServiceException, SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<CreateInvalidationResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(CreateInvalidationResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

        return clientHandler.execute(new ClientExecutionParams<CreateInvalidationRequest, CreateInvalidationResponse>()
                .withOperationName("CreateInvalidation").withCombinedResponseHandler(responseHandler)
                .withInput(createInvalidationRequest).withMarshaller(new CreateInvalidationRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Add a new public key to CloudFront to use, for example, for field-level encryption. You can add a maximum of 10
     * public keys with one AWS account.
     * </p>
     *
     * @param createPublicKeyRequest
     * @return Result of the CreatePublicKey operation returned by the service.
     * @throws PublicKeyAlreadyExistsException
     *         The specified public key already exists.
     * @throws InvalidArgumentException
     *         The argument is invalid.
     * @throws TooManyPublicKeysException
     *         The maximum number of public keys for field-level encryption have been created. To create a new public
     *         key, delete one of the existing keys.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.CreatePublicKey
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/CreatePublicKey" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreatePublicKeyResponse createPublicKey(CreatePublicKeyRequest createPublicKeyRequest)
            throws PublicKeyAlreadyExistsException, InvalidArgumentException, TooManyPublicKeysException, AwsServiceException,
            SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<CreatePublicKeyResponse>> responseHandler = protocolFactory.createCombinedResponseHandler(
                CreatePublicKeyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

        return clientHandler.execute(new ClientExecutionParams<CreatePublicKeyRequest, CreatePublicKeyResponse>()
                .withOperationName("CreatePublicKey").withCombinedResponseHandler(responseHandler)
                .withInput(createPublicKeyRequest).withMarshaller(new CreatePublicKeyRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates a new RTMP distribution. An RTMP distribution is similar to a web distribution, but an RTMP distribution
     * streams media files using the Adobe Real-Time Messaging Protocol (RTMP) instead of serving files using HTTP.
     * </p>
     * <p>
     * To create a new distribution, submit a <code>POST</code> request to the <i>CloudFront API
     * version</i>/distribution resource. The request body must include a document with a
     * <i>StreamingDistributionConfig</i> element. The response echoes the <code>StreamingDistributionConfig</code>
     * element and returns other information about the RTMP distribution.
     * </p>
     * <p>
     * To get the status of your request, use the <i>GET StreamingDistribution</i> API action. When the value of
     * <code>Enabled</code> is <code>true</code> and the value of <code>Status</code> is <code>Deployed</code>, your
     * distribution is ready. A distribution usually deploys in less than 15 minutes.
     * </p>
     * <p>
     * For more information about web distributions, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-rtmp.html">Working with
     * RTMP Distributions</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * <important>
     * <p>
     * Beginning with the 2012-05-05 version of the CloudFront API, we made substantial changes to the format of the XML
     * document that you include in the request body when you create or update a web distribution or an RTMP
     * distribution, and when you invalidate objects. With previous versions of the API, we discovered that it was too
     * easy to accidentally delete one or more values for an element that accepts multiple values, for example, CNAMEs
     * and trusted signers. Our changes for the 2012-05-05 release are intended to prevent these accidental deletions
     * and to notify you when there's a mismatch between the number of values you say you're specifying in the
     * <code>Quantity</code> element and the number of values specified.
     * </p>
     * </important>
     *
     * @param createStreamingDistributionRequest
     *        The request to create a new streaming distribution.
     * @return Result of the CreateStreamingDistribution operation returned by the service.
     * @throws CnameAlreadyExistsException
     *         The CNAME specified is already defined for CloudFront.
     * @throws StreamingDistributionAlreadyExistsException
     *         The caller reference you attempted to create the streaming distribution with is associated with another
     *         distribution
     * @throws InvalidOriginException
     *         The Amazon S3 origin server specified does not refer to a valid Amazon S3 bucket.
     * @throws InvalidOriginAccessIdentityException
     *         The origin access identity is not valid or doesn't exist.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws TooManyTrustedSignersException
     *         Your request contains more trusted signers than are allowed per distribution.
     * @throws TrustedSignerDoesNotExistException
     *         One or more of your trusted signers don't exist.
     * @throws MissingBodyException
     *         This operation requires a body. Ensure that the body is present and the <code>Content-Type</code> header
     *         is set.
     * @throws TooManyStreamingDistributionCnamEsException
     *         Your request contains more CNAMEs than are allowed per distribution.
     * @throws TooManyStreamingDistributionsException
     *         Processing your request would cause you to exceed the maximum number of streaming distributions allowed.
     * @throws InvalidArgumentException
     *         The argument is invalid.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.CreateStreamingDistribution
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/CreateStreamingDistribution"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateStreamingDistributionResponse createStreamingDistribution(
            CreateStreamingDistributionRequest createStreamingDistributionRequest) throws CnameAlreadyExistsException,
            StreamingDistributionAlreadyExistsException, InvalidOriginException, InvalidOriginAccessIdentityException,
            AccessDeniedException, TooManyTrustedSignersException, TrustedSignerDoesNotExistException, MissingBodyException,
            TooManyStreamingDistributionCnamEsException, TooManyStreamingDistributionsException, InvalidArgumentException,
            InconsistentQuantitiesException, AwsServiceException, SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<CreateStreamingDistributionResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(CreateStreamingDistributionResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

        return clientHandler
                .execute(new ClientExecutionParams<CreateStreamingDistributionRequest, CreateStreamingDistributionResponse>()
                        .withOperationName("CreateStreamingDistribution").withCombinedResponseHandler(responseHandler)
                        .withInput(createStreamingDistributionRequest)
                        .withMarshaller(new CreateStreamingDistributionRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Create a new streaming distribution with tags.
     * </p>
     *
     * @param createStreamingDistributionWithTagsRequest
     *        The request to create a new streaming distribution with tags.
     * @return Result of the CreateStreamingDistributionWithTags operation returned by the service.
     * @throws CnameAlreadyExistsException
     *         The CNAME specified is already defined for CloudFront.
     * @throws StreamingDistributionAlreadyExistsException
     *         The caller reference you attempted to create the streaming distribution with is associated with another
     *         distribution
     * @throws InvalidOriginException
     *         The Amazon S3 origin server specified does not refer to a valid Amazon S3 bucket.
     * @throws InvalidOriginAccessIdentityException
     *         The origin access identity is not valid or doesn't exist.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws TooManyTrustedSignersException
     *         Your request contains more trusted signers than are allowed per distribution.
     * @throws TrustedSignerDoesNotExistException
     *         One or more of your trusted signers don't exist.
     * @throws MissingBodyException
     *         This operation requires a body. Ensure that the body is present and the <code>Content-Type</code> header
     *         is set.
     * @throws TooManyStreamingDistributionCnamEsException
     *         Your request contains more CNAMEs than are allowed per distribution.
     * @throws TooManyStreamingDistributionsException
     *         Processing your request would cause you to exceed the maximum number of streaming distributions allowed.
     * @throws InvalidArgumentException
     *         The argument is invalid.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws InvalidTaggingException
     *         The tagging specified is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.CreateStreamingDistributionWithTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/CreateStreamingDistributionWithTags"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateStreamingDistributionWithTagsResponse createStreamingDistributionWithTags(
            CreateStreamingDistributionWithTagsRequest createStreamingDistributionWithTagsRequest)
            throws CnameAlreadyExistsException, StreamingDistributionAlreadyExistsException, InvalidOriginException,
            InvalidOriginAccessIdentityException, AccessDeniedException, TooManyTrustedSignersException,
            TrustedSignerDoesNotExistException, MissingBodyException, TooManyStreamingDistributionCnamEsException,
            TooManyStreamingDistributionsException, InvalidArgumentException, InconsistentQuantitiesException,
            InvalidTaggingException, AwsServiceException, SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<CreateStreamingDistributionWithTagsResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(CreateStreamingDistributionWithTagsResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

        return clientHandler
                .execute(new ClientExecutionParams<CreateStreamingDistributionWithTagsRequest, CreateStreamingDistributionWithTagsResponse>()
                        .withOperationName("CreateStreamingDistributionWithTags").withCombinedResponseHandler(responseHandler)
                        .withInput(createStreamingDistributionWithTagsRequest)
                        .withMarshaller(new CreateStreamingDistributionWithTagsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Delete an origin access identity.
     * </p>
     *
     * @param deleteCloudFrontOriginAccessIdentityRequest
     *        Deletes a origin access identity.
     * @return Result of the DeleteCloudFrontOriginAccessIdentity operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid for the distribution.
     * @throws NoSuchCloudFrontOriginAccessIdentityException
     *         The specified origin access identity does not exist.
     * @throws PreconditionFailedException
     *         The precondition given in one or more of the request-header fields evaluated to <code>false</code>.
     * @throws CloudFrontOriginAccessIdentityInUseException
     *         The Origin Access Identity specified is already in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.DeleteCloudFrontOriginAccessIdentity
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/DeleteCloudFrontOriginAccessIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteCloudFrontOriginAccessIdentityResponse deleteCloudFrontOriginAccessIdentity(
            DeleteCloudFrontOriginAccessIdentityRequest deleteCloudFrontOriginAccessIdentityRequest)
            throws AccessDeniedException, InvalidIfMatchVersionException, NoSuchCloudFrontOriginAccessIdentityException,
            PreconditionFailedException, CloudFrontOriginAccessIdentityInUseException, AwsServiceException, SdkClientException,
            CloudFrontException {

        HttpResponseHandler<Response<DeleteCloudFrontOriginAccessIdentityResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(DeleteCloudFrontOriginAccessIdentityResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

        return clientHandler
                .execute(new ClientExecutionParams<DeleteCloudFrontOriginAccessIdentityRequest, DeleteCloudFrontOriginAccessIdentityResponse>()
                        .withOperationName("DeleteCloudFrontOriginAccessIdentity").withCombinedResponseHandler(responseHandler)
                        .withInput(deleteCloudFrontOriginAccessIdentityRequest)
                        .withMarshaller(new DeleteCloudFrontOriginAccessIdentityRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Delete a distribution.
     * </p>
     *
     * @param deleteDistributionRequest
     *        This action deletes a web distribution. To delete a web distribution using the CloudFront API, perform the
     *        following steps.</p>
     *        <p>
     *        <b>To delete a web distribution using the CloudFront API:</b>
     *        </p>
     *        <ol>
     *        <li>
     *        <p>
     *        Disable the web distribution
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Submit a <code>GET Distribution Config</code> request to get the current configuration and the
     *        <code>Etag</code> header for the distribution.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Update the XML document that was returned in the response to your <code>GET Distribution Config</code>
     *        request to change the value of <code>Enabled</code> to <code>false</code>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Submit a <code>PUT Distribution Config</code> request to update the configuration for your distribution.
     *        In the request body, include the XML document that you updated in Step 3. Set the value of the HTTP
     *        <code>If-Match</code> header to the value of the <code>ETag</code> header that CloudFront returned when
     *        you submitted the <code>GET Distribution Config</code> request in Step 2.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Review the response to the <code>PUT Distribution Config</code> request to confirm that the distribution
     *        was successfully disabled.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Submit a <code>GET Distribution</code> request to confirm that your changes have propagated. When
     *        propagation is complete, the value of <code>Status</code> is <code>Deployed</code>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Submit a <code>DELETE Distribution</code> request. Set the value of the HTTP <code>If-Match</code> header
     *        to the value of the <code>ETag</code> header that CloudFront returned when you submitted the
     *        <code>GET Distribution Config</code> request in Step 6.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Review the response to your <code>DELETE Distribution</code> request to confirm that the distribution was
     *        successfully deleted.
     *        </p>
     *        </li>
     *        </ol>
     *        <p>
     *        For information about deleting a distribution using the CloudFront console, see <a
     *        href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/HowToDeleteDistribution.html"
     *        >Deleting a Distribution</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * @return Result of the DeleteDistribution operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws DistributionNotDisabledException
     *         The specified CloudFront distribution is not disabled. You must disable the distribution before you can
     *         delete it.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid for the distribution.
     * @throws NoSuchDistributionException
     *         The specified distribution does not exist.
     * @throws PreconditionFailedException
     *         The precondition given in one or more of the request-header fields evaluated to <code>false</code>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.DeleteDistribution
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/DeleteDistribution" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteDistributionResponse deleteDistribution(DeleteDistributionRequest deleteDistributionRequest)
            throws AccessDeniedException, DistributionNotDisabledException, InvalidIfMatchVersionException,
            NoSuchDistributionException, PreconditionFailedException, AwsServiceException, SdkClientException,
            CloudFrontException {

        HttpResponseHandler<Response<DeleteDistributionResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(DeleteDistributionResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

        return clientHandler.execute(new ClientExecutionParams<DeleteDistributionRequest, DeleteDistributionResponse>()
                .withOperationName("DeleteDistribution").withCombinedResponseHandler(responseHandler)
                .withInput(deleteDistributionRequest).withMarshaller(new DeleteDistributionRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Remove a field-level encryption configuration.
     * </p>
     *
     * @param deleteFieldLevelEncryptionConfigRequest
     * @return Result of the DeleteFieldLevelEncryptionConfig operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid for the distribution.
     * @throws NoSuchFieldLevelEncryptionConfigException
     *         The specified configuration for field-level encryption doesn't exist.
     * @throws PreconditionFailedException
     *         The precondition given in one or more of the request-header fields evaluated to <code>false</code>.
     * @throws FieldLevelEncryptionConfigInUseException
     *         The specified configuration for field-level encryption is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.DeleteFieldLevelEncryptionConfig
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/DeleteFieldLevelEncryptionConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteFieldLevelEncryptionConfigResponse deleteFieldLevelEncryptionConfig(
            DeleteFieldLevelEncryptionConfigRequest deleteFieldLevelEncryptionConfigRequest) throws AccessDeniedException,
            InvalidIfMatchVersionException, NoSuchFieldLevelEncryptionConfigException, PreconditionFailedException,
            FieldLevelEncryptionConfigInUseException, AwsServiceException, SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<DeleteFieldLevelEncryptionConfigResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(DeleteFieldLevelEncryptionConfigResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

        return clientHandler
                .execute(new ClientExecutionParams<DeleteFieldLevelEncryptionConfigRequest, DeleteFieldLevelEncryptionConfigResponse>()
                        .withOperationName("DeleteFieldLevelEncryptionConfig").withCombinedResponseHandler(responseHandler)
                        .withInput(deleteFieldLevelEncryptionConfigRequest)
                        .withMarshaller(new DeleteFieldLevelEncryptionConfigRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Remove a field-level encryption profile.
     * </p>
     *
     * @param deleteFieldLevelEncryptionProfileRequest
     * @return Result of the DeleteFieldLevelEncryptionProfile operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid for the distribution.
     * @throws NoSuchFieldLevelEncryptionProfileException
     *         The specified profile for field-level encryption doesn't exist.
     * @throws PreconditionFailedException
     *         The precondition given in one or more of the request-header fields evaluated to <code>false</code>.
     * @throws FieldLevelEncryptionProfileInUseException
     *         The specified profile for field-level encryption is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.DeleteFieldLevelEncryptionProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/DeleteFieldLevelEncryptionProfile"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteFieldLevelEncryptionProfileResponse deleteFieldLevelEncryptionProfile(
            DeleteFieldLevelEncryptionProfileRequest deleteFieldLevelEncryptionProfileRequest) throws AccessDeniedException,
            InvalidIfMatchVersionException, NoSuchFieldLevelEncryptionProfileException, PreconditionFailedException,
            FieldLevelEncryptionProfileInUseException, AwsServiceException, SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<DeleteFieldLevelEncryptionProfileResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(DeleteFieldLevelEncryptionProfileResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

        return clientHandler
                .execute(new ClientExecutionParams<DeleteFieldLevelEncryptionProfileRequest, DeleteFieldLevelEncryptionProfileResponse>()
                        .withOperationName("DeleteFieldLevelEncryptionProfile").withCombinedResponseHandler(responseHandler)
                        .withInput(deleteFieldLevelEncryptionProfileRequest)
                        .withMarshaller(new DeleteFieldLevelEncryptionProfileRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Remove a public key you previously added to CloudFront.
     * </p>
     *
     * @param deletePublicKeyRequest
     * @return Result of the DeletePublicKey operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws PublicKeyInUseException
     *         The specified public key is in use.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid for the distribution.
     * @throws NoSuchPublicKeyException
     *         The specified public key doesn't exist.
     * @throws PreconditionFailedException
     *         The precondition given in one or more of the request-header fields evaluated to <code>false</code>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.DeletePublicKey
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/DeletePublicKey" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeletePublicKeyResponse deletePublicKey(DeletePublicKeyRequest deletePublicKeyRequest) throws AccessDeniedException,
            PublicKeyInUseException, InvalidIfMatchVersionException, NoSuchPublicKeyException, PreconditionFailedException,
            AwsServiceException, SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<DeletePublicKeyResponse>> responseHandler = protocolFactory.createCombinedResponseHandler(
                DeletePublicKeyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

        return clientHandler.execute(new ClientExecutionParams<DeletePublicKeyRequest, DeletePublicKeyResponse>()
                .withOperationName("DeletePublicKey").withCombinedResponseHandler(responseHandler)
                .withInput(deletePublicKeyRequest).withMarshaller(new DeletePublicKeyRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Delete a streaming distribution. To delete an RTMP distribution using the CloudFront API, perform the following
     * steps.
     * </p>
     * <p>
     * <b>To delete an RTMP distribution using the CloudFront API</b>:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Disable the RTMP distribution.
     * </p>
     * </li>
     * <li>
     * <p>
     * Submit a <code>GET Streaming Distribution Config</code> request to get the current configuration and the
     * <code>Etag</code> header for the distribution.
     * </p>
     * </li>
     * <li>
     * <p>
     * Update the XML document that was returned in the response to your <code>GET Streaming Distribution Config</code>
     * request to change the value of <code>Enabled</code> to <code>false</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Submit a <code>PUT Streaming Distribution Config</code> request to update the configuration for your
     * distribution. In the request body, include the XML document that you updated in Step 3. Then set the value of the
     * HTTP <code>If-Match</code> header to the value of the <code>ETag</code> header that CloudFront returned when you
     * submitted the <code>GET Streaming Distribution Config</code> request in Step 2.
     * </p>
     * </li>
     * <li>
     * <p>
     * Review the response to the <code>PUT Streaming Distribution Config</code> request to confirm that the
     * distribution was successfully disabled.
     * </p>
     * </li>
     * <li>
     * <p>
     * Submit a <code>GET Streaming Distribution Config</code> request to confirm that your changes have propagated.
     * When propagation is complete, the value of <code>Status</code> is <code>Deployed</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Submit a <code>DELETE Streaming Distribution</code> request. Set the value of the HTTP <code>If-Match</code>
     * header to the value of the <code>ETag</code> header that CloudFront returned when you submitted the
     * <code>GET Streaming Distribution Config</code> request in Step 2.
     * </p>
     * </li>
     * <li>
     * <p>
     * Review the response to your <code>DELETE Streaming Distribution</code> request to confirm that the distribution
     * was successfully deleted.
     * </p>
     * </li>
     * </ol>
     * <p>
     * For information about deleting a distribution using the CloudFront console, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/HowToDeleteDistribution.html">Deleting a
     * Distribution</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     *
     * @param deleteStreamingDistributionRequest
     *        The request to delete a streaming distribution.
     * @return Result of the DeleteStreamingDistribution operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws StreamingDistributionNotDisabledException
     *         The specified CloudFront distribution is not disabled. You must disable the distribution before you can
     *         delete it.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid for the distribution.
     * @throws NoSuchStreamingDistributionException
     *         The specified streaming distribution does not exist.
     * @throws PreconditionFailedException
     *         The precondition given in one or more of the request-header fields evaluated to <code>false</code>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.DeleteStreamingDistribution
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/DeleteStreamingDistribution"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteStreamingDistributionResponse deleteStreamingDistribution(
            DeleteStreamingDistributionRequest deleteStreamingDistributionRequest) throws AccessDeniedException,
            StreamingDistributionNotDisabledException, InvalidIfMatchVersionException, NoSuchStreamingDistributionException,
            PreconditionFailedException, AwsServiceException, SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<DeleteStreamingDistributionResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(DeleteStreamingDistributionResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

        return clientHandler
                .execute(new ClientExecutionParams<DeleteStreamingDistributionRequest, DeleteStreamingDistributionResponse>()
                        .withOperationName("DeleteStreamingDistribution").withCombinedResponseHandler(responseHandler)
                        .withInput(deleteStreamingDistributionRequest)
                        .withMarshaller(new DeleteStreamingDistributionRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Get the information about an origin access identity.
     * </p>
     *
     * @param getCloudFrontOriginAccessIdentityRequest
     *        The request to get an origin access identity's information.
     * @return Result of the GetCloudFrontOriginAccessIdentity operation returned by the service.
     * @throws NoSuchCloudFrontOriginAccessIdentityException
     *         The specified origin access identity does not exist.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetCloudFrontOriginAccessIdentity
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/GetCloudFrontOriginAccessIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetCloudFrontOriginAccessIdentityResponse getCloudFrontOriginAccessIdentity(
            GetCloudFrontOriginAccessIdentityRequest getCloudFrontOriginAccessIdentityRequest)
            throws NoSuchCloudFrontOriginAccessIdentityException, AccessDeniedException, AwsServiceException, SdkClientException,
            CloudFrontException {

        HttpResponseHandler<Response<GetCloudFrontOriginAccessIdentityResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(GetCloudFrontOriginAccessIdentityResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

        return clientHandler
                .execute(new ClientExecutionParams<GetCloudFrontOriginAccessIdentityRequest, GetCloudFrontOriginAccessIdentityResponse>()
                        .withOperationName("GetCloudFrontOriginAccessIdentity").withCombinedResponseHandler(responseHandler)
                        .withInput(getCloudFrontOriginAccessIdentityRequest)
                        .withMarshaller(new GetCloudFrontOriginAccessIdentityRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Get the configuration information about an origin access identity.
     * </p>
     *
     * @param getCloudFrontOriginAccessIdentityConfigRequest
     *        The origin access identity's configuration information. For more information, see <a href=
     *        "https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_CloudFrontOriginAccessIdentityConfig.html"
     *        >CloudFrontOriginAccessIdentityConfig</a>.
     * @return Result of the GetCloudFrontOriginAccessIdentityConfig operation returned by the service.
     * @throws NoSuchCloudFrontOriginAccessIdentityException
     *         The specified origin access identity does not exist.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetCloudFrontOriginAccessIdentityConfig
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/GetCloudFrontOriginAccessIdentityConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetCloudFrontOriginAccessIdentityConfigResponse getCloudFrontOriginAccessIdentityConfig(
            GetCloudFrontOriginAccessIdentityConfigRequest getCloudFrontOriginAccessIdentityConfigRequest)
            throws NoSuchCloudFrontOriginAccessIdentityException, AccessDeniedException, AwsServiceException, SdkClientException,
            CloudFrontException {

        HttpResponseHandler<Response<GetCloudFrontOriginAccessIdentityConfigResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(GetCloudFrontOriginAccessIdentityConfigResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

        return clientHandler
                .execute(new ClientExecutionParams<GetCloudFrontOriginAccessIdentityConfigRequest, GetCloudFrontOriginAccessIdentityConfigResponse>()
                        .withOperationName("GetCloudFrontOriginAccessIdentityConfig")
                        .withCombinedResponseHandler(responseHandler).withInput(getCloudFrontOriginAccessIdentityConfigRequest)
                        .withMarshaller(new GetCloudFrontOriginAccessIdentityConfigRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Get the information about a distribution.
     * </p>
     *
     * @param getDistributionRequest
     *        The request to get a distribution's information.
     * @return Result of the GetDistribution operation returned by the service.
     * @throws NoSuchDistributionException
     *         The specified distribution does not exist.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetDistribution
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/GetDistribution" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetDistributionResponse getDistribution(GetDistributionRequest getDistributionRequest)
            throws NoSuchDistributionException, AccessDeniedException, AwsServiceException, SdkClientException,
            CloudFrontException {

        HttpResponseHandler<Response<GetDistributionResponse>> responseHandler = protocolFactory.createCombinedResponseHandler(
                GetDistributionResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

        return clientHandler.execute(new ClientExecutionParams<GetDistributionRequest, GetDistributionResponse>()
                .withOperationName("GetDistribution").withCombinedResponseHandler(responseHandler)
                .withInput(getDistributionRequest).withMarshaller(new GetDistributionRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Get the configuration information about a distribution.
     * </p>
     *
     * @param getDistributionConfigRequest
     *        The request to get a distribution configuration.
     * @return Result of the GetDistributionConfig operation returned by the service.
     * @throws NoSuchDistributionException
     *         The specified distribution does not exist.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetDistributionConfig
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/GetDistributionConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetDistributionConfigResponse getDistributionConfig(GetDistributionConfigRequest getDistributionConfigRequest)
            throws NoSuchDistributionException, AccessDeniedException, AwsServiceException, SdkClientException,
            CloudFrontException {

        HttpResponseHandler<Response<GetDistributionConfigResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(GetDistributionConfigResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

        return clientHandler.execute(new ClientExecutionParams<GetDistributionConfigRequest, GetDistributionConfigResponse>()
                .withOperationName("GetDistributionConfig").withCombinedResponseHandler(responseHandler)
                .withInput(getDistributionConfigRequest)
                .withMarshaller(new GetDistributionConfigRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Get the field-level encryption configuration information.
     * </p>
     *
     * @param getFieldLevelEncryptionRequest
     * @return Result of the GetFieldLevelEncryption operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws NoSuchFieldLevelEncryptionConfigException
     *         The specified configuration for field-level encryption doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetFieldLevelEncryption
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/GetFieldLevelEncryption"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetFieldLevelEncryptionResponse getFieldLevelEncryption(GetFieldLevelEncryptionRequest getFieldLevelEncryptionRequest)
            throws AccessDeniedException, NoSuchFieldLevelEncryptionConfigException, AwsServiceException, SdkClientException,
            CloudFrontException {

        HttpResponseHandler<Response<GetFieldLevelEncryptionResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(GetFieldLevelEncryptionResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

        return clientHandler.execute(new ClientExecutionParams<GetFieldLevelEncryptionRequest, GetFieldLevelEncryptionResponse>()
                .withOperationName("GetFieldLevelEncryption").withCombinedResponseHandler(responseHandler)
                .withInput(getFieldLevelEncryptionRequest)
                .withMarshaller(new GetFieldLevelEncryptionRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Get the field-level encryption configuration information.
     * </p>
     *
     * @param getFieldLevelEncryptionConfigRequest
     * @return Result of the GetFieldLevelEncryptionConfig operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws NoSuchFieldLevelEncryptionConfigException
     *         The specified configuration for field-level encryption doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetFieldLevelEncryptionConfig
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/GetFieldLevelEncryptionConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetFieldLevelEncryptionConfigResponse getFieldLevelEncryptionConfig(
            GetFieldLevelEncryptionConfigRequest getFieldLevelEncryptionConfigRequest) throws AccessDeniedException,
            NoSuchFieldLevelEncryptionConfigException, AwsServiceException, SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<GetFieldLevelEncryptionConfigResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(GetFieldLevelEncryptionConfigResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

        return clientHandler
                .execute(new ClientExecutionParams<GetFieldLevelEncryptionConfigRequest, GetFieldLevelEncryptionConfigResponse>()
                        .withOperationName("GetFieldLevelEncryptionConfig").withCombinedResponseHandler(responseHandler)
                        .withInput(getFieldLevelEncryptionConfigRequest)
                        .withMarshaller(new GetFieldLevelEncryptionConfigRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Get the field-level encryption profile information.
     * </p>
     *
     * @param getFieldLevelEncryptionProfileRequest
     * @return Result of the GetFieldLevelEncryptionProfile operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws NoSuchFieldLevelEncryptionProfileException
     *         The specified profile for field-level encryption doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetFieldLevelEncryptionProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/GetFieldLevelEncryptionProfile"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetFieldLevelEncryptionProfileResponse getFieldLevelEncryptionProfile(
            GetFieldLevelEncryptionProfileRequest getFieldLevelEncryptionProfileRequest) throws AccessDeniedException,
            NoSuchFieldLevelEncryptionProfileException, AwsServiceException, SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<GetFieldLevelEncryptionProfileResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(GetFieldLevelEncryptionProfileResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

        return clientHandler
                .execute(new ClientExecutionParams<GetFieldLevelEncryptionProfileRequest, GetFieldLevelEncryptionProfileResponse>()
                        .withOperationName("GetFieldLevelEncryptionProfile").withCombinedResponseHandler(responseHandler)
                        .withInput(getFieldLevelEncryptionProfileRequest)
                        .withMarshaller(new GetFieldLevelEncryptionProfileRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Get the field-level encryption profile configuration information.
     * </p>
     *
     * @param getFieldLevelEncryptionProfileConfigRequest
     * @return Result of the GetFieldLevelEncryptionProfileConfig operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws NoSuchFieldLevelEncryptionProfileException
     *         The specified profile for field-level encryption doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetFieldLevelEncryptionProfileConfig
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/GetFieldLevelEncryptionProfileConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetFieldLevelEncryptionProfileConfigResponse getFieldLevelEncryptionProfileConfig(
            GetFieldLevelEncryptionProfileConfigRequest getFieldLevelEncryptionProfileConfigRequest)
            throws AccessDeniedException, NoSuchFieldLevelEncryptionProfileException, AwsServiceException, SdkClientException,
            CloudFrontException {

        HttpResponseHandler<Response<GetFieldLevelEncryptionProfileConfigResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(GetFieldLevelEncryptionProfileConfigResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

        return clientHandler
                .execute(new ClientExecutionParams<GetFieldLevelEncryptionProfileConfigRequest, GetFieldLevelEncryptionProfileConfigResponse>()
                        .withOperationName("GetFieldLevelEncryptionProfileConfig").withCombinedResponseHandler(responseHandler)
                        .withInput(getFieldLevelEncryptionProfileConfigRequest)
                        .withMarshaller(new GetFieldLevelEncryptionProfileConfigRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Get the information about an invalidation.
     * </p>
     *
     * @param getInvalidationRequest
     *        The request to get an invalidation's information.
     * @return Result of the GetInvalidation operation returned by the service.
     * @throws NoSuchInvalidationException
     *         The specified invalidation does not exist.
     * @throws NoSuchDistributionException
     *         The specified distribution does not exist.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetInvalidation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/GetInvalidation" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetInvalidationResponse getInvalidation(GetInvalidationRequest getInvalidationRequest)
            throws NoSuchInvalidationException, NoSuchDistributionException, AccessDeniedException, AwsServiceException,
            SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<GetInvalidationResponse>> responseHandler = protocolFactory.createCombinedResponseHandler(
                GetInvalidationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

        return clientHandler.execute(new ClientExecutionParams<GetInvalidationRequest, GetInvalidationResponse>()
                .withOperationName("GetInvalidation").withCombinedResponseHandler(responseHandler)
                .withInput(getInvalidationRequest).withMarshaller(new GetInvalidationRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Get the public key information.
     * </p>
     *
     * @param getPublicKeyRequest
     * @return Result of the GetPublicKey operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws NoSuchPublicKeyException
     *         The specified public key doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetPublicKey
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/GetPublicKey" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetPublicKeyResponse getPublicKey(GetPublicKeyRequest getPublicKeyRequest) throws AccessDeniedException,
            NoSuchPublicKeyException, AwsServiceException, SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<GetPublicKeyResponse>> responseHandler = protocolFactory.createCombinedResponseHandler(
                GetPublicKeyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

        return clientHandler.execute(new ClientExecutionParams<GetPublicKeyRequest, GetPublicKeyResponse>()
                .withOperationName("GetPublicKey").withCombinedResponseHandler(responseHandler).withInput(getPublicKeyRequest)
                .withMarshaller(new GetPublicKeyRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Return public key configuration informaation
     * </p>
     *
     * @param getPublicKeyConfigRequest
     * @return Result of the GetPublicKeyConfig operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws NoSuchPublicKeyException
     *         The specified public key doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetPublicKeyConfig
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/GetPublicKeyConfig" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetPublicKeyConfigResponse getPublicKeyConfig(GetPublicKeyConfigRequest getPublicKeyConfigRequest)
            throws AccessDeniedException, NoSuchPublicKeyException, AwsServiceException, SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<GetPublicKeyConfigResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(GetPublicKeyConfigResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

        return clientHandler.execute(new ClientExecutionParams<GetPublicKeyConfigRequest, GetPublicKeyConfigResponse>()
                .withOperationName("GetPublicKeyConfig").withCombinedResponseHandler(responseHandler)
                .withInput(getPublicKeyConfigRequest).withMarshaller(new GetPublicKeyConfigRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Gets information about a specified RTMP distribution, including the distribution configuration.
     * </p>
     *
     * @param getStreamingDistributionRequest
     *        The request to get a streaming distribution's information.
     * @return Result of the GetStreamingDistribution operation returned by the service.
     * @throws NoSuchStreamingDistributionException
     *         The specified streaming distribution does not exist.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetStreamingDistribution
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/GetStreamingDistribution"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetStreamingDistributionResponse getStreamingDistribution(
            GetStreamingDistributionRequest getStreamingDistributionRequest) throws NoSuchStreamingDistributionException,
            AccessDeniedException, AwsServiceException, SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<GetStreamingDistributionResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(GetStreamingDistributionResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

        return clientHandler
                .execute(new ClientExecutionParams<GetStreamingDistributionRequest, GetStreamingDistributionResponse>()
                        .withOperationName("GetStreamingDistribution").withCombinedResponseHandler(responseHandler)
                        .withInput(getStreamingDistributionRequest)
                        .withMarshaller(new GetStreamingDistributionRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Get the configuration information about a streaming distribution.
     * </p>
     *
     * @param getStreamingDistributionConfigRequest
     *        To request to get a streaming distribution configuration.
     * @return Result of the GetStreamingDistributionConfig operation returned by the service.
     * @throws NoSuchStreamingDistributionException
     *         The specified streaming distribution does not exist.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetStreamingDistributionConfig
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/GetStreamingDistributionConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetStreamingDistributionConfigResponse getStreamingDistributionConfig(
            GetStreamingDistributionConfigRequest getStreamingDistributionConfigRequest)
            throws NoSuchStreamingDistributionException, AccessDeniedException, AwsServiceException, SdkClientException,
            CloudFrontException {

        HttpResponseHandler<Response<GetStreamingDistributionConfigResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(GetStreamingDistributionConfigResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

        return clientHandler
                .execute(new ClientExecutionParams<GetStreamingDistributionConfigRequest, GetStreamingDistributionConfigResponse>()
                        .withOperationName("GetStreamingDistributionConfig").withCombinedResponseHandler(responseHandler)
                        .withInput(getStreamingDistributionConfigRequest)
                        .withMarshaller(new GetStreamingDistributionConfigRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Lists origin access identities.
     * </p>
     *
     * @param listCloudFrontOriginAccessIdentitiesRequest
     *        The request to list origin access identities.
     * @return Result of the ListCloudFrontOriginAccessIdentities operation returned by the service.
     * @throws InvalidArgumentException
     *         The argument is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListCloudFrontOriginAccessIdentities
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/ListCloudFrontOriginAccessIdentities"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListCloudFrontOriginAccessIdentitiesResponse listCloudFrontOriginAccessIdentities(
            ListCloudFrontOriginAccessIdentitiesRequest listCloudFrontOriginAccessIdentitiesRequest)
            throws InvalidArgumentException, AwsServiceException, SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<ListCloudFrontOriginAccessIdentitiesResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(ListCloudFrontOriginAccessIdentitiesResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

        return clientHandler
                .execute(new ClientExecutionParams<ListCloudFrontOriginAccessIdentitiesRequest, ListCloudFrontOriginAccessIdentitiesResponse>()
                        .withOperationName("ListCloudFrontOriginAccessIdentities").withCombinedResponseHandler(responseHandler)
                        .withInput(listCloudFrontOriginAccessIdentitiesRequest)
                        .withMarshaller(new ListCloudFrontOriginAccessIdentitiesRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * List CloudFront distributions.
     * </p>
     *
     * @param listDistributionsRequest
     *        The request to list your distributions.
     * @return Result of the ListDistributions operation returned by the service.
     * @throws InvalidArgumentException
     *         The argument is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListDistributions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/ListDistributions" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListDistributionsResponse listDistributions(ListDistributionsRequest listDistributionsRequest)
            throws InvalidArgumentException, AwsServiceException, SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<ListDistributionsResponse>> responseHandler = protocolFactory.createCombinedResponseHandler(
                ListDistributionsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

        return clientHandler.execute(new ClientExecutionParams<ListDistributionsRequest, ListDistributionsResponse>()
                .withOperationName("ListDistributions").withCombinedResponseHandler(responseHandler)
                .withInput(listDistributionsRequest).withMarshaller(new ListDistributionsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * List the distributions that are associated with a specified AWS WAF web ACL.
     * </p>
     *
     * @param listDistributionsByWebAclIdRequest
     *        The request to list distributions that are associated with a specified AWS WAF web ACL.
     * @return Result of the ListDistributionsByWebACLId operation returned by the service.
     * @throws InvalidArgumentException
     *         The argument is invalid.
     * @throws InvalidWebAclIdException
     *         A web ACL ID specified is not valid. To specify a web ACL created using the latest version of AWS WAF,
     *         use the ACL ARN, for example
     *         <code>arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/473e64fd-f30b-4765-81a0-62ad96dd167a</code>
     *         . To specify a web ACL created using AWS WAF Classic, use the ACL ID, for example
     *         <code>473e64fd-f30b-4765-81a0-62ad96dd167a</code>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListDistributionsByWebACLId
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/ListDistributionsByWebACLId"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListDistributionsByWebAclIdResponse listDistributionsByWebACLId(
            ListDistributionsByWebAclIdRequest listDistributionsByWebAclIdRequest) throws InvalidArgumentException,
            InvalidWebAclIdException, AwsServiceException, SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<ListDistributionsByWebAclIdResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(ListDistributionsByWebAclIdResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

        return clientHandler
                .execute(new ClientExecutionParams<ListDistributionsByWebAclIdRequest, ListDistributionsByWebAclIdResponse>()
                        .withOperationName("ListDistributionsByWebACLId").withCombinedResponseHandler(responseHandler)
                        .withInput(listDistributionsByWebAclIdRequest)
                        .withMarshaller(new ListDistributionsByWebAclIdRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * List all field-level encryption configurations that have been created in CloudFront for this account.
     * </p>
     *
     * @param listFieldLevelEncryptionConfigsRequest
     * @return Result of the ListFieldLevelEncryptionConfigs operation returned by the service.
     * @throws InvalidArgumentException
     *         The argument is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListFieldLevelEncryptionConfigs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/ListFieldLevelEncryptionConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListFieldLevelEncryptionConfigsResponse listFieldLevelEncryptionConfigs(
            ListFieldLevelEncryptionConfigsRequest listFieldLevelEncryptionConfigsRequest) throws InvalidArgumentException,
            AwsServiceException, SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<ListFieldLevelEncryptionConfigsResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(ListFieldLevelEncryptionConfigsResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

        return clientHandler
                .execute(new ClientExecutionParams<ListFieldLevelEncryptionConfigsRequest, ListFieldLevelEncryptionConfigsResponse>()
                        .withOperationName("ListFieldLevelEncryptionConfigs").withCombinedResponseHandler(responseHandler)
                        .withInput(listFieldLevelEncryptionConfigsRequest)
                        .withMarshaller(new ListFieldLevelEncryptionConfigsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Request a list of field-level encryption profiles that have been created in CloudFront for this account.
     * </p>
     *
     * @param listFieldLevelEncryptionProfilesRequest
     * @return Result of the ListFieldLevelEncryptionProfiles operation returned by the service.
     * @throws InvalidArgumentException
     *         The argument is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListFieldLevelEncryptionProfiles
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/ListFieldLevelEncryptionProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListFieldLevelEncryptionProfilesResponse listFieldLevelEncryptionProfiles(
            ListFieldLevelEncryptionProfilesRequest listFieldLevelEncryptionProfilesRequest) throws InvalidArgumentException,
            AwsServiceException, SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<ListFieldLevelEncryptionProfilesResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(ListFieldLevelEncryptionProfilesResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

        return clientHandler
                .execute(new ClientExecutionParams<ListFieldLevelEncryptionProfilesRequest, ListFieldLevelEncryptionProfilesResponse>()
                        .withOperationName("ListFieldLevelEncryptionProfiles").withCombinedResponseHandler(responseHandler)
                        .withInput(listFieldLevelEncryptionProfilesRequest)
                        .withMarshaller(new ListFieldLevelEncryptionProfilesRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Lists invalidation batches.
     * </p>
     *
     * @param listInvalidationsRequest
     *        The request to list invalidations.
     * @return Result of the ListInvalidations operation returned by the service.
     * @throws InvalidArgumentException
     *         The argument is invalid.
     * @throws NoSuchDistributionException
     *         The specified distribution does not exist.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListInvalidations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/ListInvalidations" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListInvalidationsResponse listInvalidations(ListInvalidationsRequest listInvalidationsRequest)
            throws InvalidArgumentException, NoSuchDistributionException, AccessDeniedException, AwsServiceException,
            SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<ListInvalidationsResponse>> responseHandler = protocolFactory.createCombinedResponseHandler(
                ListInvalidationsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

        return clientHandler.execute(new ClientExecutionParams<ListInvalidationsRequest, ListInvalidationsResponse>()
                .withOperationName("ListInvalidations").withCombinedResponseHandler(responseHandler)
                .withInput(listInvalidationsRequest).withMarshaller(new ListInvalidationsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * List all public keys that have been added to CloudFront for this account.
     * </p>
     *
     * @param listPublicKeysRequest
     * @return Result of the ListPublicKeys operation returned by the service.
     * @throws InvalidArgumentException
     *         The argument is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListPublicKeys
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/ListPublicKeys" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListPublicKeysResponse listPublicKeys(ListPublicKeysRequest listPublicKeysRequest) throws InvalidArgumentException,
            AwsServiceException, SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<ListPublicKeysResponse>> responseHandler = protocolFactory.createCombinedResponseHandler(
                ListPublicKeysResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

        return clientHandler.execute(new ClientExecutionParams<ListPublicKeysRequest, ListPublicKeysResponse>()
                .withOperationName("ListPublicKeys").withCombinedResponseHandler(responseHandler)
                .withInput(listPublicKeysRequest).withMarshaller(new ListPublicKeysRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * List streaming distributions.
     * </p>
     *
     * @param listStreamingDistributionsRequest
     *        The request to list your streaming distributions.
     * @return Result of the ListStreamingDistributions operation returned by the service.
     * @throws InvalidArgumentException
     *         The argument is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListStreamingDistributions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/ListStreamingDistributions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListStreamingDistributionsResponse listStreamingDistributions(
            ListStreamingDistributionsRequest listStreamingDistributionsRequest) throws InvalidArgumentException,
            AwsServiceException, SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<ListStreamingDistributionsResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(ListStreamingDistributionsResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

        return clientHandler
                .execute(new ClientExecutionParams<ListStreamingDistributionsRequest, ListStreamingDistributionsResponse>()
                        .withOperationName("ListStreamingDistributions").withCombinedResponseHandler(responseHandler)
                        .withInput(listStreamingDistributionsRequest)
                        .withMarshaller(new ListStreamingDistributionsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * List tags for a CloudFront resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     *        The request to list tags for a CloudFront resource.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws InvalidArgumentException
     *         The argument is invalid.
     * @throws InvalidTaggingException
     *         The tagging specified is not valid.
     * @throws NoSuchResourceException
     *         A resource that was specified is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws AccessDeniedException, InvalidArgumentException, InvalidTaggingException, NoSuchResourceException,
            AwsServiceException, SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<ListTagsForResourceResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(ListTagsForResourceResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

        return clientHandler.execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                .withOperationName("ListTagsForResource").withCombinedResponseHandler(responseHandler)
                .withInput(listTagsForResourceRequest).withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Add tags to a CloudFront resource.
     * </p>
     *
     * @param tagResourceRequest
     *        The request to add tags to a CloudFront resource.
     * @return Result of the TagResource operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws InvalidArgumentException
     *         The argument is invalid.
     * @throws InvalidTaggingException
     *         The tagging specified is not valid.
     * @throws NoSuchResourceException
     *         A resource that was specified is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws AccessDeniedException,
            InvalidArgumentException, InvalidTaggingException, NoSuchResourceException, AwsServiceException, SdkClientException,
            CloudFrontException {

        HttpResponseHandler<Response<TagResourceResponse>> responseHandler = protocolFactory.createCombinedResponseHandler(
                TagResourceResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

        return clientHandler.execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                .withOperationName("TagResource").withCombinedResponseHandler(responseHandler).withInput(tagResourceRequest)
                .withMarshaller(new TagResourceRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Remove tags from a CloudFront resource.
     * </p>
     *
     * @param untagResourceRequest
     *        The request to remove tags from a CloudFront resource.
     * @return Result of the UntagResource operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws InvalidArgumentException
     *         The argument is invalid.
     * @throws InvalidTaggingException
     *         The tagging specified is not valid.
     * @throws NoSuchResourceException
     *         A resource that was specified is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws AccessDeniedException,
            InvalidArgumentException, InvalidTaggingException, NoSuchResourceException, AwsServiceException, SdkClientException,
            CloudFrontException {

        HttpResponseHandler<Response<UntagResourceResponse>> responseHandler = protocolFactory.createCombinedResponseHandler(
                UntagResourceResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

        return clientHandler.execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                .withOperationName("UntagResource").withCombinedResponseHandler(responseHandler).withInput(untagResourceRequest)
                .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Update an origin access identity.
     * </p>
     *
     * @param updateCloudFrontOriginAccessIdentityRequest
     *        The request to update an origin access identity.
     * @return Result of the UpdateCloudFrontOriginAccessIdentity operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws IllegalUpdateException
     *         Origin and <code>CallerReference</code> cannot be updated.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid for the distribution.
     * @throws MissingBodyException
     *         This operation requires a body. Ensure that the body is present and the <code>Content-Type</code> header
     *         is set.
     * @throws NoSuchCloudFrontOriginAccessIdentityException
     *         The specified origin access identity does not exist.
     * @throws PreconditionFailedException
     *         The precondition given in one or more of the request-header fields evaluated to <code>false</code>.
     * @throws InvalidArgumentException
     *         The argument is invalid.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.UpdateCloudFrontOriginAccessIdentity
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/UpdateCloudFrontOriginAccessIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateCloudFrontOriginAccessIdentityResponse updateCloudFrontOriginAccessIdentity(
            UpdateCloudFrontOriginAccessIdentityRequest updateCloudFrontOriginAccessIdentityRequest)
            throws AccessDeniedException, IllegalUpdateException, InvalidIfMatchVersionException, MissingBodyException,
            NoSuchCloudFrontOriginAccessIdentityException, PreconditionFailedException, InvalidArgumentException,
            InconsistentQuantitiesException, AwsServiceException, SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<UpdateCloudFrontOriginAccessIdentityResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(UpdateCloudFrontOriginAccessIdentityResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

        return clientHandler
                .execute(new ClientExecutionParams<UpdateCloudFrontOriginAccessIdentityRequest, UpdateCloudFrontOriginAccessIdentityResponse>()
                        .withOperationName("UpdateCloudFrontOriginAccessIdentity").withCombinedResponseHandler(responseHandler)
                        .withInput(updateCloudFrontOriginAccessIdentityRequest)
                        .withMarshaller(new UpdateCloudFrontOriginAccessIdentityRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Updates the configuration for a web distribution.
     * </p>
     * <important>
     * <p>
     * When you update a distribution, there are more required fields than when you create a distribution. When you
     * update your distribution by using this API action, follow the steps here to get the current configuration and
     * then make your updates, to make sure that you include all of the required fields. To view a summary, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-overview-required-fields.html"
     * >Required Fields for Create Distribution and Update Distribution</a> in the <i>Amazon CloudFront Developer
     * Guide</i>.
     * </p>
     * </important>
     * <p>
     * The update process includes getting the current distribution configuration, updating the XML document that is
     * returned to make your changes, and then submitting an <code>UpdateDistribution</code> request to make the
     * updates.
     * </p>
     * <p>
     * For information about updating a distribution using the CloudFront console instead, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-creating-console.html"
     * >Creating a Distribution</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * <p>
     * <b>To update a web distribution using the CloudFront API</b>
     * </p>
     * <ol>
     * <li>
     * <p>
     * Submit a <a href="https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_GetDistributionConfig.html">
     * GetDistributionConfig</a> request to get the current configuration and an <code>Etag</code> header for the
     * distribution.
     * </p>
     * <note>
     * <p>
     * If you update the distribution again, you must get a new <code>Etag</code> header.
     * </p>
     * </note></li>
     * <li>
     * <p>
     * Update the XML document that was returned in the response to your <code>GetDistributionConfig</code> request to
     * include your changes.
     * </p>
     * <important>
     * <p>
     * When you edit the XML file, be aware of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You must strip out the ETag parameter that is returned.
     * </p>
     * </li>
     * <li>
     * <p>
     * Additional fields are required when you update a distribution. There may be fields included in the XML file for
     * features that you haven't configured for your distribution. This is expected and required to successfully update
     * the distribution.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can't change the value of <code>CallerReference</code>. If you try to change this value, CloudFront returns
     * an <code>IllegalUpdate</code> error.
     * </p>
     * </li>
     * <li>
     * <p>
     * The new configuration replaces the existing configuration; the values that you specify in an
     * <code>UpdateDistribution</code> request are not merged into your existing configuration. When you add, delete, or
     * replace values in an element that allows multiple values (for example, <code>CNAME</code>), you must specify all
     * of the values that you want to appear in the updated distribution. In addition, you must update the corresponding
     * <code>Quantity</code> element.
     * </p>
     * </li>
     * </ul>
     * </important></li>
     * <li>
     * <p>
     * Submit an <code>UpdateDistribution</code> request to update the configuration for your distribution:
     * </p>
     * <ul>
     * <li>
     * <p>
     * In the request body, include the XML document that you updated in Step 2. The request body must include an XML
     * document with a <code>DistributionConfig</code> element.
     * </p>
     * </li>
     * <li>
     * <p>
     * Set the value of the HTTP <code>If-Match</code> header to the value of the <code>ETag</code> header that
     * CloudFront returned when you submitted the <code>GetDistributionConfig</code> request in Step 1.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Review the response to the <code>UpdateDistribution</code> request to confirm that the configuration was
     * successfully updated.
     * </p>
     * </li>
     * <li>
     * <p>
     * Optional: Submit a <a
     * href="https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_GetDistribution.html">GetDistribution</a>
     * request to confirm that your changes have propagated. When propagation is complete, the value of
     * <code>Status</code> is <code>Deployed</code>.
     * </p>
     * </li>
     * </ol>
     *
     * @param updateDistributionRequest
     *        The request to update a distribution.
     * @return Result of the UpdateDistribution operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws CnameAlreadyExistsException
     *         The CNAME specified is already defined for CloudFront.
     * @throws IllegalUpdateException
     *         Origin and <code>CallerReference</code> cannot be updated.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid for the distribution.
     * @throws MissingBodyException
     *         This operation requires a body. Ensure that the body is present and the <code>Content-Type</code> header
     *         is set.
     * @throws NoSuchDistributionException
     *         The specified distribution does not exist.
     * @throws PreconditionFailedException
     *         The precondition given in one or more of the request-header fields evaluated to <code>false</code>.
     * @throws TooManyDistributionCnamEsException
     *         Your request contains more CNAMEs than are allowed per distribution.
     * @throws InvalidDefaultRootObjectException
     *         The default root object file name is too big or contains an invalid character.
     * @throws InvalidRelativePathException
     *         The relative path is too big, is not URL-encoded, or does not begin with a slash (/).
     * @throws InvalidErrorCodeException
     *         An invalid error code was specified.
     * @throws InvalidResponseCodeException
     *         A response code is not valid.
     * @throws InvalidArgumentException
     *         The argument is invalid.
     * @throws InvalidOriginAccessIdentityException
     *         The origin access identity is not valid or doesn't exist.
     * @throws TooManyTrustedSignersException
     *         Your request contains more trusted signers than are allowed per distribution.
     * @throws TrustedSignerDoesNotExistException
     *         One or more of your trusted signers don't exist.
     * @throws InvalidViewerCertificateException
     *         A viewer certificate specified is not valid.
     * @throws InvalidMinimumProtocolVersionException
     *         The minimum protocol version specified is not valid.
     * @throws InvalidRequiredProtocolException
     *         This operation requires the HTTPS protocol. Ensure that you specify the HTTPS protocol in your request,
     *         or omit the <code>RequiredProtocols</code> element from your distribution configuration.
     * @throws NoSuchOriginException
     *         No origin exists with the specified <code>Origin Id</code>.
     * @throws TooManyOriginsException
     *         You cannot create more origins for the distribution.
     * @throws TooManyOriginGroupsPerDistributionException
     *         Processing your request would cause you to exceed the maximum number of origin groups allowed.
     * @throws TooManyCacheBehaviorsException
     *         You cannot create more cache behaviors for the distribution.
     * @throws TooManyCookieNamesInWhiteListException
     *         Your request contains more cookie names in the whitelist than are allowed per cache behavior.
     * @throws InvalidForwardCookiesException
     *         Your request contains forward cookies option which doesn't match with the expectation for the
     *         <code>whitelisted</code> list of cookie names. Either list of cookie names has been specified when not
     *         allowed or list of cookie names is missing when expected.
     * @throws TooManyHeadersInForwardedValuesException
     *         Your request contains too many headers in forwarded values.
     * @throws InvalidHeadersForS3OriginException
     *         The headers specified are not valid for an Amazon S3 origin.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws TooManyCertificatesException
     *         You cannot create anymore custom SSL/TLS certificates.
     * @throws InvalidLocationCodeException
     *         The location code specified is not valid.
     * @throws InvalidGeoRestrictionParameterException
     *         The specified geo restriction parameter is not valid.
     * @throws InvalidTtlOrderException
     *         The TTL order specified is not valid.
     * @throws InvalidWebAclIdException
     *         A web ACL ID specified is not valid. To specify a web ACL created using the latest version of AWS WAF,
     *         use the ACL ARN, for example
     *         <code>arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/473e64fd-f30b-4765-81a0-62ad96dd167a</code>
     *         . To specify a web ACL created using AWS WAF Classic, use the ACL ID, for example
     *         <code>473e64fd-f30b-4765-81a0-62ad96dd167a</code>.
     * @throws TooManyOriginCustomHeadersException
     *         Your request contains too many origin custom headers.
     * @throws TooManyQueryStringParametersException
     *         Your request contains too many query string parameters.
     * @throws InvalidQueryStringParametersException
     *         The query string parameters specified are not valid.
     * @throws TooManyDistributionsWithLambdaAssociationsException
     *         Processing your request would cause the maximum number of distributions with Lambda function associations
     *         per owner to be exceeded.
     * @throws TooManyLambdaFunctionAssociationsException
     *         Your request contains more Lambda function associations than are allowed per distribution.
     * @throws InvalidLambdaFunctionAssociationException
     *         The specified Lambda function association is invalid.
     * @throws InvalidOriginReadTimeoutException
     *         The read timeout specified for the origin is not valid.
     * @throws InvalidOriginKeepaliveTimeoutException
     *         The keep alive timeout specified for the origin is not valid.
     * @throws NoSuchFieldLevelEncryptionConfigException
     *         The specified configuration for field-level encryption doesn't exist.
     * @throws IllegalFieldLevelEncryptionConfigAssociationWithCacheBehaviorException
     *         The specified configuration for field-level encryption can't be associated with the specified cache
     *         behavior.
     * @throws TooManyDistributionsAssociatedToFieldLevelEncryptionConfigException
     *         The maximum number of distributions have been associated with the specified configuration for field-level
     *         encryption.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.UpdateDistribution
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/UpdateDistribution" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateDistributionResponse updateDistribution(UpdateDistributionRequest updateDistributionRequest)
            throws AccessDeniedException, CnameAlreadyExistsException, IllegalUpdateException, InvalidIfMatchVersionException,
            MissingBodyException, NoSuchDistributionException, PreconditionFailedException, TooManyDistributionCnamEsException,
            InvalidDefaultRootObjectException, InvalidRelativePathException, InvalidErrorCodeException,
            InvalidResponseCodeException, InvalidArgumentException, InvalidOriginAccessIdentityException,
            TooManyTrustedSignersException, TrustedSignerDoesNotExistException, InvalidViewerCertificateException,
            InvalidMinimumProtocolVersionException, InvalidRequiredProtocolException, NoSuchOriginException,
            TooManyOriginsException, TooManyOriginGroupsPerDistributionException, TooManyCacheBehaviorsException,
            TooManyCookieNamesInWhiteListException, InvalidForwardCookiesException, TooManyHeadersInForwardedValuesException,
            InvalidHeadersForS3OriginException, InconsistentQuantitiesException, TooManyCertificatesException,
            InvalidLocationCodeException, InvalidGeoRestrictionParameterException, InvalidTtlOrderException,
            InvalidWebAclIdException, TooManyOriginCustomHeadersException, TooManyQueryStringParametersException,
            InvalidQueryStringParametersException, TooManyDistributionsWithLambdaAssociationsException,
            TooManyLambdaFunctionAssociationsException, InvalidLambdaFunctionAssociationException,
            InvalidOriginReadTimeoutException, InvalidOriginKeepaliveTimeoutException, NoSuchFieldLevelEncryptionConfigException,
            IllegalFieldLevelEncryptionConfigAssociationWithCacheBehaviorException,
            TooManyDistributionsAssociatedToFieldLevelEncryptionConfigException, AwsServiceException, SdkClientException,
            CloudFrontException {

        HttpResponseHandler<Response<UpdateDistributionResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(UpdateDistributionResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

        return clientHandler.execute(new ClientExecutionParams<UpdateDistributionRequest, UpdateDistributionResponse>()
                .withOperationName("UpdateDistribution").withCombinedResponseHandler(responseHandler)
                .withInput(updateDistributionRequest).withMarshaller(new UpdateDistributionRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Update a field-level encryption configuration.
     * </p>
     *
     * @param updateFieldLevelEncryptionConfigRequest
     * @return Result of the UpdateFieldLevelEncryptionConfig operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws IllegalUpdateException
     *         Origin and <code>CallerReference</code> cannot be updated.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws InvalidArgumentException
     *         The argument is invalid.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid for the distribution.
     * @throws NoSuchFieldLevelEncryptionProfileException
     *         The specified profile for field-level encryption doesn't exist.
     * @throws NoSuchFieldLevelEncryptionConfigException
     *         The specified configuration for field-level encryption doesn't exist.
     * @throws PreconditionFailedException
     *         The precondition given in one or more of the request-header fields evaluated to <code>false</code>.
     * @throws TooManyFieldLevelEncryptionQueryArgProfilesException
     *         The maximum number of query arg profiles for field-level encryption have been created.
     * @throws TooManyFieldLevelEncryptionContentTypeProfilesException
     *         The maximum number of content type profiles for field-level encryption have been created.
     * @throws QueryArgProfileEmptyException
     *         No profile specified for the field-level encryption query argument.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.UpdateFieldLevelEncryptionConfig
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/UpdateFieldLevelEncryptionConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateFieldLevelEncryptionConfigResponse updateFieldLevelEncryptionConfig(
            UpdateFieldLevelEncryptionConfigRequest updateFieldLevelEncryptionConfigRequest) throws AccessDeniedException,
            IllegalUpdateException, InconsistentQuantitiesException, InvalidArgumentException, InvalidIfMatchVersionException,
            NoSuchFieldLevelEncryptionProfileException, NoSuchFieldLevelEncryptionConfigException, PreconditionFailedException,
            TooManyFieldLevelEncryptionQueryArgProfilesException, TooManyFieldLevelEncryptionContentTypeProfilesException,
            QueryArgProfileEmptyException, AwsServiceException, SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<UpdateFieldLevelEncryptionConfigResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(UpdateFieldLevelEncryptionConfigResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

        return clientHandler
                .execute(new ClientExecutionParams<UpdateFieldLevelEncryptionConfigRequest, UpdateFieldLevelEncryptionConfigResponse>()
                        .withOperationName("UpdateFieldLevelEncryptionConfig").withCombinedResponseHandler(responseHandler)
                        .withInput(updateFieldLevelEncryptionConfigRequest)
                        .withMarshaller(new UpdateFieldLevelEncryptionConfigRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Update a field-level encryption profile.
     * </p>
     *
     * @param updateFieldLevelEncryptionProfileRequest
     * @return Result of the UpdateFieldLevelEncryptionProfile operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws FieldLevelEncryptionProfileAlreadyExistsException
     *         The specified profile for field-level encryption already exists.
     * @throws IllegalUpdateException
     *         Origin and <code>CallerReference</code> cannot be updated.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws InvalidArgumentException
     *         The argument is invalid.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid for the distribution.
     * @throws NoSuchPublicKeyException
     *         The specified public key doesn't exist.
     * @throws NoSuchFieldLevelEncryptionProfileException
     *         The specified profile for field-level encryption doesn't exist.
     * @throws PreconditionFailedException
     *         The precondition given in one or more of the request-header fields evaluated to <code>false</code>.
     * @throws FieldLevelEncryptionProfileSizeExceededException
     *         The maximum size of a profile for field-level encryption was exceeded.
     * @throws TooManyFieldLevelEncryptionEncryptionEntitiesException
     *         The maximum number of encryption entities for field-level encryption have been created.
     * @throws TooManyFieldLevelEncryptionFieldPatternsException
     *         The maximum number of field patterns for field-level encryption have been created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.UpdateFieldLevelEncryptionProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/UpdateFieldLevelEncryptionProfile"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateFieldLevelEncryptionProfileResponse updateFieldLevelEncryptionProfile(
            UpdateFieldLevelEncryptionProfileRequest updateFieldLevelEncryptionProfileRequest) throws AccessDeniedException,
            FieldLevelEncryptionProfileAlreadyExistsException, IllegalUpdateException, InconsistentQuantitiesException,
            InvalidArgumentException, InvalidIfMatchVersionException, NoSuchPublicKeyException,
            NoSuchFieldLevelEncryptionProfileException, PreconditionFailedException,
            FieldLevelEncryptionProfileSizeExceededException, TooManyFieldLevelEncryptionEncryptionEntitiesException,
            TooManyFieldLevelEncryptionFieldPatternsException, AwsServiceException, SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<UpdateFieldLevelEncryptionProfileResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(UpdateFieldLevelEncryptionProfileResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

        return clientHandler
                .execute(new ClientExecutionParams<UpdateFieldLevelEncryptionProfileRequest, UpdateFieldLevelEncryptionProfileResponse>()
                        .withOperationName("UpdateFieldLevelEncryptionProfile").withCombinedResponseHandler(responseHandler)
                        .withInput(updateFieldLevelEncryptionProfileRequest)
                        .withMarshaller(new UpdateFieldLevelEncryptionProfileRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Update public key information. Note that the only value you can change is the comment.
     * </p>
     *
     * @param updatePublicKeyRequest
     * @return Result of the UpdatePublicKey operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws CannotChangeImmutablePublicKeyFieldsException
     *         You can't change the value of a public key.
     * @throws InvalidArgumentException
     *         The argument is invalid.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid for the distribution.
     * @throws IllegalUpdateException
     *         Origin and <code>CallerReference</code> cannot be updated.
     * @throws NoSuchPublicKeyException
     *         The specified public key doesn't exist.
     * @throws PreconditionFailedException
     *         The precondition given in one or more of the request-header fields evaluated to <code>false</code>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.UpdatePublicKey
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/UpdatePublicKey" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdatePublicKeyResponse updatePublicKey(UpdatePublicKeyRequest updatePublicKeyRequest) throws AccessDeniedException,
            CannotChangeImmutablePublicKeyFieldsException, InvalidArgumentException, InvalidIfMatchVersionException,
            IllegalUpdateException, NoSuchPublicKeyException, PreconditionFailedException, AwsServiceException,
            SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<UpdatePublicKeyResponse>> responseHandler = protocolFactory.createCombinedResponseHandler(
                UpdatePublicKeyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

        return clientHandler.execute(new ClientExecutionParams<UpdatePublicKeyRequest, UpdatePublicKeyResponse>()
                .withOperationName("UpdatePublicKey").withCombinedResponseHandler(responseHandler)
                .withInput(updatePublicKeyRequest).withMarshaller(new UpdatePublicKeyRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Update a streaming distribution.
     * </p>
     *
     * @param updateStreamingDistributionRequest
     *        The request to update a streaming distribution.
     * @return Result of the UpdateStreamingDistribution operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws CnameAlreadyExistsException
     *         The CNAME specified is already defined for CloudFront.
     * @throws IllegalUpdateException
     *         Origin and <code>CallerReference</code> cannot be updated.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid for the distribution.
     * @throws MissingBodyException
     *         This operation requires a body. Ensure that the body is present and the <code>Content-Type</code> header
     *         is set.
     * @throws NoSuchStreamingDistributionException
     *         The specified streaming distribution does not exist.
     * @throws PreconditionFailedException
     *         The precondition given in one or more of the request-header fields evaluated to <code>false</code>.
     * @throws TooManyStreamingDistributionCnamEsException
     *         Your request contains more CNAMEs than are allowed per distribution.
     * @throws InvalidArgumentException
     *         The argument is invalid.
     * @throws InvalidOriginAccessIdentityException
     *         The origin access identity is not valid or doesn't exist.
     * @throws TooManyTrustedSignersException
     *         Your request contains more trusted signers than are allowed per distribution.
     * @throws TrustedSignerDoesNotExistException
     *         One or more of your trusted signers don't exist.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.UpdateStreamingDistribution
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/UpdateStreamingDistribution"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateStreamingDistributionResponse updateStreamingDistribution(
            UpdateStreamingDistributionRequest updateStreamingDistributionRequest) throws AccessDeniedException,
            CnameAlreadyExistsException, IllegalUpdateException, InvalidIfMatchVersionException, MissingBodyException,
            NoSuchStreamingDistributionException, PreconditionFailedException, TooManyStreamingDistributionCnamEsException,
            InvalidArgumentException, InvalidOriginAccessIdentityException, TooManyTrustedSignersException,
            TrustedSignerDoesNotExistException, InconsistentQuantitiesException, AwsServiceException, SdkClientException,
            CloudFrontException {

        HttpResponseHandler<Response<UpdateStreamingDistributionResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(UpdateStreamingDistributionResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

        return clientHandler
                .execute(new ClientExecutionParams<UpdateStreamingDistributionRequest, UpdateStreamingDistributionResponse>()
                        .withOperationName("UpdateStreamingDistribution").withCombinedResponseHandler(responseHandler)
                        .withInput(updateStreamingDistributionRequest)
                        .withMarshaller(new UpdateStreamingDistributionRequestMarshaller(protocolFactory)));
    }

    private AwsXmlProtocolFactory init() {
        return AwsXmlProtocolFactory
                .builder()
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("StreamingDistributionAlreadyExists")
                                .exceptionBuilderSupplier(StreamingDistributionAlreadyExistsException::builder)
                                .httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TrustedSignerDoesNotExist")
                                .exceptionBuilderSupplier(TrustedSignerDoesNotExistException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoSuchInvalidation")
                                .exceptionBuilderSupplier(NoSuchInvalidationException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoSuchFieldLevelEncryptionConfig")
                                .exceptionBuilderSupplier(NoSuchFieldLevelEncryptionConfigException::builder).httpStatusCode(404)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyHeadersInForwardedValues")
                                .exceptionBuilderSupplier(TooManyHeadersInForwardedValuesException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidOriginReadTimeout")
                                .exceptionBuilderSupplier(InvalidOriginReadTimeoutException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidMinimumProtocolVersion")
                                .exceptionBuilderSupplier(InvalidMinimumProtocolVersionException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyInvalidationsInProgress")
                                .exceptionBuilderSupplier(TooManyInvalidationsInProgressException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyFieldLevelEncryptionConfigs")
                                .exceptionBuilderSupplier(TooManyFieldLevelEncryptionConfigsException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyPublicKeys")
                                .exceptionBuilderSupplier(TooManyPublicKeysException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidErrorCode")
                                .exceptionBuilderSupplier(InvalidErrorCodeException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyCacheBehaviors")
                                .exceptionBuilderSupplier(TooManyCacheBehaviorsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CloudFrontOriginAccessIdentityInUse")
                                .exceptionBuilderSupplier(CloudFrontOriginAccessIdentityInUseException::builder)
                                .httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("FieldLevelEncryptionProfileAlreadyExists")
                                .exceptionBuilderSupplier(FieldLevelEncryptionProfileAlreadyExistsException::builder)
                                .httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyFieldLevelEncryptionFieldPatterns")
                                .exceptionBuilderSupplier(TooManyFieldLevelEncryptionFieldPatternsException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("MissingBody")
                                .exceptionBuilderSupplier(MissingBodyException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyOrigins")
                                .exceptionBuilderSupplier(TooManyOriginsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata
                                .builder()
                                .errorCode("IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior")
                                .exceptionBuilderSupplier(
                                        IllegalFieldLevelEncryptionConfigAssociationWithCacheBehaviorException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidRequiredProtocol")
                                .exceptionBuilderSupplier(InvalidRequiredProtocolException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoSuchOrigin")
                                .exceptionBuilderSupplier(NoSuchOriginException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyTrustedSigners")
                                .exceptionBuilderSupplier(TooManyTrustedSignersException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("BatchTooLarge")
                                .exceptionBuilderSupplier(BatchTooLargeException::builder).httpStatusCode(413).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidResponseCode")
                                .exceptionBuilderSupplier(InvalidResponseCodeException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("FieldLevelEncryptionConfigAlreadyExists")
                                .exceptionBuilderSupplier(FieldLevelEncryptionConfigAlreadyExistsException::builder)
                                .httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidOriginKeepaliveTimeout")
                                .exceptionBuilderSupplier(InvalidOriginKeepaliveTimeoutException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyStreamingDistributionCNAMEs")
                                .exceptionBuilderSupplier(TooManyStreamingDistributionCnamEsException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyStreamingDistributions")
                                .exceptionBuilderSupplier(TooManyStreamingDistributionsException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("PublicKeyInUse")
                                .exceptionBuilderSupplier(PublicKeyInUseException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("StreamingDistributionNotDisabled")
                                .exceptionBuilderSupplier(StreamingDistributionNotDisabledException::builder).httpStatusCode(409)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyDistributionCNAMEs")
                                .exceptionBuilderSupplier(TooManyDistributionCnamEsException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("PreconditionFailed")
                                .exceptionBuilderSupplier(PreconditionFailedException::builder).httpStatusCode(412).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyQueryStringParameters")
                                .exceptionBuilderSupplier(TooManyQueryStringParametersException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyFieldLevelEncryptionEncryptionEntities")
                                .exceptionBuilderSupplier(TooManyFieldLevelEncryptionEncryptionEntitiesException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("FieldLevelEncryptionConfigInUse")
                                .exceptionBuilderSupplier(FieldLevelEncryptionConfigInUseException::builder).httpStatusCode(409)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DistributionAlreadyExists")
                                .exceptionBuilderSupplier(DistributionAlreadyExistsException::builder).httpStatusCode(409)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CloudFrontOriginAccessIdentityAlreadyExists")
                                .exceptionBuilderSupplier(CloudFrontOriginAccessIdentityAlreadyExistsException::builder)
                                .httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidProtocolSettings")
                                .exceptionBuilderSupplier(InvalidProtocolSettingsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyFieldLevelEncryptionProfiles")
                                .exceptionBuilderSupplier(TooManyFieldLevelEncryptionProfilesException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyOriginCustomHeaders")
                                .exceptionBuilderSupplier(TooManyOriginCustomHeadersException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidLocationCode")
                                .exceptionBuilderSupplier(InvalidLocationCodeException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidForwardCookies")
                                .exceptionBuilderSupplier(InvalidForwardCookiesException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("FieldLevelEncryptionProfileSizeExceeded")
                                .exceptionBuilderSupplier(FieldLevelEncryptionProfileSizeExceededException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyCertificates")
                                .exceptionBuilderSupplier(TooManyCertificatesException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("QueryArgProfileEmpty")
                                .exceptionBuilderSupplier(QueryArgProfileEmptyException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidOriginAccessIdentity")
                                .exceptionBuilderSupplier(InvalidOriginAccessIdentityException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidQueryStringParameters")
                                .exceptionBuilderSupplier(InvalidQueryStringParametersException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("IllegalUpdate")
                                .exceptionBuilderSupplier(IllegalUpdateException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyCookieNamesInWhiteList")
                                .exceptionBuilderSupplier(TooManyCookieNamesInWhiteListException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoSuchDistribution")
                                .exceptionBuilderSupplier(NoSuchDistributionException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CNAMEAlreadyExists")
                                .exceptionBuilderSupplier(CnameAlreadyExistsException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoSuchFieldLevelEncryptionProfile")
                                .exceptionBuilderSupplier(NoSuchFieldLevelEncryptionProfileException::builder)
                                .httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoSuchResource")
                                .exceptionBuilderSupplier(NoSuchResourceException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidTTLOrder")
                                .exceptionBuilderSupplier(InvalidTtlOrderException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InconsistentQuantities")
                                .exceptionBuilderSupplier(InconsistentQuantitiesException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidLambdaFunctionAssociation")
                                .exceptionBuilderSupplier(InvalidLambdaFunctionAssociationException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyLambdaFunctionAssociations")
                                .exceptionBuilderSupplier(TooManyLambdaFunctionAssociationsException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidViewerCertificate")
                                .exceptionBuilderSupplier(InvalidViewerCertificateException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DistributionNotDisabled")
                                .exceptionBuilderSupplier(DistributionNotDisabledException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyOriginGroupsPerDistribution")
                                .exceptionBuilderSupplier(TooManyOriginGroupsPerDistributionException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidDefaultRootObject")
                                .exceptionBuilderSupplier(InvalidDefaultRootObjectException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AccessDenied")
                                .exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(403).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidArgument")
                                .exceptionBuilderSupplier(InvalidArgumentException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoSuchStreamingDistribution")
                                .exceptionBuilderSupplier(NoSuchStreamingDistributionException::builder).httpStatusCode(404)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyCloudFrontOriginAccessIdentities")
                                .exceptionBuilderSupplier(TooManyCloudFrontOriginAccessIdentitiesException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoSuchPublicKey")
                                .exceptionBuilderSupplier(NoSuchPublicKeyException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyFieldLevelEncryptionContentTypeProfiles")
                                .exceptionBuilderSupplier(TooManyFieldLevelEncryptionContentTypeProfilesException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidRelativePath")
                                .exceptionBuilderSupplier(InvalidRelativePathException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidWebACLId")
                                .exceptionBuilderSupplier(InvalidWebAclIdException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata
                                .builder()
                                .errorCode("TooManyDistributionsAssociatedToFieldLevelEncryptionConfig")
                                .exceptionBuilderSupplier(
                                        TooManyDistributionsAssociatedToFieldLevelEncryptionConfigException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyDistributionsWithLambdaAssociations")
                                .exceptionBuilderSupplier(TooManyDistributionsWithLambdaAssociationsException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidHeadersForS3Origin")
                                .exceptionBuilderSupplier(InvalidHeadersForS3OriginException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyDistributions")
                                .exceptionBuilderSupplier(TooManyDistributionsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CannotChangeImmutablePublicKeyFields")
                                .exceptionBuilderSupplier(CannotChangeImmutablePublicKeyFieldsException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyFieldLevelEncryptionQueryArgProfiles")
                                .exceptionBuilderSupplier(TooManyFieldLevelEncryptionQueryArgProfilesException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("PublicKeyAlreadyExists")
                                .exceptionBuilderSupplier(PublicKeyAlreadyExistsException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("FieldLevelEncryptionProfileInUse")
                                .exceptionBuilderSupplier(FieldLevelEncryptionProfileInUseException::builder).httpStatusCode(409)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidIfMatchVersion")
                                .exceptionBuilderSupplier(InvalidIfMatchVersionException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidTagging")
                                .exceptionBuilderSupplier(InvalidTaggingException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidOrigin")
                                .exceptionBuilderSupplier(InvalidOriginException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoSuchCloudFrontOriginAccessIdentity")
                                .exceptionBuilderSupplier(NoSuchCloudFrontOriginAccessIdentityException::builder)
                                .httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidGeoRestrictionParameter")
                                .exceptionBuilderSupplier(InvalidGeoRestrictionParameterException::builder).httpStatusCode(400)
                                .build()).clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(CloudFrontException::builder).build();
    }

    @Override
    public void close() {
        clientHandler.close();
    }

    private <T extends CloudFrontRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder()
                .version(VersionInfo.SDK_VERSION).name("PAGINATED").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration()
                .map(c -> c.toBuilder().applyMutation(userAgentApplier).build())
                .orElse((AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier).build()));
        return (T) request.toBuilder().overrideConfiguration(overrideConfiguration).build();
    }
}
