/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum SSLSupportMethod {
    SNI_ONLY("sni-only"),
    VIP("vip"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private SSLSupportMethod(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SSLSupportMethod fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(SSLSupportMethod.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SSLSupportMethod> knownValues() {
        return Stream.of(SSLSupportMethod.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

