/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Complex data type for field-level encryption profiles that includes the encryption key and field pattern
 * specifications.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EncryptionEntity implements SdkPojo, Serializable,
        ToCopyableBuilder<EncryptionEntity.Builder, EncryptionEntity> {
    private static final SdkField<String> PUBLIC_KEY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(EncryptionEntity::publicKeyId))
            .setter(setter(Builder::publicKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicKeyId")
                    .unmarshallLocationName("PublicKeyId").build()).build();

    private static final SdkField<String> PROVIDER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(EncryptionEntity::providerId))
            .setter(setter(Builder::providerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProviderId")
                    .unmarshallLocationName("ProviderId").build()).build();

    private static final SdkField<FieldPatterns> FIELD_PATTERNS_FIELD = SdkField
            .<FieldPatterns> builder(MarshallingType.SDK_POJO)
            .getter(getter(EncryptionEntity::fieldPatterns))
            .setter(setter(Builder::fieldPatterns))
            .constructor(FieldPatterns::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldPatterns")
                    .unmarshallLocationName("FieldPatterns").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PUBLIC_KEY_ID_FIELD,
            PROVIDER_ID_FIELD, FIELD_PATTERNS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String publicKeyId;

    private final String providerId;

    private final FieldPatterns fieldPatterns;

    private EncryptionEntity(BuilderImpl builder) {
        this.publicKeyId = builder.publicKeyId;
        this.providerId = builder.providerId;
        this.fieldPatterns = builder.fieldPatterns;
    }

    /**
     * <p>
     * The public key associated with a set of field-level encryption patterns, to be used when encrypting the fields
     * that match the patterns.
     * </p>
     * 
     * @return The public key associated with a set of field-level encryption patterns, to be used when encrypting the
     *         fields that match the patterns.
     */
    public String publicKeyId() {
        return publicKeyId;
    }

    /**
     * <p>
     * The provider associated with the public key being used for encryption. This value must also be provided with the
     * private key for applications to be able to decrypt data.
     * </p>
     * 
     * @return The provider associated with the public key being used for encryption. This value must also be provided
     *         with the private key for applications to be able to decrypt data.
     */
    public String providerId() {
        return providerId;
    }

    /**
     * <p>
     * Field patterns in a field-level encryption content type profile specify the fields that you want to be encrypted.
     * You can provide the full field name, or any beginning characters followed by a wildcard (*). You can't overlap
     * field patterns. For example, you can't have both ABC* and AB*. Note that field patterns are case-sensitive.
     * </p>
     * 
     * @return Field patterns in a field-level encryption content type profile specify the fields that you want to be
     *         encrypted. You can provide the full field name, or any beginning characters followed by a wildcard (*).
     *         You can't overlap field patterns. For example, you can't have both ABC* and AB*. Note that field patterns
     *         are case-sensitive.
     */
    public FieldPatterns fieldPatterns() {
        return fieldPatterns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(publicKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(providerId());
        hashCode = 31 * hashCode + Objects.hashCode(fieldPatterns());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EncryptionEntity)) {
            return false;
        }
        EncryptionEntity other = (EncryptionEntity) obj;
        return Objects.equals(publicKeyId(), other.publicKeyId()) && Objects.equals(providerId(), other.providerId())
                && Objects.equals(fieldPatterns(), other.fieldPatterns());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("EncryptionEntity").add("PublicKeyId", publicKeyId()).add("ProviderId", providerId())
                .add("FieldPatterns", fieldPatterns()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PublicKeyId":
            return Optional.ofNullable(clazz.cast(publicKeyId()));
        case "ProviderId":
            return Optional.ofNullable(clazz.cast(providerId()));
        case "FieldPatterns":
            return Optional.ofNullable(clazz.cast(fieldPatterns()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EncryptionEntity, T> g) {
        return obj -> g.apply((EncryptionEntity) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EncryptionEntity> {
        /**
         * <p>
         * The public key associated with a set of field-level encryption patterns, to be used when encrypting the
         * fields that match the patterns.
         * </p>
         * 
         * @param publicKeyId
         *        The public key associated with a set of field-level encryption patterns, to be used when encrypting
         *        the fields that match the patterns.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicKeyId(String publicKeyId);

        /**
         * <p>
         * The provider associated with the public key being used for encryption. This value must also be provided with
         * the private key for applications to be able to decrypt data.
         * </p>
         * 
         * @param providerId
         *        The provider associated with the public key being used for encryption. This value must also be
         *        provided with the private key for applications to be able to decrypt data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providerId(String providerId);

        /**
         * <p>
         * Field patterns in a field-level encryption content type profile specify the fields that you want to be
         * encrypted. You can provide the full field name, or any beginning characters followed by a wildcard (*). You
         * can't overlap field patterns. For example, you can't have both ABC* and AB*. Note that field patterns are
         * case-sensitive.
         * </p>
         * 
         * @param fieldPatterns
         *        Field patterns in a field-level encryption content type profile specify the fields that you want to be
         *        encrypted. You can provide the full field name, or any beginning characters followed by a wildcard
         *        (*). You can't overlap field patterns. For example, you can't have both ABC* and AB*. Note that field
         *        patterns are case-sensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldPatterns(FieldPatterns fieldPatterns);

        /**
         * <p>
         * Field patterns in a field-level encryption content type profile specify the fields that you want to be
         * encrypted. You can provide the full field name, or any beginning characters followed by a wildcard (*). You
         * can't overlap field patterns. For example, you can't have both ABC* and AB*. Note that field patterns are
         * case-sensitive.
         * </p>
         * This is a convenience that creates an instance of the {@link FieldPatterns.Builder} avoiding the need to
         * create one manually via {@link FieldPatterns#builder()}.
         *
         * When the {@link Consumer} completes, {@link FieldPatterns.Builder#build()} is called immediately and its
         * result is passed to {@link #fieldPatterns(FieldPatterns)}.
         * 
         * @param fieldPatterns
         *        a consumer that will call methods on {@link FieldPatterns.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fieldPatterns(FieldPatterns)
         */
        default Builder fieldPatterns(Consumer<FieldPatterns.Builder> fieldPatterns) {
            return fieldPatterns(FieldPatterns.builder().applyMutation(fieldPatterns).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String publicKeyId;

        private String providerId;

        private FieldPatterns fieldPatterns;

        private BuilderImpl() {
        }

        private BuilderImpl(EncryptionEntity model) {
            publicKeyId(model.publicKeyId);
            providerId(model.providerId);
            fieldPatterns(model.fieldPatterns);
        }

        public final String getPublicKeyId() {
            return publicKeyId;
        }

        @Override
        public final Builder publicKeyId(String publicKeyId) {
            this.publicKeyId = publicKeyId;
            return this;
        }

        public final void setPublicKeyId(String publicKeyId) {
            this.publicKeyId = publicKeyId;
        }

        public final String getProviderId() {
            return providerId;
        }

        @Override
        public final Builder providerId(String providerId) {
            this.providerId = providerId;
            return this;
        }

        public final void setProviderId(String providerId) {
            this.providerId = providerId;
        }

        public final FieldPatterns.Builder getFieldPatterns() {
            return fieldPatterns != null ? fieldPatterns.toBuilder() : null;
        }

        @Override
        public final Builder fieldPatterns(FieldPatterns fieldPatterns) {
            this.fieldPatterns = fieldPatterns;
            return this;
        }

        public final void setFieldPatterns(FieldPatterns.BuilderImpl fieldPatterns) {
            this.fieldPatterns = fieldPatterns != null ? fieldPatterns.build() : null;
        }

        @Override
        public EncryptionEntity build() {
            return new EncryptionEntity(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
