/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request to create a new distribution with tags.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDistributionWithTagsRequest extends CloudFrontRequest implements
        ToCopyableBuilder<CreateDistributionWithTagsRequest.Builder, CreateDistributionWithTagsRequest> {
    private static final SdkField<DistributionConfigWithTags> DISTRIBUTION_CONFIG_WITH_TAGS_FIELD = SdkField
            .<DistributionConfigWithTags> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateDistributionWithTagsRequest::distributionConfigWithTags))
            .setter(setter(Builder::distributionConfigWithTags))
            .constructor(DistributionConfigWithTags::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DistributionConfigWithTags")
                    .unmarshallLocationName("DistributionConfigWithTags").build(), PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(DISTRIBUTION_CONFIG_WITH_TAGS_FIELD));

    private final DistributionConfigWithTags distributionConfigWithTags;

    private CreateDistributionWithTagsRequest(BuilderImpl builder) {
        super(builder);
        this.distributionConfigWithTags = builder.distributionConfigWithTags;
    }

    /**
     * <p>
     * The distribution's configuration information.
     * </p>
     * 
     * @return The distribution's configuration information.
     */
    public DistributionConfigWithTags distributionConfigWithTags() {
        return distributionConfigWithTags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(distributionConfigWithTags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDistributionWithTagsRequest)) {
            return false;
        }
        CreateDistributionWithTagsRequest other = (CreateDistributionWithTagsRequest) obj;
        return Objects.equals(distributionConfigWithTags(), other.distributionConfigWithTags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateDistributionWithTagsRequest")
                .add("DistributionConfigWithTags", distributionConfigWithTags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DistributionConfigWithTags":
            return Optional.ofNullable(clazz.cast(distributionConfigWithTags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDistributionWithTagsRequest, T> g) {
        return obj -> g.apply((CreateDistributionWithTagsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFrontRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateDistributionWithTagsRequest> {
        /**
         * <p>
         * The distribution's configuration information.
         * </p>
         * 
         * @param distributionConfigWithTags
         *        The distribution's configuration information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder distributionConfigWithTags(DistributionConfigWithTags distributionConfigWithTags);

        /**
         * <p>
         * The distribution's configuration information.
         * </p>
         * This is a convenience that creates an instance of the {@link DistributionConfigWithTags.Builder} avoiding the
         * need to create one manually via {@link DistributionConfigWithTags#builder()}.
         *
         * When the {@link Consumer} completes, {@link DistributionConfigWithTags.Builder#build()} is called immediately
         * and its result is passed to {@link #distributionConfigWithTags(DistributionConfigWithTags)}.
         * 
         * @param distributionConfigWithTags
         *        a consumer that will call methods on {@link DistributionConfigWithTags.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #distributionConfigWithTags(DistributionConfigWithTags)
         */
        default Builder distributionConfigWithTags(Consumer<DistributionConfigWithTags.Builder> distributionConfigWithTags) {
            return distributionConfigWithTags(DistributionConfigWithTags.builder().applyMutation(distributionConfigWithTags)
                    .build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFrontRequest.BuilderImpl implements Builder {
        private DistributionConfigWithTags distributionConfigWithTags;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDistributionWithTagsRequest model) {
            super(model);
            distributionConfigWithTags(model.distributionConfigWithTags);
        }

        public final DistributionConfigWithTags.Builder getDistributionConfigWithTags() {
            return distributionConfigWithTags != null ? distributionConfigWithTags.toBuilder() : null;
        }

        @Override
        public final Builder distributionConfigWithTags(DistributionConfigWithTags distributionConfigWithTags) {
            this.distributionConfigWithTags = distributionConfigWithTags;
            return this;
        }

        public final void setDistributionConfigWithTags(DistributionConfigWithTags.BuilderImpl distributionConfigWithTags) {
            this.distributionConfigWithTags = distributionConfigWithTags != null ? distributionConfigWithTags.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDistributionWithTagsRequest build() {
            return new CreateDistributionWithTagsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
