/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.ICPRecordalStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AliasICPRecordal
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AliasICPRecordal> {
    private static final SdkField<String> CNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AliasICPRecordal.getter(AliasICPRecordal::cname)).setter(AliasICPRecordal.setter(Builder::cname)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CNAME").unmarshallLocationName("CNAME").build()}).build();
    private static final SdkField<String> ICP_RECORDAL_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AliasICPRecordal.getter(AliasICPRecordal::icpRecordalStatusAsString)).setter(AliasICPRecordal.setter(Builder::icpRecordalStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ICPRecordalStatus").unmarshallLocationName("ICPRecordalStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CNAME_FIELD, ICP_RECORDAL_STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String cname;
    private final String icpRecordalStatus;

    private AliasICPRecordal(BuilderImpl builder) {
        this.cname = builder.cname;
        this.icpRecordalStatus = builder.icpRecordalStatus;
    }

    public String cname() {
        return this.cname;
    }

    public ICPRecordalStatus icpRecordalStatus() {
        return ICPRecordalStatus.fromValue(this.icpRecordalStatus);
    }

    public String icpRecordalStatusAsString() {
        return this.icpRecordalStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cname());
        hashCode = 31 * hashCode + Objects.hashCode(this.icpRecordalStatusAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AliasICPRecordal)) {
            return false;
        }
        AliasICPRecordal other = (AliasICPRecordal)obj;
        return Objects.equals(this.cname(), other.cname()) && Objects.equals(this.icpRecordalStatusAsString(), other.icpRecordalStatusAsString());
    }

    public String toString() {
        return ToString.builder((String)"AliasICPRecordal").add("CNAME", (Object)this.cname()).add("ICPRecordalStatus", (Object)this.icpRecordalStatusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CNAME": {
                return Optional.ofNullable(clazz.cast(this.cname()));
            }
            case "ICPRecordalStatus": {
                return Optional.ofNullable(clazz.cast(this.icpRecordalStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AliasICPRecordal, T> g) {
        return obj -> g.apply((AliasICPRecordal)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String cname;
        private String icpRecordalStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(AliasICPRecordal model) {
            this.cname(model.cname);
            this.icpRecordalStatus(model.icpRecordalStatus);
        }

        public final String getCname() {
            return this.cname;
        }

        @Override
        public final Builder cname(String cname) {
            this.cname = cname;
            return this;
        }

        public final void setCname(String cname) {
            this.cname = cname;
        }

        public final String getIcpRecordalStatusAsString() {
            return this.icpRecordalStatus;
        }

        @Override
        public final Builder icpRecordalStatus(String icpRecordalStatus) {
            this.icpRecordalStatus = icpRecordalStatus;
            return this;
        }

        @Override
        public final Builder icpRecordalStatus(ICPRecordalStatus icpRecordalStatus) {
            this.icpRecordalStatus(icpRecordalStatus == null ? null : icpRecordalStatus.toString());
            return this;
        }

        public final void setIcpRecordalStatus(String icpRecordalStatus) {
            this.icpRecordalStatus = icpRecordalStatus;
        }

        public AliasICPRecordal build() {
            return new AliasICPRecordal(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AliasICPRecordal> {
        public Builder cname(String var1);

        public Builder icpRecordalStatus(String var1);

        public Builder icpRecordalStatus(ICPRecordalStatus var1);
    }
}

