/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudfront.model.StreamingDistribution;
import software.amazon.awssdk.services.cloudfront.transform.ActiveTrustedSignersUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.StreamingDistributionConfigUnmarshaller;

public class StreamingDistributionUnmarshaller
implements Unmarshaller<StreamingDistribution, StaxUnmarshallerContext> {
    private static final StreamingDistributionUnmarshaller INSTANCE = new StreamingDistributionUnmarshaller();

    public StreamingDistribution unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        StreamingDistribution.Builder streamingDistribution = StreamingDistribution.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Id", targetDepth)) {
                    streamingDistribution.id(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ARN", targetDepth)) {
                    streamingDistribution.arn(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Status", targetDepth)) {
                    streamingDistribution.status(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("LastModifiedTime", targetDepth)) {
                    streamingDistribution.lastModifiedTime(SimpleTypeStaxUnmarshallers.InstantUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DomainName", targetDepth)) {
                    streamingDistribution.domainName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ActiveTrustedSigners", targetDepth)) {
                    streamingDistribution.activeTrustedSigners(ActiveTrustedSignersUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("StreamingDistributionConfig", targetDepth)) continue;
                streamingDistribution.streamingDistributionConfig(StreamingDistributionConfigUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (StreamingDistribution)streamingDistribution.build();
    }

    public static StreamingDistributionUnmarshaller getInstance() {
        return INSTANCE;
    }
}

