/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.cloudfront.CloudFrontClient;
import software.amazon.awssdk.services.cloudfront.model.InvalidationSummary;
import software.amazon.awssdk.services.cloudfront.model.ListInvalidationsRequest;
import software.amazon.awssdk.services.cloudfront.model.ListInvalidationsResponse;

public final class ListInvalidationsPaginator
implements SdkIterable<ListInvalidationsResponse> {
    private final CloudFrontClient client;
    private final ListInvalidationsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListInvalidationsPaginator(CloudFrontClient client, ListInvalidationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListInvalidationsResponseFetcher();
    }

    public Iterator<ListInvalidationsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<InvalidationSummary> items() {
        Function<ListInvalidationsResponse, Iterator> getIterator = response -> response != null ? response.invalidationList().items().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListInvalidationsResponseFetcher
    implements NextPageFetcher<ListInvalidationsResponse> {
        private ListInvalidationsResponseFetcher() {
        }

        public boolean hasNextPage(ListInvalidationsResponse previousPage) {
            return previousPage.invalidationList().isTruncated();
        }

        public ListInvalidationsResponse nextPage(ListInvalidationsResponse previousPage) {
            if (previousPage == null) {
                return ListInvalidationsPaginator.this.client.listInvalidations(ListInvalidationsPaginator.this.firstRequest);
            }
            return ListInvalidationsPaginator.this.client.listInvalidations((ListInvalidationsRequest)((Object)ListInvalidationsPaginator.this.firstRequest.toBuilder().marker(previousPage.invalidationList().nextMarker()).build()));
        }
    }
}

