/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.cloudfront.CloudFrontClient;
import software.amazon.awssdk.services.cloudfront.model.DistributionSummary;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsRequest;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsResponse;

public final class ListDistributionsPaginator
implements SdkIterable<ListDistributionsResponse> {
    private final CloudFrontClient client;
    private final ListDistributionsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListDistributionsPaginator(CloudFrontClient client, ListDistributionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListDistributionsResponseFetcher();
    }

    public Iterator<ListDistributionsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<DistributionSummary> items() {
        Function<ListDistributionsResponse, Iterator> getIterator = response -> response != null ? response.distributionList().items().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListDistributionsResponseFetcher
    implements NextPageFetcher<ListDistributionsResponse> {
        private ListDistributionsResponseFetcher() {
        }

        public boolean hasNextPage(ListDistributionsResponse previousPage) {
            return previousPage.distributionList().isTruncated();
        }

        public ListDistributionsResponse nextPage(ListDistributionsResponse previousPage) {
            if (previousPage == null) {
                return ListDistributionsPaginator.this.client.listDistributions(ListDistributionsPaginator.this.firstRequest);
            }
            return ListDistributionsPaginator.this.client.listDistributions((ListDistributionsRequest)((Object)ListDistributionsPaginator.this.firstRequest.toBuilder().marker(previousPage.distributionList().nextMarker()).build()));
        }
    }
}

