/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetInvalidationRequest
extends CloudFrontRequest
implements ToCopyableBuilder<Builder, GetInvalidationRequest> {
    private final String distributionId;
    private final String id;

    private GetInvalidationRequest(BuilderImpl builder) {
        super(builder);
        this.distributionId = builder.distributionId;
        this.id = builder.id;
    }

    public String distributionId() {
        return this.distributionId;
    }

    public String id() {
        return this.id;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.distributionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInvalidationRequest)) {
            return false;
        }
        GetInvalidationRequest other = (GetInvalidationRequest)((Object)obj);
        return Objects.equals(this.distributionId(), other.distributionId()) && Objects.equals(this.id(), other.id());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.distributionId() != null) {
            sb.append("DistributionId: ").append(this.distributionId()).append(",");
        }
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DistributionId": {
                return Optional.of(clazz.cast(this.distributionId()));
            }
            case "Id": {
                return Optional.of(clazz.cast(this.id()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudFrontRequest.BuilderImpl
    implements Builder {
        private String distributionId;
        private String id;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInvalidationRequest model) {
            this.distributionId(model.distributionId);
            this.id(model.id);
        }

        public final String getDistributionId() {
            return this.distributionId;
        }

        @Override
        public final Builder distributionId(String distributionId) {
            this.distributionId = distributionId;
            return this;
        }

        public final void setDistributionId(String distributionId) {
            this.distributionId = distributionId;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public GetInvalidationRequest build() {
            return new GetInvalidationRequest(this);
        }
    }

    public static interface Builder
    extends CloudFrontRequest.Builder,
    CopyableBuilder<Builder, GetInvalidationRequest> {
        public Builder distributionId(String var1);

        public Builder id(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

