/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CustomErrorResponse
implements ToCopyableBuilder<Builder, CustomErrorResponse> {
    private final Integer errorCode;
    private final String responsePagePath;
    private final String responseCode;
    private final Long errorCachingMinTTL;

    private CustomErrorResponse(BuilderImpl builder) {
        this.errorCode = builder.errorCode;
        this.responsePagePath = builder.responsePagePath;
        this.responseCode = builder.responseCode;
        this.errorCachingMinTTL = builder.errorCachingMinTTL;
    }

    public Integer errorCode() {
        return this.errorCode;
    }

    public String responsePagePath() {
        return this.responsePagePath;
    }

    public String responseCode() {
        return this.responseCode;
    }

    public Long errorCachingMinTTL() {
        return this.errorCachingMinTTL;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.responsePagePath());
        hashCode = 31 * hashCode + Objects.hashCode(this.responseCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorCachingMinTTL());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomErrorResponse)) {
            return false;
        }
        CustomErrorResponse other = (CustomErrorResponse)obj;
        return Objects.equals(this.errorCode(), other.errorCode()) && Objects.equals(this.responsePagePath(), other.responsePagePath()) && Objects.equals(this.responseCode(), other.responseCode()) && Objects.equals(this.errorCachingMinTTL(), other.errorCachingMinTTL());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.errorCode() != null) {
            sb.append("ErrorCode: ").append(this.errorCode()).append(",");
        }
        if (this.responsePagePath() != null) {
            sb.append("ResponsePagePath: ").append(this.responsePagePath()).append(",");
        }
        if (this.responseCode() != null) {
            sb.append("ResponseCode: ").append(this.responseCode()).append(",");
        }
        if (this.errorCachingMinTTL() != null) {
            sb.append("ErrorCachingMinTTL: ").append(this.errorCachingMinTTL()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ErrorCode": {
                return Optional.of(clazz.cast(this.errorCode()));
            }
            case "ResponsePagePath": {
                return Optional.of(clazz.cast(this.responsePagePath()));
            }
            case "ResponseCode": {
                return Optional.of(clazz.cast(this.responseCode()));
            }
            case "ErrorCachingMinTTL": {
                return Optional.of(clazz.cast(this.errorCachingMinTTL()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Integer errorCode;
        private String responsePagePath;
        private String responseCode;
        private Long errorCachingMinTTL;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomErrorResponse model) {
            this.errorCode(model.errorCode);
            this.responsePagePath(model.responsePagePath);
            this.responseCode(model.responseCode);
            this.errorCachingMinTTL(model.errorCachingMinTTL);
        }

        public final Integer getErrorCode() {
            return this.errorCode;
        }

        @Override
        public final Builder errorCode(Integer errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final void setErrorCode(Integer errorCode) {
            this.errorCode = errorCode;
        }

        public final String getResponsePagePath() {
            return this.responsePagePath;
        }

        @Override
        public final Builder responsePagePath(String responsePagePath) {
            this.responsePagePath = responsePagePath;
            return this;
        }

        public final void setResponsePagePath(String responsePagePath) {
            this.responsePagePath = responsePagePath;
        }

        public final String getResponseCode() {
            return this.responseCode;
        }

        @Override
        public final Builder responseCode(String responseCode) {
            this.responseCode = responseCode;
            return this;
        }

        public final void setResponseCode(String responseCode) {
            this.responseCode = responseCode;
        }

        public final Long getErrorCachingMinTTL() {
            return this.errorCachingMinTTL;
        }

        @Override
        public final Builder errorCachingMinTTL(Long errorCachingMinTTL) {
            this.errorCachingMinTTL = errorCachingMinTTL;
            return this;
        }

        public final void setErrorCachingMinTTL(Long errorCachingMinTTL) {
            this.errorCachingMinTTL = errorCachingMinTTL;
        }

        public CustomErrorResponse build() {
            return new CustomErrorResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CustomErrorResponse> {
        public Builder errorCode(Integer var1);

        public Builder responsePagePath(String var1);

        public Builder responseCode(String var1);

        public Builder errorCachingMinTTL(Long var1);
    }
}

