/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.cloudfront.model.TagKeys;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UntagResourceRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UntagResourceRequest> {
    private final String resource;
    private final TagKeys tagKeys;

    private UntagResourceRequest(BuilderImpl builder) {
        this.resource = builder.resource;
        this.tagKeys = builder.tagKeys;
    }

    public String resource() {
        return this.resource;
    }

    public TagKeys tagKeys() {
        return this.tagKeys;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resource());
        hashCode = 31 * hashCode + Objects.hashCode(this.tagKeys());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UntagResourceRequest)) {
            return false;
        }
        UntagResourceRequest other = (UntagResourceRequest)((Object)obj);
        return Objects.equals(this.resource(), other.resource()) && Objects.equals(this.tagKeys(), other.tagKeys());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.resource() != null) {
            sb.append("Resource: ").append(this.resource()).append(",");
        }
        if (this.tagKeys() != null) {
            sb.append("TagKeys: ").append(this.tagKeys()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Resource": {
                return Optional.of(clazz.cast(this.resource()));
            }
            case "TagKeys": {
                return Optional.of(clazz.cast(this.tagKeys()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String resource;
        private TagKeys tagKeys;

        private BuilderImpl() {
        }

        private BuilderImpl(UntagResourceRequest model) {
            this.resource(model.resource);
            this.tagKeys(model.tagKeys);
        }

        public final String getResource() {
            return this.resource;
        }

        @Override
        public final Builder resource(String resource) {
            this.resource = resource;
            return this;
        }

        public final void setResource(String resource) {
            this.resource = resource;
        }

        public final TagKeys.Builder getTagKeys() {
            return this.tagKeys != null ? this.tagKeys.toBuilder() : null;
        }

        @Override
        public final Builder tagKeys(TagKeys tagKeys) {
            this.tagKeys = tagKeys;
            return this;
        }

        public final void setTagKeys(TagKeys.BuilderImpl tagKeys) {
            this.tagKeys = tagKeys != null ? tagKeys.build() : null;
        }

        public UntagResourceRequest build() {
            return new UntagResourceRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UntagResourceRequest> {
        public Builder resource(String var1);

        public Builder tagKeys(TagKeys var1);

        default public Builder tagKeys(Consumer<TagKeys.Builder> tagKeys) {
            return this.tagKeys((TagKeys)((TagKeys.Builder)TagKeys.builder().apply(tagKeys)).build());
        }
    }
}

