/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.cloudfront.model.InvalidationBatch;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateInvalidationRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateInvalidationRequest> {
    private final String distributionId;
    private final InvalidationBatch invalidationBatch;

    private CreateInvalidationRequest(BuilderImpl builder) {
        this.distributionId = builder.distributionId;
        this.invalidationBatch = builder.invalidationBatch;
    }

    public String distributionId() {
        return this.distributionId;
    }

    public InvalidationBatch invalidationBatch() {
        return this.invalidationBatch;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.distributionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.invalidationBatch());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInvalidationRequest)) {
            return false;
        }
        CreateInvalidationRequest other = (CreateInvalidationRequest)((Object)obj);
        return Objects.equals(this.distributionId(), other.distributionId()) && Objects.equals(this.invalidationBatch(), other.invalidationBatch());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.distributionId() != null) {
            sb.append("DistributionId: ").append(this.distributionId()).append(",");
        }
        if (this.invalidationBatch() != null) {
            sb.append("InvalidationBatch: ").append(this.invalidationBatch()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DistributionId": {
                return Optional.of(clazz.cast(this.distributionId()));
            }
            case "InvalidationBatch": {
                return Optional.of(clazz.cast(this.invalidationBatch()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String distributionId;
        private InvalidationBatch invalidationBatch;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateInvalidationRequest model) {
            this.distributionId(model.distributionId);
            this.invalidationBatch(model.invalidationBatch);
        }

        public final String getDistributionId() {
            return this.distributionId;
        }

        @Override
        public final Builder distributionId(String distributionId) {
            this.distributionId = distributionId;
            return this;
        }

        public final void setDistributionId(String distributionId) {
            this.distributionId = distributionId;
        }

        public final InvalidationBatch.Builder getInvalidationBatch() {
            return this.invalidationBatch != null ? this.invalidationBatch.toBuilder() : null;
        }

        @Override
        public final Builder invalidationBatch(InvalidationBatch invalidationBatch) {
            this.invalidationBatch = invalidationBatch;
            return this;
        }

        public final void setInvalidationBatch(InvalidationBatch.BuilderImpl invalidationBatch) {
            this.invalidationBatch = invalidationBatch != null ? invalidationBatch.build() : null;
        }

        public CreateInvalidationRequest build() {
            return new CreateInvalidationRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateInvalidationRequest> {
        public Builder distributionId(String var1);

        public Builder invalidationBatch(InvalidationBatch var1);

        default public Builder invalidationBatch(Consumer<InvalidationBatch.Builder> invalidationBatch) {
            return this.invalidationBatch((InvalidationBatch)((InvalidationBatch.Builder)InvalidationBatch.builder().apply(invalidationBatch)).build());
        }
    }
}

