/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.cloudfront.model.Distribution;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateDistributionWithTagsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, CreateDistributionWithTagsResponse> {
    private final Distribution distribution;
    private final String location;
    private final String eTag;

    private CreateDistributionWithTagsResponse(BuilderImpl builder) {
        this.distribution = builder.distribution;
        this.location = builder.location;
        this.eTag = builder.eTag;
    }

    public Distribution distribution() {
        return this.distribution;
    }

    public String location() {
        return this.location;
    }

    public String eTag() {
        return this.eTag;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.distribution());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.eTag());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDistributionWithTagsResponse)) {
            return false;
        }
        CreateDistributionWithTagsResponse other = (CreateDistributionWithTagsResponse)((Object)obj);
        return Objects.equals(this.distribution(), other.distribution()) && Objects.equals(this.location(), other.location()) && Objects.equals(this.eTag(), other.eTag());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.distribution() != null) {
            sb.append("Distribution: ").append(this.distribution()).append(",");
        }
        if (this.location() != null) {
            sb.append("Location: ").append(this.location()).append(",");
        }
        if (this.eTag() != null) {
            sb.append("ETag: ").append(this.eTag()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Distribution": {
                return Optional.of(clazz.cast(this.distribution()));
            }
            case "Location": {
                return Optional.of(clazz.cast(this.location()));
            }
            case "ETag": {
                return Optional.of(clazz.cast(this.eTag()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Distribution distribution;
        private String location;
        private String eTag;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDistributionWithTagsResponse model) {
            this.distribution(model.distribution);
            this.location(model.location);
            this.eTag(model.eTag);
        }

        public final Distribution.Builder getDistribution() {
            return this.distribution != null ? this.distribution.toBuilder() : null;
        }

        @Override
        public final Builder distribution(Distribution distribution) {
            this.distribution = distribution;
            return this;
        }

        public final void setDistribution(Distribution.BuilderImpl distribution) {
            this.distribution = distribution != null ? distribution.build() : null;
        }

        public final String getLocation() {
            return this.location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        public final String getETag() {
            return this.eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        public CreateDistributionWithTagsResponse build() {
            return new CreateDistributionWithTagsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateDistributionWithTagsResponse> {
        public Builder distribution(Distribution var1);

        default public Builder distribution(Consumer<Distribution.Builder> distribution) {
            return this.distribution((Distribution)((Distribution.Builder)Distribution.builder().apply(distribution)).build());
        }

        public Builder location(String var1);

        public Builder eTag(String var1);
    }
}

