/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.PathMarshallers;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.cloudfront.model.DeleteStreamingDistributionRequest;

public class DeleteStreamingDistributionRequestMarshaller
implements Marshaller<Request<DeleteStreamingDistributionRequest>, DeleteStreamingDistributionRequest> {
    public Request<DeleteStreamingDistributionRequest> marshall(DeleteStreamingDistributionRequest deleteStreamingDistributionRequest) {
        if (deleteStreamingDistributionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteStreamingDistributionRequest, "CloudFrontClient");
        request.setHttpMethod(HttpMethodName.DELETE);
        if (deleteStreamingDistributionRequest.ifMatch() != null) {
            request.addHeader("If-Match", StringUtils.fromString((String)deleteStreamingDistributionRequest.ifMatch()));
        }
        String uriResourcePath = "/2017-03-25/streaming-distribution/{Id}";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Id", deleteStreamingDistributionRequest.id());
        request.setResourcePath(uriResourcePath);
        return request;
    }
}

