/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import software.amazon.awssdk.services.cloudfront.model.CookiePreference;
import software.amazon.awssdk.services.cloudfront.model.Headers;
import software.amazon.awssdk.services.cloudfront.model.QueryStringCacheKeys;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ForwardedValues
implements ToCopyableBuilder<Builder, ForwardedValues> {
    private final Boolean queryString;
    private final CookiePreference cookies;
    private final Headers headers;
    private final QueryStringCacheKeys queryStringCacheKeys;

    private ForwardedValues(BuilderImpl builder) {
        this.queryString = builder.queryString;
        this.cookies = builder.cookies;
        this.headers = builder.headers;
        this.queryStringCacheKeys = builder.queryStringCacheKeys;
    }

    public Boolean queryString() {
        return this.queryString;
    }

    public CookiePreference cookies() {
        return this.cookies;
    }

    public Headers headers() {
        return this.headers;
    }

    public QueryStringCacheKeys queryStringCacheKeys() {
        return this.queryStringCacheKeys;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.queryString() == null ? 0 : this.queryString().hashCode());
        hashCode = 31 * hashCode + (this.cookies() == null ? 0 : this.cookies().hashCode());
        hashCode = 31 * hashCode + (this.headers() == null ? 0 : this.headers().hashCode());
        hashCode = 31 * hashCode + (this.queryStringCacheKeys() == null ? 0 : this.queryStringCacheKeys().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ForwardedValues)) {
            return false;
        }
        ForwardedValues other = (ForwardedValues)obj;
        if (other.queryString() == null ^ this.queryString() == null) {
            return false;
        }
        if (other.queryString() != null && !other.queryString().equals(this.queryString())) {
            return false;
        }
        if (other.cookies() == null ^ this.cookies() == null) {
            return false;
        }
        if (other.cookies() != null && !other.cookies().equals(this.cookies())) {
            return false;
        }
        if (other.headers() == null ^ this.headers() == null) {
            return false;
        }
        if (other.headers() != null && !other.headers().equals(this.headers())) {
            return false;
        }
        if (other.queryStringCacheKeys() == null ^ this.queryStringCacheKeys() == null) {
            return false;
        }
        return other.queryStringCacheKeys() == null || other.queryStringCacheKeys().equals(this.queryStringCacheKeys());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.queryString() != null) {
            sb.append("QueryString: ").append(this.queryString()).append(",");
        }
        if (this.cookies() != null) {
            sb.append("Cookies: ").append(this.cookies()).append(",");
        }
        if (this.headers() != null) {
            sb.append("Headers: ").append(this.headers()).append(",");
        }
        if (this.queryStringCacheKeys() != null) {
            sb.append("QueryStringCacheKeys: ").append(this.queryStringCacheKeys()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private Boolean queryString;
        private CookiePreference cookies;
        private Headers headers;
        private QueryStringCacheKeys queryStringCacheKeys;

        private BuilderImpl() {
        }

        private BuilderImpl(ForwardedValues model) {
            this.setQueryString(model.queryString);
            this.setCookies(model.cookies);
            this.setHeaders(model.headers);
            this.setQueryStringCacheKeys(model.queryStringCacheKeys);
        }

        public final Boolean getQueryString() {
            return this.queryString;
        }

        @Override
        public final Builder queryString(Boolean queryString) {
            this.queryString = queryString;
            return this;
        }

        public final void setQueryString(Boolean queryString) {
            this.queryString = queryString;
        }

        public final CookiePreference getCookies() {
            return this.cookies;
        }

        @Override
        public final Builder cookies(CookiePreference cookies) {
            this.cookies = cookies;
            return this;
        }

        public final void setCookies(CookiePreference cookies) {
            this.cookies = cookies;
        }

        public final Headers getHeaders() {
            return this.headers;
        }

        @Override
        public final Builder headers(Headers headers) {
            this.headers = headers;
            return this;
        }

        public final void setHeaders(Headers headers) {
            this.headers = headers;
        }

        public final QueryStringCacheKeys getQueryStringCacheKeys() {
            return this.queryStringCacheKeys;
        }

        @Override
        public final Builder queryStringCacheKeys(QueryStringCacheKeys queryStringCacheKeys) {
            this.queryStringCacheKeys = queryStringCacheKeys;
            return this;
        }

        public final void setQueryStringCacheKeys(QueryStringCacheKeys queryStringCacheKeys) {
            this.queryStringCacheKeys = queryStringCacheKeys;
        }

        public ForwardedValues build() {
            return new ForwardedValues(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ForwardedValues> {
        public Builder queryString(Boolean var1);

        public Builder cookies(CookiePreference var1);

        public Builder headers(Headers var1);

        public Builder queryStringCacheKeys(QueryStringCacheKeys var1);
    }
}

